clear all
set mem 5g
set more off
use "freqtsseries.dta", clear
keep year congress *freq

sort year
merge 1:1 congress using "../rawdata/time_independent_vars_2013.dta",  gen(mergets)
tsset congress
drop mergets


tsset congress
replace googlepol_freq = googlepol_freq*100000
replace googleparti_freq = googleparti_freq*100000

label var googlepol_freq "Political Polarization in Google N-grams (X 100000)"
label var congpol_freq "Political Polarization in Congress"
label var googleparti_freq "Political Partisanship in Google N-grams (X 100000)"
label var congparti_freq "Political Partisanship in Congress"

 replace realgdpgrowth = log(splicedseriesbasedondavis)- log(L2.splicedseriesbasedondavis)
*label var top1pctincsharePS "Top 1% Income Share"
label var politicalviolencepermillion "Domestic Political Violence/Million"
label var casualtiesperhundredthousand "Military Casualties/Thousand"
label var realgdpgrowth "Real GDP Growth"
label var dem_house "Number of Democratic Seats in House"

label var MLI "Legislative Production of Major Policy Changes"
label var LPI "Legislative Production of Statutes"


cd "../Pics_Tables"


gen yearlabel=""
replace yearlabel="Reconstruction Ends (1877)" if year==1877
replace yearlabel="Progressive Constitution (1913)" if year==1913
replace yearlabel="New Deal (1933)" if year==1933
replace yearlabel="Voting Rights Act (1965)" if year==1965
replace yearlabel="Republican House (1995)" if year==1995


gen mprpol = (num100*abs(dwnom1100)+num200*abs(dwnom1200))
gen mprparti=num100*dwnom1100 + num200*dwnom1200
foreach v of varlist googlepol_freq mprpol congpol_freq congparti_freq googleparti_freq mprparti {
	sum `v'
	gen `v'_std= (`v'-`r(mean)')/`r(sd)' 
	sum `v'_std
	
}

label var googlepol_freq_std "Political Polarization in Google N-grams (Stdized)"
label var congpol_freq_std "Political Polarization in Congress (Stdized)"
label var googleparti_freq_std "Political Partisanship in Google N-grams (Stdized)"
label var congparti_freq_std "Political Partisanship in Congress (Stdized)"

label var mprpol_std "DW-1 Political Polarization (Stdized)"
label var mprparti_std "DW-1 Political Partisanship  (Stdized)"

#delimit ;

twoway (scatter congpol_freq_std year, xline(1877 1913 1933 1965 1995)
 text(3 1877 "Reconstruction Ends (1877)", place(e) )
 text(-3 1913 "Progressive Constitution (1913)", place(e) ) 
 text(2 1933 "New Deal (1933)", place(e) )
 text(-2 1965 "Voting Rights Act (1965)", place(e) )
 text(3 1995 "Republican House(1995)", place(e) ) 
 yscale(range (-3 3)) xscale(range (1870 2050)) legend(rows(2)) ) (line mprpol_std year, msymbol(o)) 
;
cap graph save freqcut_congpol_year_allyears, replace;
graph export freqcut_congpol_year_allyears.png, replace;

drop if year>2000 ;

*#delimit ;
twoway (scatter googlepol_freq_std year, xline(1877 1913 1933 1965 1995)
 text(3 1877 "Reconstruction Ends (1877)", place(e) )
 text(-3 1913 "Progressive Constitution (1913)", place(e) ) 
 text(2 1933 "New Deal (1933)", place(e) )
 text(-2 1965 "Voting Rights Act (1965)", place(e) )
 text(3 1995 "Republican House(1995)", place(e) ) 
 yscale(range (-3 3)) xscale(range (1870 2050)) legend(rows(2)) ) (line mprpol_std year, msymbol(o)) 
;

cap graph save freqcut_googmprpol_year_pre2001, replace;
graph export freqcut_googmprpol_year_pre2001.png, replace;
