clear

load data_positive_13

% keep 2007 and 2012
index=find(year==2007);
year=year(index);
va=va(index);
soe=soe(index);
d_07_12=d_07_12(index);

% number of observations
n=length(va);

%% generate the percentile according to sales
temp=zeros(n,4);
for i=1:n
    temp(i,1)=i; temp(i,2)=1; temp(i,3)=va(i);
end
temp=sortrows(temp, [2 3]);
in=0;
for i=1:n
    in=in+1;
    temp(i,4)= floor((in-1)/n*100)+1;
end
temp=sortrows(temp, [1]);
cl_va=temp(:,4);

%% survival rate
% survival probabilities
sur07=zeros(100,2);
for i=1:100
    sur07(i,1)=length(find(cl_va==i & soe==1 & d_07_12))/length(find(cl_va==i & soe==1));
    sur07(i,2)=length(find(cl_va==i & soe==0 & d_07_12))/length(find(cl_va==i & soe==0));
end

% compute overall exit rates
sur07_soe=mean(sur07(:,1));
sur07_nso=mean(sur07(:,2));
exit07_soe=1-sur07_soe.^(1/5)
exit07_nso=1-sur07_nso.^(1/5)

%% Figure Exit/Surival Rates
exit_soe=1-sur07(:,1).^(1/5);
exit_nso=1-sur07(:,2).^(1/5);

% smooth
ord=5; % order of polynomial
x=(1:100)';
for i=0:ord
    X(:,i+1)=x.^i;
end
Y=exit_soe;
b=regress(Y,X)
exit_soe=X*b;
Y=exit_nso;
b=regress(Y,X)
exit_nso=X*b;

subplot(1,1,1)
plot([1:100]',exit_soe*100,'r -','LineWidth',2)
hold on
plot([1:100]',exit_nso*100,'b :','LineWidth',2)
hold off
% title({'Panel A: Survival Rates (%)'})
xlabel('percentiles by 2007 value-added')
legend('SOE','Private')

stata(:,1)=[1:100]';
stata(:,2)=exit_soe*100;
stata(:,3)=exit_nso*100;