clear

% load data_all
load data_positive

n=length(va);


%% generate the percentile according to va
temp=zeros(n,4);
for i=1:n
    temp(i,1)=i; temp(i,2)=year(i); temp(i,3)=va(i);
end
temp=sortrows(temp, [2 3]);
nyear=zeros(10,1);
for i=1998:2007
    nyear(i-1997)=length(find(year==i));
end
in=0;
for i=1:n
    in=in+1;
    temp(i,4)= floor((in-1)/nyear(temp(i,2)-1997)*100)+1;
    if in==nyear(temp(i,2)-1997)
        in=0;
    end
end
temp=sortrows(temp, [1]);
cl_va=temp(:,4);

%% survival rate
% dummy for survival firms in 2007
% dummy for lsgx in 1998
year07=zeros(n,1);
ls98=zeros(n,1);
for i=1:n
    year07(i)=year(last(i))==2007;
%     ls98(i)=ls(first(i))==10;
end

% survival probabilities
sur98=zeros(100,2);
for i=1:100
    sur98(i,1)=length(find(year==1998 & cl_va==i & soe & year07))/length(find(year==1998 & cl_va==i & soe));
    sur98(i,2)=length(find(year==1998 & cl_va==i & ~soe & year07))/length(find(year==1998 & cl_va==i & ~soe));
%     sur98(i,3)=length(find(year==1998 & cl_va==i & soe & year07 & ls98))/length(find(year==1998 & cl_va==i & soe & ls98));
%     sur98(i,4)=length(find(year==1998 & cl_va==i & soe & year07 & ~ls98))/length(find(year==1998 & cl_va==i & soe & ~ls98));
end

% compute overall exit rates
sur98_soe=mean(sur98(:,1));
sur98_nso=mean(sur98(:,2));
exit98_soe=1-sur98_soe.^(1/9)
exit98_nso=1-sur98_nso.^(1/9)

%% Figure Exit/Surival Rates
exit_soe=1-sur98(:,1).^(1/9);
exit_nso=1-sur98(:,2).^(1/9);
mean(exit_soe(1:10))
mean(exit_nso(1:10))

% moving average
% exit_soe=feval('fun_ma',exit_soe);
% exit_nso=feval('fun_ma',exit_nso);

% smooth
ord=5; % order of polynomial
x=(1:100)';
for i=0:ord
    X(:,i+1)=x.^i;
end
Y=exit_soe;
b=regress(Y,X)
exit_soe=X*b;
Y=exit_nso;
b=regress(Y,X)
exit_nso=X*b;

subplot(1,1,1)
plot([1:100]',exit_soe*100,'r -','LineWidth',2)
hold on
plot([1:100]',exit_nso*100,'b :','LineWidth',2)
hold off
% title({'Panel A: Survival Rates (%)'})
xlabel('percentiles by 1998 value-added')
legend('SOE','Private')
% subplot(1,2,2)
% plot(sur_VA(:,1),ucon_soe,'r -','LineWidth',2)
% hold on
% plot(sur_VA(:,1),conv_soe,'b :','LineWidth',2)
% hold off
% legend('Corp. SOE','Priv. SOE')
% title({'Panel B: Ownership Conversion Rates (%)'})
% xlabel('percentiles by 1998 value-added')
print('-depsc2','survival.eps');

% %% Figure for Central and Non-Central SOE
% sur_ce=feval('fun_ma',sur98(:,3)*100);
% sur_nc=feval('fun_ma',sur98(:,4)*100);
% subplot(1,1,1)
% plot([1:100]',sur_ce,'r -','LineWidth',2)
% hold on
% plot([1:100]',sur_nc,'b :','LineWidth',2)
% hold off
% % title({'Panel A: Survival Rates (%)'})
% xlabel('percentiles by 1998 value-added')
% legend('central','non-central')
% print('-depsc2','survival_center.eps');

%% exit rate from 1991 to 1995
exit91_95_soe=fsolve('fun_exit_soe',0.01)
exit91_95_nso=fsolve('fun_exit_nso',0.10)