clear

load data_positive

load data_parameter

hc_index=1; % 1 for education adjusted human capital and 0 for unadjusted
if hc_index == 1
    emp=hc;
end

rl_index=2; % 0 for benchmark, 1 for aggregate adjustment and 2 for threshold adjustment

% definition
Y=zeros(10,39);
w=zeros(10,39);

Y_cso=zeros(10,39); L_cso=zeros(10,39); K_cso=zeros(10,39);
Y_nso=zeros(10,39); L_nso=zeros(10,39); K_nso=zeros(10,39); 

% distortion and tfp
index=length(va);
tfp=zeros(index,1);
tfp_r=zeros(index,1);
tfp_r_ad=zeros(index,1);
tau_l=zeros(index,1); 
tau_k=zeros(index,1);

% distortion and tfp with heterogeneous markups
tfp_mk=zeros(index,1);
tau_l_mk=zeros(index,1); 
tau_k_mk=zeros(index,1);
tfp_r_mk=zeros(index,1);

% industry median tfp
tfp_ind=zeros(10,39);

% redundant labor
tau_thres=0; % -1; % -0.86; % -1; % -0.704; % threshold value of tau for redundant workers
tfp_ad=zeros(index,1);
tau_l_ad=zeros(index,1);
rl=zeros(index,1);
emp_ad=zeros(index,1);
% emp_check=zeros(index,1);

% initial state ownership
soe_ini=zeros(index,1);

% wincorization
perc_min=1; perc_max=99;
tfp_win=zeros(index,1);
tfp_mk_win=zeros(index,1);
tfp_ad_win=zeros(index,1);
tau_l_win=zeros(index,1);
tau_k_win=zeros(index,1);
rl_win=zeros(index,1);
va_win=zeros(index,1);

% compute tfp and distortions
for t=1998:2007 
    
    % by industry
    for i=1:39
        
        % load data for alpha
        alp=alpha(i,2);
        
        % year and industry index
        index=find(year==t & cic2==cic2_index(i));
        
        % size
        Y(t-1997,i)=sum(va(index));
        
        % incumbent private firms
        index_nso=find(year==t & cic2==cic2_index(i) & conv_own==3 & d_inc==1);
         
        % output
        Y_nso(t-1997,i)=sum(va(index_nso));
        L_nso(t-1997,i)=sum(emp(index_nso));
        K_nso(t-1997,i)=sum(rk(index_nso));

        % corp. SOE
        index_cso=find(year==t & cic2==cic2_index(i) & conv_own==1 & d_inc==1); 

        Y_cso(t-1997,i)=sum(va(index_cso));
        L_cso(t-1997,i)=sum(emp(index_cso));
        K_cso(t-1997,i)=sum(rk(index_cso));
        
        % priv. SOE
        index_pso=find(year==t & cic2==cic2_index(i) & conv_own==2 & d_inc==1); 

        % TFP
        tfp(index,1)=va(index).^(1/(1-eta))*Y(t-1997,i)^(-eta/(1-eta))./(rk(index).^alp.*emp(index).^(1-alp));

        % distortions (tau_l is MINUS for SOEs)
        tau_l(index,1)=(va(index)./emp(index))/(Y_nso(t-1997,i)/L_nso(t-1997,i))-1;
        tau_k(index,1)=(va(index)./rk(index))/(Y_cso(t-1997,i)/K_cso(t-1997,i))-1;
        
        % wage rate by assuming private firms have zero tau_l
        w(t-1997,i)=(1-alp)*(1-eta)*Y_nso(t-1997,i)/L_nso(t-1997,i);
                
        % checking empty results
        if isempty(index_nso) == 1
            w(t-1997,i)=0;
        end
        
        % check
        tfp_ind(t-1997,i)=median(tfp(index,1));
        
        %% hetergeneous markups & redundant labor
        s_index=find(year==t & cic2==cic2_index(i) & soe==1);
        n_index=find(year==t & cic2==cic2_index(i) & soe~=1);
        
        Y_s=sum(va(s_index)); L_s=sum(emp(s_index));
        
        % non-state firms
        tfp_mk(n_index,1)=tfp(n_index,1);
        tau_l_mk(n_index,1)=tau_l(n_index,1);
        tau_k_mk(n_index,1)=(1+tau_k(n_index,1))/(1-the)-1;

        % SOE
        tfp_mk(s_index,1)=Y_s^(-the/e_t)*Y(t-1997,i)^(-eta/(1-eta))*va(s_index).^(1/e_t)./(rk(s_index).^alp.*emp(s_index).^(1-alp));
        tau_l_mk(s_index,1)=(1+tau_l(s_index,1))*(1-the)-1;
        tau_k_mk(s_index,1)=(1+tau_k(s_index,1))*(1-the)-1;
        
        % relative TFP
        tfp_r(index,1)=tfp(index,1)/median(tfp(index_nso));
        tfp_r_mk(index,1)=tfp_mk(index,1)/median(tfp_mk(index_nso));

        % tfp_r(index,1)=tfp(index,1)/(sum(va(index_nso).*tfp(index_nso))/Y_nso(t-1997,i));
        % tfp_r_mk(index,1)=tfp_mk(index,1)/(sum(va(index_nso).*tfp_mk(index_nso))/Y_nso(t-1997,i));
        
        %% redundant labor approach (for initially soe in BP only)
        
        % initial state ownership
        soe_ini(index)=soe(first(index));
        
        % adjusted TFP by taking into account overhead labor
 
        % firms with overhead labor
        if rl_index == 0 % benchmark with no labor redundancy
            
            tfp_ad(index)=tfp(index);
            tau_l_ad(index)=tau_l(index);
            
        elseif rl_index == 1 % labor redundancy matched to MRPL of private incumbent firms
            
            % total redundant labor
            index_1=find(year==t & cic2==cic2_index(i) & soe_ini==1); 
            F=max(0,(1-sum(va(index_1))/sum(emp(index_1))/(Y_nso(t-1997,i)/L_nso(t-1997,i)))*sum(emp(index_1)));
            rl(index_1)=emp(index_1)/sum(emp(index_1))*F;
            
            % tfp adjustment
            tfp_ad(index)=va(index).^(1/(1-eta))*Y(t-1997,i)^(-eta/(1-eta))./(rk(index).^alp.*(emp(index)-rl(index)).^(1-alp));

            % labor distortion adjustment
            tau_l_ad(index)=(1+tau_l(index))./(1-rl(index)./emp(index))-1;
            
        elseif rl_index == 2 % labor redundancy calibrated by tau_thres
            
            index_1=find(year==t & cic2==cic2_index(i) & soe_ini==1 & tau_l < tau_thres); 
            if isempty(index_1)~=1
                tfp_ad(index_1)=tfp(index_1)./((1+tau_l(index_1))/(1+tau_thres)).^(1-alp);
                rl(index_1)=-((tau_l(index_1)-tau_thres)/(1+tau_thres)).*emp(index_1);
                tau_l_ad(index_1)=tau_thres;
            end
        
            % firms without overhead labor
            index_0=find(year==t & cic2==cic2_index(i) & (soe_ini~=1 | tau_l >= tau_thres));
            tfp_ad(index_0)=tfp(index_0);
            rl(index_0)=0;
            tau_l_ad(index_0)=tau_l(index_0);
            
        end
                
%         % check
%         RL=sum(rl(index));
%         L=sum(emp(index));
%         X1=sum(tfp(index).^((1-eta)/eta)./((1+tau_k(index)).^(alp*(1-eta)/eta).*(1+tau_l(index)).^((1-alp)*(1-eta)/eta+1)));
%         Y1=sum(tfp_ad(index_1).^((1-eta)/eta)./((1+tau_k(index_1)).^(alp*(1-eta)/eta).*(1+tau_thres).^((1-alp)*(1-eta)/eta+1)));
%         Z1=(L-RL)/L*X1-Y1;
% 
%         % emp_check(index)=tfp(index).^((1-eta)/eta)./((1+tau_k(index)).^(alp*(1-eta)/eta).*(1+tau_l(index)).^((1-alp)*(1-eta)/eta+1))/X1*L;
%         
%         emp_ad(index_1)=tfp_ad(index_1).^((1-eta)/eta)./((1+tau_k(index_1)).^(alp*(1-eta)/eta).*(1+tau_thres).^((1-alp)*(1-eta)/eta+1))*L/X1+rl(index_1);
%         emp_ad(index_0)=tfp_ad(index_0).^((1-eta)/eta)./((1+tau_k(index_0)).^(alp*(1-eta)/eta).*(1+tau_l_ad(index_0)).^((1-alp)*(1-eta)/eta+1))*L/X1;
        
        tfp_r_ad(index,1)=tfp_ad(index,1)/median(tfp_ad(index_nso));
        % tfp_r_ad(index,1)=tfp_ad(index,1)/(sum(va(index_nso).*tfp_ad(index_nso))/Y_nso(t-1997,i));

        % winsorization
        tfp_win(index)=tfp(index);
        tfp_mk_win(index)=tfp_mk(index);
        tfp_ad_win(index)=tfp_ad(index);
        tau_l_win(index)=tau_l_ad(index);
        tau_k_win(index)=tau_k(index);
        rl_win(index)=rl(index);
        va_win(index)=va(index);
        if t == 1998
            index_win=find(year==t & cic2==cic2_index(i)); 
            tfp_max=prctile(tfp(index_win),perc_max); tfp_min=prctile(tfp(index_win),perc_min);
            tfp_mk_max=prctile(tfp_mk(index_win),perc_max); tfp_mk_min=prctile(tfp_mk(index_win),perc_min);
            tfp_ad_max=prctile(tfp_ad(index_win),perc_max); tfp_ad_min=prctile(tfp_ad(index_win),perc_min);
            tau_l_max=prctile(tau_l_ad(index_win),perc_max); tau_l_min=prctile(tau_l_ad(index_win),perc_min);
            tau_k_max=prctile(tau_k(index_win),perc_max); tau_k_min=prctile(tau_k(index_win),perc_min);
            rl_max=prctile(rl(index_win),perc_max); rl_min=prctile(rl(index_win),perc_min);
            va_max=prctile(va(index_win),perc_max); va_min=prctile(va(index_win),perc_min);
            tfp_win(index_win)=max(min(tfp_max,tfp(index_win)),tfp_min);
            tfp_mk_win(index_win)=max(min(tfp_mk_max,tfp_mk(index_win)),tfp_mk_min);
            tfp_ad_win(index_win)=max(min(tfp_ad_max,tfp_ad(index_win)),tfp_ad_min);
            tau_l_win(index_win)=max(min(tau_l_max,tau_l_ad(index_win)),tau_l_min);
            tau_k_win(index_win)=max(min(tau_k_max,tau_k(index_win)),tau_k_min);
            rl_win(index_win)=max(min(rl_max,rl(index_win)),rl_min);
            va_win(index_win)=max(min(va_max,va(index_win)),va_min);
        end

    end
        
end

% dealing with NaN
index=find(~isfinite(tfp)|~isfinite(tau_l)|~isfinite(tau_k));
tfp(index)=0; tfp_r(index)=0; tau_l(index)=0; tau_k(index)=0;
index=find(~isfinite(tfp_mk)|~isfinite(tau_l_mk)|~isfinite(tau_k_mk));
tfp_mk(index)=0; tau_l_mk(index)=0; tau_k_mk(index)=0;
index=find(~isfinite(tfp_ad)|~isfinite(tau_l_ad)|~isfinite(tau_k));
tfp_ad(index)=0; tau_l_ad(index)=0; tau_k(index)=0;
index=find(~isfinite(tfp_win)|~isfinite(tau_l_win)|~isfinite(tau_k_win));
tfp_win(index)=0; tau_l_win(index)=0; tau_k_win(index)=0;


save data_tfp hc_index tfp tfp_r tfp_r_ad rl_index tau_l tau_k tfp_mk tau_l_mk tau_k_mk tfp_r_mk w eta tfp_ad tau_l_ad rl tau_thres tfp_win tfp_mk_win tfp_ad_win va_win tau_l_win tau_k_win rl_win hc_index

% size of redundant workers
index=find(year==1998);
rl_ratio(1)=sum(rl(index))/sum(emp(index));
index_soe=find(year==1998 & soe==1);
rl_ratio_soe(1)=sum(rl(index_soe))/sum(emp(index_soe));

index=find(year==2007);
rl_ratio(2)=sum(rl(index))/sum(emp(index));
index_soe=find(year==2007 & soe==1);
rl_ratio_soe(2)=sum(rl(index_soe))/sum(emp(index_soe));

disp('rl ratio 1998 2007')
disp(rl_ratio)
disp('rl ratio SOE 1998 2007')
disp(rl_ratio_soe)

% check
% xxx(:,1)=emp;
% xxx(:,2)=emp_ad;
% 
% counterfactual_benchmark_redundant_labor