clear

load data_positive

%% state registration capital distributions

subplot(1,1,1)
for t=1998:2007
    index_25=find(year==t & fr>=1/4 & soe==1);
    index_50=find(year==t & fr>=1/2 & soe==1);
    index_75=find(year==t & fr>=3/4 & soe==1);
    index_soe=find(year==t & soe==1);
    share_25(t-1997)=length(index_25)/length(index_soe);
    share_50(t-1997)=length(index_50)/length(index_soe);
    share_w_50(t-1997)=sum(emp(index_50))/sum(emp(index_soe));
    share_75(t-1997)=length(index_75)/length(index_soe);
end

load data_positive_13

index_25=find(year==2012 & fr>=1/4 & soe==1);
index_50=find(year==2012 & fr>=1/2 & soe==1);
index_75=find(year==2012 & fr>=3/4 & soe==1);
index_soe=find(year==2012 & soe==1);
share_25(11)=length(index_25)/length(index_soe);
share_50(11)=length(index_50)/length(index_soe);
share_w_50(11)=sum(emp(index_50))/sum(emp(index_soe));
share_75(11)=length(index_75)/length(index_soe);

T1=1998:2007;

T3=2007:2012;
X=[2007 2012];
Y=[share_50(10) share_50(11)];
share_50_linear=interp1(X,Y,T3);
Y=[share_w_50(10) share_w_50(11)];
share_50_w_linear=interp1(X,Y,T3);

plot(T1,share_50(1:10),'- r','linewidth',2)
hold on
plot(T1,share_w_50(1:10),'-* b','linewidth',2)
hold on
plot(T3,share_50_linear,': r','linewidth',2)
hold on
plot(T3,share_50_w_linear,': b','linewidth',2)
hold off
% legend('legal person share >= 25%','legal person share >= 50%','legal person share >= 75%')
legend('unweighted','weighted')
legend('boxoff')
xlabel('year')
axis([1998 2012 0 0.5])
box off
set(gca,'YTick',[0:0.1:0.5])
set(gca,'XTick',1998:2012)
set(gca,'ygrid','on')
