clear

load data_positive

%% keep SOE
index=find((conv_own==1 | conv_own==2) & d_inc==1);
year=year(index); va=va(index); conv_own=conv_own(index); soe_div=soe_div(index);

% length
n=length(va);

%% construct first 
lag_index=zeros(n,1);
lag_index(2:n,1)=newid(2:n,1)==newid(1:n-1,1);

% find firm's location of first sample and last sample 
first=zeros(n,1);
for i=1:n
    if lag_index(i)==0
        temp_f=i;
    end
    first(i)=temp_f;
end

% xxx(:,1)=year;
% xxx(:,2)=first;

%% generate the percentile according to va
temp=zeros(n,4);
for i=1:n
    temp(i,1)=i; temp(i,2)=year(i); temp(i,3)=va(i);
end
temp=sortrows(temp, [2 3]);
nyear=zeros(10,1);
for i=1998:2007
    nyear(i-1997)=length(find(year==i));
end
in=0;
for i=1:n
    in=in+1;
    temp(i,4)= floor((in-1)/nyear(temp(i,2)-1997)*100)+1;
    if in==nyear(temp(i,2)-1997)
        in=0;
    end
end
temp=sortrows(temp, [1]);
cl_va=temp(:,4);

%% diversification and privatization
% dummy for privatized SOE in 2007
year07_pri=zeros(n,1);
cl_va_ini=zeros(n,1);
for i=1:n
    year07_pri(i)=conv_own(i)==2;
    cl_va_ini(i)=cl_va(first(i));
end

% shares
for i=1:100
    div(i,1)=length(find(year==2007 & soe_div & cl_va_ini==i))/length(find(year==1998 & cl_va==i));
    pri(i,1)=length(find(year==2007 & conv_own==2 & cl_va_ini==i))/length(find(year==1998 & cl_va==i));
end

%% Figure Surival Rates
% smooth
ord=5; % order of polynomial
x=(1:100)';
for i=0:ord
    X(:,i+1)=x.^i;
end
Y=pri;
b=regress(Y,X)
pri=X*b;

subplot(1,1,1)
plot([1:100]',pri*100,'r -','LineWidth',2)
xlabel('percentiles by 1998 value-added')
axis([0 100 0 50])
% print('-depsc2','privatization_percentile.eps');

%% new data

clear

load data_positive_13

%% keep SOE
index=find(year==2007 & soe==1 & d_07_12==1);
year=year(index); va=va(index); soe_12=soe_12(index);

% length
n=length(va);

%% generate the percentile according to sales
temp=zeros(n,4);
for i=1:n
    temp(i,1)=i; temp(i,2)=1; temp(i,3)=va(i);
end
temp=sortrows(temp, [2 3]);
in=0;
for i=1:n
    in=in+1;
    temp(i,4)= floor((in-1)/n*100)+1;
end
temp=sortrows(temp, [1]);
cl_va=temp(:,4);

% shares
for i=1:100
    pri(i,1)=length(find(soe_12==0 & cl_va==i))/length(find(cl_va==i));
end

% smooth
ord=5; % order of polynomial
x=(1:100)';
for i=0:ord
    X(:,i+1)=x.^i;
end
Y=pri;
b=regress(Y,X)
pri=X*b;

subplot(1,1,1)
plot([1:100]',pri*100,'r -','LineWidth',2)
xlabel('percentiles by 2007 value-added')
axis([0 100 0 50])
stata(:,1)=[1:100]';
stata(:,2)=pri*100;