clear

close all

load data_positive

% state share
for t=1998:2007
    
    % standard
    index=find(year==t);
    index_soe=find(year==t & soe==1);
    soe_0(t-1997)=sum(sales(index_soe))/sum(sales(index));

    % by registration type
    index_soe_dj=find(year==t & soe_dj==1);
    soe_0_dj(t-1997)=sum(sales(index_soe_dj))/sum(sales(index));

    % SOE registered as private firms
    index_soe_dj_priv=find(year==t & soe_dj==0 & soe==1);
    soe_dj_priv(t-1997)=length(index_soe_dj_priv)/length(index_soe);
    soe_dj_priv_w(t-1997)=sum(emp(index_soe_dj_priv))/sum(emp(index_soe));

    % exclude "old" entrants
    if t > 1998
        index=find(year==t & d_entry_old==0);
        index_soe=find(year==t & soe==1 & d_entry_old==0);
    end
    soe_1(t-1997)=sum(sales(index_soe))/sum(sales(index));

end

load data_positive_13
% SOE registered as private firms
index_soe=find(year==2012 & soe==1);
index_soe_dj_priv=find(year==2012 & soe_dj==0 & soe==1);
soe_dj_priv_12=length(index_soe_dj_priv)/length(index_soe);
soe_dj_priv_w_12=sum(emp(index_soe_dj_priv))/sum(emp(index_soe));

T3=2007:2012
X=[2007 2012];
Y=[soe_dj_priv(10) soe_dj_priv_12];
soe_dj_priv_linear=interp1(X,Y,T3);
Y=[soe_dj_priv_w(10) soe_dj_priv_w_12];
soe_dj_priv_w_linear=interp1(X,Y,T3);

figure(1)
T1=1998:2007;
plot(T1,soe_dj_priv,'- r','linewidth',2)
hold on
plot(T1,soe_dj_priv_w,'-* b','linewidth',2)
hold on
plot(T3,soe_dj_priv_linear,': r','linewidth',2)
hold on
plot(T3,soe_dj_priv_w_linear,': b','linewidth',2)
% plot(2012,soe_dj_priv_12,'* r','linewidth',2)
legend('unweighted','weighted')
legend('boxoff')
axis([1998 2012 0 0.6])
hold off
box off
set(gca,'YTick',[0:0.1:0.6])
set(gca,'XTick',1998:2012)
set(gca,'ygrid','on')