load data_positive

% state share
for t=1998:2007
    
    % standard
    index=find(year==t);
    index_soe=find(year==t & soe==1);
    soe_0(t-1997)=sum(sales(index_soe))/sum(sales(index));

    % by registration type
    index_soe_dj=find(year==t & soe_dj==1);
    soe_0_dj(t-1997)=sum(sales(index_soe_dj))/sum(sales(index));

    % SOE registered as private firms
    index_soe_dj_priv=find(year==t & soe_dj==0 & soe==1);
    soe_dj_priv(t-1997)=length(index_soe_dj_priv)/length(index_soe);

    % exclude "old" entrants
    if t > 1998
        index=find(year==t & d_entry_old==0);
        index_soe=find(year==t & soe==1 & d_entry_old==0);
    end
    soe_1(t-1997)=sum(sales(index_soe))/sum(sales(index));

end

load data_positive_13
for t=2012:2013
    
    % standard
    index=find(year==t);
    index_soe=find(year==t & soe==1);
    soe_0_new(t-2011)=sum(sales(index_soe))/sum(sales(index));

    % by registration type
    index_soe_dj=find(year==t & soe_dj==1);
    soe_0_dj_new(t-2011)=sum(sales(index_soe_dj))/sum(sales(index));

end

soe_nbs=[0.523253414	0.514671576	0.50151209	0.474148473	0.436990213	0.405298106	0.359114151	0.344301934	0.323364354	0.306759812	0.295003959	0.279620789	0.278525763	0.271907707	0.263723457	0.250928096];

figure(1)
T1=1998:2007;
T2=1998:2013;
T3=2007:2012;
X=[2007 2012];
Y=[soe_0(10) soe_0_new(1)];
soe_0_new_linear=interp1(X,Y,T3);
Y=[soe_0_dj(10) soe_0_dj_new(1)];
soe_0_dj_new_linear=interp1(X,Y,T3);
subplot(1,1,1)
plot(T2,soe_nbs,'- k','linewidth',2)
hold on
plot(T1,soe_0,'-* r','linewidth',2)
hold on
plot(T1,soe_0_dj,'-^ b','linewidth',2)
hold on
plot(T3,soe_0_new_linear,':* r','linewidth',2)
hold on
plot(T3,soe_0_dj_new_linear,':^ b','linewidth',2)
hold off
axis([1998 2013 0 0.6])
legend('China Statistical Yearbook','State-Controlled Firms (Firm Data)','Registered as State-Owned Firms (Firm Data)')
legend('boxoff')
box off
% title('Revenue Share of State Owned Firms')
set(gca,'YTick',[0:0.1:0.6])
set(gca,'XTick',[1998:2013])
set(gca,'ygrid','on')