#delimit ;
* This program uses the "winsor" module. Download the module using
*   <ssc install winsor> command.

* Set project directory for where the data file is stored
cd "M:\BPEA\BPEA Spring 2015\HsiehSong_copy-edited\programs_and_data\";
use "may 2015 data.dta",clear;

* incumbents 1998 to 2007;
* definition;
ren col1 id;
ren col2 year;
ren col4 industry;
ren col10 d_07_12;
ren col11 Y;
ren col12 YL;
ren col14 YK;
ren col15 tfp;
ren col8 soe7;
ren col9 soe12;

gen emp = 1/(YL/Y);
gen log_Y = log(Y);
gen log_YL = log(YL);
gen log_YK = log(YK);
gen log_tfp = log(tfp);

** trim employment outliers **;
winsor emp, gen(empwin) p(0.01);
replace emp = empwin;
** end trimming ***************;

/*
quietly sum log_Y if year == 2007 & soe7 == 0 & soe12 == 0 & d_07_12 == 1 [aweight = emp] , detail;
replace log_Y = log_Y - r(mean) if year == 2007;
quietly sum log_Y if year == 2012 & soe12 == 0 & soe12 == 0 & d_07_12 == 1 [aweight = emp] , detail;
replace log_Y = log_Y - r(mean) if year == 2007;
*/


gen log_Ywin = log10(exp(log_Y))/log10(2);
replace log_YL = log10(exp(log_YL))/log10(2);
replace log_YK = log10(exp(log_YK))/log10(2);
replace log_tfp = log10(exp(log_tfp))/log10(2);

** Y/L *****************************************************************************************************************;
* Corporatized SOEs 2007 vs 2012;
twoway (kdensity log_YL if year == 2007 & soe7 == 1 & soe12 == 1  [aweight = emp], range(-4 4.3) clwidth(thick) clpattern(solid) 
) 
(kdensity log_YL if year == 2012 & soe7 == 1 & soe12 == 1 [aweight = emp], range(-4 4.3) clwidth(thick) clpattern(dash) 
),
  graphregion(color(white)) 
 xtitle(" ") legend(position(3) ring(0)) legend(off)
 plotregion(margin(zero)) ytitle(" ")
 xlabel(-4 "1/16" -3 "1/8" -2 "1/4" -1 "1/2" 0 "1" 1 "2" 2 "4" 3 "8" 4 "16")
 title("Revenue/Worker", size(medium))
 ylabel(0 .1 .2 .3)
 ;
 graph save fig1,replace;

** Entrants 2012, SOE vs Private;
twoway 
(kdensity log_YL if year == 2012 & soe12 == 1 & d_07_12 == 0 [aweight = emp], range(-4 4.3) clwidth(thick) clpattern(solid) 
)
(kdensity log_YL if year == 2012 & soe12 == 0 & d_07_12 == 0 [aweight = emp], range(-4 4.3) clwidth(thick) clpattern(dash) 
),

  graphregion(color(white)) 
 xtitle(" ") legend(position(1) ring(0)) 
 plotregion(margin(zero)) ytitle(" ")
 xlabel(-4 "1/16" -3 "1/8" -2 "1/4" -1 "1/2" 0 "1" 1 "2" 2 "4" 3 "8" 4 "16")
 title("Revenue/Worker", size(medium))
 ylabel(0 .1 .2 .3) legend(off)
    legend(region(lcolor(white)) cols(1) label(1 "State Owned") label(2 "Private") )
 ;
 graph save fig1a,replace;
 
** END Y/L **************************************************************************************************************;

** Y/K *****************************************************************************************************************;
* Corporatized SOEs, 2007 vs 2012;
twoway (kdensity log_YK if year == 2007 & soe7 == 1 & soe12 == 1  [aweight = emp], range(-4 3) clwidth(thick) clpattern(solid) 
) 
(kdensity log_YK if year == 2012 & soe7 == 1 & soe12 == 1  [aweight = emp], range(-4 3) clwidth(thick) clpattern(dash) 
),
  graphregion(color(white)) 
 xtitle(" ") legend(position(2) ring(0)) legend(off)
 plotregion(margin(zero)) ytitle(" ")
 xlabel(-4 "1/16" -3 "1/8" -2 "1/4" -1 "1/2" 0 "1" 1 "2" 2 "4" 3 "8")
 title("Revenue/Capital", size(medium))
   legend(region(lcolor(white)) cols(1) label(1 "2007") label(2 "2012") )

 ;
 graph save fig3,replace;
 
 * Entrants in 2012, SOEs vs. Private;
twoway 
(kdensity log_YK if year == 2012 & soe12 == 1 & d_07_12 == 0 [aweight = emp], range(-4.3 4) clwidth(thick) clpattern(solid) 
)
(kdensity log_YK if year == 2012  & soe12 == 0 & d_07_12 == 0 [aweight = emp], range(-4.3 4) clwidth(thick) clpattern(dash) 
)
,
  graphregion(color(white)) 
 xtitle(" ") 
 plotregion(margin(zero)) ytitle(" ") legend(off)
 xlabel(-4 "1/16" -3 "1/8" -2 "1/4" -1 "1/2" 0 "1" 1 "2" 2 "4" 3 "8" 4 "16")
 title("Revenue/Capital", size(medium))
   legend(region(lcolor(white)) cols(1) label(1 "State Owned") label(2 "Private") )

 ;
 graph save fig3a,replace;

* END Y/K **************************************************************************************************************;

** Output *****************************************************************************************************************;
* Corporatized SOEs, 2007 vs 2012;
twoway (kdensity log_Ywin if year == 2007 & soe7 == 1 & soe12 == 1  [aweight = emp], range(-3 9.7) clwidth(thick) clpattern(solid) ) 
(kdensity log_Ywin if year == 2012 & soe7 == 1 & soe12 == 1  [aweight = emp], range(-3 9.7) clwidth(thick) clpattern(dash) ),
  graphregion(color(white)) 
 xtitle(" ") legend(position(1) ring(0)) 
 plotregion(margin(zero)) ytitle(" ")
 xlabel( -3 "1/8" -2 "1/4" -1 "1/2" 0 "1" 1 "2" 2 "4" 3 "8" 4 "16" 5 "32" 6 "64" 7 "128" 8 "256" 9 "512")
 title("Revenue", size(medium))
  legend(region(lcolor(white)) cols(1) label(1 "2007") label(2 "2012") )
  ylabel(0(.05).2)
 ;
 graph save fig5,replace;
 
* Entrants in 2012, SOE vs. Private;
twoway  
(kdensity log_Ywin if year == 2012 & soe12 == 1 & d_07_12 == 0 [weight = emp], range(-3 9.3) clwidth(thick) clpattern(solid) )
(kdensity log_Ywin if year == 2012 & soe12 == 0 & d_07_12 == 0 [weight = emp], range(-3 9.3) clwidth(thick) clpattern(dash) ),
  graphregion(color(white)) 
 xtitle(" ") legend(position(1) ring(0)) 
 plotregion(margin(zero)) ytitle(" ")
 xlabel(-3 "1/8" -2 "1/4" -1 "1/2" 0 "1" 1 "2" 2 "4" 3 "8" 4 "16" 5 "32" 6 "64" 7 "128" 8 "256" 9 "512")
 title("Revenue", size(medium))
  ylabel(0(.05).2)
    legend(region(lcolor(white)) cols(1) label(1 "State Owned") label(2 "Private") )
  
 ;
 graph save fig5a,replace;
 
 * END output **************************************************************************************************************;

** TFP *****************************************************************************************************************;
* Corporatized SOEs;
twoway (kdensity log_tfp if year == 2007 & soe7 == 1 & soe12 == 1  [aweight = emp], range(-5 5) clwidth(thick) clpattern(solid) ) 
(kdensity log_tfp if year == 2012 & soe7 == 1 & soe12 == 1  [aweight = emp], range(-5 5) clwidth(thick) clpattern(dash) ),
  graphregion(color(white)) 
 xtitle(" ") legend(position(2) ring(0)) 
 plotregion(margin(zero)) ytitle(" ")
 xlabel(-5 "1/32" -4 "1/16" -3 "1/8" -2 "1/4" -1 "1/2" 0 "1" 1 "2" 2 "4" 3 "8" 4 "16" 5 "32" )
  ylabel(0(.05).3)
    legend(region(lcolor(white)) cols(1) label(1 "2007") label(2 "2012") )
    b1("TFP (Private Firms = 1)", size(medium))
 ;
 graph save figtfp0712,replace;
 * END output **************************************************************************************************************;

** combne plots *********************************************************************************************************;
gr combine fig5.gph fig1.gph fig3.gph, cols(1) graphregion(color(white))  
xsize(7) ysize(9)  l1("Density of Employment", size(small));
graph save fig_20072012,replace;

erase fig1.gph;
erase fig3.gph;
erase fig5.gph;

gr combine fig5a.gph fig1a.gph fig3a.gph, cols(1) graphregion(color(white))  
xsize(7) ysize(9)  l1("Density of Employment", size(small));
graph save fig_20072012a,replace;

erase fig1a.gph;
erase fig3a.gph;
erase fig5a.gph;
 

