use "c:\documents and settings\chsieh\my documents\grab large\data\table7_2007.dta",clear

* definition
ren col1 log_Y
ren col2 log_YL
ren col3 log_YK
ren col4 CSOE
ren col5 PSOE
ren col6 CSOE_EI
ren col7 PSOE_EI
ren col8 NSOE_EI
ren col9 CSOE_EN
ren col10 PSOE_EN
ren col11 NSOE_EN
replace NSOE_EN = 1 if PSOE_EN == 1
ren col12 cic2
gen NS = (CSOE == 0 & PSOE == 0 & CSOE_EI == 0 & PSOE_EI == 0 & NSOE_EI == 0 & CSOE_EN == 0 & PSOE_EN == 0 & NSOE_EN == 0 )
* ren col13 age

gen output = log_Y - log_YL
replace output = exp(output)
** output is now employment
* gen output = exp(log_Y)
winsor output, gen(outputwin) p(0.01)
gen log_Ywin = log_Y


reg log_Ywin CSOE PSOE CSOE_EI PSOE_EI NSOE_EI CSOE_EN NSOE_EN [aweight = outputwin], cluster(cic2)
est store Y

reg log_YL CSOE PSOE CSOE_EI PSOE_EI NSOE_EI CSOE_EN NSOE_EN [aweight = outputwin], cluster(cic2)
est store YL

reg log_YK CSOE PSOE CSOE_EI PSOE_EI NSOE_EI CSOE_EN NSOE_EN [aweight = outputwin], cluster(cic2)
est store YK

*outreg2 [Y YL YK] using 2007, word excel replace

#delimit ;
cd "c:\documents and settings\chsieh\my documents\grab large\data\";

** now for plots ***************************************************************;
quietly sum log_YL if NS == 1 [aweight = outputwin] , detail;
replace log_YL = log_YL - r(mean);

quietly sum log_YK if NS == 1 [aweight = outputwin] , detail;
replace log_YK = log_YK - r(mean);

quietly sum log_Ywin if NS == 1 [aweight = outputwin], detail;
replace log_Ywin = log_Ywin - r(mean);

replace log_Ywin = log10(exp(log_Ywin))/log10(2);
replace log_YL = log10(exp(log_YL))/log10(2);
replace log_YK = log10(exp(log_YK))/log10(2);

** Y/L *****************************************************************************************************************;
twoway (kdensity log_YL if CSOE_EN == 1 [weight = outputwin], range(-4 5) clwidth(thick) clpattern(solid) 
) 
(kdensity log_YL if NSOE_EN == 1 [weight = outputwin], range(-4 5) clwidth(thick) clpattern("dash") 
),
  graphregion(color(white)) 
 xtitle(" ") legend(position(6) ring(0)) legend(position(2) ring(0))  
 plotregion(margin(zero)) ytitle(" ")
 xlabel(-4 "1/16" -3 "1/8" -2 "1/4" -1 "1/2" 0 "1" 1 "2" 2 "4" 3 "8" 4 "16" 5 "32")
 title("VA/Worker", size(medium))
 ylabel(0(.1).3)
 legend(region(lcolor(white)) cols(1) label(1 "State Owned") label(2 "Private"))
 ;
 graph save fig1,replace;
** end Y/L **************************************************************************************************************;

** Y/K ******************************************************************************************************************;
twoway (kdensity log_YK if CSOE_EN == 1 [weight = outputwin], range(-4 5) clwidth(thick) clpattern(solid) 
) 
(kdensity log_YK if NSOE_EN == 1 [weight = outputwin], range(-4 5) clwidth(thick) clpattern("dash") 
),
  graphregion(color(white)) 
 xtitle(" ") legend(position(6) ring(0)) legend(off) 
 plotregion(margin(zero)) ytitle(" ")
 xlabel(-4 "1/16" -3 "1/8" -2 "1/4" -1 "1/2" 0 "1" 1 "2" 2 "4" 3 "8" 4 "16" 5 "32")
 title("VA/Capital", size(medium))
 ylabel(0(.1).3)
 
 ;
 graph save fig2,replace;
** end Y/K ***************************************************************************************************************; 


** output ******************************************************************************************************************;
twoway (kdensity log_Ywin if CSOE_EN == 1 [weight = outputwin], range(-6 6) clwidth(thick) clpattern(solid) 
) 
(kdensity log_Ywin if NSOE_EN == 1 [weight = outputwin], range(-6 6) clwidth(thick) clpattern("dash") 
),
  graphregion(color(white)) 
 xtitle(" ") legend(off)
 plotregion(margin(zero)) ytitle(" ")
 xlabel(-6 "1/64" -5 "1/32" -4 "1/16" -3 "1/8" -2 "1/4" -1 "1/2" 0 "1" 1 "2" 2 "4" 3 "8" 4 "16" 5 "32" 6 "64")
 title("VA", size(medium))
 ylabel(0(.1).2)
 
 
 ;
 graph save fig3,replace;
** end output ***************************************************************************************************************; 

** combine plots ***;
gr combine fig3.gph fig1.gph fig2.gph, cols(1) graphregion(color(white))  
xsize(7) ysize(9)
l1("Density of Employment", size(small));
graph save fig_new,replace;

erase fig1.gph;
erase fig2.gph;
erase fig3.gph;
