#delimit ;
* This program uses the "winsor" module. Download the module using
*   <ssc install winsor> command.

* Set project directory for where the data file is stored
cd "M:\BPEA\BPEA Spring 2015\HsiehSong_copy-edited\programs_and_data\";
use "M:\BPEA\BPEA Spring 2015\HsiehSong_copy-edited\programs_and_data\figure5.dta",clear;

* incumbents 1998 to 2007;
* definition;
ren var1 id;
ren var2 year;
ren var3 log_Y;
ren var4 log_YL;
ren var5 log_YK;
ren var6 own;
* own = 1 corporatized SOEs;
* own = 2 privatized SOEs;
* own = 3 private;
* own = 4 nationalized;

gen output = log_Y - log_YL;
replace output = exp(output);
** output is now employment;
* gen output = exp(log_Y);
winsor output if year == 1998, gen(outputwin) p(0.01);
gen log_Ywin = log_Y;

winsor output if year == 2007, gen(outputwinb) p(0.01);
replace outputwin = outputwinb if year == 2007;

quietly sum log_YL if year == 1998 & own == 3 [aweight = outputwin] , detail;
replace log_YL = log_YL - r(mean) if year == 1998;
quietly sum log_YL if year == 2007 & own == 3 [aweight = outputwin] , detail;
replace log_YL = log_YL - r(mean) if year == 2007;

quietly sum log_YK if year == 1998 & own == 3 [aweight = outputwin] , detail;
replace log_YK = log_YK - r(mean) if year == 1998;
quietly sum log_YK if year == 2007 & own == 3 [aweight = outputwin] , detail;
replace log_YK = log_YK - r(mean) if year == 2007;

quietly sum log_Ywin if year == 1998 & own == 3 [aweight = outputwin] , detail;
replace log_Ywin = log_Ywin - r(mean) if year == 1998;
quietly sum log_Ywin if year == 2007 & own == 3 [aweight = outputwin] , detail;
replace log_Ywin = log_Ywin - r(mean) if year == 2007;

replace log_Ywin = log10(exp(log_Ywin))/log10(2);
replace log_YL = log10(exp(log_YL))/log10(2);
replace log_YK = log10(exp(log_YK))/log10(2);

** Y/L *****************************************************************************************************************;
* Corporatized SOEs;
twoway (kdensity log_YL if own == 1 & year == 1998 [weight = outputwin], range(-4 4) clwidth(thick) clpattern(solid) 
) 
(kdensity log_YL if own == 1 & year == 2007 [weight = outputwin], range(-4 4) clwidth(thick) clpattern(dash) 
),
  graphregion(color(white)) 
 xtitle(" ") legend(position(6) ring(0)) legend(off) 
 plotregion(margin(zero)) ytitle(" ")
 xlabel(-4 "1/16" -3 "1/8" -2 "1/4" -1 "1/2" 0 "1" 1 "2" 2 "4" 3 "8" 4 "16")
 title("State Owned Firms", size(medium))
 ylabel(0 .1 .2 .3 .35)
 ;
 graph save fig1,replace;
 

 * Privatized SOEs;
twoway (kdensity log_YL if own == 2 & year == 1998 [weight = outputwin], range(-4 4) clwidth(thick) clpattern(solid) 
) 
(kdensity log_YL if own == 2 & year == 2007 [weight = outputwin], range(-4 4) clwidth(thick) clpattern(dash) 
),
  graphregion(color(white)) 
 xtitle(" ") legend(position(2) ring(0))
 plotregion(margin(zero)) ytitle(" ")
 xlabel(-4 "1/16" -3 "1/8" -2 "1/4" -1 "1/2" 0 "1" 1 "2" 2 "4" 3 "8" 4 "16")
 title("Privatized State Owned Firms", size(medium))
      legend(region(lcolor(white)) cols(1) label(1 "1998") label(2 "2007"))
 ylabel(0 .1 .2 .3 .35)
 ;
 graph save fig2,replace;
 
 * Private Firms;
twoway (kdensity log_YL if own == 3 & year == 1998 [weight = outputwin], range(-4 4) clwidth(thick) clpattern(solid) 
) 
(kdensity log_YL if own == 3 & year == 2007 [weight = outputwin], range(-4 4) clwidth(thick) clpattern(dash)
),
  graphregion(color(white)) 
 xtitle(" ") legend(position(6) ring(0)) legend(off) 
  xlabel(-4 "1/16" -3 "1/8" -2 "1/4" -1 "1/2" 0 "1" 1 "2" 2 "4" 3 "8" 4 "16")
   ylabel(0 .1 .2 .3 .35)
 plotregion(margin(zero)) ytitle(" ")
 title("Private", size(medium))
 ;
** END Y/L **************************************************************************************************************;

** Y/K *****************************************************************************************************************;
* Corporatized SOEs;
twoway (kdensity log_YK if own == 1 & year == 1998 [weight = outputwin], range(-4 3) clwidth(thick) clpattern(solid) 
) 
(kdensity log_YK if own == 1 & year == 2007 [weight = outputwin], range(-4 3) clwidth(thick) clpattern(dash) 
),
  graphregion(color(white)) 
 xtitle(" ") legend(position(6) ring(0)) legend(off) 
 plotregion(margin(zero)) ytitle(" ")
 xlabel(-4 "1/16" -3 "1/8" -2 "1/4" -1 "1/2" 0 "1" 1 "2" 2 "4" 3 "8")
 title("State Owned Firms", size(medium))

 ;
 graph save fig3,replace;
 
 * Privatized SOEs;
twoway (kdensity log_YK if own == 2 & year == 1998 [weight = outputwin], range(-4 3) clwidth(thick) clpattern(solid) 
) 
(kdensity log_YK if own == 2 & year == 2007 [weight = outputwin], range(-4 3) clwidth(thick) clpattern(dash) 
),
  graphregion(color(white)) 
 xtitle(" ") legend(position(2) ring(0)) 
 plotregion(margin(zero)) ytitle(" ")
 xlabel(-4 "1/16" -3 "1/8" -2 "1/4" -1 "1/2" 0 "1" 1 "2" 2 "4" 3 "8")
 title("Privatized State Owned Firms", size(medium))
     legend(region(lcolor(white)) cols(1) label(1 "1998") label(2 "2007"))
 ;
 graph save fig4,replace;
 
 * Private Firms;
twoway (kdensity log_YK if own == 3 & year == 1998 [weight = outputwin], range(-4 4) clwidth(thick) clpattern(solid) 
) 
(kdensity log_YK if own == 3 & year == 2007 [weight = outputwin], range(-3 3) clwidth(thick) clpattern(dash) 
),
  graphregion(color(white)) 
 xtitle(" ") legend(position(6) ring(0)) legend(off) 
 plotregion(margin(zero)) ytitle(" ")
 xlabel(-4 "1/16" -3 "1/8" -2 "1/4" -1 "1/2" 0 "1" 1 "2" 2 "4" 3 "8" 4 "16")
 title("Private", size(medium))
 ;
 * graph save fig4a,replace;
** END Y/K **************************************************************************************************************;

** Output *****************************************************************************************************************;
* Corporatized SOEs;
twoway (kdensity log_Ywin if own == 1 & year == 1998 [aweight = outputwin], range(-5 8.2) clwidth(thick) clpattern(solid) ) 
(kdensity log_Ywin if own == 1 & year == 2007 [aweight = outputwin], range(-5 8.2) clwidth(thick) clpattern(dash) ),
  graphregion(color(white)) 
 xtitle(" ") legend(position(6) ring(0)) legend(off) 
 plotregion(margin(zero)) ytitle(" ")
 xlabel(-5 "1/32" -4 "1/16" -3 "1/8" -2 "1/4" -1 "1/2" 0 "1" 1 "2" 2 "4" 3 "8" 4 "16" 5 "32" 6 "64" 7 "128" 8 "256")
 title("State Owned Firms", size(medium))
  ylabel(0(.05).2)
 ;
 graph save fig5,replace;
 
 * Privatized SOEs;
twoway (kdensity log_Ywin if own == 2 & year == 1998 [aweight = outputwin], range(-5 8.2) clwidth(thick) clpattern(solid) ) 
(kdensity log_Ywin if own == 2 & year == 2007 [aweight = outputwin], range(-5 8.2) clwidth(thick) clpattern(dash) ),
  graphregion(color(white)) 
 xtitle(" ") legend(position(2) ring(0))  
 plotregion(margin(zero)) ytitle(" ")
 xlabel(-5 "1/32" -4 "1/16" -3 "1/8" -2 "1/4" -1 "1/2" 0 "1" 1 "2" 2 "4" 3 "8" 4 "16" 5 "32" 6 "64" 7 "128" 8 "256")
 title("Privatized State Owned Firms", size(medium))
  ylabel(0(.05).2)
    legend(region(lcolor(white)) cols(1) label(1 "1998") label(2 "2007"))
 ;
 graph save fig6,replace;
 
 * Private Firms;
twoway (kdensity log_Ywin if own == 3 & year == 1998 , range(-6 6.3) clwidth(thick) clpattern(solid) ) 
(kdensity log_Ywin if own == 3 & year == 2007, range(-6 6.3) clwidth(thick) clpattern(dash) ),
  graphregion(color(white)) 
 xtitle(" ") legend(position(6) ring(0)) legend(off) 
 plotregion(margin(zero)) ytitle(" ")
 xlabel(-6 "1/64" -5 "1/32" -4 "1/16" -3 "1/8" -2 "1/4" -1 "1/2" 0 "1" 1 "2" 2 "4" 3 "8" 4 "16" 5 "32" 6 "64" 7 "128")
 title("Private", size(medium))
  ylabel(0 .1 .2 .25)
 ;
 graph save fig7,replace;
** END output **************************************************************************************************************;


** combne plots *********************************************************************************************************;
gr combine fig1.gph fig2.gph, cols(1) graphregion(color(white))  
xsize(7) ysize(9) b1("VA/Worker (Mean Private Firms = 1)", size(small) ) l1("Density of Employment", size(small));
graph save fig_yl,replace;

erase fig1.gph;
erase fig2.gph;

gr combine fig3.gph fig4.gph, cols(1) graphregion(color(white))  
xsize(7) ysize(9) b1("VA/Capital (Mean Private Firms = 1)", size(small) ) l1("Density of Employment", size(small));
graph save fig_yk,replace;

erase fig3.gph;
erase fig4.gph;

gr combine fig5.gph fig6.gph, cols(1) graphregion(color(white))  
xsize(7) ysize(9) b1("Value-Added (Mean Private Firms = 1)", size(small) ) l1("Density of Employment", size(small));
graph save fig_y,replace;

erase fig5.gph;
erase fig6.gph;
erase fig7.gph;


 

