#delimit ;
cd "M:\BPEA\BPEA Spring 2015\HsiehSong_copy-edited\programs_and_data\";


use "figure10.dta",clear;      ** incumbents 1998 to 2007;
* definition;
destring,replace;
ren var1 pctileva;
ren var2 soe98;
ren var3 soe07;   
ren var4 priv98;  
ren var5 priv07;  
   

** Y/L *****************************************************************************************************************;
* Corporatized SOEs;
twoway (lpoly soe98 pctileva , clwidth(thick) clpattern(solid) 
) 
(lpoly soe07 pctileva, clwidth(thick) clpattern(dash) 
),
  graphregion(color(white)) 
 xtitle(" ") legend(position(2) ring(0)) 
 plotregion(margin(zero)) ytitle(" ")
 xlabel(1 10 25 50 75 90 99)
 title("State Owned Firms", size(medium))
 ylabel(0.2(.1).9)
   legend(region(lcolor(white)) cols(1) label(1 "1998") label(2 "2007") )
     legend(region(lcolor(white)) cols(1) label(1 "1998") label(2 "2007"))
 ;
 graph save fig1,replace;

* Corporatized SOEs;
twoway (lpoly priv98 pctileva , clwidth(thick) clpattern(solid) 
) 
(lpoly priv07 pctileva , clwidth(thick) clpattern(dash) 
),
  graphregion(color(white)) 
 xtitle(" ") legend(position(6) ring(0)) legend(off) 
 plotregion(margin(zero)) ytitle(" ")
 xlabel(1 10 25 50 75 90 99)
 title("Privatized State Owned Firms", size(medium))
 ylabel(0.2(.1).9)
  ;
 graph save fig2,replace;


gr combine fig1.gph fig2.gph, cols(1) graphregion(color(white))  
xsize(7) ysize(9) b1("Size Percentile in 1998", size(small) ) l1("TFP (Private Firms = 1)", size(small));
graph save fig_tfpsize,replace;

erase fig1.gph;
erase fig2.gph;



 

