#delimit ;
* This program uses the "winsor" module. Download the module using
*   <ssc install winsor> command.

* Set project directory for where the data file is stored
cd "M:\BPEA\BPEA Spring 2015\HsiehSong_copy-edited\programs_and_data\";
use "figure9.dta",clear;

* incumbents 1998 to 2007;
* definition;
ren var1 id;
ren var2 year;
ren var3 tfp;
ren var4 own;
* own = 1 corporatized SOEs;
* own = 2 privatized SOEs;
* own = 3 private;
* own = 4 nationalized;
sort year id;
save bs,replace;

use "figure5.dta",clear;
ren var1 id;
ren var2 year;
ren var3 log_Y;
ren var4 log_YL;
keep id year log_Y log_YL;
sort year id;
save bs2,replace;

use bs,clear;
  merge year id using bs2;
  erase bs.dta;
  erase bs2.dta;
  keep if _merge == 3;
  
gen output = log_Y - log_YL;
replace output = exp(output);
** output is now employment;
* gen output = exp(log_Y);
winsor output if year == 1998, gen(outputwin) p(0.01);
gen log_Ywin = log_Y;

winsor output if year == 2007, gen(outputwinb) p(0.01);
replace outputwin = outputwinb if year == 2007;

quietly sum tfp if year == 1998 & own == 3  [aweight = outputwin], detail;
replace tfp = tfp - r(mean) if year == 1998;
quietly sum tfp if year == 2007 & own == 3 [aweight = outputwin] , detail;
replace tfp = tfp - r(mean) if year == 2007;

replace tfp = log10(tfp)/log10(2);


** TFP *****************************************************************************************************************;
* Corporatized SOEs;
twoway (kdensity tfp if own == 1 & year == 1998 [aweight = outputwin], range(-5 5.2) clwidth(thick) clpattern(solid) ) 
(kdensity tfp if own == 1 & year == 2007 [aweight = outputwin], range(-5 5.2) clwidth(thick) clpattern(dash) ),
  graphregion(color(white)) 
 xtitle(" ") legend(position(6) ring(0)) legend(off) 
 plotregion(margin(zero)) ytitle(" ")
 xlabel(-5 "1/32" -4 "1/16" -3 "1/8" -2 "1/4" -1 "1/2" 0 "1" 1 "2" 2 "4" 3 "8" 4 "16" 5 "32")
 title("State Owned Firms", size(medium))
  ylabel(0(.05).25)
 ;
 graph save fig5,replace;
 
 * Privatized SOEs;
twoway (kdensity tfp if own == 2 & year == 1998 [aweight = outputwin], range(-5 5.2) clwidth(thick) clpattern(solid) ) 
(kdensity tfp if own == 2 & year == 2007 [aweight = outputwin], range(-5 5.2) clwidth(thick) clpattern(dash) ),
  graphregion(color(white)) 
 xtitle(" ") legend(position(2) ring(0))  
 plotregion(margin(zero)) ytitle(" ")
 xlabel(-5 "1/32" -4 "1/16" -3 "1/8" -2 "1/4" -1 "1/2" 0 "1" 1 "2" 2 "4" 3 "8" 4 "16" 5 "32")
 title("Privatized State Owned Firms", size(medium))
  ylabel(0(.05).25)
    legend(region(lcolor(white)) cols(1) label(1 "1998") label(2 "2007"))
 ;
 graph save fig6,replace;
 
 * Private Firms;
twoway (kdensity tfp if own == 3 & year == 1998 , range(-6 6.3) clwidth(thick) clpattern(solid) ) 
(kdensity tfp if own == 3 & year == 2007, range(-6 6.3) clwidth(thick) clpattern(dash) ),
  graphregion(color(white)) 
 xtitle(" ") legend(position(6) ring(0)) legend(off) 
 plotregion(margin(zero)) ytitle(" ")
 xlabel(-6 "1/64" -5 "1/32" -4 "1/16" -3 "1/8" -2 "1/4" -1 "1/2" 0 "1" 1 "2" 2 "4" 3 "8" 4 "16" 5 "32" 6 "64")
 title("Private", size(medium))
  ylabel(0(.1).3)
 ;
 graph save fig7,replace;
** END output **************************************************************************************************************;


** combne plots *********************************************************************************************************;

gr combine fig5.gph fig6.gph, cols(1) graphregion(color(white))  
xsize(7) ysize(9) b1("TFP (Private Firms = 1)", size(small) ) l1("Density of Employment", size(small));
graph save fig_tfp,replace;

erase fig5.gph;
erase fig6.gph;
* erase fig7.gph;


 

