clear

load data_positive

load data_tfp % run firm_tep_distortion

load data_distortion_industry

load data_parameter

hc_index=1; % 0 for benchmark and 1 for education adjusted human capital
if hc_index == 1
    emp=hc;
end

open_index=1; % 1 for open economy and zero for closed economy

distortion_index=1; % 1 for benchmark and 0 for improving labor distortions

redundancy_index=1; % 1 for redundant workers to have zero productivity and 0 for them to be equally productive 0

% definition: unbalanced panel
tfp_ubp=tfp_ad; % tfp_win; % tfp_ad;
tau_l_ubp=tau_l_ad; % tau_l_win; % tau_l_ad;
tau_k_ubp=tau_k; % tau_k_win; % tau_k;
rl_ubp=rl; % rl_win;
clear tfp tau_l tau_k rl

% condition
cond=1; % 1 for new firms

% excluding five industries
cic2_index=[6	8	9	10	13	14	15	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	39	40	41	42  44	46]';

num=length(cic2_index);

% consistency of alpha
j=0;
for i=1:num
    
    index=find(alpha(:,1)==cic2_index(i));
    if isempty(index) ~= 1
        j=j+1;
        alpha_new(j,:)=alpha(index,:);
    end
    
end
alpha=alpha_new;

% index length (for finding exiting firms)
n=length(va);
index_length(:,1)=1:n;

% compute TFP
for t=1998:2007
        
    % by industry
    for i=1:num
        
        % load data for alpha
        alp=alpha(i,2);
        
        % year and industry index
        index=find(year==t & cic2==cic2_index(i));
        
        % load firm-level data
        y=va(index); k=rk(index); l=emp(index); tfp=tfp_ubp(index); tau_l=tau_l_ubp(index); tau_k=tau_k_ubp(index); rl=rl_ubp(index);
        % ownership
        soe_temp=soe(index); conv_own_temp=conv_own(index);
        % industry
        cic2_temp=cic2(index);
        % incumbent firms
        d_inc_temp=d_inc(index);
        % firms enter after 1998 and survive in 2007
        d_entry_surv_temp=d_entry_surv(index);
        % new incumbent firms
        d_entry_old_temp=d_entry_old(index);
        % new firms
        d_entry_new_temp=d_entry_new(index);
 
        % initial tfp and distortions
        tfp_ini=tfp_ubp(first(index));
        tau_l_ini=tau_l_ubp(first(index));
        tau_k_ini=tau_k_ubp(first(index));
        
        % initial redundant labor
        rl_ini=rl_ubp(first(index));
        
        % initial cic2
        cic2_ini=cic2(first(index));

        % identifying new SOEs
        if t > 1998
            
            % entry of new firms
            index_new_temp=find(d_entry_new_temp==1);
            tfp_ini(index_new_temp)=0;
            tau_l_ini(index_new_temp)=0;
            tau_k_ini(index_new_temp)=0;
            rl_ini(index_new_temp)=0;
            
        end
        
        % incumbent corp. SOE
        index_cso=find(year==t & cic2==cic2_index(i) & conv_own==1 & d_inc==1); 
        % incumbent privatized SOE
        index_pso=find(year==t & cic2==cic2_index(i) & conv_own==2 & d_inc==1);
        
        % industry patterns
        L=sum(emp(index)); Y=sum(va(index)); K=sum(rk(index));
        r=alp*(1-eta)*sum(va(index_cso))/sum(rk(index_cso));

        %*********************************************************************
        % generating pseudo data: no tfp growth, no change labor distortions 
        % for incumbent Corp./Priv. SOE and restoring exiting SOE
        %*********************************************************************

        % counterfactual: shutting down all tfp growth for incumbent Corp.
        % and Priv. SOE and, if cond==1, new SOEs
        if cond == 0
            index_replace=cic2_temp==cic2_ini&d_inc_temp==1&(conv_own_temp==1|conv_own_temp==2);
        elseif cond == 1
            if t == 1998
                index_replace=cic2_temp==cic2_ini&d_inc_temp==1&(conv_own_temp==1|conv_own_temp==2);
            else
                index_replace=cic2_temp==cic2_ini&(conv_own_temp==1|conv_own_temp==2)&(d_inc_temp==1|d_entry_surv_temp==1);
            end
        end
        
        % counterfactuals
        fun_cf
                
        % counterfactual: restore exiting SOE (with initial tfp and labor and age >= t-1998)
        if t == 1998
            
            num_f=0; num_exit=0;
            exit=0; % 1 indicating experiment on exit firms; 0 indicating no change on exit firms;
            
        elseif t > 1998
            
            exit=1; % 1 indicating experiment on exit firms; 0 indicating no change on exit firms;
            index_exit=find(year<=t-1 & cic2_first==cic2_index(i) & soe==1 & last==index_length & d_exit==1 & d_entry_new~=1);
            num_f=size(index,1);
            num_exit=size(index_exit,1);
            
            % counterfactuals
            tfp_cf(num_f+1:num_f+num_exit,1)=tfp_ubp(first(index_exit));
            rl_cf(num_f+1:num_f+num_exit,1)=rl_ubp(first(index_exit));
            tau_l_cf(num_f+1:num_f+num_exit,1)=tau_l_ubp(first(index_exit));
            tau_k_cf(num_f+1:num_f+num_exit,1)=tau_k_ubp(first(index_exit));

        end
        
        % save
        tfp_exit_cf=tfp_cf(num_f+1:num_f+num_exit,1); tau_k_exit_cf=tau_k_cf(num_f+1:num_f+num_exit,1); 
        tau_l_exit_cf=tau_l_cf(num_f+1:num_f+num_exit,1); rl_exit_cf=rl_cf(num_f+1:num_f+num_exit,1); 
        save temp_exit num_f num_exit tfp_exit_cf tau_k_exit_cf tau_l_exit_cf rl_exit_cf
        
        % results
        fun_benchmark;
        
        % results
        Y_bm=yyy(1); K_bm=yyy(2); Y_S_bm=yyy(3);
        Y_bm_cso=yyy(4); Y_bm_pso=yyy(5); Y_bm_nso=yyy(6);
        L_bm_cso=yyy(7); L_bm_pso=yyy(8); L_bm_nso=yyy(9);
        Y_bm_exit=yyy(10); L_bm_exit=yyy(11);
        Y_bm_cso_new=yyy(12); Y_bm_pso_new=yyy(13); Y_bm_nso_new=yyy(14);
        L_bm_cso_new=yyy(15); L_bm_pso_new=yyy(16); L_bm_nso_new=yyy(17);
        
        % labor redundancy
        RL_bm_share(t-1997,i)=sum(rl)/L;
        
        %***********************************************
        % generating pseudo data: Kick out Exiting SOE
        %***********************************************

        % counterfactual: shutting down all tfp growth for all Corp. and Priv. SOE
        if cond == 0
            index_replace=cic2_temp==cic2_ini&d_inc_temp==1&(conv_own_temp==1|conv_own_temp==2);
        elseif cond == 1
            if t == 1998
                index_replace=cic2_temp==cic2_ini&d_inc_temp==1&(conv_own_temp==1|conv_own_temp==2);
            else
                index_replace=cic2_temp==cic2_ini&(conv_own_temp==1|conv_own_temp==2)&(d_inc_temp==1|d_entry_surv_temp==1);
            end
        end
        
        % counterfactuals
        fun_cf
        
        % exit
        exit=0;
                
        % results
        fun_benchmark;
        
        % results
        Y_1=yyy(1); K_1=yyy(2); Y_S_1=yyy(3);
        Y_1_cso=yyy(4); Y_1_pso=yyy(5); Y_1_nso=yyy(6);
        L_1_cso=yyy(7); L_1_pso=yyy(8); L_1_nso=yyy(9);
        Y_1_cso_new=yyy(12); Y_1_pso_new=yyy(13); Y_1_nso_new=yyy(14);
        L_1_cso_new=yyy(15); L_1_pso_new=yyy(16); L_1_nso_new=yyy(17);

        %***************************************************************
        % generating pseudo data: Kick out Exiting SOE + Privatize SOE
        %***************************************************************
        
        % counterfactual: shutting down all tfp growth for all Corp.
        % SOE and the entry of new priv. SOEs
        if cond == 0
            index_replace=cic2_temp==cic2_ini&d_inc_temp==1&(conv_own_temp==1);
        elseif cond == 1
            if t == 1998
                index_replace=cic2_temp==cic2_ini&d_inc_temp==1&(conv_own_temp==1);
            else
                index_replace=cic2_temp==cic2_ini&((conv_own_temp==1&(d_inc_temp==1|d_entry_surv_temp==1))|(conv_own_temp==2&d_entry_new_temp==1));
            end
        end
        
        % counterfactuals
        fun_cf
        
        % exit
        exit=0;
                
        % results
        fun_benchmark;
        
        % results
        Y_2=yyy(1); K_2=yyy(2); Y_S_2=yyy(3);
        Y_2_cso=yyy(4); Y_2_pso=yyy(5); Y_2_nso=yyy(6);
        L_2_cso=yyy(7); L_2_pso=yyy(8); L_2_nso=yyy(9);
        Y_2_cso_new=yyy(12); Y_2_pso_new=yyy(13); Y_2_nso_new=yyy(14);
        L_2_cso_new=yyy(15); L_2_pso_new=yyy(16); L_2_nso_new=yyy(17);
        
        %********************************
        % generating pseudo data: Data
        %********************************

        % counterfactual: no change
        tfp_cf=tfp;
        
        % counterfactual: no change
        rl_cf=rl;
        
        % counterfactual: no change
        tau_k_cf=tau_k; tau_l_cf=tau_l;
        
        % exit
        exit=0;
                
        % results
        fun_benchmark;
        
        % results
        Y_3=yyy(1); K_3=yyy(2); Y_S_3=yyy(3);
        Y_3_cso=yyy(4); Y_3_pso=yyy(5); Y_3_nso=yyy(6);
        L_3_cso=yyy(7); L_3_pso=yyy(8); L_3_nso=yyy(9);
        Y_3_cso_new=yyy(12); Y_3_pso_new=yyy(13); Y_3_nso_new=yyy(14);
        L_3_cso_new=yyy(15); L_3_pso_new=yyy(16); L_3_nso_new=yyy(17);

        
        % labor redundancy
        RL_3_share(t-1997,i)=sum(rl)/L;

        %********************************************************************
        % generating pseudo data: Benchmark Case + Removing Capital
        % Distortions
        %********************************************************************
        
        % reduction in capital distortions
        reduction=0.10;

        % counterfactual: shutting down all tfp growth for all Corp. and Priv. SOE
        if cond == 0
            index_replace=cic2_temp==cic2_ini&d_inc_temp==1&(conv_own_temp==1|conv_own_temp==2);
        elseif cond == 1
            if t == 1998
                index_replace=cic2_temp==cic2_ini&d_inc_temp==1&(conv_own_temp==1|conv_own_temp==2);
            else
                index_replace=cic2_temp==cic2_ini&(conv_own_temp==1|conv_own_temp==2)&(d_inc_temp==1|d_entry_surv_temp==1);
            end
        end

        % counterfactuals
        fun_cf

        % capital distortions reduction
        index_replace=soe_temp==1;
        tau_k_cf=index_replace.*tau_k_cf+(1-index_replace).*tau_k_cf*(1-reduction);
        
        % counterfactual: restore exiting SOE (with initial tfp and labor)
        if t > 1998
            exit=1;
            load temp_exit
            tfp_cf(num_f+1:num_f+num_exit,1)=tfp_exit_cf;
            tau_k_cf(num_f+1:num_f+num_exit,1)=tau_k_exit_cf;
            tau_l_cf(num_f+1:num_f+num_exit,1)=tau_l_exit_cf;
            rl_cf(num_f+1:num_f+num_exit,1)=rl_exit_cf;
        end

        % results
        fun_benchmark;
        
        % results
        Y_4=yyy(1); K_4=yyy(2); Y_S_4=yyy(3);
        Y_4_cso=yyy(4); Y_4_pso=yyy(5); Y_4_nso=yyy(6);
        L_4_cso=yyy(7); L_4_pso=yyy(8); L_4_nso=yyy(9);
        Y_4_exit=yyy(10); L_4_exit=yyy(11);
        Y_4_cso_new=yyy(12); Y_4_pso_new=yyy(13); Y_4_nso_new=yyy(14);
        L_4_cso_new=yyy(15); L_4_pso_new=yyy(16); L_4_nso_new=yyy(17);

        %**********************************************************
        % check the robustness of the sequence of counterfactuals
        %**********************************************************
        
        %************************************************************************
        % generating pseudo data: no tfp growth, no change in labor distortions
        % for incumbent Priv. SOE and restoring exiting SOE
        % + tfp growth and distortion change for Corp. SOE
        %************************************************************************
        
        % counterfactual: shutting down all tfp growth for all Priv. SOE and
        % the entry of new SOE
        if cond == 0
            index_replace=cic2_temp==cic2_ini&d_inc_temp==1&(conv_own_temp==2);
        elseif cond == 1
            if t == 1998
                index_replace=cic2_temp==cic2_ini&d_inc_temp==1&(conv_own_temp==2);
            else
                % corporatization only
                index_replace=cic2_temp==cic2_ini&((conv_own_temp==2&(d_inc_temp==1|d_entry_surv_temp==1))|(conv_own_temp==1&d_entry_new_temp==1));
            end
        end
        
        % counterfactuals
        fun_cf
        
        % consider labor productivity improvement
        if distortion_index == 0
            if t == 2007
                g=0.127; % the increase for all corporatized SOEs
                index_cso=find(conv_own_temp==1 & tau_l < 0);
                tau_l_cf(index_cso)=min(0,(1+tau_l(index_cso))*(1+g)-1);
            end
        end
        
        % counterfactual: restore exiting SOE (with initial tfp and labor)
        if t > 1998
            exit=1;
            load temp_exit
            tfp_cf(num_f+1:num_f+num_exit,1)=tfp_exit_cf;
            tau_k_cf(num_f+1:num_f+num_exit,1)=tau_k_exit_cf;
            tau_l_cf(num_f+1:num_f+num_exit,1)=tau_l_exit_cf;
            rl_cf(num_f+1:num_f+num_exit,1)=rl_exit_cf;
        end

        % results
        fun_benchmark;
        
        % results
        Y_5=yyy(1); K_5=yyy(2); Y_S_5=yyy(3);
        Y_5_cso=yyy(4); Y_5_pso=yyy(5); Y_5_nso=yyy(6);
        L_5_cso=yyy(7); L_5_pso=yyy(8); L_5_nso=yyy(9);
        Y_5_exit=yyy(10); L_5_exit=yyy(11);
        Y_5_cso_new=yyy(12); Y_5_pso_new=yyy(13); Y_5_nso_new=yyy(14);
        L_5_cso_new=yyy(15); L_5_pso_new=yyy(16); L_5_nso_new=yyy(17);

%         %******************************************************************
%         % generating pseudo data: Shutting Down Growth of Private Firms in
%         % BP
%         %******************************************************************
%         
%         % counterfactual: shutting down all tfp growth for Incumbent
%         % private firms
%         if cond == 0
%             index_replace=d_inc_temp==1&cic2_temp==cic2_ini&(conv_own_temp==3);
%         elseif cond == 1
%             index_replace=d_inc_temp==1&cic2_temp==cic2_ini&(conv_own_temp==3)&tfp>=tfp_ini;
%         end
          
        %***********************************
        % privatizating incumbent SOE only
        %***********************************

        % counterfactual: shutting down all tfp growth for all Corp. SOE
        % and the entry of priv. SOE
        if cond == 0
            index_replace=cic2_temp==cic2_ini&d_inc_temp==1&(conv_own_temp==1);
        elseif cond == 1
            if t == 1998
                index_replace=cic2_temp==cic2_ini&d_inc_temp==1&(conv_own_temp==1);
            else
                index_replace=cic2_temp==cic2_ini&((conv_own_temp==1&(d_inc_temp==1|d_entry_surv_temp==1))|(conv_own_temp==2&d_entry_new_temp==1));
            end
        end
        
        % counterfactuals
        fun_cf

        % consider labor productivity improvement
        if distortion_index == 0
            if t == 2007
                g=0.062; % the increase for all corporatized SOEs
                index_pso=find(conv_own_temp==2 & tau_l < 0);
                tau_l_cf(index_pso)=min(0,(1+tau_l(index_pso))*(1+g)-1);
            end
        end
        
        % counterfactual: restore exiting SOE (with initial tfp and labor)
        if t > 1998
            exit=1;
            load temp_exit
            tfp_cf(num_f+1:num_f+num_exit,1)=tfp_exit_cf;
            tau_k_cf(num_f+1:num_f+num_exit,1)=tau_k_exit_cf;
            tau_l_cf(num_f+1:num_f+num_exit,1)=tau_l_exit_cf;
            rl_cf(num_f+1:num_f+num_exit,1)=rl_exit_cf;
        end

        % results
        fun_benchmark;
        
        % results
        Y_6=yyy(1); K_6=yyy(2); Y_S_6=yyy(3);
        Y_6_cso=yyy(4); Y_6_pso=yyy(5); Y_6_nso=yyy(6);
        L_6_cso=yyy(7); L_6_pso=yyy(8); L_6_nso=yyy(9);
        Y_6_exit=yyy(10); L_6_exit=yyy(11);
        Y_6_cso_new=yyy(12); Y_6_pso_new=yyy(13); Y_6_nso_new=yyy(14);
        L_6_cso_new=yyy(15); L_6_pso_new=yyy(16); L_6_nso_new=yyy(17);
        
        %******************************
        % Allowing entry of SOEs only
        %******************************
        
        if cond == 1
            
        index_replace=cic2_temp==cic2_ini&(conv_own_temp==1|conv_own_temp==2)&(d_inc_temp==1|(d_entry_new_temp~=1&d_entry_surv_temp==1));
               
        % counterfactuals
        fun_cf    
        
        % counterfactual: restore exiting SOE (with initial tfp and labor)
        if t > 1998
            exit=1;
            load temp_exit
            tfp_cf(num_f+1:num_f+num_exit,1)=tfp_exit_cf;
            tau_k_cf(num_f+1:num_f+num_exit,1)=tau_k_exit_cf;
            tau_l_cf(num_f+1:num_f+num_exit,1)=tau_l_exit_cf;
            rl_cf(num_f+1:num_f+num_exit,1)=rl_exit_cf;
        end

        % results
        fun_benchmark;
        
        % results
        Y_7=yyy(1); K_7=yyy(2); Y_S_7=yyy(3);
        Y_7_cso=yyy(4); Y_7_pso=yyy(5); Y_7_nso=yyy(6);
        L_7_cso=yyy(7); L_7_pso=yyy(8); L_7_nso=yyy(9);
        Y_7_exit=yyy(10); L_7_exit=yyy(11);
        Y_7_cso_new=yyy(12); Y_7_pso_new=yyy(13); Y_7_nso_new=yyy(14);
        L_7_cso_new=yyy(15); L_7_pso_new=yyy(16); L_7_nso_new=yyy(17);
        
        %************************************
        % Allowing entry of Corp. SOEs only
        %************************************
        
        index_replace=cic2_temp==cic2_ini&((conv_own_temp==1&(d_inc_temp==1|(d_entry_surv_temp==1&d_entry_new_temp~=1)))|conv_own_temp==2&(d_inc_temp==1|d_entry_surv_temp==1));
        
        % counterfactuals
        fun_cf    
        
        % counterfactual: restore exiting SOE (with initial tfp and labor)
        if t > 1998
            exit=1;
            load temp_exit
            tfp_cf(num_f+1:num_f+num_exit,1)=tfp_exit_cf;
            tau_k_cf(num_f+1:num_f+num_exit,1)=tau_k_exit_cf;
            tau_l_cf(num_f+1:num_f+num_exit,1)=tau_l_exit_cf;
            rl_cf(num_f+1:num_f+num_exit,1)=rl_exit_cf;
        end

        % results
        fun_benchmark;
        
        % results
        Y_8=yyy(1); K_8=yyy(2); Y_S_8=yyy(3);
        Y_8_cso=yyy(4); Y_8_pso=yyy(5); Y_8_nso=yyy(6);
        L_8_cso=yyy(7); L_8_pso=yyy(8); L_8_nso=yyy(9);
        Y_8_exit=yyy(10); L_8_exit=yyy(11);
        Y_8_cso_new=yyy(12); Y_8_pso_new=yyy(13); Y_8_nso_new=yyy(14);
        L_8_cso_new=yyy(15); L_8_pso_new=yyy(16); L_8_nso_new=yyy(17);

        %************************************
        % Allowing entry of Priv. SOEs only
        %************************************
        
        index_replace=cic2_temp==cic2_ini&((conv_own_temp==2&(d_inc_temp==1|(d_entry_surv_temp==1&d_entry_new_temp~=1)))|conv_own_temp==1&(d_inc_temp==1|d_entry_surv_temp==1));
        
        % counterfactuals
        fun_cf    
        
        % counterfactual: restore exiting SOE (with initial tfp and labor)
        if t > 1998
            exit=1;
            load temp_exit
            tfp_cf(num_f+1:num_f+num_exit,1)=tfp_exit_cf;
            tau_k_cf(num_f+1:num_f+num_exit,1)=tau_k_exit_cf;
            tau_l_cf(num_f+1:num_f+num_exit,1)=tau_l_exit_cf;
            rl_cf(num_f+1:num_f+num_exit,1)=rl_exit_cf;
        end

        % results
        fun_benchmark;
        
        % results
        Y_9=yyy(1); K_9=yyy(2); Y_S_9=yyy(3);
        Y_9_cso=yyy(4); Y_9_pso=yyy(5); Y_9_nso=yyy(6);
        L_9_cso=yyy(7); L_9_pso=yyy(8); L_9_nso=yyy(9);
        Y_9_exit=yyy(10); L_9_exit=yyy(11);
        Y_9_cso_new=yyy(12); Y_9_pso_new=yyy(13); Y_9_nso_new=yyy(14);
        L_9_cso_new=yyy(15); L_9_pso_new=yyy(16); L_9_nso_new=yyy(17);

        %***************************************************
        % Grasp the Large: Corporatization + All NEW FIRMS
        %***************************************************

        % counterfactual: shutting down all tfp growth for all Priv. SOE +
        % maintain exit SOE
        if cond == 0
            index_replace=cic2_temp==cic2_ini&d_inc_temp==1&(conv_own_temp==2);
        elseif cond == 1
            if t == 1998
                index_replace=cic2_temp==cic2_ini&d_inc_temp==1&(conv_own_temp==2);
            else
                % corporatization + new SOEs
                index_replace=cic2_temp==cic2_ini&(conv_own_temp==2&(d_inc_temp==1|(d_entry_surv_temp==1&d_entry_new_temp~=1)));
            end
        end
        
        % counterfactuals
        fun_cf
        
        % counterfactual: restore exiting SOE (with initial tfp and labor)
        if t > 1998
            exit=1;
            load temp_exit
            tfp_cf(num_f+1:num_f+num_exit,1)=tfp_exit_cf;
            tau_k_cf(num_f+1:num_f+num_exit,1)=tau_k_exit_cf;
            tau_l_cf(num_f+1:num_f+num_exit,1)=tau_l_exit_cf;
            rl_cf(num_f+1:num_f+num_exit,1)=rl_exit_cf;
        end

        % results
        fun_benchmark;
        
        % results
        Y_10=yyy(1); K_10=yyy(2); Y_S_10=yyy(3);
        Y_10_cso=yyy(4); Y_10_pso=yyy(5); Y_10_nso=yyy(6);
        L_10_cso=yyy(7); L_10_pso=yyy(8); L_10_nso=yyy(9);
        Y_10_exit=yyy(10); L_10_exit=yyy(11);
        Y_10_cso_new=yyy(12); Y_10_pso_new=yyy(13); Y_10_nso_new=yyy(14);
        L_10_cso_new=yyy(15); L_10_pso_new=yyy(16); L_10_nso_new=yyy(17);

        end % if cond == 1
        

        %**********
        % summary
        %**********
        
        fun_result_industry
        
    end % i
    
    % aggregation
    index=find(year==t); L_agg=sum(emp(index));
    fun_result_aggregate
    
end % t
        
figure(1)
subplot(1,1,1)
T=1998:2007;
plot(T,Y_bm_t,'k :o','LineWidth',2)
% hold on
% plot(T,Y_1_t,'g :+','LineWidth',2)
% hold on
% plot(T,Y_2_t,'b -.^','LineWidth',2)
% hold on
% plot(T,Y_5_t,'g --+','LineWidth',2)
% plot(T,Y_2_t+(Y_3_t-Y_2_t)/2,'g --+','LineWidth',2)
hold on
plot(T,Y_3_t,'r -*','LineWidth',2)
hold off
% legend('benchmark','EXP I','EXP II','EXP III')
legend('Benchmark','Data')
xlabel('year')
axis([1998 2007 0 8])
% if open_index == 1
%     print('-depsc2','slide_cf.eps');
% elseif open_index == 0
%     print('-depsc2','slide_cf_closed.eps');
% end

%% excel file
Tab(:,1)=Y_bm_t';
Tab(:,2)=Y_3_t';

%% display results
disp('Table 8: Welfare Gains')
if cond == 0
    disp('let go of the small, exit, privatization, grasp the large, overall')
    result=[Y_2_t(10)/Y_bm_t(10) Y_1_t(10)/Y_bm_t(10) Y_6_t(10)/Y_bm_t(10) Y_5_t(10)/Y_bm_t(10) Y_3_t(10)/Y_bm_t(10)]';
    disp(result')
    save data_result Y_bm_t Y_1_t Y_2_t Y_3_t Y_4_t Y_5_t Y_6_t
elseif cond == 1
    disp('let go of the small, exit, privatization, grasp the large, corporatization, entry, entry-corp, entry-priv, overall')
    result=[Y_2_t(10)/Y_bm_t(10) Y_1_t(10)/Y_bm_t(10) Y_6_t(10)/Y_bm_t(10) Y_10_t(10)/Y_bm_t(10) Y_5_t(10)/Y_bm_t(10) Y_7_t(10)/Y_bm_t(10) Y_8_t(10)/Y_bm_t(10) Y_9_t(10)/Y_bm_t(10) Y_3_t(10)/Y_bm_t(10)]';
    disp(result')
    save data_result Y_bm_t Y_1_t Y_2_t Y_3_t Y_4_t Y_5_t Y_6_t Y_7_t Y_8_t Y_9_t
end
result=(result-1)*100;

% table: va 
% disp('column 4 1 2 5')
index=[4 1 2 5];
tab=zeros(8,length(index));
tab(1,:)=Ys_3_t(10,index);
tab(2,:)=Ys_bm_t(10,index);
tab(3,:)=Ys_2_t(10,index);
tab(4,:)=Ys_1_t(10,index);
tab(5,:)=Ys_6_t(10,index);
tab(6,:)=Ys_10_t(10,index);
tab(7,:)=Ys_5_t(10,index);
tab(8,:)=Ys_7_t(10,index);
tab=tab*100;

% Y_5_cso/L_5_cso/(Y_5_nso/L_5_nso)/(Y_3_cso/L_3_cso/(Y_3_nso/L_3_nso))
% Y_6_pso/L_6_pso/(Y_6_nso/L_6_nso)/(Y_3_pso/L_3_pso/(Y_3_nso/L_3_nso))

if rl_index == 0 & open_index == 1 & distortion_index == 1 & redundancy_index == 1
    
    Y_3_t_0=Y_3_t; Y_bm_t_0=Y_bm_t;
    save data_result_plot Y_3_t_0 Y_bm_t_0

elseif rl_index > 0 & open_index == 1 & distortion_index == 1 & redundancy_index == 1

    load data_result_plot
    plot(T,Y_3_t,'r -*','LineWidth',2)
    hold on
    plot(T,Y_bm_t,'b :^','LineWidth',2)
    hold on
    plot(T,Y_bm_t_0,'k --o','LineWidth',2)
    hold off
    legend('Data','No Labor Redundancy','Labor Redundancy',2)
    xlabel('year')
    axis([1998 2007 0 8])
    set(gcf,'color','white')
    
end