function yvec1=impf_initial(a,b,shock,XtoGDP,pos,nstep,neq)

%*******************************************************
%******** Proc to compute impulse response from system: 
%*******************************************************

%Set initial capital stock to reflect current Inv to GDP ratio
%XtoGDP is the actual Inv to GDP ratio in data minus Inv to GDP ratio in model ss

% nstep=nimp; a=AVAR;

initial=zeros(neq,1);
%initial(Kpos) = XtoGDP/(a(Xpos,Kpos) - a(GDPpos,Kpos))*100;

A = a(pos.X,pos.K(1))-a(pos.GDP,pos.K(1));
for i=2:length(pos.K)
    A = [A a(pos.X,pos.K(i))-a(pos.GDP,pos.K(i))]; 
end
initial(pos.K) = (A/100)\XtoGDP;

yvec=zeros(nstep,length(a));
yvec(1,:)=initial';
yvec(1,:)= (a*yvec(1,:)')'+(b*shock)';

for i=2:nstep;         % loop through periods 
 yvec(i,:)=(a*yvec(i-1,:)')';
end;
yvec1= yvec(2:end,1:neq);




% to check that algorithm works, compare (Xshsel-X./GDP)'*100 to
%(AVAR(Xpos,Kpos) - AVAR(GDPpos,Kpos))*(Xshsel-X./GDP);
%disp(impdat(1,Xpos)-impdat(1,GDPpos))
% after running the code without any shocks
