% ================================================================================= % 
% greece_mod_sub2.m 
% ================================================================================= % 

function [IMPDAT, pos, PDV_REV, TAB_SRLR, DC] = greece_mod_sub2(delay, greece_rate, wealth_effect, param, finance_type) 

%%% Note: Exclude pegged countries from ECB rule.

% if exist('Var','var')==0
% clearvars; %#ok<*CLSCR>
% clc;
% end
% close all; 

global RP GDP shocktype rho spill N complete psiy omega_i Taylor phi_i phi_y phi_pi fixed thetap thetaw alpha d psiq fpp app beta s sep phi eta filename foldername printing finacc F Felas C G X Eurocalib Countries countriesselect omega shockselect supertitle sim_exog

nplot_a = 10;    	% number of years to be plotted


% ======================================================================= %
%% 1. Preamble                                    
% ======================================================================= %

% (i) Printing
printing = 0;      % =1: print IRF to file   
filetitle = 'Benchmark'; % file name (shock type automatically gets appended)
%filetitle = 'Small Fixed';
%filetitle = 'Sticky Prices';
%filetitle = 'Inv Adj Cost';
%filetitle = 'Fin Accel + Sticky Prices';
% Filenames: Benchmark, Sticky Prices, Sticky Wages,
% Sticky all, Inv Adj Cost, Fin Accel,
foldername = 'IRF default'; % folder name

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% (ii) List of countries
Countries =['Belgium    ';  %  1 CU (Euro)
            'Bulgaria   ';  %  2 CU (peg)
            'Czech Rep  ';  %  3 
            'Denmark    ';  %  4 CU (peg)
            'Germany    ';  %  5 CU (Euro)
            'Estonia    ';  %  6 CU (peg / Euro)
            'Ireland    ';  %  7 CU (Euro)
            'Greece     ';  %  8 CU (Euro)
            'Spain      ';  %  9 CU (Euro)
            'France     ';  % 10 CU (Euro)
            'Croatia    ';  % 11 
            'Italy      ';  % 12 CU (Euro)
            'Cyprus     ';  % 13 CU (Euro)
            'Latvia     ';  % 14 CU (peg)
            'Lithuania  ';  % 15 CU (peg)
            'Luxembourg ';  % 16 CU (Euro)
            'Hungary    ';  % 17
            'Malta      ';  % 18 CU (Euro)
            'Netherlands';  % 19 CU (Euro)
            'Austria    ';  % 20 CU (Euro)
            'Poland     ';  % 21 
            'Portugal   ';  % 22 CU (Euro)
            'Romania    ';  % 23 
            'Slovenia   ';  % 24 CU (Euro)
            'Slovakia   ';  % 25 CU (Euro)
            'Finland    ';  % 26 CU (Euro)
            'Sweden     ';  % 27
            'UK         ';  % 28
            'Norway     ';  % 29
            'Switzerland';  % 30
            'USA        ';  % 31
            'RoW        ';  % 32 Rest of World
            'Eurozone   ';  % 33 All countries marked CU
            'GIIPS      ';];% 34 Greece, Ireland, Italy, Portugal, Spain

% 1. Either choose Heathcote and Perri setting
%calibration ='NYFED';     % []: our own; 'HeathPerri': Heathcote and Perri, 'NYFED': New York Fed 
%calibration='HeathPerri';
calibration = [];

% 2. ... or calibrate to European economies (Population(GDP), trade share, net exports, government spending, still missing: investment)
Eurocalib = 0;  % = 1: Calibrate to European economies

countriesselect = [1:34]; % Select countries to include from sample of 31 countries + 2 country groups; RoW automatically included and its size adjusted to set of selected countries 

    % optional 
shockselect = [33];        % choose countries to shock: use country numbers; default: first country (must be subset of countriesselect for Eurocalibration)
plotselect={[33 34]};   % countries to plot; e.g. {[1 2], 3}: plot cty 1 & 2 on first plot, and plot cty 3 on second plot
intlplotselect=[28 33];    % 1x2 vector containing country pair for intl plots; 

% 3. ... or choose generic countries: Number of countries & Size 
if Eurocalib == 0
    N = 2;              
    Y =[.02];     % Size (measured as absorption=C+G+I) of Cty 1; if e.g. Y = 2, Cty 1 is twice as big as every other country;  or: insert a vector of length N with specific population weights
        % optional     
    shockselect = [1];        % choose countries to shock: use country numbers; default: first country (must be subset of countriesselect for Eurocalibration)
    plotselect={[1 2]};       % countries to plot; e.g. {[1 2], 3}: plot cty 1 & 2 on first plot, and plot cty 3 on second plot
    intlplotselect=[1 3];     % 1x2 vector containing country pair for intl plots; only values <32 allowed
else
    N = 31;
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% (ii) Select other parameters        

sim     = 0;     % simulate the economy

    % Choose type of shock (one-time shock)   
%shocktype = 'Money';       % positive shock to money / positive shock to interest rate
%shocktype = 'TFP';        % positive shock to TFP
%shocktype = 'Net worth'; % positive shock to Net worth
% shocktype = 'Government purchases (G)';  % positive shock to government spending
%shocktype = 'Spread shock';% positive shock to interest rate spread
shocktype = 'Finance Plan';  % positive shock to government spending
%shocktype = 'None';        % no shock


% ======================================================================= %
% Moving Average (Forward-Looking) Shocks
% ======================================================================= %

Qdelay = delay*4; 

MA_coefs    = zeros(40,5);      % Ordering: (1) tau_N; (2) tau_C; (3) tau_K; (4) G, (5) Repayment

perm_flag   = 1; 

% MA_coefs(1+Qdelay:40,5) = 0.041499296;         % All feature "permanent repayment"

% MA_coefs(1+Qdelay:40,4) = -0.041499296;        % Govt spending reduction

% MA_coefs(1+Qdelay:40,2) = 0.125146315;         % VAT (Cons Tax)
% MA_coefs(1+Qdelay:40,1) = 0.061280522;         % Labor Tax
% MA_coefs(1+Qdelay:40,3) = 0.124562429;         % Capital Tax


if finance_type == 1;
    MA_coefs(1+Qdelay:40,5) = 0.01;         % Repayment
elseif finance_type == 2;
    MA_coefs(1+Qdelay:40,4) = -0.01;        % Government Spending Cut
elseif finance_type == 3;
    MA_coefs(1+Qdelay:40,2) = 0.01;         % VAT
elseif finance_type == 4;
    MA_coefs(1+Qdelay:40,1) = 0.01;         % Labor Tax
elseif finance_type == 5;
    MA_coefs(1+Qdelay:40,3) = 0.01;         % Capital Tax
elseif finance_type == 10;
    MA_coefs(1+Qdelay:40,5) = 0.01;         % Repayment
    MA_coefs(1+Qdelay:40,4) = -0.01;        % Government Spending Cut
    MA_coefs(1+Qdelay:40,3) = 0.01;         % VAT
    MA_coefs(1+Qdelay:40,2) = 0.01;         % Capital Tax
    MA_coefs(1+Qdelay:40,1) = 0.01;         % Labor Tax
%     MA_coefs(1+Qdelay:40,2) = 0.01;         % VAT
elseif finance_type == 11;
    MA_coefs(1+Qdelay:40,5) = 0.01;         % Repayment
    MA_coefs(1+Qdelay:40,2) = 0.01;         % VAT
elseif finance_type == 12;
    MA_coefs(1+Qdelay:40,5) = 0.01;         % Repayment
    MA_coefs(1+Qdelay:40,1) = 0.01;         % Labor
elseif finance_type == 13;
    MA_coefs(1+Qdelay:40,5) = 0.01;         % Repayment
    MA_coefs(1+Qdelay:40,3) = 0.01;         % Capital Tax
end;

MA_coefs = MA_coefs*100; 

MA_coefs = MA_coefs*(1+greece_rate)^delay; 




% ======================================================================= %
% ======================================================================= %



negshock    = 0;    % = 1: turn shock negative

    % If shocktype == 'None', feed in exogenous shock process (for Eurocalib==1: uses data to recover shock process; for Eurocalib==0: forces i or spr to follow AR(1)
G_proc = 0;
i_proc = 0;
spr_proc = 0;            % only starts in [2007 1]
        % for Eurocalib
Tst_date = [2002 1];     % start of exogenous process; [yyyy q]; min: [2002 1];
Tend_date = [2013 4];    % start of exogenous process; [yyyy q]; max: [2013 4];
Tshock_date = [2008 1];  % shock date; [yyyy q];

    % Financial markets
complete    = 0;       % =1: complete international financial markets; o/w: non-contingent bonds

    % NK
price_duration = 8/3;   % average duration of prices (in quarters). Typical estimate is 8 months. 
wage_duration = 4;      % average duration of wages (in quarters). Basu et al get roughly 1 year. 
    
thetap      = 0.0;       % price stickiness parameter
thetaw      = 0.0;       % wage stickiness parameter
thetap      = 1 - (1/price_duration);       % price stickiness parameter
thetaw      = 1 - (1/wage_duration);       % wage stickiness parameter


%thetap=0; thetaw=0;

    % Monetary policy
Taylor      = 1;     % =1: Taylor rule; =0: constant money supply growth 
phi_y       = .5;  phi_pi = 1.5; phi_i = .75; % Taylor rule parameters
GDPgrowth   = 0;    % =1 Taylor rule targets GDP growth instead of GDP in levels
fixed       = 1;    % =1: fixed exchange rate (Taylor rule based on all countries' GDP and inflation); 

    % Production
alpha       = .36;  % capital share
psiq        = 10;   % elasticity of substition between intermediate good varieties
d           = .025; % depreciation rate
fpp         = 2.48;    % investment adjustment cost
% fpp         = 0;
%app         = .01*.0325;
app         = .286; % utilization elasticity
% app         = inf;

    % Preferences
beta        = .99;  % discount factor
s           = 2;	% coefficient of relative risk aversion 
% s           = 1;	% coefficient of relative risk aversion 
sep         = 1;    % =1: separable preferences; =0: CD preferences
phi         = .34;  % exponent on consumption (.34) if sep==0
eta         = .5;    % Frisch elasticity (1) if sep==1
% h           = .1;  % habit formation; if without: set h=0
h           = 0;  % habit formation; if without: set h=0

    % Government spending
GGDP        = .2;    % G/GDP

MA_coefs(1:40,4) = MA_coefs(1:40,4)/GGDP;

tau_N_SS    = .43; 
tau_K_SS    = .18; 
tau_C_SS    = .16; 


    % Trade
psiy        = 1;   % elasticity of substitution between domestic and foreign goods 
psiy        = 1.5;   % elasticity of substitution between domestic and foreign goods 
                    % Trade literature: 5 - 6
                    % Intl finance literature : 1- 1.5
psiy        = param;                     
omega_i     = .79;   % 1 - trade share [0;1]; home bias parameter
% omega_i     = .5;   % 1 - trade share [0;1]; home bias parameter
NXGDP       = 0;   % for generic, 2 countries: if NXGDP==0, adjusted Armington weights omega so that net exports =0; otherwise: comment out

    % Financial accelerator
finacc      = 0;     % =1: add financial accelerator
F           = 1.0298^(1/4); % external risk premium (1.0298^(1/4))
Felas       = .2; % elasticity of external risk premium to leverage (0.2)
% gam         = .99; % Fraction of entrepreneurs that survive from one period to the next
% Felas       = .08;
gam         = beta/F; 

% Tax Parameters

tau_N_GDP_Ratio     = .14; 
tau_K_GDP_Ratio     = .15;
tau_C_GDP_Ratio     = .09; 


    % Shock process: 
if strcmp(shocktype,'Money')
    rho = 0; spill = 0;
elseif strcmp(shocktype,'TFP')
    rho = .97; spill = 0;%0.025;
elseif strcmp(shocktype,'Net worth');
    rho = .95; spill = 0;
elseif strcmp(shocktype,'Government purchases (G)');
    rho = .93; spill = 0;
elseif strcmp(shocktype,'Spread shock');
    rho = .95; spill = 0;
elseif strcmp(shocktype,'Finance Plan');
    rho = .9; spill = 0;
elseif strcmp(shocktype,'None');
    rho = 0; spill = 0;
end

shockvar = eye(N)*.01^2;
%shockvar    = [.01^2 .29*.01*.01;.29*.01*.01 .01^2];
    % Shocks to feed in time series
rhoG    = .8; spillG  = 0;       % government spending       
rhosp   = .95; spillsp = 0;       % spread
rhoi    = 0; spilli  = 0;         % interest rate


rhotauN = .9; 
rhotauC = .9; 
rhotauK = .9; 

    % Correct for initial differences in investment to GDP ratio (for Eurocalibration)
correctinvtoGDP = 0;

    % Plotting details
% nplot_a = 20;    	% number of years to be plotted
annualized = 1;     % =1: annualized growth rates

%%% END PARAMETER SELECTION
%%% START COMPUTATION

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% (iv) Initial calculations based on choice of parameters (Don't change)

    % Heathcote and Perri parameters
if strcmp(calibration,'HeathPerri')
    N=2; GDP = 1; alpha = .36; d = 0.025; fpp = 0; thetap=0; thetaw=0; beta=.99; s=2; sep=0; phi=.34; psiy=.9; omega_i=.85; omega_j = (1-omega_i)/(N-1); F=1; Felas=0;
    rho = .97; spill = 0.025; shockvar = [.0073^2 .29*.0073*.0044;.29*.0073*.0044 .0044^2]; rhoG = .0; spillG = 0; GGDP=0; shockvarG = [0 0; 0 0]; psiq=1000; CUselect=[0 0]; countriesselect=[1 2];
elseif strcmp(calibration,'NYFED')
    beta = .999; eta = .77; alpha = .35; d = .025; app = .286; psiq = 7.67; thetap = .88; thetaw = .9; fpp = 4.01; s = 1; finacc = 1; gam = .99; Felas = .081; F = 1.0075; Taylor=1; h=.73; 
    GGDP=0; complete = 1;  phi_y = .1; phi_pi = 1.5; phi_i = .8; GDPgrowth = 1; 
    if strcmp(shocktype,'Money')
        rho = 0;          % not sure
    elseif strcmp(shocktype,'TFP')
        rho = .47;        % note sure: z?
    elseif strcmp(shocktype,'G');
        rho = .93;  
    elseif strcmp(shocktype,'Spread shock');
        rho = .96; 
    end     
end  
% GGDP=.2;

    % Add group members to selected countries
if Eurocalib==1    
countriesselect=[countriesselect 32];     % add RoW (mandatory)
Eurozone = [1 2 4 5 6 7 8 9 10 12 13 14 15 16 18 19 20 22 24 25 26];
%Eurozone = [1 2];
GIIPS = [7 8 9 12 22];
i=1;
if sum(ismember(countriesselect,33))==1, 
    countriesselect = [countriesselect Eurozone]; 
end
if sum(ismember(countriesselect,34))==1, 
    countriesselect = [countriesselect GIIPS]; 
end
countriesselect = unique(countriesselect);
N=numel(countriesselect(countriesselect<33));
else
    countriesselect = 1:N;
end

    % Set up countries to be plotted
group = cell(0);
if exist('plotselect','var')==1
    N_plot=cell2mat(plotselect); 
    if isequal(sort(N_plot),intersect(N_plot,countriesselect))==0
         disp('Warning: Selected plots must be subset of selected countries. Default plotting.')
        N_plot = [1 2]; plotselect = {1,2}; intlplotselect=[1 2]; %CUselect=CUselect(1:N);
    end
    plotselect = cellfun(@(v) intersect(v, countriesselect), plotselect, 'UniformOutput', false);
    
    plotselect(~cellfun('isempty',plotselect));  
    [~,plotselect]=cellfun(@(v) ismember(v,countriesselect), plotselect, 'UniformOutput', false); 
    if Eurocalib==1
        [~,group{1} ]=ismember(Eurozone,countriesselect);
        [~,group{2} ]=ismember(GIIPS,countriesselect);
    end
end
if N==1
    N_plot = 1; plotselect={1}; 
elseif exist('N_plot','var')==0   % which countries to plot
    N_plot = [1 2]; plotselect = {1,2}; intlplotselect=[1 2];
end  

    % Set up countries that receive shock
if exist('shockselect','var')==1
    if isequal(sort(shockselect),intersect(shockselect,countriesselect))==0
        disp('Warning: Shocked countries must be subset of selected countries. Default shock to country 1.')
        shockselect=1;
    end
    [~,tmpshock] =  ismember(shockselect(shockselect<33),countriesselect);
    if sum(ismember(shockselect,33))==1 
        [~,tmp]=ismember(Eurozone,countriesselect);
        tmpshock = [tmpshock tmp];
    end
    if sum(ismember(shockselect,34))==1 
        [~,tmp]=ismember(GIIPS,countriesselect);
        tmpshock = [tmpshock tmp];
    end
    shockselect = unique(tmpshock);
else
    shockselect = 1;
end
Nshock =  numel(shockselect); % Nshock: number of countries that receive shock


    % Set up international plot
[~,intlplotselect] =  ismember(intlplotselect,countriesselect);
if numel(intlplotselect)<2, disp('No international plot. Select 2 countries.'); end

    % Set up exchange rate regime
if Eurocalib==0
    if fixed==1 && exist('CUselect','var')==0 ;
        CUselect = ones(1,N);
    elseif fixed==0 && exist('CUselect','var')==0 ;
        CUselect = zeros(1,N);
    end
else
    CU = [1 1 0 1 1 1 1 1 1 1 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 1 0 0 0 0 0 0 0 0]; % countries with Euro or pegged to Euro       
    CUselect = CU(countriesselect(countriesselect<33));  % don't change; countries in currency union
end
if Eurocalib==1
    pegged = [1 2 4 5 6 7 8 9 10 12 13 14 15 16 18 19 20 22 24 25 26];
    floating = [3 11 17 21 23 27 28 29 30 31];
else
    pegged = find(CUselect==1);
    floating = find(CUselect==0);
end

    % Rename money shock
if strcmp(shocktype,'Money') && Taylor==1, shocktype='Nom int rate'; end

    % Feed in exog process if no shock selected
if strcmp(shocktype,'None'), sim_exog = 1; else sim_exog = 0; end

    % Financial accelerator
if finacc == 0, F = 1; Felas = 0; end

    % Check that exogenous shock is stationary
GAMMA = spill*ones(N,N); GAMMAG = spillG*ones(N,N);
for i = 1:N; GAMMA(i,i) = rho; GAMMAG(i,i) = rhoG; end
if max(abs(eig(GAMMA))) >= 1;  disp('unstable technology process');  return; end;
if max(abs(eig(GAMMAG))) >= 1;  disp('unstable government process');  return; end;

    % For plotting impulse response function 
nimp_a 	= 10000;    % number of years in impulse response
hy      = 1/4;     % fraction of a year per period (h=1 is one year)
nimp    = nimp_a/hy;   
nplot   = nplot_a/hy; 
set(0,'defaultaxesfontsize',14)     % change default font size
CUmember = {'Floating XRT','Fixed XRT'};

ifig=0;
if Eurocalib==0
    filename = ['IRF ' num2str(N) '-country ' filetitle [' '] shocktype];    % set up file name
else
    filename = ['IRF Eurocalibration ' filetitle [' '] shocktype];
end
[~,supertitle] = strtok(filename);


% ======================================================================= %
%% 2. Nonstochastic steady state:                                    
% =======================================================================
% 
if Eurocalib==1
% load data on trade shares and GDP
load Eurocalibration.mat 

    % Abs: Absorption = real GDP - NX (ave. 2000 - 2013)
    % ImportstoAbs: Imports to row from column over Absorption of row (ave.
    % 2000 - 2013); diagonal is zero
    % NX: Exports - Imports (ave. 2000 - 2013) (not directly used)
    % GGDP: Government spending over GDP (ave. 2000 - 2013),
    % still missing for RoW (right now, I use US value for RoW)
    % XGDP: Investment (private + govt) to GDP ratio (ave. 2000 - 2007)
    % still missing for RoW (right now, I use US value for RoW)
    % spread: interest rate spread in 2007q1 (RoW missing)

    Trade = ImportstoAbs.*repmat(Abs,[1 32]);  % Imports to row from column
    for i=1:N-1
        ii = countriesselect(i);
        omega(i,i) = 1-sum(ImportstoAbs(ii,:));  % non-trade share of Absorption
    end
    for i=1:N-1
        for j=1:N-1
            if i ~= j
                ii = countriesselect(i); jj = countriesselect(j);
                omega(i,j) = Trade(ii,jj)/Abs(ii);
            end
        end
    end      
    Abssel = Abs(countriesselect(countriesselect<32));  
    GGDP = GGDP(countriesselect(countriesselect<32));
    XGDP = XGDP(countriesselect(countriesselect<32));
    
    
    for i=1:N-1 % Fill out RoW (all countries except for those selected): omega(N,i) is imports from i to RoW over RoW GDP
        ii = countriesselect(i);            
        AbsRoW=sum(Abs)-sum(Abs(countriesselect(countriesselect<32)));
        % = (world exports of ii - exports of ii to selected countries)/(world absorption - aborption of selected countries)
        omega(N,i) = (sum(Trade(:,ii)) - sum(Trade(countriesselect(countriesselect<32),ii)))/(sum(Abs)-sum(Abs(countriesselect(countriesselect<32))));
    end       
    for i=1:N
        omega(i,N) = 1-sum(omega(i,1:N-1));     % omega(i,N) is imports from RoW to i over i GDP; use fact that every row of omega sums to 1
    end
    
    Abssel = [Abssel; AbsRoW]/100*N; GGDP = [GGDP; GGDP(31)]; XGDP = [XGDP; XGDP(31)];  
    y = omega.*repmat(Abssel,[1 N]);
    Ex = sum(y,1)'; Im=sum(y,2);
    NX = sum(y,1)'-sum(y,2);  
    GDP = Abssel + NX;
    NXGDP = NX./GDP;
    %F = 1+[spread; spread(end)]/400;
    F = ones(N,1)*1.0298^(1/4);
    RP = (F./beta-1+d); % R/P   
    Pop = GDP.*(1-alpha*d./RP*(psiq-1)/psiq-(GGDP+NXGDP));
    
    if sep==1
        L=Pop; C=Pop;
    else
        disp('Use separable preferences for Euro calibration')
    end
    K = GDP./(RP./alpha*psiq/(psiq-1));
    X  = d*K;
    Y = C + X + GGDP.*GDP;    
       
else    % Non-Euro calibration
    F(numel(F)+1:N) = repmat(F(1),[N-numel(F) 1]); F=F(:);
    RP = (F./beta-1+d); % R/P, rky 
    
    if sum(Y)==Y(1), Y(2:N) = 1; end   
    Y=Y'/sum(Y)*N; % ensure that world Y = N

    if N==1    
        omega_i=1; omega_j=0; omega=1;
    else
        omega_j = (1-omega_i)/(N-1);
        omega = omega_j*ones(N);
        for i=1:N
            omega(i,i) = omega_i;
        end
    end
    if exist('NXGDP','var')
        omega(2,2)=omega(2,1)*((Y(2)-Y(1))/Y(2) + omega(1,1)/omega(1,2))*Y(2)/Y(1);
    elseif N>1
        omega = omega.*repmat(Y',[N 1]);%/N;   
    end
        
    omega = omega./repmat(sum(omega,2),[1 N]);
    y = omega.*repmat(Y,[1 N]); 
    
    Ex = sum(y,1)'-diag(y);
    Im = sum(y,2)-diag(y);
    NX = Ex-Im;     % check that NX./GDP = NXGDP
    GDP = Y+NX;
    NXGDP = NX./GDP; 
    if sum(NXGDP)==NXGDP(1), NXGDP(2:N) = -NXGDP(1)*GDP(1)/(sum(GDP(2:N))); end 
    NXGDP=NXGDP;
    if abs(NXGDP'*GDP)>1e-12, disp('Sum of net exports not equal to zero'); disp(abs(NXGDP'*GDP)); return; end
    Pop = GDP.*(1-alpha*d./RP.*(psiq-1)/psiq-(GGDP+NXGDP)); 
    K = GDP./(RP./alpha*psiq/(psiq-1));
    X = d*K;
    XGDP = X./GDP; 
    if sep==1
        L=Pop; C=Pop;
    else % only to use for Heathcote & Perri setting
        L = phi*(1-alpha)/((1-phi)*(1-alpha*d./RP)+phi*(1-alpha))*Pop;
        C = Y-X;
    end 
end

G = Y-C-X;
if printing==1, 
    if exist(foldername,'file')==0
        mkdir(foldername)
    end
    if exist(strcat(foldername, '/',filename,'.pdf'),'file')==1
        delete(strcat(foldername, '/',filename,'.pdf')); 
    end
    %run Experiment_description.m; ifig=1;
end

GDP_cu = CUselect*GDP;                % total GDP of currency union
for i=1:N
    weight(i) = CUselect(i)*GDP(i)/GDP_cu; % weights for Taylor rule
end

% Transform all quantities into per capita
GDP = GDP./Pop; C = C./Pop; X = X./Pop; Y = Y./Pop; L = L./Pop; K = K./Pop;
y = y./repmat(Pop,[1 N]); Ex = Ex./Pop; Im = Im./Pop;

Q = GDP;
Z = RP./(alpha*(K).^(alpha-1))*psiq/(psiq-1);

WP= (1-alpha).*Q./L;
G = Y-C-X;
S = zeros(N,1);     % NFA



Wk  = (1-gam*F./beta).*K./2.11; % Transfer from exiting to new entrepreneurs (so that BK/Nk=1.11)
NWP = Wk./(1-gam*F./beta);    % net worth

ss.GDP = GDP; ss.Y = Y; ss.Q = Q; ss.C = C; ss.L = L; ss.X = X; ss.K = K; ss.y = y; 
ss.NWP = NWP; ss.G = G; ss.WP = WP; ss.RP = RP; ss.z = Z; ss.Ex = Ex; ss.Im = Im; ss.Pop = Pop; 


% auxiliary parameter for utility calculation 

kappa = WP(1)*(1-tau_N_SS)/(1+tau_C_SS); 

% ================================================================================= % 
%% 3. Begin setup for constructing log-linear system coef matrix 
% ================================================================================= % 


nlead = 1;  % Number of leads in system 
nlag  = 1;  % Number of lags in system 

% Enter country-specific variables (f1), bilateral variables (f2), and
% shocks (fsh)
f1 = {'C';
    'L';
    'K';
    'e';
    'pP';
    'WP';
    'RP';
    'MCP';
    'i';
    'pi';
    'X';
    'Q';
    'Y';
    'u1';
    'u2';
    'nx';
    'dE';
    'ToT';
    'muP';
    'u';
    'S';
    'piw';
    'NWP';
    'lam';
    'GDP';
    'spr';
    'G';
    'Sh';
    'Shi';
    'Shspr';
    'tau_N';
    'tau_C';
    'tau_K'; 
    'rev'; 
    'stat_rev'}; 

f2 = {'y'}; 
fsh = {'e_gShock';
       'e_iShock';
       'e_sprShock';
       'e_Shock';
       'e_tauNShock';
       'e_tauKShock';
       'e_tauCShock'};

% Don't change
n1 = numel(f1);
n2 = numel(f2);
nsh = numel(fsh);

ct = 1:N;
for j=1:n1, pos.(f1{j})= ct; ct = ct + N; end

for j = 1:40;
    pos.MA(j,:) = ct;
    ct = ct + N;
end;

for i=1:N-1, ct = [ct; ct(end,:)+N]; end
for j=1:n2, pos.(f2{j}) = ct; ct = ct + N^2; end
ct = ct(1,:);
for j=1:nsh, pos.(fsh{j}) = ct; ct = ct + N; end
neq = N*(n1+N*n2+nsh + 40);
if isequal(neq,(ct(1)-1))==0
    display('Check position counters')
    return
end

colzero = 0+nlag*neq;      % Position counter for start of contemp. coefs 
collead = 0+nlag*neq+neq; % Position counter for start of lead coefs 
collag  = 0;                % Position counter for start of lag coefs  

% Indicators for contemporanous coefs for each variable: 
fields = fieldnames(pos);
for j=1:numel(fields)
    zero.(fields{j})=colzero+pos.(fields{j});
    lead.(fields{j})=collead+pos.(fields{j});
    lag.(fields{j})=collag+pos.(fields{j});
end

% Determine number of coefficients per equation: 

ncoef = neq*(nlag+nlead+1);

cof = zeros(neq,ncoef);             % Coef matrix --- Each row is an equation

%%
% ================================================================================= % 
% 4. Fill in the coefficient matrix (cof)
% ================================================================================= % 
ct=0;
% ================================================================================= % 
% 1. Domestic Euler Equation
% ================================================================================= % 

for i = 1:N;

  cof(ct+i,zero.i(i))  = beta;
  cof(ct+i,lead.pi(i)) = -1; 
  cof(ct+i,zero.u1(i)) = -1;
  cof(ct+i,lead.u1(i)) = 1;
  cof(ct+i,zero.tau_C(i)) = 1/(1+tau_C_SS);
  cof(ct+i,lead.tau_C(i)) = -1/(1+tau_C_SS);
  
end;
ct=ct+N;

% ================================================================================= % 
% 2. Wage Phillips curve
% ================================================================================= % 

for i = 1:N;
 
  cof(ct+i,zero.piw(i))         = -thetaw;
  cof(ct+i,zero.u2(i))          = (1-thetaw)*(1-thetaw*beta);  
if wealth_effect == 1; 
  cof(ct+i,zero.u1(i))          = -(1-thetaw)*(1-thetaw*beta);
end; 
  cof(ct+i,zero.WP(i))          = -(1-thetaw)*(1-thetaw*beta);
  cof(ct+i,zero.tau_C(i))       = (1-thetaw)*(1-thetaw*beta)/(1+tau_C_SS);
  cof(ct+i,zero.tau_N(i))       = (1-thetaw)*(1-thetaw*beta)/(1-tau_N_SS);
  cof(ct+i,lead.piw(i))         = thetaw*beta;
    
end;
ct=ct+N;

% ================================================================================= % 
% 3. Capital Euler equation
% ================================================================================= % 

for i = 1:N; 

    cof(ct+i,lead.RP(i)) = -beta*RP(i)/F(i);  
        cof(ct+i,lead.tau_K(i)) = beta*RP(i)/(F(i)*(1-tau_K_SS)); 
    cof(ct+i,zero.i(i))  = beta; 
    cof(ct+i,lead.pi(i)) = -1;  
    cof(ct+i,zero.spr(i))= 1/F(i);
    cof(ct+i,zero.muP(i))= 1;
    cof(ct+i,lead.muP(i))= -beta/F(i)*(1-d);
    
end;
ct=ct+N;

% ================================================================================= % 
% 4. Price of capital
% ================================================================================= % 

for i = 1:N;     

    cof(ct+i,zero.muP(i))= -1;
    cof(ct+i,lag.X(i))  = -fpp;
    cof(ct+i,zero.X(i)) = fpp*(1+beta);
    cof(ct+i,lead.X(i)) = -fpp*beta;
        
end;
ct=ct+N;

% ================================================================================= % 
% 5. Optimal capital utilization
% ================================================================================= % 

for i = 1:N; 
    
    if app==inf;
        cof(ct+i,zero.u(i))   = 1;
    else
        cof(ct+i,zero.RP(i))  = -RP(i);    
        cof(ct+i,zero.u(i))   = app;
        cof(ct+i,zero.tau_K(i))   = RP(i)/(1-tau_K_SS);
    end

end;
ct=ct+N;

% ================================================================================= % 
% 6. Optimal factor employment
% ================================================================================= % 

for i = 1:N; 
    
    cof(ct+i,zero.RP(i))  = -1;
    cof(ct+i,zero.WP(i))  = 1;
    cof(ct+i,zero.L(i))   = 1;
    cof(ct+i,zero.u(i))   = -1;
    cof(ct+i,lag.K(i))    = -1;

end;
ct=ct+N;

% ================================================================================= % 
% 7. Real marginal costs
% ================================================================================= % 

for i = 1:N; 
   
    cof(ct+i,zero.MCP(i))  = -1;
    cof(ct+i,zero.WP(i))   = 1-alpha;
    cof(ct+i,zero.RP(i))   = alpha; 
    if strcmp(shocktype,'TFP')
        cof(ct+i,zero.Sh(i))   = -1;
    end   
    
end;
ct=ct+N;

% ================================================================================= % 
% 8. Demand for intermediates
% ================================================================================= % 

for i = 1:N; 
for j = 1:N;
    
    cof(ct+N*(i-1)+j,zero.pP(j)) = -1;
    cof(ct+N*(i-1)+j,zero.e(j))  = -1;
    cof(ct+N*(i-1)+j,zero.e(i))  = 1;
    cof(ct+N*(i-1)+j,zero.Y(i))  = 1/psiy;
    cof(ct+N*(i-1)+j,zero.y(i,j))= -1/psiy;
    if i==j
        cof(ct+N*(i-1)+j,zero.e(i))  = 0;
    end

end;
end;
ct=ct+N^2;

% ================================================================================= % 
% 9. Production of Q 
% ================================================================================= % 

for i = 1:N; 
 
    cof(ct+i,zero.Q(i))   = -1;
    if strcmp(shocktype,'TFP')
        cof(ct+i,zero.Sh(i))   = 1;
    end    
    cof(ct+i,zero.u(i))   = alpha;
    cof(ct+i,lag.K(i))    = alpha;
    cof(ct+i,zero.L(i))   = 1-alpha;
    
end;
ct=ct+N;

% ================================================================================= % 
% 10. Production of Y
% ================================================================================= % 

for i = 1:N; 
   
    cof(ct+i,zero.Y(i))   = -1;
    for j = 1:N
        if psiy==1
            cof(ct+i,zero.y(i,j)) = omega(i,j);
        else
            cof(ct+i,zero.y(i,j)) = (omega(i,j)^(1/(psiy-1))*y(i,j)/Y(i))^((psiy-1)/psiy);
        end
    end      
    
end;
ct=ct+N;

% ================================================================================= % 
% 11. Market clearing for intermediate goods
% ================================================================================= % 

for i = 1:N; 
 
    cof(ct+i,zero.Q(i))   = -1;
    cof(ct+i,zero.y(:,i)) = Pop.*y(:,i)/sum(Pop.*y(:,i),1);
    
end;
ct=ct+N;

% ================================================================================= % 
% 12. Market clearing for final goods
% ================================================================================= % 

for i = 1:N; 
    
    cof(ct+i,zero.Y(i))   = -Y(i);
    cof(ct+i,zero.C(i))   = C(i);
    cof(ct+i,zero.X(i))   = X(i);
    cof(ct+i,zero.G(i))   = G(i);
    cof(ct+i,zero.u(i))   = RP(i)*K(i);
    
end;
ct=ct+N;

% ================================================================================= % 
% 13. Phillips curve
% ================================================================================= % 

for i = 1:N; 
    
    cof(ct+i,zero.pi(i))  = -thetap;
    cof(ct+i,zero.ToT(i)) = -thetap;
    cof(ct+i,zero.MCP(i)) = (1-thetap)*(1-thetap*beta);
    cof(ct+i,zero.pP(i)) = -(1-thetap)*(1-thetap*beta);
    cof(ct+i,lead.pi(i))  = beta*thetap; 
    cof(ct+i,lead.ToT(i)) = beta*thetap; 
    
end;
ct=ct+N;

% ================================================================================= % 
% 14. Monetary Policy
% ================================================================================= % 
leader=[];
for i = 1:N;  
    if CUselect(i)==0  % floating
        if Taylor==1    % Taylor policy rule
            cof(ct+i,zero.i(i))  = -1;
            cof(ct+i,lag.i(i))   = phi_i;
            cof(ct+i,zero.GDP(i))= (1-phi_i)*phi_y/4;
            if GDPgrowth==1
                cof(ct+i,lag.GDP(i)) = -(1-phi_i)*phi_y/4;
            end
            cof(ct+i,zero.pi(i))  = (1-phi_i)*phi_pi;
            if strcmp(shocktype,'Nom int rate')
                cof(ct+i,zero.Sh(i)) = 1;
            end
            cof(ct+i,zero.Shi(i)) = 1; 
        else            % Constant money supply growth
            cof(ct+i,zero.GDP(i))= -1;
            cof(ct+i,lag.GDP(i)) = 1;
            cof(ct+i,zero.pi(i)) = -1;        
            if strcmp(shocktype,'Money')
                cof(ct+i,zero.Sh(i)) = 1;
            end
        end
    elseif CUselect(i)==1  % currency union 
        if isempty(leader)==1;    % first country in currency union implements monetary policy
            if Taylor==1    % Taylor policy rule
                cof(ct+i,zero.i(i))  = -1;
                cof(ct+i,lag.i(i))   = phi_i;
                for j = 1:N
                    if CUselect(j)==1
                    cof(ct+i,zero.GDP(j))  = (1-phi_i)*weight(j)*phi_y/4;
                    if GDPgrowth==1
                        cof(ct+i,lag.GDP(j))   = -(1-phi_i)*weight(j)*phi_y/4;
                    end
                    cof(ct+i,zero.pi(j)) = (1-phi_i)*phi_pi*weight(j);
                    end
                end 
                if strcmp(shocktype,'Nom int rate')
                    cof(ct+i,zero.Sh(i)) = 1;
                end
                cof(ct+i,zero.Shi(i)) = 1; 
            else        % Constant money supply growth        
                for j = 1:N     
                    if CUselect(j)==1
                    cof(ct+i,zero.GDP(j))= -CUselect(j)*weight(j);
                    cof(ct+i,lag.GDP(j)) = (1)*CUselect(j)*weight(j);
                    cof(ct+i,zero.pi(j)) = -CUselect(j)*weight(j);
                    end
                end
                if strcmp(shocktype,'Money')
                    cof(ct+i,zero.Sh(i)) = 1;
                end    
            end
            leader=i;
        else        % other countries follow
            cof(ct+i,zero.dE(i))        = -1;
            cof(ct+i,zero.dE(leader))   = 1;    
        end
    end
end
ct=ct+N; 

% ================================================================================= % 
% 15. Complete markets condition / Uncovered interest rate parity
% ================================================================================= % 

if complete==1
for i = 1:N; 
    
    cof(ct+i,zero.u1(i))  = -1;
    cof(ct+i,zero.e(i))   = 1;
    
end;

else

cof(ct+1,zero.dE(1))= 1; 
for i = 2:N; 
    
    cof(ct+i,zero.i(i))  = -beta;
    cof(ct+i,lead.dE(i)) = -1;
    cof(ct+i,zero.S(i))  = -.00000015*(1-S(i))*((abs(S(i))>0)*S(i)+(abs(S(i))==0));  % penalty term -.000005; allow for S(i)=0
    cof(ct+i,zero.i(1))  = beta;
    cof(ct+i,lead.dE(1)) = 1;
    cof(ct+i,zero.S(1))  = .00000015*(1-S(1))*((abs(S(1))>0)*S(1)+(abs(S(1))==0));   
    
end;
end     
ct=ct+N;

% ================================================================================= % 
% 16. Definition of change in nominal exchange rate 
% ================================================================================= % 

for i = 1:N; 
    
    cof(ct+i,zero.dE(i))  = -1;
    cof(ct+i,zero.e(i))   = 1;
    cof(ct+i,lag.e(i))    = -1;
    cof(ct+i,zero.pi(i)) = -1;
    
end;
ct=ct+N;

% ================================================================================= % 
% 17. Definition of Terms of Trade
% ================================================================================= % 

for i = 1:N; 
    
    cof(ct+i,zero.ToT(i)) = -1;
    cof(ct+i,zero.pP(i))  = 1;
    cof(ct+i,lag.pP(i))   = -1;
    
end;
ct=ct+N;

% ================================================================================= % 
% 18. Definition of wage inflation
% ================================================================================= % 

for i = 1:N; 
    
    cof(ct+i,zero.piw(i)) = -1;
    cof(ct+i,zero.pi(i)) = 1;    
    cof(ct+i,zero.WP(i))   = 1;
    cof(ct+i,lag.WP(i))    = -1;
    
end;
ct=ct+N;

% ================================================================================= % 
% 19. Law of motion for net worth
% ================================================================================= % 

for i = 1:N

  cof(ct+i,zero.NWP(i)) = -beta/F(i);
  cof(ct+i,lag.NWP(i))  = gam;
  cof(ct+i,zero.muP(i)) = gam*(1-RP(i)*beta/F(i));
  cof(ct+i,lag.muP(i))  = -gam;
  cof(ct+i,zero.RP(i))  = gam*RP(i)*beta/F(i);
  cof(ct+i,zero.tau_K(i))  = -gam*RP(i)*beta/(F(i)*(1-tau_K_SS));
  if strcmp(shocktype,'Net worth')
    cof(ct+i,zero.Sh(i)) = 1;
  end  

end
ct=ct+N;

% ================================================================================= % 
% 20. Definition leverage 
% ================================================================================= % 

for i = 1:N
    
  cof(ct+i,zero.lam(i)) = -1;
  cof(ct+i,zero.muP(i))= 1;
  cof(ct+i,zero.K(i))  = 1;
  cof(ct+i,zero.NWP(i)) = -1;

end
ct=ct+N;

% ================================================================================= % 
% 21. Definition GDP 
% ================================================================================= % 

for i = 1:N
    
  cof(ct+i,zero.GDP(i))  = -1;
  cof(ct+i,zero.pP(i))   = 1;
  cof(ct+i,zero.Q(i))    = 1;
  
end

ct=ct+N;

% ================================================================================= % 
% 22. Definition of Net exports 
% ================================================================================= % 

for i = 1:N
    
  cof(ct+i,zero.nx(i))   = -1;
  cof(ct+i,zero.y(:,i))  = Pop./Pop(i).*y(:,i);    % exports
  cof(ct+i,zero.y(i,:))  = -y(i,:);   % imports  
  cof(ct+i,zero.y(i,i))  = 0;    

  
end
ct=ct+N;

% ================================================================================= % 
% 23. Definition of investment 
% ================================================================================= % 

for i = 1:N; 
    
    cof(ct+i,zero.X(i))   = -d;
    cof(ct+i,zero.K(i))   = 1;
    cof(ct+i,lag.K(i))    = -(1-d);
    
end;
ct=ct+N;

% ================================================================================= % 
% 24. Definition int rate spread
% ================================================================================= % 

for i = 1:N
    
  cof(ct+i,zero.spr(i))  = -1/F(i);
  cof(ct+i,zero.lam(i))  = Felas;
  cof(ct+i,zero.Shspr(i)) = 1;
  if strcmp(shocktype,'Spread shock')
    cof(ct+i,zero.Sh(i)) = 1;
  end
  
end
ct=ct+N;


% ================================================================================= % 
% 25. Marginal utility of consumption
% ================================================================================= % 

for i = 1:N;
  
  if sep==0
    cof(ct+i,zero.u1(i))   = -1;
    cof(ct+i,zero.C(i))    = phi*(1-s)-1;
    cof(ct+i,zero.L(i))    = -(1-phi)*(1-s)*L(i)/(1-L(i));
  elseif h>0
    cof(ct+i,zero.u1(i))   = -(1-h*beta)*(1-h);
    cof(ct+i,zero.C(i))    = -(1+beta*h^2);
    cof(ct+i,lag.C(i))     = h;
    cof(ct+i,lead.C(i))    = beta*h;
  else
    cof(ct+i,zero.u1(i))   = -1;
    cof(ct+i,zero.C(i))    = -s;
  end
end
ct=ct+N;

% ================================================================================= % 
% 26. Marginal utility of labor
% ================================================================================= % 

for i = 1:N
  
  if sep==0  
    cof(ct+i,zero.u2(i)) = -1;
    cof(ct+i,zero.C(i))  = phi*(1-s);
    cof(ct+i,zero.L(i))  = -((1-phi)*(1-s)-1)*L(i)/(1-L(i));
  else
    cof(ct+i,zero.u2(i)) = -1;
    cof(ct+i,zero.L(i))  = 1/eta;
  end
  
end
ct=ct+N;

% ================================================================================= % 
% 27. Budget constraint
% ================================================================================= % 

if complete==1
    
    for i = 1:N;
        
        cof(ct+i,zero.S(i))   = 1;
        
    end;
    
else
    
    for i = 1:N;
        if S(i)==0
            cof(ct+i,zero.Y(i))   = -Y(i);
            cof(ct+i,zero.S(i))   = -1;
            cof(ct+i,zero.pP(i))  = Q(i);
            cof(ct+i,zero.Q(i))   = Q(i);
            cof(ct+i,lag.S(i))    = 1/beta;
            if strcmp(shocktype,'Finance Plan')
                for j = 1:40;
                    if i == 1;
                        cof(ct+i,zero.MA(j,i)) = -Q(i)*MA_coefs(j,5);
                    else
                        cof(ct+i,zero.MA(j,1)) =  Q(1)*(Pop(1)/Pop(2))*MA_coefs(j,5);
                    end;
                end
                
            end
            
        else
            cof(ct+i,zero.Y(i))   = -Y(i);
            cof(ct+i,zero.S(i))   = -S(i);
            cof(ct+i,zero.pP(i))  = Q(i);
            cof(ct+i,zero.Q(i))   = Q(i);
            cof(ct+i,lag.S(i))    = S(i)/beta;
            cof(ct+i,zero.dE(i))  = S(i)/beta;
            cof(ct+i,zero.e(i))   = S(i)*(1-beta)/beta;
        end
        
    end;
end
ct=ct+N;

% ================================================================================= % 
% 28. Law of motion for generic shock
% ================================================================================= % 
for i = 1:N;
    
    cof(ct+i,zero.Sh(i))   = 1;
    for j = 1:N
        cof(ct+i,lag.Sh(j))    = -spill;
    end
    cof(ct+i,lag.Sh(i))    = -rho;
    cof(ct+i,zero.e_Shock(i)) = -1;
end;
ct=ct+N;

% ================================================================================= % 
% 29. Law of motion for Government spending
% ================================================================================= % 
for i = 1:N;
    
    cof(ct+i,zero.G(i))   = 1;
%     for j = 1:N
%         cof(ct+i,lag.G(j))    = -spillG;
%     end
%     cof(ct+i,lag.G(i))    = -rhoG;
    
    if strcmp(shocktype,'Government purchases (G)')
        cof(ct+i,zero.e_Shock(i)) = -1;
    end
    
    if strcmp(shocktype,'Finance Plan')
        for j = 1:40;
            cof(ct+i,zero.MA(j,i)) = -MA_coefs(j,4);
        end;
    end
    
    cof(ct+i,zero.e_gShock(i)) = -1;
end;
ct=ct+N;

% ================================================================================= % 
% 30. Law of motion for interest rate shock
% ================================================================================= % 
for i = 1:N;
    
    cof(ct+i,zero.Shi(i))   = 1;
    for j = 1:N
        cof(ct+i,lag.Shi(j))    = -spilli;
    end
    cof(ct+i,lag.Shi(i))    = -rhoi;
    
    cof(ct+i,zero.e_iShock(i)) = -1;
end;
ct=ct+N;

% ================================================================================= % 
% 31. Law of motion for spread shock
% ================================================================================= % 
for i = 1:N;
    
    cof(ct+i,zero.Shspr(i))   = 1;
    for j = 1:N
        cof(ct+i,lag.Shspr(j))    = -spillsp;
    end
    cof(ct+i,lag.Shspr(i))    = -rhosp;
    cof(ct+i,zero.e_sprShock(i)) = -1;
end;
ct=ct+N;



% ================================================================================= % 
% 31. Law of motion for tauN shock
% ================================================================================= % 
for i = 1:N;
    
    cof(ct+i,zero.tau_N(i))   = 1;
    
    if strcmp(shocktype,'Finance Plan')
        for j = 1:40;
            cof(ct+i,zero.MA(j,i)) = -MA_coefs(j,1);
        end;
    end
    
end;
ct=ct+N;



% ================================================================================= % 
% 31. Law of motion for tauC shock
% ================================================================================= % 
for i = 1:N;
    
    cof(ct+i,zero.tau_C(i))   = 1;    
    if strcmp(shocktype,'Finance Plan')
        for j = 1:40;
            cof(ct+i,zero.MA(j,i)) = -MA_coefs(j,2);
        end;
    end
    
end;
ct=ct+N;


% ================================================================================= % 
% 31. Law of motion for tauK shock
% ================================================================================= % 
for i = 1:N;
    
    cof(ct+i,zero.tau_K(i))   = 1;
    if strcmp(shocktype,'Finance Plan')
        for j = 1:40;
            cof(ct+i,zero.MA(j,i)) = -MA_coefs(j,3);
        end;
    end
    
end;
ct=ct+N;


% ================================================================================= % 
% Revenue 
% ================================================================================= % 
for i = 1:N;

    cof(ct+i,zero.rev(i))   = -1;
    
    cof(ct+i,zero.tau_K(i))     = K(i)*RP(i)/GDP(i);
    cof(ct+i,zero.K(i))         = tau_K_GDP_Ratio;
    cof(ct+i,zero.RP(i))        = tau_K_GDP_Ratio;

    cof(ct+i,zero.tau_N(i))     = WP(i)*L(i)/GDP(i);
    cof(ct+i,zero.L(i))         = tau_N_GDP_Ratio;
    cof(ct+i,zero.WP(i))        = tau_N_GDP_Ratio;
    
    cof(ct+i,zero.tau_C(i))     = C(i)/GDP(i);
    cof(ct+i,zero.C(i))         = tau_C_GDP_Ratio;
    
    
end;
ct=ct+N;


% ================================================================================= % 
% Static Revenue 
% ================================================================================= % 
for i = 1:N;

    cof(ct+i,zero.stat_rev(i))   = -1;
    
    cof(ct+i,zero.tau_K(i))     = K(i)*RP(i)/GDP(i);

    cof(ct+i,zero.tau_N(i))     = WP(i)*L(i)/GDP(i);
    
    cof(ct+i,zero.tau_C(i))     = C(i)/GDP(i);
    
    
end;
ct=ct+N;

% ================================================================================= % 
% Moving Average Terms 
% ================================================================================= % 

for i = 1:N; 
        cof(ct+i,zero.MA(1,i)) = 1;
        cof(ct+i,zero.e_Shock(i)) = -1;
end; 
ct = ct+N; 



for j = 2:39;
    for i = 1:N;
        cof(ct+i,zero.MA(j,i)) = 1;
        cof(ct+i,lag.MA(j-1,i)) = -1;
    end;
ct = ct+N; 
end;

for i = 1:N;
    cof(ct+i,zero.MA(40,i)) = 1;
    cof(ct+i,lag.MA(40,i)) = -1*perm_flag;
    cof(ct+i,lag.MA(39,i)) = -1;
end;
ct = ct+N; 


% ================================================================================= % 
% 32.-35. Structural Shocks. 
% ================================================================================= % 

for i = 1:N;
  cof(ct+i,zero.e_gShock(i)) = 1;
end;
ct = ct+N; 

for i = 1:N;
  cof(ct+i,zero.e_iShock(i)) = 1;
end;
ct = ct+N; 

for i = 1:N;
  cof(ct+i,zero.e_sprShock(i)) = 1;
end;

ct = ct+N; 
for i = 1:N;
  cof(ct+i,zero.e_Shock(i)) = 1;
end;

ct = ct+N; 
for i = 1:N;
  cof(ct+i,zero.e_tauNShock(i)) = 1;
end;

ct = ct+N; 
for i = 1:N;
  cof(ct+i,zero.e_tauKShock(i)) = 1;
end;

ct = ct+N; 
for i = 1:N;
  cof(ct+i,zero.e_tauCShock(i)) = 1;
end;


% ================================================================================= % 
% AIM solution algorithm
% ================================================================================= % 

if isequal(neq,(ct+N))==0
    display('Number of variables differs from number of equations')
    return
end

% Use AIM procedure to solve model: 
uprbnd = 1+1e-8;    % Tolerance values for AIM program 
condn = 1e-8;


uprbnd = 1+1e-10;    % Tolerance values for AIM program 
condn = 1e-10;


[cofb,rts,ia,nex,nnum,lgrts,mcode] = aim_eig(cof,neq,nlag,nlead,condn,uprbnd);
scof = obstruct(cof,cofb,neq,nlag,nlead);

s0 = scof(:,(neq*nlag+1):neq*(nlag+1)); 	%Contemp. coefs from obs. structure
amat=zeros(neq*nlag,neq*nlag);   		% Initialize A matrix 
bmat=cofb(1:neq,((nlag-1)*neq+1):nlag*neq);  	% Lag 1 coefficients 
i=2;
while i<=nlag;
  bmat=[bmat cofb(1:neq,((nlag-i)*neq+1):(nlag-i+1)*neq)]; % Lag i coefs 
  i=i+1;
end;
amat(1:neq,:)=bmat;  				% Coefs for equations 
if nlag>1;
 amat((length(cofb(:,1))+1):length(amat(:,1)),1:neq*(nlag-1))=eye(neq*(nlag-1));
end;
b = zeros(length(amat(:,1)),length(s0(1,:)));
b(1:length(s0(:,1)),1:length(s0(1,:))) = inv(s0);  % Store coefs 

AVAR = amat; 
BVAR = b; 


% ================================================================================= % 
% Impulse Response Function
% ================================================================================= % 

if sim_exog==0 % one-time exogenous shock
    
    shock = zeros(neq,1);   % Shock vector    
    if strcmp(shocktype,'Money')
        shocksize = ones(Nshock,1);
    elseif strcmp(shocktype,'Nom int rate')
        shocksize = ones(Nshock,1)*.13;
    elseif strcmp(shocktype,'TFP')
        shocksize = ones(Nshock,1);
    elseif strcmp(shocktype,'Net worth');
        shocksize = ones(Nshock,1);
    elseif strcmp(shocktype,'Government purchases (G)');
        shocksize = 5*ones(Nshock,1);
    elseif strcmp(shocktype,'Finance Plan');
        shocksize = ones(Nshock,1);
    elseif strcmp(shocktype,'Spread shock');
        shocksize = ones(Nshock,1)*.095;
    elseif strcmp(shocktype,'None');
        shocksize = zeros(Nshock,1);
    end 
    
    
    shock(pos.e_Shock(shockselect),1) = shocksize*(negshock*(-1) + (1-negshock));   % Shock variable, size of shock 
    if correctinvtoGDP == 0        
        impdat = impf(AVAR,BVAR,shock,nimp,neq);
    else % correct for initial capital stock
        XtoGDP = XGDP-X./GDP;
        impdat = impf_initial(AVAR,BVAR,shock,XtoGDP,pos,nimp,neq); 
        nimp=nimp-1;
    end    
    dat=(1:nplot)';  % Date variable for plotting 
    
elseif sim_exog==1 % exog process for shock
      
    load CB_int_rates   % Central bank interest rate, annualized, in %, starts in 2002
    load i_innov        % CB interest rate innovations, 1995.1 - 2014.4
    load spread         % int rate for corporate loans - money market rate, percentage points      
    load gov_res_q      % dev from forecast, govt. spending, starts in 2002
    % Add values for Croatia and RoW
        %gov_spe_perc(11,:) = [23.0*ones(1,4) 23.1*ones(1,4) 23.3*ones(1,4) 22.9*ones(1,4) 23.0*ones(1,4) 23.8*ones(1,4) 23.1*ones(1,4) 24.8*ones(1,4) 23.3*ones(1,4) 23.0*ones(1,4) 22.6*ones(1,4) 22.7*ones(1,4)]/100;  % use annual data for Croatia
        gov_res_q = [gov_res_q(1:10,:); zeros(1,60); gov_res_q(11:end,:)]; 
        gov_res_q = gov_res_q(:,end-47:end);
        gov_res_q(end+1,:) = mean(gov_res_q(31,:))*ones(1,size(gov_res_q,2)); % use US ave as a constant value for RoW 
%        CB_int_rates(end+1,:) = 4*(1-beta)/beta; % RoW interest rate
        i_innov(end+1,:) = 0;
        spread(end+1,:) = (F(end)-1);
    % Prepare shock series
        Tst = max(1,4*(Tst_date(1)+Tst_date(2)/4 - 2002)); Tend = 4*(Tend_date(1)+Tend_date(2)/4 - 2002); % timing for exog process
        Tshock= 4*(Tshock_date(1)+Tshock_date(2)/4 - 2002); % timing of shock
        nimp = Tend-Tst+1; nplot=nimp-1;
        
    if Eurocalib==1
        shock = zeros(neq,nimp); shock(pos.e_Shock(shockselect),Tshock) = negshock*(-1) + (1-negshock);  
        exog_g = G_proc*100*(gov_res_q); exog_g = exog_g(:,Tst:min(48,Tend));
        %exog_i = i_proc*100*(CB_int_rates(:,1:end-2)/4-(1-beta)/beta);  
        exog_i = i_proc*(i_innov(:,29:end-3));
        exog_i = exog_i(sort([floating leader]),:); exog_i = exog_i(:,Tst:min(48,Tend));
        exog_spr = [zeros(N,20) spr_proc*spread(:,1:end-2)/4];

    else    % no Eurocalibration  
        exog_g=[]; exog_g(:,1) = ones(N,1);
        for t=2:Tend-Tst+1, exog_g(:,t) = rhoG*exog_g(:,t-1);  end
        exog_i=[]; exog_i(:,1) = ones(N,1)./4-(1-beta)/beta;
        for t=2:Tend-Tst+1, exog_i(:,t) = rhoi*exog_i(:,t-1); end 
        exog_spr=[]; exog_spr(:,1) = ones(N,1)*.25;
        for t=2:Tend-Tst+1, exog_spr(:,t) = rhosp*exog_spr(:,t-1); end
    end       
    
    % Stack up exogenous processes 
        exog=[]; pos.exog = []; pos.exogshock = [];
        if G_proc==1, exog = [exog; exog_g]; pos.exog = [pos.exog pos.G]; pos.exogshock=[pos.exogshock pos.e_gShock]; end
        if i_proc==1, exog = [exog; exog_i]; pos.exog = [pos.exog pos.i(sort([floating leader]))]; pos.exogshock=[pos.exogshock pos.e_iShock(sort([floating leader]))]; end
        if spr_proc==1, exog = [exog; exog_spr]; pos.exog = [pos.exog pos.spr]; pos.exogshock=[pos.exogshock pos.e_sprShock]; end     
        exog = [exog zeros(size(exog,1),max(Tend-48,0))];
    % Call routine for IRF
        if correctinvtoGDP==0; XtoGDP = 0; else XtoGDP = XGDP-X./GDP; end
        [impdat,shock] = impf_multi(AVAR,BVAR,exog,pos,nimp,neq,XtoGDP);
        dat=datenum(datetime(2002,1,15)+ calquarters(1:Tend)); % Date variable for plotting 
        dat = dat(Tst:Tend-1);
        
end


% Prepare figure plotting
Fsav = F; RPsav = RP;
    % Gather impulse response data
[impdat_cg,impplot]=prepplot(ss,impdat,group,pos,nplot,CUselect,annualized);

if N==2
IRF = {'Govt', impplot.G,...                               % 1
    'GDP',impplot.GDP,...                                        % 2                                  
    'Final good (Y)',impplot.Y,...                               % 3   'Interm good (Q)',impplot.Q,...
    'Consumption (C)',impplot.C,...                              % 4    'Ann. GDP growth',impplot.GDPgr,...                          % 3
    'Labor (L)',impplot.L,...                                    % 5 
    'Investment (X)',impplot.X,...                               % 6
    'ToT',impplot.ToT,...                                        % 7 'Real net worth (NW/P)',impplot.NWP,... 
    'Nom XRT (E_1/E_2)',squeeze(impplot.Ebi(:,2,:)),...          % 8
    'Net exports',impplot.nx,...                                 % 9
    'Capital Utilization',impplot.u,...                          % 10
    'Ann. nom int rate (i)',impplot.i,...                        % 11
    'Ann. inflation',impplot.pi};                                  % 12   

elseif N==1
IRF = {shocktype,impplot.shock,...                               % 1
    'GDP',impplot.GDP,...                                        % 2                                  
    'Final good (Y)',impplot.Y,...                               % 3   'Interm good (Q)',impplot.Q,...
    'Consumption (C)',impplot.C,...                              % 4    'Ann. GDP growth',impplot.GDPgr,...                          % 3
    'Labor (L)',impplot.L,...                                    % 5 
    'Investment (X)',impplot.X,...                               % 6
    'R/P',impplot.RP,...                                        % 7 'Real net worth (NW/P)',impplot.NWP,... 
    'Capital Utilization',impplot.u,...                          % 8
    'GDP growth',impplot.GDPgr,...                               % 9
    'Tau_N',impplot.tau_N,...                        % 10
    'Gov spending',impplot.G,...                                  % 11 
    'Tau_C',impplot.tau_C};                                % 12
end


IMPDAT  = impdat; 

% Country 1 NX/GDP 

NX_GDP = impdat(:,pos.pP(1)) + impdat(:,pos.Q(1)) - impdat(:,pos.Y(1));


% ======================================================================= %
% PDV Revenue
% ======================================================================= %

revenue = impdat(:,pos.rev(1)); 

stat_revenue = impdat(:,pos.stat_rev(1)); 

A_beta = 1/(1+ greece_rate); 
beta2 = A_beta^.25;

J_beta = beta2.^[1:40000]';

PDV_rev         = J_beta'*revenue;
% PDV_stat_rev    = J_beta'*stat_revenue;
    
horiz = 4; 

SR2015_GDP          = mean(impdat(1:horiz,pos.GDP(1))); 
SR2015_Emp          = mean(impdat(1:horiz,pos.L(1))); 
SR2015_Inv          = mean(impdat(1:horiz,pos.X(1))); 
SR2015_Prim_Bal     = mean(impdat(1:horiz,pos.rev(1)) - impdat(1:horiz,pos.G(1))*GGDP); 
SR2015_ToT          = mean(impdat(1:horiz,pos.ToT(1))); 
% SR2015_NX           = mean(impdat(1:horiz,pos.nx(1))); 
SR2015_NX           = mean(NX_GDP(1:horiz)); 
SR2015_C            = mean(impdat(1:horiz,pos.C(1))); 
SR2015_K            = mean(impdat(1:horiz,pos.K(1))); 
SR2015_STAT_REV     = mean(impdat(1:horiz,pos.stat_rev(1))); 
SR2015_REV          = mean(impdat(1:horiz,pos.rev(1))); 

horiz = 20; 

SR_GDP          = mean(impdat(1:horiz,pos.GDP(1))); 
SR_Emp          = mean(impdat(1:horiz,pos.L(1))); 
SR_Inv          = mean(impdat(1:horiz,pos.X(1))); 
SR_Prim_Bal     = mean(impdat(1:horiz,pos.rev(1)) - impdat(1:horiz,pos.G(1))*GGDP); 
SR_ToT          = mean(impdat(1:horiz,pos.ToT(1))); 
% SR_NX           = mean(impdat(1:horiz,pos.nx(1))); 
SR_NX           = mean(NX_GDP(1:horiz)); 
SR_C            = mean(impdat(1:horiz,pos.C(1))); 
SR_K            = mean(impdat(1:horiz,pos.K(1))); 
SR_STAT_REV     = mean(impdat(1:horiz,pos.stat_rev(1))); 
SR_REV          = mean(impdat(1:horiz,pos.rev(1))); 

horiz = 140; 

LR_GDP          = mean(impdat(60:horiz,pos.GDP(1))); 
LR_Emp          = mean(impdat(60:horiz,pos.L(1))); 
LR_Inv          = mean(impdat(60:horiz,pos.X(1))); 
LR_Prim_Bal     = mean(impdat(60:horiz,pos.rev(1)) - impdat(60:horiz,pos.G(1))*GGDP); 
LR_ToT          = mean(impdat(60:horiz,pos.ToT(1))); 
% LR_NX           = mean(impdat(60:horiz,pos.nx(1))).*Scale; 
LR_NX           = mean(NX_GDP(60:horiz)); 
LR_C            = mean(impdat(60:horiz,pos.C(1))); 
LR_K            = mean(impdat(60:horiz,pos.K(1))); 
LR_STAT_REV     = mean(impdat(60:horiz,pos.stat_rev(1))); 
LR_REV          = mean(impdat(60:horiz,pos.rev(1))); 


TAB_SRLR =  [SR2015_GDP SR_GDP LR_GDP; ... 
            SR2015_Inv SR_Inv LR_Inv; ... 
            SR2015_Prim_Bal SR_Prim_Bal LR_Prim_Bal; ... 
            SR2015_NX SR_NX LR_NX; ... 
            SR2015_Emp SR_Emp LR_Emp; ... 
            SR2015_C SR_C LR_C; ... 
            SR2015_K SR_K LR_K; ... 
            SR2015_ToT SR_ToT LR_ToT; ...
            SR2015_STAT_REV SR_STAT_REV LR_STAT_REV; ... 
            SR2015_REV SR_REV LR_REV] ;

PDV_REV = PDV_rev; 

% ======================================================================= %
% Approximate Change to Lifetime Utility 
% ======================================================================= %

U_beta = beta.^[1:4000];

du  = (impdat(1:4000,pos.C(1))*(C(1,1)^(1 - s))) - impdat(1:4000,pos.L(1,1))*(kappa*L(1)^(1+(1/eta))); 

dU  = U_beta*du;

% consumption equivalent 

dC_avoid = (1-beta)*dU/(C(1,1)^(1 - s));

DC = dC_avoid; 

% 
% % Plotting
% %plotselect={[8 9]}; 
% for i=1:length(plotselect)
%     fig_IRF(1+i,[4,3],dat,IRF,plotselect{i})
% end
% 
% 
% 
% disp('yay')
% 
% figure(100)
% 
% time = [1:40]'; 
% 
% subplot(3,3,1);
% plot(time, impdat(1:40,pos.tau_N(1)));
% axis([1 40 0 20])
% title('tau_N');
% 
% 
% subplot(3,3,2);
% plot(time, impdat(1:40,pos.tau_C(1)));
% axis([1 40 0 20])
% title('tau_C');
% 
% 
% subplot(3,3,3);
% plot(time, impdat(1:40,pos.tau_K(1)));
% axis([1 40 0 20])
% title('tau_K');
% % 
% % 
% % for j = 1:3; 
% % subplot(3,3,j);
% % plot(time, impdat(1:40,pos.MA(10*j,1)));
% % end; 
% % 
% % for j = 1:3
% % subplot(3,3,j+3);
% % plot(time, impdat(1:40,pos.MA(10*j,2)));
% % end; 
% 
% Y1 = impdat(:,pos.Y(1)); 
% Y2 = impdat(:,pos.Y(2)); 
% S1 = impdat(:,pos.S(1)); 
% S2 = impdat(:,pos.S(2)); 
% pP1 = impdat(:,pos.pP(1)); 
% pP2 = impdat(:,pos.pP(2)); 
% Q1 = impdat(:,pos.Q(1)); 
% Q2 = impdat(:,pos.Q(2)); 
% 
% 
% 
% time = [1:400]'; 
% 
% subplot(3,3,7);
% plot(time, Pop(1)*Q(1)*S1(1:400)); 
% hold on; 
% plot(time, Pop(2)*Q(2)*S2(1:400)); 
% hold off; 
% legend('AGG_S1','AGG_S2','Location','NorthEast');
% 
% subplot(3,3,8);
% plot(time, impdat(1:400,pos.RP(1)));
% hold on; 
% plot(time, impdat(1:400,pos.WP(1)));
% hold off; 
% legend('RP1','WP1','Location','NorthEast');
% 
% subplot(3,3,9);
% plot(time, impdat(1:400,pos.pP(1)));
% legend('pP','Location','NorthEast');
% 
% 
% EMP = mean(impdat(1:4,pos.L(1))); 