% Transform data across periods
% function output = datetransform(data,periodicity,summe)
% input:    data: starting with first date in period (e.g. January for monthly data, 1st quarter for quarterly data), row vector (e.g. country x time)
%           periodicity: 3 to transform monthly to quarterly; 4 to transform quarterly to annual; 
%           summe: 1 if e.g. quarterly data is sum of monthly data; 0 if e.g.
%           quarterly data is average of monthly data
% output:   data at new frequency


function output = datetransform(data,periodicity,summe)

ndata = size(data,1);

for j=1:ndata
    n(j)= fix(length(data(j,:))/periodicity);
end

output=zeros(ndata,max(n));

for j=1:size(data,1)


for i=1:n(j)
    if summe ==1
        output(j,i)=nansum(data(j,(i-1)*periodicity+1:(i-1)*periodicity+periodicity),2);
    else
        output(j,i)=nanmean(data(j,(i-1)*periodicity+1:(i-1)*periodicity+periodicity),2);
    end
end

end
