function [yvec1,shock]=impf_multi(a,b,exog,pos,nstep,neq,XtoGDP)

%*******************************************************
%******** Proc to compute impulse response from system: 
%*******************************************************

yvec=zeros(nstep,length(a));
shock = zeros(neq,nstep); 

btmp = b(pos.exog,pos.exogshock); %invbtmp = inv(btmp); %shock(pos.exogshock,1)=invbtmp*exog(:,1);
shock(pos.exogshock,1)=btmp\exog(:,1);
y=b*shock(:,1);                 % initial value 
yvec(1,:)=y';              % store initial value 
i=2;
while i<=nstep;         % loop through periods 
 shock(pos.exogshock,i)=btmp\(exog(:,i)-a(pos.exog,:)*y);   
 y=a*y+b*shock(:,i); 
 yvec(i,:)=y';
 i=i+1;
end;
yvec1= yvec(:,1:neq);
shock=shock(pos.exogshock,:);


return

if XtoGDP==0
    y=b*shock(:,1);                 % initial value 
    y(pos.exog)=exog(:,1);
    yvec=zeros(nstep,length(a));
    yvec(1,:)=y';              % store initial value 
    i=2;

else
    initial=zeros(neq,1);

A = a(pos.X,pos.K(1))-a(pos.GDP,pos.K(1));
for i=2:length(pos.K)
    A = [A a(pos.X,pos.K(i))-a(pos.GDP,pos.K(i))]; 
end
initial(pos.K) = (A/100)\XtoGDP;
yvec=zeros(nstep,length(a));
yvec(1,:)=initial';
yvec(2,:)= (a*yvec(1,:)')'+(b*shock(:,1))';
yvec(2,pos.exog)=exog(:,1)'; y=yvec(2,:)';
yvec(1,:)=yvec(2,:);
i=2;
end

while i<=nstep;         % loop through periods 
 y=a*y+b*shock(:,i); 
 y(pos.exog)=exog(:,i);
 yvec(i,:)=y';
 i=i+1;
end;

yvec1= yvec(:,1:neq);
