% ======================================================================= %
% greece_loop_figure.m
% ======================================================================= %


clc; 
clear all; 
close all; 

delay_loop      = [0 2 4 8 0 ];
% delay_loop      = [0 0 0 0 0 ];

param_loop      = 1.5*[1 1 1 1 1];
% param_loop      = [1.5 5 10 100];

% finance_loop    = [1 2 3 4 5]; 
finance_loop    = [10 11 12 13]; 

greece_rate     = .06; 

wealth_effect   = 1; 

N_Loop          = 4; 
D_Loop          = 4; 

ALL_IMPDAT  = NaN(40000,168,N_Loop*D_Loop); 
REV_DAT     = NaN(N_Loop*D_Loop,1); 
TABLE_DAT   = NaN(10,3,N_Loop*D_Loop);
DC_DAT      = NaN(N_Loop*D_Loop,1); 

for j = 1:N_Loop; 

    for d = 1:D_Loop; 
        
    delay           = delay_loop(d);
    param           = param_loop(j);
    finance_type    = finance_loop(j);
    
    [IMPDAT, pos, PDV_REV, TAB_SRLR, DC] = greece_mod_sub2(delay, greece_rate, wealth_effect, param, finance_type);
    
    ALL_IMPDAT(:,:,4*(j-1)+d)       = IMPDAT;
    REV_DAT(4*(j-1)+d,1)            = PDV_REV; 
    TABLE_DAT(:,:,4*(j-1)+d)        = TAB_SRLR;
    DC_DAT(4*(j-1)+d,1)             = DC; 

    end; 
    
end; 


years_plot = 40; 
    
figure(1)

for j = 1:N_Loop;
    
    jj = 4*(j-1);
        
    subplot(2,2,j)
    plot(ALL_IMPDAT(1:years_plot*4,pos.GDP(1),jj+1),'-c', 'LineWidth', 2);
    hold on;
    plot(ALL_IMPDAT(1:years_plot*4,pos.GDP(1),jj+2),'-ro', 'LineWidth', 1);
    plot(ALL_IMPDAT(1:years_plot*4,pos.GDP(1),jj+3),':k', 'LineWidth', 2.5);
    plot(ALL_IMPDAT(1:years_plot*4,pos.GDP(1),jj+4),'--m', 'LineWidth', 2);
    hold off;
    if j == 1;
        title('Government Spending')
        legend('Immediate','2-Year Delay','4-Year Delay','8-Year Delay','Location', 'SouthEast')
    elseif j == 2;
        title('Consumption Tax')
    elseif j == 3;
        title('Labor Tax')
    elseif j == 4;
        title('Capital Tax')
    end;
%     ylim([-1 140])
    xlim([0 140])
    set(gca,'XTick',[0 20 40 60 80 100 120 140])
    set(gca,'XTickLabel',{'2015',  '2020', '2025', '2030', '2035', '2040', '2045', '2050'})
    xlim([0 80])
    set(gca,'XTick',[0 20 40 60 80])
    set(gca,'XTickLabel',{'2015',  '2020', '2025', '2030', '2035'})
    
end;


set(gcf, 'Position', get(0,'Screensize')); % Maximize figure.

return; 
