%% balanced
% balanced panel regression
% inputs: yvar: LHS variable (T x N)
%         xvar: {K}(T x N), every cell is 1 covariate



function [bhat,bhatstd,yhat,X] = balanced(yvar,xvar,FEi,FEt)

[T,N] = size(yvar);
K=length(xvar);

y = yvar(:);
for k=1:K
    X(:,k)=xvar{k}(:);
end

if FEi==1
    for i=1:N
        tmp = zeros(T*N,1);
        tmp(T*(i-1)+1:T*(i-1)+T) = ones(T,1);
        X = [X tmp];
    end
end

if FEt==1
    if FEi==1
        Tend=T-1;
    else
        Tend=T;
    end
    for t=1:Tend
        tmp = zeros(T*N,1);
        for i=1:N
            tmp(T*(i-1)+t) = 1;
        end
        X = [X tmp];
    end
end
    
[bhat,bhatstd] = ols(y,X);    
yhat = bhat'*X';     
