% ======================================================================= %
% greece_loop_table.m
% ======================================================================= %


clc; 
clear all; 
close all; 

% delay_loop      = [0 2 4 8 0 ];
delay_loop      = [0 0 0 0 0 0];

param_loop      = 1.5*[1 1 1 1 1 1];
% param_loop      = [1.5 5 10 100];

finance_loop    = [1 2 3 4 5 10]; 

greece_rate     = .04; 

wealth_effect   = 1; 

N_Loop          = 6; 

ALL_IMPDAT  = NaN(40000,168,N_Loop); 
REV_DAT     = NaN(N_Loop,1); 
TABLE_DAT   = NaN(10,3,N_Loop);
DC_DAT      = NaN(N_Loop,1); 

for j = 1:N_Loop; 
    
    delay           = delay_loop(j);
    param           = param_loop(j);
    finance_type    = finance_loop(j);
    
    [IMPDAT, pos, PDV_REV, TAB_SRLR, DC] = greece_mod_sub2(delay, greece_rate, wealth_effect, param, finance_type);
    
    ALL_IMPDAT(:,:,j)       = IMPDAT;
    REV_DAT(j,1)            = PDV_REV; 
    TABLE_DAT(:,:,j)        = TAB_SRLR;
    DC_DAT(j,1)             = DC; 
    
end; 

% DATA ORDERING
% 1: Repayment 
% 2: Government Spending Cut 
% 3: VAT 
% 4: Labor Tax 
% 5: Capital Tax

% ======================================================================= %
% Cash that Greece needs to come up with (including endogenous effects of
% transfer). 
% NOTE: these figures are in percentage points -- i.e., 1 is one percent. 
% ======================================================================= %

A_beta = 1/(1+ greece_rate); 
beta = A_beta^.25;

r_Q     = (1/beta) - 1; 

cash_gap = REV_DAT(1,1) - (1/r_Q); 

SCALE_DAT = NaN(4,1); 

% ======================================================================= %
% 1. Repayment by Government Spending Cuts. 
% ======================================================================= %

% Spending Cuts Sufficient to Payback 1 Percent of GDP in Perpetuity. 

a = REV_DAT(2,1)/(-1);

tempcoef = r_Q/(1-r_Q*a); 

% Required change in government spending (pct of initial GDP)

dG = tempcoef*cash_gap; 

% Calculate the responses (Table) associated with the revised change

Scale_temp = -dG;

SCALE_DAT(1,1)  = Scale_temp;  

Govt_TAB = TABLE_DAT(:,:,1) + Scale_temp*TABLE_DAT(:,:,2); 

colNAN  = NaN(10,1);

TABLE_1     = [Govt_TAB];  

dc_temp     = DC_DAT(1) + Scale_temp*DC_DAT(2); 

DC_DAT2     = [dc_temp]; 

% ======================================================================= %
% 2. Repayment by Consumption Tax Increase
% ======================================================================= %

b   = REV_DAT(3,1); 

% Required change in VAT

dVAT = -cash_gap/b; 

% Calculate the responses (Table) associated with the revised change

Scale_temp = dVAT;

SCALE_DAT(2,1)  = Scale_temp;  

VAT_TAB = TABLE_DAT(:,:,1) + Scale_temp*TABLE_DAT(:,:,3); 

TABLE_1     = [TABLE_1 colNAN VAT_TAB];  

dc_temp     = DC_DAT(1) + Scale_temp*DC_DAT(3); 

DC_DAT2     = [DC_DAT2 dc_temp]; 


% ======================================================================= %
% 3. Repayment by Labor Tax Increase
% ======================================================================= %

b   = REV_DAT(4,1); 

% Required change in VAT

dtauN = -cash_gap/b; 

% Calculate the responses (Table) associated with the revised change

Scale_temp = dtauN;

SCALE_DAT(3,1)  = Scale_temp;  

tauN_TAB = TABLE_DAT(:,:,1) + Scale_temp*TABLE_DAT(:,:,4); 

TABLE_1     = [TABLE_1 colNAN tauN_TAB];  

dc_temp     = DC_DAT(1) + Scale_temp*DC_DAT(4); 

DC_DAT2     = [DC_DAT2 dc_temp]; 


% ======================================================================= %
% 4. Repayment by Capital Tax Increase
% ======================================================================= %

b   = REV_DAT(5,1); 

% Required change in VAT

dtauK = -cash_gap/b; 

% Calculate the responses (Table) associated with the revised change

Scale_temp = dtauK;

SCALE_DAT(4,1)  = Scale_temp;  

tauK_TAB = TABLE_DAT(:,:,1) + Scale_temp*TABLE_DAT(:,:,5); 

TABLE_1     = [TABLE_1 colNAN tauK_TAB];  

dc_temp     = DC_DAT(1) + Scale_temp*DC_DAT(5); 

DC_DAT2     = [DC_DAT2 dc_temp]; 


TABLE_1

SCALE_DAT'

DC_DAT2
