clear
cd "C:\Users\dschaffa\Downloads\Final Materials"

insheet using "cbo data.csv"
compress
tostring per, replace

merge 1:m per using quarterlyexp2.dta, nogenerate

save quarterlyexp3.dta, replace

clear

insheet using "bea data.csv"
compress
tostring per, replace

merge 1:m per using quarterlyexp3.dta, nogenerate

destring per, replace
tsset t, quarterly

***Change Pop to Billions
replace pop=pop/1000000000

***Generate fed-defense
gen ftexpnd = ftexpn - rdefense

***Make Variable Per Capita
gen ftexpndpc = ftexpnd/pop
gen ftexpnpc = ftexpn/pop
gen stexpnpc = stexpn/pop
gen fedtotrecpc = rfedtotrec/pop
gen fedcurtaxpc = rfedcurtax/pop
gen sttotrecpc = rsttotrec/pop
gen stcurtaxpc = rstcurtax/pop
gen netstlosavingpc = rnetstlosaving/pop
gen netfedlosavingpc = rnetfedlosaving/pop
gen gdppc = rgdp/pop

***Generate output gap and gap/potential
gen gap=pgdp-gdp
gen gapdpgdp=gap/pgdp
gen chgapdpgdp=s.gapdpgdp

***Generate log variables
gen lftexpndpc = log(ftexpndpc)
gen lftexpnpc = log(ftexpnpc)
gen lstexpnpc = log(stexpnpc)
gen lfedtotrecpc = log(fedtotrecpc)
gen lfedcurtaxpc = log(fedcurtaxpc)
gen lsttotrecpc = log(sttotrecpc)
gen lstcurtaxpc = log(stcurtaxpc)
gen lnetstlosavingpc = log(netstlosavingpc)
gen lnetfedlosavingpc = log(netfedlosavingpc)


gen lgdppc = log(gdppc)

***Generate ratio variables
gen qftexpnd = ftexpnd/pgdp
gen qftexpn = ftexpn/pgdp
gen qstexpn = stexpn/pgdp
gen qfedtotrec = rfedtotrec/pgdp
gen qfedcurtax = rfedcurtax/pgdp
gen qsttotrec = rsttotrec/pgdp
gen qstcurtax = rstcurtax/pgdp
gen qnetstlosaving = rnetstlosaving/pgdp
gen qnetfedlosaving = rnetfedlosaving/pgdp

***Generate state/fed variables
gen stexpndftexpn = stexpn/ftexpn
gen stexpndftexpnd = stexpn/ftexpnd
gen lstexpndftexpn = log(stexpndftexpn)
gen lstexpndftexpnd = log(stexpndftexpnd)
               
***Generate change variables
gen gdppcgro = S.lgdppc
gen gdppcgro4 = S4.lgdppc

gen fd_tax_gro = S.lfedcurtaxpc
gen st_tax_gro = S.lstcurtaxpc
gen fd_nde_gro = S.lftexpndpc
gen fd_exp_gro = S.lftexpnpc
gen st_exp_gro = S.lstexpnpc

egen medgro = median(gdppcgro) if gdppcgro !=.
egen medgro4 = median(gdppcgro4) if gdppcgro4 !=.

***differences
gen fd_tax_nde = fd_tax_gro - fd_nde_gro
gen fd_tax_exp = fd_tax_gro - fd_exp_gro
gen st_tax_exp = st_tax_gro - st_exp_gro

gen fs_tax = fd_tax_gro - st_tax_gro
gen fs_nde = fd_nde_gro - st_exp_gro
gen fs_exp = fd_exp_gro - st_exp_gro

***generate indicator variables
gen np_gdp = (gdppcgro<0) if gdppcgro !=.
gen ab_gdp = (gdppcgro<medgro) if gdppcgro !=.
gen ab_gd4 = (gdppcgro4<medgro4) if gdppcgro4 !=.
gen np_gap = (gapdpgdp>0) if gapdpgdp !=.
gen rf_gap = (chgapdpgdp>0) if chgapdpgdp !=.

gen fnp_gap = f.np_gap
gen frec = f.rec


***Output Stats

log using "ttest file.smcl"

***positive/negative gap/pgdp
ttest fd_tax_gro, by(np_gap) unequal
ttest st_tax_gro, by(np_gap) unequal
ttest fd_nde_gro, by(np_gap) unequal
ttest fd_exp_gro, by(np_gap) unequal
ttest st_exp_gro, by(np_gap) unequal
ttest fs_tax, by(np_gap) unequal
ttest fs_nde, by(np_gap) unequal
ttest fs_exp, by(np_gap) unequal

***rising/falling output gap
ttest fd_tax_gro, by(rf_gap) unequal
ttest st_tax_gro, by(rf_gap) unequal
ttest fd_nde_gro, by(rf_gap) unequal
ttest fd_exp_gro, by(rf_gap) unequal
ttest st_exp_gro, by(rf_gap) unequal
ttest fs_tax, by(rf_gap) unequal
ttest fs_nde, by(rf_gap) unequal
ttest fs_exp, by(rf_gap) unequal

***rec 0/1
ttest fd_tax_gro if gdppcgro !=., by(rec) unequal
ttest st_tax_gro if gdppcgro !=., by(rec) unequal
ttest fd_nde_gro if gdppcgro !=., by(rec) unequal
ttest fd_exp_gro if gdppcgro !=., by(rec) unequal
ttest st_exp_gro if gdppcgro !=., by(rec) unequal
ttest fs_tax if gdppcgro !=., by(rec) unequal
ttest fs_nde if gdppcgro !=., by(rec) unequal
ttest fs_exp if gdppcgro !=., by(rec) unequal

log close

save final_dataset, replace
