clear
set more off
cd "M:\Summer 2010\Data"
ssc install outreg2
insheet using CorpDepend2.csv
compress
merge 1:m sid using HinesFinalData.dta
***texp adjusted using consumption exp and inv price index, pinc using GDP price index
replace pop=pop*1000
replace pinc=pinc*1000000
replace texp=texp*1000



***Converst all to dollars and replace all real variables with real per capita values
replace edexp=(edexp*1000)/pop
replace hhexp=(hhexp*1000)/pop
replace highexp=(highexp*1000)/pop
replace pubwelexp=(pubwelexp*1000)/pop
replace uecompexp=(uecompexp*1000)/pop
replace pinc=pinc/pop
replace texp=texp/pop
replace totrev=(totrev*1000)/pop
replace taxrev=(taxrev*1000)/pop
replace prop=(prop*1000)/pop
replace sales=(sales*1000)/pop
replace indiv=(indiv*1000)/pop
replace corp=(corp*1000)/pop


***Drop national totals
drop if (sid==0)
***Drop Alaska
drop if (sid==2)
***Drop Hawaii
drop if (sid==12)
***Drop 1950 data because does not have DC
drop if (yr==1950)
***Sort and set as time series
sort sid yr
tsset sid yr

***Demeaned variables (pop share, mobility and corruption)
sum popsh
replace popsh=popsh-r(mean)
sum mobility
replace mobility=mobility-r(mean)
sum cor
replace cor=cor-r(mean)

****Generate log variables
gen ltexp=log(texp)
gen lpinc=log(pinc)
gen ledexp=log(edexp)
gen lhhexp=log(hhexp)
gen lhighexp=log(highexp)
gen lpubwelexp=log(pubwelexp)
gen luecompexp=log(uecompexp)
gen ltotrev=log(totrev)
gen ltaxrev=log(taxrev)
gen lprop=log(prop)
gen lsales=log(sales)
gen lindiv=log(indiv)
gen lcorp=log(corp)

***Generate dummies and interactions
xi i.yr
gen dlpinc=S.lpinc
xi i.sid*dlpinc
gen sumdlpinc=dlpinc+L.dlpinc
xi i.sid*sumdlpinc
gen popinc=popsh*lpinc
gen mobinc=mobility*lpinc
gen corinc=cor*lpinc
gen dpopinc=popsh*S.lpinc


gen bbrinc=bbr*lpinc

gen IGpop=popsh*IG
gen dIGpop=popsh*S.IG
gen LdIGpop=L.dIGpop
gen IGmob=mobility*IG
gen IGcor=cor*IG
gen texpdpinc=texp/pinc




cd "M:\Summer 2010\FinalTablesHines"

***Table 4: new corruption variable (Nov 16)
xtreg S.ltexp S.lpinc SL.lpinc S.bbrinc SL.bbrinc S.mobinc SL.mobinc S.corinc SL.corinc dpopinc L.dpopinc popsh L.popsh i.yr, fe cluster(sid)
outreg2 using "table4.doc", replace
lincom S.lpinc+SL.lpinc
lincom S.mobinc+SL.mobinc
lincom S.corinc+SL.corinc
lincom dpopinc+L.dpopinc

xtreg S.ltexp S.lpinc SL.lpinc S.bbrinc SL.bbrinc  S.mobinc SL.mobinc S.corinc SL.corinc dpopinc L.dpopinc popsh L.popsh S.IG SL.IG dIGpop L.dIGpop i.yr, fe cluster(sid)
outreg2 using "table4.doc"
lincom S.lpinc+SL.lpinc
lincom S.mobinc+SL.mobinc
lincom S.corinc+SL.corinc
lincom dpopinc+L.dpopinc

xtreg S.ltaxrev S.lpinc SL.lpinc S.bbrinc SL.bbrinc S.mobinc SL.mobinc S.corinc SL.corinc dpopinc L.dpopinc popsh L.popsh i.yr, fe cluster(sid)
outreg2 using "table4.doc"
lincom S.lpinc+SL.lpinc
lincom S.mobinc+SL.mobinc
lincom S.corinc+SL.corinc
lincom dpopinc+L.dpopinc


xtreg S.ltaxrev S.lpinc SL.lpinc S.bbrinc SL.bbrinc  S.mobinc SL.mobinc S.corinc SL.corinc dpopinc L.dpopinc popsh L.popsh S.IG SL.IG dIGpop L.dIGpop i.yr, fe cluster(sid)
outreg2 using "table4.doc"
lincom S.lpinc+SL.lpinc
lincom S.mobinc+SL.mobinc
lincom S.corinc+SL.corinc
lincom dpopinc+L.dpopinc

***Table 2

xtreg S.ltexp S.lpinc SL.lpinc S.bbrinc SL.bbrinc dpopinc L.dpopinc popsh L.popsh i.yr, fe cluster(sid)
outreg2 using "table2.doc", replace
xtreg S.ltexp S.lpinc SL.lpinc S.bbrinc SL.bbrinc  dpopinc L.dpopinc popsh L.popsh S.IG SL.IG dIGpop L.dIGpop i.yr, fe cluster(sid)
outreg2 using "table2.doc"
xtreg S.ltaxrev S.lpinc SL.lpinc S.bbrinc SL.bbrinc dpopinc L.dpopinc popsh L.popsh i.yr, fe cluster(sid)
outreg2 using "table2.doc"
xtreg S.ltaxrev S.lpinc SL.lpinc S.bbrinc SL.bbrinc dpopinc L.dpopinc popsh L.popsh  S.IG SL.IG dIGpop L.dIGpop i.yr, fe cluster(sid)
outreg2 using "table2.doc"

***Table 3a
xtreg S.ledexp S.lpinc SL.lpinc S.bbrinc SL.bbrinc dpopinc L.dpopinc popsh L.popsh S.IG SL.IG dIGpop L.dIGpop i.yr, fe cluster(sid)
outreg2 using "table3a.doc", replace
lincom dpopinc+L.dpopinc
xtreg S.lhhexp S.lpinc SL.lpinc S.bbrinc SL.bbrinc dpopinc L.dpopinc popsh L.popsh S.IG SL.IG dIGpop L.dIGpop i.yr, fe cluster(sid)
outreg2 using "table3a.doc"
lincom dpopinc+L.dpopinc
xtreg S.lpubwelexp S.lpinc SL.lpinc S.bbrinc SL.bbrinc dpopinc L.dpopinc popsh L.popsh S.IG SL.IG dIGpop L.dIGpop i.yr, fe cluster(sid)
outreg2 using "table3a.doc"
lincom dpopinc+L.dpopinc
xtreg S.lhighexp S.lpinc SL.lpinc S.bbrinc SL.bbrinc dpopinc L.dpopinc popsh L.popsh S.IG SL.IG dIGpop L.dIGpop i.yr, fe cluster(sid)
outreg2 using "table3a.doc"
lincom dpopinc+L.dpopinc
xtreg S.luecompexp S.lpinc SL.lpinc S.bbrinc SL.bbrinc dpopinc L.dpopinc popsh L.popsh S.IG SL.IG dIGpop L.dIGpop i.yr, fe cluster(sid)
outreg2 using "table3a.doc" 
lincom dpopinc+L.dpopinc


***Table 3b
xtreg S.lindiv S.lpinc SL.lpinc S.bbrinc SL.bbrinc dpopinc L.dpopinc popsh L.popsh S.IG SL.IG dIGpop L.dIGpop i.yr, fe cluster(sid)
outreg2 using "table3b.doc", replace
lincom dpopinc+L.dpopinc
xtreg S.lcorp S.lpinc SL.lpinc S.bbrinc SL.bbrinc dpopinc L.dpopinc popsh L.popsh S.IG SL.IG dIGpop L.dIGpop i.yr, fe cluster(sid)
outreg2 using "table3b.doc"
lincom dpopinc+L.dpopinc
xtreg S.lsales S.lpinc SL.lpinc S.bbrinc SL.bbrinc dpopinc L.dpopinc popsh L.popsh  S.IG SL.IG dIGpop L.dIGpop i.yr, fe cluster(sid)
outreg2 using "table3b.doc"
lincom dpopinc+L.dpopinc
xtreg S.lprop S.lpinc SL.lpinc S.bbrinc SL.bbrinc dpopinc L.dpopinc popsh L.popsh S.IG SL.IG dIGpop L.dIGpop i.yr, fe cluster(sid)
outreg2 using "table3b.doc"
lincom dpopinc+L.dpopinc




***Scatter plot coefficients:

xtreg S.ltexp S.bbrinc SL.bbrinc popsh L.popsh S.IG SL.IG S.IGpop SL.IGpop i.yr _IsidXsumd*, fe cluster(sid)
outreg2 using "scattercoeff.xls", replace noas
xtreg S.ltaxrev S.bbrinc SL.bbrinc popsh L.popsh S.IG SL.IG S.IGpop SL.IGpop i.yr _IsidXsumd*, fe cluster(sid)
outreg2 using "scattercoeff.xls", noas



