

#delimit;
clear all;
set more off;
version 13;


/* Note: change Stata directory to the ../Stata/Code directory to run the code */
/*qui: cd "DIRECTORY IN HERE/Stata/Code"; */

* setting paths;
qui: do Paths;

* loval vars;
local rececb = "2008m11";
local trendb = "2001m2";
local abestt = "2012m11";
local abeend = "2013m11";
local cebase = "2012m12";
local celast = "2013m9";
local plotst = "2011m7";

* variables to be used;
local cefevars cpi gdp cons ip;
local pltnames CPI GDP Consumption "Industrial Production";

* location of variables in excel file;
local sheetlist "Consumer Prices" "GDP Q-o-Q" "Consumption Q-o-Q" "Industrial Production";
local celllist "A5:DM107";


* local nums;
local cebasenum = tm(`cebase');
local celastnum = tm(`celast');

local abelen = tm(`abestt')-tm(`abeend');
local plotnum= tm(`plotst');	

********************************************************************************
*
* Consensus forecasts for Japan: quarterly forecasts
*
********************************************************************************;

local zz = 1;

foreach var in `cefevars' {;

	local sheetname: word `zz' of "`sheetlist'";
	display "`sheetname'";

	qui: cd "$DataPath/Consensus";
	import excel using "JAPAN Extended.xls", sheet("`sheetname'") cellrange("`celllist'") firstrow case(lower);
	drop if _n==1;
	
	destring, replace;
	
	foreach varq of varlist q* {;
		local varstr "`varq'";
		local yearst = substr("`varstr'",3,4);
		local qurtst = substr("`varstr'",1,2);
		rename `varq' `var'`yearst'`qurtst';
	};
	
	reshape long `var', i(surveydate) j(date) string;
	
	
	* new date variable;
	gen year = substr(date,1,4);
	gen quarter = substr(date,6,1);
	destring year quarter, replace;
	drop date;
	gen date = ym(year,2+(quarter-1)*3);
	drop year quarter;
	format date %tm;
	
	* new survey variable;
	gen survey = mofd(surveydate);
	format survey %tm;
	drop surveydate;
	
	* reshape again for merging;
	*reshape wide `var', i(survey) j(date);
	save "$StDataPath/jpceq`var'", replace;
	clear all;
	
	local zz = `zz' + 1;
};

qui: cd "$CodePath";

* merging files;
use "$StDataPath/jpceqgdp";
merge m:1 survey date using "$StDataPath/jpceqcons", gen(_mergececons);
merge m:1 survey date using "$StDataPath/jpceqcpi", gen(_mergececpi);
merge m:1 survey date using "$StDataPath/jpceqip", gen(_mergeceip);
save "$StDataPath/jpcequart", replace;
