*This graphs quarterly changes in seasonally adjusted Japanese GDP, at an annual rate.;
* Figures plotted are 4(a); 

#delimit;
clear all;
set more off;
version 13;

/* Note: change Stata directory to the ../Stata/Code directory to run the code */
/*qui: cd "DIRECTORY IN HERE/Stata/Code"; */

* setting paths;
qui: do paths;

********************************************************************************
*
* Japan since 2007: national accounts  
*
********************************************************************************;


* importing GDP data: need nominal data for contributions;
qui: do jp_na_setup_update.do;
clear all;
use "$StDataPath/jpna";
merge m:1 date using "$StDataPath/jpnanom", gen(_mergenanom);

********************************************************************************
*
* Calculations  
*
********************************************************************************;

tsset date, quarterly;

gen quarter=quarter(dofq(date));
gen year=year(dofq(date));
gen lab_var = "Quarter";

* total investment;
gen invest = invres+invnonres+dinvent;
gen nominvest = nominvres+nominvnonres+nomdinvent;

* imports are negative contribution;
replace imp = -imp;
replace nomimp = -nomimp;

* annual mean and growth rate;
sort year;
foreach var of varlist gdp cons invest govt exp imp nom* {;
	by year: egen `var'y=mean(`var');
};
foreach var of varlist gdp cons invest govt exp imp {;
	gen defl`var'y=nom`var'y/`var'y;
};
sort date;

* contributions calculated as in Japan national accounts;
foreach var of varlist gdp cons invest govt exp imp {;
	gen dl`var' = S.`var'/L.`var'*400;
	gen dl`var'_contrib = (S.`var'/L.`var')*(L4.defl`var'y*L.`var'/(L4.deflgdpy*L.gdp))*400;*S.`var'/L.gdp*400;
};


* GDP under Abe;
gen dlgdp_abe = dlgdp if year>2012;

correlate dlcons_contrib dlinvest_contrib dlgovt_contrib if year>=2013;

* quarters since Abe begins;
gen quarter_abe = date - yq(2012,4);

	 
********************************************************************************
*
* Graphs
*
********************************************************************************;

cd "$StGrphPath";

* Graph 4(a): quarterly evolution;
graph twoway (bar dlgdp date if year>2006, lcolor(black)) (bar dlgdp_abe date if year>2006, color(red) lcolor(black)), ///
   xtitle("Date") ytitle("Real GDP growth (%, annualized)")  ///
	 saving(quart_gdp, replace)  graphregion(color(white)) name(quart_gdp) legend(off);
graph export quart_gdp.pdf, replace;


	 
