*This file generates figures 1(a)-(e);

clear all
set more off
#delimit;
version 13;


/* Note: change Stata directory to the ../Stata/Code directory to run the code */
/*qui: cd "DIRECTORY IN HERE/Stata/Code"; */

*setting paths;
qui: do paths;



* some analysis variables;
local startdate	=	"2012m1" ;
local startdatelong	=	"2007m1" ;
local abestt = "2012m11";
local moreqe = "2014m10";
local target2 = "2013m1";
local qqe = "2013m4";
local abeend = "2014m2";
local abenum = tm(`abestt');
local trenum = tm(`abeend');

local announcedate "15nov2012" "22jan2013" "05feb2013" "04apr2013" "31oct2014";

local announcevarsd bond2 bond10 bond30 is2 is10;
local announcevarspct nxr topix;

/*************************************************************************************************************
This do-file constructs a dataset for the Japan analysis `startdate'
*************************************************************************************************************/



* importing real exchange rate;
clear all;
qui: cd "$DataPath/BIS";
import excel broad1508.xls, cellrange(A5:BJ264) sheet("Real") firstrow; 
rename A daten;
gen jprlxr=RBJP^-1;
gen rlxr= jprlxr / jprlxr[169]*100;
keep date rlxr; 
label var rlxr "Real Exchange Rate (2008m1=100)";
save "$StDataPath/rlxr", replace;
clear all;



* importing topix from Bloomberg;
clear all;
import excel "$DataPath/Bloomberg/bloomberg20150828.xlsx", sheet("new series") firstrow case(lower);
drop if _n==1;
destring, replace;
keep tpx* b;
gen daten = date(tpxindex,"MDY");
format daten %td;
drop tpxindex;
rename b topix;
cd "$StDataPath";
save topix_daily, replace;
clear all;

* importing exchange rate from bloomberg;
clear all;
import excel "$DataPath/Bloomberg/bloomberg20150828.xlsx", sheet("new series") firstrow case(lower);
drop if _n==1;
destring, replace;
keep usd* e;
gen daten = date(usdjpycurncy,"MDY");
format daten %td;
drop usdjpycurncy;
rename e nxr;
drop if daten==.;
cd "$StDataPath";
save xryendollar, replace;
clear all;


* importing bloomberg:
* bond rates;
import excel "$DataPath/Bloomberg/bloomberg20150828.xlsx", sheet("Sheet3") cellrange(A1:W6544) firstrow case(lower) allstring;
drop if _n==2;
drop if _n==1;
destring, replace;

foreach var of varlist _all {;
    capture assert mi(`var');
     if !_rc {;
        drop `var';
     };
};

local lastvar;
foreach varname of varlist * {;
	local currvar: var label `varname';
	display "`currvar'";
	display substr("`currvar'",4,1);
	if substr("`currvar'",4,1)~="B" {;
		local surp1 = substr("`lastvar'",5,1);
		local surp2 = substr("`lastvar'",6,1);
		if substr("`lastvar'",6,1)=="0" {;
			local newname = "bond`surp1'`surp2'";
		};
		else {;
			local newname = "bond`surp1'";
		};
		display "`newname'";
		gen `newname'=`varname';
	};
	else {;
		local surp1 = substr("`currvar'",5,1);
		local surp2 = substr("`currvar'",6,1);
		if substr("`currvar'",6,1)=="0" {;
			local newname = "bond`surp1'`surp2'_date";
		};
		else {;
			local newname = "bond`surp1'_date";
		};
		display "`newname'";
		generate `newname'=date(`varname',"MDY");
	};
	local lastvar "`currvar'";
	drop `varname';
};
save "$StDataPath/bloombergtemp", replace;
keep bond7_date;
rename bond7_date date;

save "$StDataPath/bloombergbond", replace;

local bondmat 1 2 3 5 7 10 20 30;
foreach isset in `bondmat' {;
	clear all;
	use "$StDataPath/bloombergtemp";
	capture: keep bond`isset' bond`isset'_date;
	capture: rename bond`isset'_date date;
	capture: drop if date==.;
	capture: save "$StDataPath/bloombergtemp2", replace;
	capture: use "$StDataPath/bloombergbond";
	capture: merge m:1 date using "$StDataPath/bloombergtemp2", gen(_merge);
	capture: drop _merge;
	capture: save "$StDataPath/bloombergbond", replace;
};
gen daten = date;
format daten %td;
drop date;
drop if daten ==.;
save "$StDataPath/bloombergbond", replace;

* importing inflations swaps from Bloomberg;
clear all;
import excel "$DataPath/Bloomberg/bloomberg20150828.xlsx", sheet("Sheet1") firstrow case(lower) allstring;
drop if _n==2;
drop if _n==1;
destring, replace;

*stop here;

foreach var of varlist _all {;
    capture assert mi(`var');
     if !_rc {;
        drop `var';
     };
};

local lastvar;
foreach varname of varlist * {;
	local currvar: var label `varname';
	display "`currvar'";
	display substr("`currvar'",4,1);
	if substr("`currvar'",4,1)~="W" {;
		local surp1 = substr("`lastvar'",1,2);
		local surp2 = substr("`lastvar'",7,1);
		if substr("`lastvar'",8,1)=="0" {;
			local surp2 = substr("`lastvar'",7,2);
		};
		local newname = "is`surp2'`surp1'";
		display "`newname'";
		gen `newname'=`varname';
	};
	else {;
		local surp1 = substr("`currvar'",1,2);
		local surp2 = substr("`currvar'",7,1);
		if substr("`currvar'",8,1)=="0" {;
			local surp2 = substr("`currvar'",7,2);
		};
		local newname = "is`surp2'`surp1'_date";
		display "`newname'";
		generate `newname '=date(`varname',"MDY");
	};
	local lastvar "`currvar'";
	drop `varname';
};
save "$StDataPath/bloombergtemp", replace;
keep is10JY_date;
rename is10JY_date date;
drop if date<.;
save "$StDataPath/bloombergswap", replace;
local countries JY;
local islen 1 2 5 10;
foreach ctrset in `countries' {;
	foreach isset in `islen' {;
		clear all;
		use "$StDataPath/bloombergtemp";
		keep is`isset'`ctrset' is`isset'`ctrset'_date;
		rename is`isset'`ctrset'_date date;
		rename is`isset'`ctrset' is`isset';
		drop if date==.;
		save "$StDataPath/bloombergtemp2", replace;
		use "$StDataPath/bloombergswap";
		merge m:1 date using "$StDataPath/bloombergtemp2", gen(_merge);
		drop _merge;
		save "$StDataPath/bloombergswap", replace;
	};
};
gen daten = date;
format daten %td;
drop date;
drop if daten==.;
save "$StDataPath/bloombergswap", replace;

clear all;

/*note krugman_pi_e--the UIP-PPP measure of inflation expectations is created in */
cd "$CodePath/";
run japan_cpi_update.do;
clear all;
cd "$CodePath/";
run infe_krugman_update.do;


* Nikkei;
clear all;
insheet using "http://ichart.finance.yahoo.com/table.csv?s=%5EN225&a=00&b=1&c=1990&g=d&ignore=.csv";
keep date close;
rename close nikkei;
label variable nikkei Nikkei225;
gen daten=date(date,"YMD");
format daten %td;
*drop observations after cut-off (8/28/15);
drop if daten > td(28aug2015);
save "$StDataPath/nikkei", replace;


********************************************************************************
*
* Merging Data 
*
********************************************************************************;


* merging data;
merge 1:1 daten using "$StDataPath/bloombergswap", generate(_mergeswap);
merge 1:1 daten using "$StDataPath/bloombergbond", generate(_mergebond);
merge 1:1 daten using "$StDataPath/rlxr", generate(_mergerlxr);
merge 1:1 daten using "$StDataPath/xryendollar", generate(_mergenxr);
merge 1:1 daten using "$StDataPath/topix_daily", generate(_mergetopix);
merge 1:1 daten using "$StDataPath/krugman_pi_e", generate(_mergekrugman);
drop _merge*;

* tsseting data;
sort daten;
drop date;
rename daten date;
format date %td;
label variable date Date;
tsset date, daily;


* generating real interest rate;
gen real10 = bond10 - is10;
gen real5 = bond5 - is5;
gen real2 = bond2 - is2;
label var real10 "10-Year Real Interest Rate";
label var real5 "5-Year Real Interest Rate";
label var real2 "2-Year Real Interest Rate";


********************************************************************************
*
* Announcements 
*
********************************************************************************;

preserve;
* creating variables for announcements;
foreach var of varlist `announcevarsd' {;
	forvalues jj=1(1)5 {;
		gen d`jj'`var' =S`jj'.`var'*100;
	};
	gen f2`var' =(F.`var'-L.`var')*100;
};

foreach var of varlist `announcevarspct' {;
	forvalues jj=1(1)5 {;
		gen d`jj'`var' =S`jj'.`var'/L`jj'.`var'*100;
	};
	gen f2`var' =(F.`var'-L.`var')/L.`var'*100;
};

* keeping data around announcement dates;
gen mark=0;

foreach date in "`announcedate'" {;
	replace mark=1 if date==td(`date');
};

keep if mark==1;
keep date d* f2*;
drop delta*;




foreach var in `announcevarsd' `announcevarspct' {;

	replace d1`var' = f2`var' if date==td("05feb2013"); // Shirakawa resignation announcement in evening so we use 2-day change;
};

keep date d1*;

* label variables;
label variable date "Announcement date";
label variable d1bond2 "2-yr JGB (b.p. change)";
label variable d1bond10 "10-yr JGB (b.p. change)";
label variable d1bond30 "30-yr JGB (b.p. change)";
label variable d1is2 "2-yr inflation swap (b.p. change)";
label variable d1is10 "10-yr inflation swap (b.p. change)";
label variable d1nxr "Yen / \$  (\% change)";
label variable d1topix "TOPIX index (\% change)";

* formatting data;
format d1* %9.2f;

* data to matrix;
mkmat date d1*, matrix(announcemat) ;
matrix announcematout = announcemat';

 capture ssc install outtable;
outtable using "$StTabPath/announcements_update", mat(announcemat) format(%tdnn/dd/YY %9.1f %9.1f %9.1f %9.1f %9.1f %9.2f %9.2f) ///
 norowlab center nobox replace caption("Announcement effects") clabel(tab:announcements);



restore; 

********************************************************************************
*
* Collapsing and plotting data
*
********************************************************************************;

* dropping mergers and collapsing data;
gen datem = mofd(date);
*collapse (mean) bond* is* real? real10 *xr nikkei topix  *_e piop, by(datem);
collapse (mean) bond* is* real? real10 *xr nikkei topix  *_e, by(datem);
rename datem date;
tsset date, monthly;

*drop anything after March;
*drop if date >=ym(2014,4);

save "$StDataPath/jp_fin_monthly", replace;

cd "$StGrphPath";


*Graph 2,10,30 year nominal rates on the same graph;
tsline bond2 bond10 bond30 if tin(`startdatelong',), name(nombondslong) ///
legend(label(1 "2-year") label(2 "10-year") label(3 "30-year") label(4 "20-year") label(5 "30-year") cols(1) ring(0) position(7)) ///
	ytitle("Nominal bond yields (%)") xtitle("") tline(`abestt') tline(`moreqe') plotregion(style(none)) ///
	lwidth(medthick medthick medthick) clpattern(solid dash dash_dot) ///
    clcolor(blue red black) graphregion(color(white)) tlabel(2007m1 2009m1 2011m1 2013m1 2015m1, format(%tm)) ;
   
    graph export bondsfinlong.pdf, replace;
   * graph export bondsfinlong.eps, replace;


*Graph 2, 10 year inflation swap rates on the same graph w/out Krugman calculation;
tsline is2 is10 if tin(`startdatelong',), name(swapslong) ///
legend(label(1 "2-year") label(2 "10-year") label(3 "5-year") label(4 "10-year") cols(1) ring(0) position(7)) ///
	ytitle("Inflation swap rates (%)") xtitle("") tline(`abestt') tline(`moreqe') plotregion(style(none)) ///
	lwidth(medthick medthick medthick) clpattern(solid dash dash_dot) ///
    clcolor(blue red black) graphregion(color(white)) tlabel(2007m1 2009m1 2011m1 2013m1 2015m1, format(%tm)) ;
    
	graph export swapsfinlong.pdf, replace;
	*graph export swapsfinlong.eps, replace;
	
	
*Graph 2,10 year inflation swap rates on the same graph w/ Krugman calculation;
tsline is2 is10 realpi_e if tin(`startdatelong',), name(swapslong_krugman) ///
legend(label(1 "2-year inflation swap rate") label(2 "10-year  inflation swap rate") label(3 "10-year UIP-PPP (Krugman, 2013)") label(4 "10-year") cols(1) ring(0) position(10)) ///
	ytitle("Expected inflation (risk-neutral, %)") xtitle("") tline(`abestt') tline(`moreqe') plotregion(style(none)) ///
	lwidth(medthick medthick medthick) clpattern(solid dash dash_dot) ///
    clcolor(blue red black) graphregion(color(white)) tlabel(2007m1 2009m1 2011m1 2013m1 2015m1, format(%tm)) ;
    
	graph export swapsfinlong_krugman.pdf, replace;
	*graph export swapsfinlong_krugman.eps, replace;	
    
    *Graph 2-10 year real rates on the same graph;
tsline real2 real10 if tin(`startdatelong',), name(realbondslong) ///
legend(label(1 "2-year") label(2 "10-year") cols(1) ring(0) position(7)) ///
	ytitle("Real bond yields (%)") xtitle("") tline(`abestt') tline(`moreqe') plotregion(style(none)) ///
	lwidth(medthick medthick medthick) clpattern(solid dash dash_dot) ///
    clcolor(blue red black) graphregion(color(white)) tlabel(2007m1 2009m1 2011m1 2013m1 2015m1, format(%tm)) ;
    
	graph export realfinlong.pdf, replace;
	*graph export realfinlong.eps, replace;
    
* Graph real and nominal xr;
foreach var of varlist rlxr {;
	gen `var'base = rlxr/nxr if date==ym(2007,1);
	egen `var'base2 = min(`var'base);
	gen `var'_index = `var' / `var'base2;
	drop `var'base*;
};
  
  
    *Graph real and nominal exchange rates on the same graph;
tsline nxr rlxr_index if tin(`startdatelong',), name(xrallfinlong) ///
legend(label(1 "Nominal exchange rate") label(2 "Real exchange rate") cols(1) ring(0) position(7)) ///
	ytitle("Yen/$ exchange rate and real exchange rate (1/2007 Yen/$)") xtitle("") tline(`abestt') tline(`moreqe') plotregion(style(none)) ///
    lwidth(medthick medthick medthick) clpattern(solid dash dash_dot) lcolor(blue red black) ///
    clcolor(blue red black) graphregion(color(white)) tlabel(2007m1 2009m1 2011m1 2013m1 2015m1, format(%tm)) ;
  
  graph export xrallfinlong.pdf, replace;
    

    
* Graph Topix and Nikkei;
*foreach var of varlist nikkei topix piop {;
foreach var of varlist nikkei topix  {;
	gen `var'base = `var' if date==ym(2007,1);
	egen `var'base2 = min(`var'base);
	gen `var'_index = `var' / `var'base2*100;
	drop `var'base*;
};

tsline nikkei_index topix_index if tin(`startdatelong',), name(stocklong) ytitle("Index (1/2007=100)") xtitle("") ///
tline(`abestt') tline(`moreqe') plotregion(style(none)) ///
legend(label(1 "Nikkei") label(2 "Topix") label(3 "Operating profits") cols(1) ring(0) position(7)) ///
lwidth(medthick medthick medthick) clpattern(solid dash dash_dot) lcolor(blue red black) ///
ms(p p Dh) mcolor(blue red black) recast(connected) ///
clcolor(blue) graphregion(color(white)) tlabel(2007m1 2009m1 2011m1 2013m1 2015m1, format(%tm)) ;

graph export stockfinlong.pdf, replace;

