#delimit;
clear all;
set more off;
version 13;

/* Note: change Stata directory to the ../Stata/Code directory to run the code */
/*qui: cd "DIRECTORY IN HERE/Stata/Code"; */

* setting paths;
qui: do paths;

* local vars;
local plotst = "2007m1";
local rececb = "2007m1";
local trendb = "2001m1";

local abestt = "2012m11";
local abeend = "2015m6";
local cpinames  cpisa cpicoresa ;
local cpinames2005 cpisa2005 cpicoresa2005 ;
local allnames cpisa cpicoresa gdp_deflator cons_deflator;
local deflnames deflgdp deflcons;
local pltnames CPI "Core CPI";


********************************************************************************
*
* Japan: CPI
*
********************************************************************************;

* insheeting japan CPI data;
cd "$DataPath/CPI";
insheet using zmi2010e_jul2015.csv, names;

* fix date format;
gen date=ym(1970,1);
replace date=date+_n-1;
destring, replace;
drop v*;

tsset date;

* renaming variables;
local oldnames allitems allitemsseasonallyadjusted allitemslessfreshfoodseasonallya allitemslessimputedrentseasonall allitemslessimputedrentfreshfood allitemslessfoodlessalcoholicbev;
local newnames cpi cpisa cpilffsa cpilirsa cpilffirsa cpicoresa;
local varkeep `cpinames';

qui: local varcount: word count `oldnames';

forvalues kk=1(1)`varcount' {;

	qui: local currname: word `kk' of `oldnames';
	qui: local nextname: word `kk' of `newnames';
	rename `currname' `nextname';
		
};
keep date cpi `varkeep';


qui: local varcount: word count `cpinames';
forvalues kk=1(1)`varcount' {;

	qui: local currname: word `kk' of `cpinames';
	qui: local labname:  word `kk' of `pltnames';
	label var `currname' "`labname'";
		
};

destring, replace;

saveold "$StDataPath/jpcpi", replace;
clear;


********************************************************************************
*
* Japan: GDP deflators
*
********************************************************************************;



* insheeting japan deflator data;
cd "$DataPath/NA";
insheet using def-qk1521.csv, names;

* fix date format;
gen date=yq(1993,4);
replace date=date+_n;
destring, replace;
drop v*;


* renaming variables;
local oldnames gdpexpenditureapproach privateconsumption privateresidentialinvestment privatenonresiinvestment changeinprivateinventories governmentconsumption publicinvestment changeinpublicinventories exports imports;
local newnames deflgdp deflcons deflinvres deflinvnonres defldinvent deflcgovt deflinvgovt defldinventgov deflexp deflimp;
local varkeep `newnames';


qui: local varcount: word count `oldnames';

forvalues kk=1(1)`varcount' {;

	qui: local currname: word `kk' of `oldnames';
	qui: local nextname: word `kk' of `newnames';
	rename `currname' `nextname';
	
	*gen l`nextname' = ln(`nextname');
	
};

keep date `varkeep';
destring, replace;
* saving japan NA deflator data;
save "$StDataPath/jpnadefl", replace;

* date;
gen datem=mofd(dofq(date))+1;
drop date;
rename datem date;
format date %tm;
tsset date;

merge 1:1 date using "$StDataPath/jpcpi";

sort date;
saveold "$StDataPath/jpcpi", replace;

clear;





********************************************************************************
*
* Plotting Data
*
********************************************************************************;

use "$StDataPath/jpcpi";

* tsseting;
tsset date, monthly;

* distance to base;
local mindat = date[1];
local recnum = tm(`plotst');
local abenum = tm(`abestt');
*add 2 for ease of working with quarterly data;
local recobs = tm(`rececb')-`mindat'+2;
local abesttobs = `abenum' - `mindat' +2; 
display "`recobs'";
local trenum = tm(`abeend');
local treobs = tm(`trendb')-`mindat'+1;
display "`treobs'";


cd "$StGrphPath";
* generating graphs;
local zz = 1;


*foreach var of varlist `cpinames' `cpinames2005' {;
foreach var of varlist `cpinames'  {;
	
	qui: local plotvar: var label `var';
	display "`plotvar'";

	
	qui: gen `var'base = `var'/`var'[`recobs']*100;

	
	
	tsline `var'base if tin(`plotst',) , name(`var'base) xlabel(`recnum'(12)`trenum' , format(%tm)) ///
	tline(`abestt') legend(order(2 "`plotvar'"));
	graph export `var'base.pdf, replace;
	
	local zz = `zz'+1;
};


foreach var of varlist `deflnames'  {;
	
	qui: local plotvar: var label `var';
	display "`plotvar'";

	qui: gen `var'base = `var'/`var'[`recobs']*100;
	

	
	
	
	tsline `var'base if tin(`plotst',) , name(`var'base) xlabel(`recnum'(12)`trenum' , format(%tm)) ///
	tline(`abestt') legend(order(2 "`plotvar'"));
	graph export `var'base.pdf, replace;
	
	local zz = `zz'+1;
};

label variable cpisabase "CPI, 2/2007 = 100";
label variable cpicoresabase "CPI ex. fresh food and energy";
label variable deflgdpbase "GDP deflator, 2007:Q1 = 100";
label variable deflconsbase "Consumption deflator";



#delimit;
*make series excluding direct effects of 4/14 consumption tax increase. Use adjustments suggested by BOJ;
local adj_april_cpi = .019;
local adj_april_cpicore = .015;
local adj_cpi = .021;
local adj_cpicore = .017;

capture gen cpisabase_xctax = cpisabase;
label var cpisabase_xctax "CPI ex. cons. tax";

capture gen cpicoresabase_xctax = cpicoresabase;
label var cpicoresabase_xctax "CPI ex. food and energy ex. cons. tax";


disp "`cpinames2'";



foreach nm in cpi cpicore {;
	replace `nm'sabase_xctax = L12.`nm'sabase*(`nm'sabase / L12.`nm'sabase - `adj_april_`nm'') if date==tm(2014m4);
	replace `nm'sabase_xctax = L12.`nm'sabase*(`nm'sabase / L12.`nm'sabase - `adj_`nm'') if tin(2014m5,2015m3);
	replace `nm'sabase_xctax = L12.`nm'sabase_xctax*(`nm'sabase / L12.`nm'sabase - (`adj_`nm'' - `adj_april_`nm'')) if date==tm(2015m4);
	replace `nm'sabase_xctax = L12.`nm'sabase_xctax*(`nm'sabase / L12.`nm'sabase) if date>tm(2015m4);
	
	};


tsline cpisabase cpisabase_xctax cpicoresabase cpicoresabase_xctax deflgdpbase if tin(`plotst',) , name(cpi_defl_allbase_xctax) xlabel(`recnum'(12)`trenum' , format(%tm)) ///
tline(`abestt') plotregion(style(none)) legend(cols(1) ring(0) position(7) ) ytitle("Price indices (SA)") xtitle("") ///
	lwidth(medthick medthick medthick medthick medthick) clpattern(solid dot dash dot dash_dot) lcolor(blue blue red red black) graphregion(color(white));
graph export cpi_defl_allbase_xctax.pdf, replace;

*thicker xctax line for presentation;
tsline cpisabase cpisabase_xctax cpicoresabase cpicoresabase_xctax deflgdpbase if tin(`plotst',) , name(cpi_defl_allbase_xctax2) xlabel(`recnum'(12)`trenum' , format(%tm)) ///
tline(`abestt') plotregion(style(none)) legend(cols(1) ring(0) position(7) ) ytitle("Price indices") xtitle("") ///
	lwidth(medthick medthick medthick medthick medthick) clpattern(solid shortdash_dot dash shortdash_dot longdash_dot) lcolor(blue blue red red black) graphregion(color(white));
graph export cpi_defl_allbase_xctax2.pdf, replace;

tsline cpisabase cpicoresabase deflgdpbase if tin(`plotst',) , name(cpi_defl_allbase) xlabel(`recnum'(12)`trenum' , format(%tm)) ///
tline(`abestt') plotregion(style(none)) legend(cols(1) ring(0) position(7) ) ytitle("Price indices") xtitle("") ///
	lwidth(medthick medthick medthick) clpattern(solid dash dash_dot) lcolor(blue red black) graphregion(color(white));
graph export cpi_defl_allbase_new.pdf, replace;



*graph to check fact that these prices measure didn't rise as much between 2005 and 2007 when the yen depreciated by 20 percent;
tsline cpisabase cpicoresabase deflgdpbase if tin(2005m1,2007m4) , xlabel(, format(%tm)) ///
plotregion(style(none)) clcolor(blue) legend(cols(1) ring(0) position(7) ) ytitle("Price indices") xtitle("") ///
	lwidth(medthick medthick medthick medthick) clcolor(blue blue red red) clpattern(solid dash solid dash) graphregion(color(white));

*for table 1, calculate effect of consumption tax on quarterly (and annual), nsa cpi;
#delimit;
clear;

local adj_april_cpi = .019;
local adj_april_cpicore = .015;
local adj_cpi = .021;
local adj_cpicore = .017;

cd "$DataPath/CPI";
insheet using zmi2010e_jul2015.csv, names;

* fix date format;
gen date=ym(1970,1);
replace date=date+_n-1;
destring, replace;
drop v*;

tsset date;
format date %tm;

rename allitems cpi;

gen cpi_xctax = cpi;
replace cpi_xctax = L12.cpi*(cpi/ L12.cpi- `adj_april_cpi') if date==tm(2014m4);
replace cpi_xctax = L12.cpi*(cpi/ L12.cpi- `adj_cpi') if tin(2014m5,2015m3);
replace cpi_xctax = L12.cpi_xctax*(cpi/ L12.cpi- (`adj_cpi' - `adj_april_cpi')) if date==tm(2015m4);
replace cpi_xctax = L12.cpi_xctax*(cpi/ L12.cpi) if date>tm(2015m4);

gen quarter=qofd(dofm(date));

collapse cpi cpi_xctax, by(quarter);
tsset quarter;
format quarter %tq;


gen inflation_q = 100*(cpi / l4.cpi -1);
gen inflation_xctaxq = 100*(cpi_xctax / l4.cpi_xctax -1);

list quarter inflation_q inflation_xctax;

gen year = yofd(dofq(quarter));

collapse cpi cpi_xctax, by(year);
tsset year;

gen inflation_xctax = 100*(cpi_xctax / l.cpi_xctax -1);

list inflation_xctax if year==2014;
