
#delimit;
clear all;
set more off;
version 13;

/* Note: change Stata directory to the ../Stata/Code directory to run the code */
/*qui: cd "DIRECTORY IN HERE/Stata/Code"; */

* setting paths;
qui: do paths;

* variables to be used;
local cefevars gdp cpi cons ip;

* location of variables in excel file;
local sheetlist "GDP" "CPI" "Consumption" "Industrial Production";


********************************************************************************
*
* Consensus forecasts for Japan: annual forecasts
*
********************************************************************************;

local zz = 1;

foreach var in `cefevars' {;
	
	local sheetname: word `zz' of "`sheetlist'";
	display "`sheetname'";

	qui: cd "$DataPath/Consensus";
	import excel using "JAPAN Extended.xls", sheet("Annual `sheetname'") firstrow case(lower);
	*drop if _n==1;
	destring, replace;
	
	
	
	tostring fyear fmonth, generate(fyear_string fmonth_string);
	gen surveydate = fyear_string + "m" + fmonth_string;
    
	drop fyear fyear_string fmonth fmonth_string;
	
	
	foreach vary of varlist y* {;

		local yearst = substr("`vary'",2,4);
		disp "`yearst'";
		rename `vary' `var'`yearst';
			};
	
	
	reshape long `var', i(surveydate) j(date) string;
	
	* new date variable;
	destring date, replace;
	
	* new survey variable;
	gen survey = monthly(surveydate,"YM");
	format survey %tm;
	drop surveydate;
	
	save "$StDataPath/jpcea`var'", replace;
	clear all;
	
	local zz = `zz' + 1;
};

qui: cd "$CodePath";

* merging data;
use "$StDataPath/jpceagdp";
merge m:1 survey date using "$StDataPath/jpceacons", gen(_mergececons);
merge m:1 survey date using "$StDataPath/jpceacpi", gen(_mergececpi);
merge m:1 survey date using "$StDataPath/jpceaip", gen(_mergeceip);

order survey date, before(gdp);


* forecast horizon (years) Note the horizon is made the same for the April
*and October forecasts.;
gen horizon = date - yofd(dofm(survey)) - (month(dofm(survey))-10)/12;
gen thorizon= -horizon;
gen mth = month(dofm(survey));

replace thorizon = thorizon*2;

/*Trick to allow panel data setting - set date to be 100 years
in the future for October surveys. */
*replace date = date+100 if mth==10;
sort date survey;
xtset date thorizon;


save "$StDataPath/jpceannual_pooled", replace;

