#delimit;
clear all;
set more off;
version 13;

local abestt = "2012m11";
local abenum = tm(`abestt');

********************************************************************************
*
* The purpose of this file is to replicate Krugman's calculation of pi_e
* (http://krugman.blogs.nytimes.com/2013/10/27/ppp-and-japanese-inflation-expectations-extremely-wonkish/?_php=true&_type=blogs&_r=0)
********************************************************************************;

/* Note: change Stata directory to the ../Stata/Code directory to run the code */
/*qui: cd "DIRECTORY IN HERE/Stata/Code"; */

* setting paths;
qui: do paths;

* japan's nominal interest rate data come from bloomberg (see japan_fin_update);
clear all;
use "$StDataPath/bloombergbond";

*need to make monthly;
gen date = mofd(daten);
collapse bond10, by(date);
format date %tm;
save "$StDataPath/bond10_monthly", replace;

*All data come from FRED except the Japanese CPI and nominal interest rate.;
clear;
freduse FII10 GS10 EXJPUS CPIAUCSL;
*make date monthly;
drop date;
gen date = mofd(daten);
drop daten;

*merge with nominal interest rate data;
merge 1:1 date using "$StDataPath/bond10_monthly", gen(_mergebond);

*merge with Japanese CPI data. See japan_cpi_update for the construction of these data;
merge 1:1 date using "$StDataPath/jpcpi", gen(_mergecpi);
format date %tm;
tsset date;
********************************************************************************
*
* Krugman's calculation of pi_e
*
********************************************************************************;

* real exchange rate;
*compute it here as EP*/P. Use seasonally adjusted monthly CPI for U.S. and Japan. ;
gen rlxr = (EXJPUS * CPIAUCSL) / cpisa;

* Krugman assumes PPP held in Jan. 2010. ;
local ppp_date = "2010m1";
local mindat = date[1]; 
local ppp_obs = tm(`ppp_date') - `mindat' +1;
disp `ppp_obs';

gen deltaqr = (rlxr[`ppp_obs']/rlxr-1)*100/10; // divide by 10 to normalize inflation expectations below;

* tips inflation expect;
gen break10US = GS10-FII10;

* inflation expectations from UIP;
gen realpi_e = -(GS10-bond10)+ break10US -deltaqr;

*graph to compare the one Krugman posted (see japan_fin_update for the graph used in the paper);
tsline realpi_e if tin(2010m1,2013m9),  name(krugplot2) ytitle("10-Year Inflation Expectations") xtitle("") ///
tline(`abestt') plotregion(style(none)) ///
legend(label(1 "UIP + PPP Series") cols(1) ring(0) position(7)) ///
lwidth(medium medium medium) lcolor(blue red green) ///
ms(p p p) mcolor(blue red green) recast(connected) ///
clcolor(blue) graphregion(color(white)) ;
*graph export "StGrphPath/kruge.pdf", replace;

*for easing merging, create daily date variable daten;
gen daten = dofm(date);
format daten %td;
drop date rlxr;
saveold "$StDataPath/krugman_pi_e", replace;
