*This graphs earnings and hours in Japan;

#delimit;
clear all;
set more off;
version 13;

/* Note: change Stata directory to the ../Stata/Code directory to run the code */
/*qui: cd "DIRECTORY IN HERE/Stata/Code"; */

* setting paths;
qui: do paths;

*locals;
local vars nom_wages real_wages hours;
local plotst = "2007m1";
local abestt = "2012m11";
local rececb = "2007m1";
local trendb = "2001m1";
local abestt = "2012m11";
local abeend = "2015m6";


*import nominal wage (total cash earnings);
import excel using "$DataPath/Wages/cash_earnings_time_series_sa_k7.xls", sheet(TL) cellrange(A9:Q35) first clear;
save "$StDataPath/nom_wages_sa", replace;

*import real wage (total cash earnings divided by the CPI excluding imputed rent);
clear;
import excel using "$DataPath/Wages/cash_earnings_time_series_sa_real_k11.xls", sheet(TL) cellrange(A9:Q35) first;
save "$StDataPath/real_wages_sa", replace;

*import hours;
clear;
import excel using "$DataPath/Wages/hours worked_time_series_sa_k13.xls", sheet(TL) cellrange(A9:Q35) first;
save "$StDataPath/hours_sa", replace;



foreach var in `vars' {;
	
	disp "`var'";
	use "$StDataPath/`var'_sa", clear;

	*for reshaping;
	rename A year;
	rename Jan `var'1;
	rename Feb `var'2;
	rename Mar `var'3;
	rename Apr `var'4;
	rename May `var'5;
	rename Jun `var'6;
	rename Jul `var'7;
	rename Aug `var'8;
	rename Sep `var'9;
	rename Oct `var'10;
	rename Nov `var'11;
	rename Dec `var'12;

	reshape long `var', i(year) j(month);

	gen date = ym(year, month);
	tsset date;
	format date %tm;

	keep date `var' year month;

	*index;
	*for indexing to 100 in 2007m1;
	local mindat = date[1];
	local recobs = tm(`rececb')-`mindat'+1;

	qui: gen `var'base = `var'/`var'[`recobs']*100;
	
	save "$StDataPath/`var'_sa_long", replace;
};

*merge;
merge 1:1 date using "$StDataPath/nom_wages_sa_long", nogenerate;
merge 1:1 date using "$StDataPath/real_wages_sa_long", nogenerate;

save "$StDataPath/wages_hours_sa", replace;


*a couple checks;
assert nom_wages==113.4 if date==tm(1997m4);
assert nom_wages==97 if date==tm(2015m6);

assert real_wages==109.1 if date==tm(1997m4);
assert real_wages==92.6 if date==tm(2015m6);

assert hours==107.5 if date==tm(1997m4);
assert hours==98.9 if date==tm(2015m6);


/* wages */
gen nom_wage_hourbase = 100*nom_wagesbase / hoursbase;
gen real_wage_hourbase = 100*real_wagesbase / hoursbase;



local recnum = tm(`plotst');
local abenum = tm(`abestt');
local recobs = tm(`rececb')-`mindat'+1;
local abesttobs = `abenum' - `mindat' +1; 
display "`recobs'";
local trenum = tm(`abeend');
local treobs = tm(`trendb')-`mindat'+1;

cd "$StGrphPath";

tsline nom_wagesbase real_wagesbase if tin(2007m1,), name(wages_present) xlabel(`recnum'(12)`trenum' , format(%tm)) ///
legend(label(1 "Nominal earnings per employee") label(2 "Real earnings per employee") cols(1) ring(0) position(7)) ///
	ytitle("Earnings (SA, 1/2007=100)") xtitle("") tline(`abestt') plotregion(style(none)) ///
	lwidth(medthick medthick medthick) clpattern(solid dash dash_dot) ///
    clcolor(blue red black) graphregion(color(white));
   
graph export wages_paper.pdf, replace;

tsline hoursbase if tin(2007m1,), name(hours_present) xlabel(`recnum'(12)`trenum' , format(%tm)) ///
legend(on label(1 "Hours per employee") cols(1) ring(0) position(7)) ///
	ytitle("Hours (SA, 1/2007=100)") xtitle("") tline(`abestt') plotregion(style(none)) ///
	lwidth(medthick medthick medthick) clpattern(solid dash dash_dot) ///
    clcolor(blue red black) graphregion(color(white));
   
graph export hours_paper.pdf, replace;


/* confirming wage calculations in text */
preserve;
gen dateq = qofd(dofm(date));
collapse (mean) nom_wages real_wages hours , by(dateq);
egen real_wages_hours_base = max(real_wages/hours*(dateq==yq(2012,2)));
egen real_wages_base = max(real_wages*(dateq==yq(2012,2)));
gen real_wages_hours_relative_base = (real_wages/hours/real_wages_hours_base-1)*100;
gen real_wages_relative_base = (real_wages/real_wages_base-1)*100;
su real_wages*_relative_base if dateq==yq(2015,2);
restore;
	
