* This file insheets national account excel files and saves them as stata format.

#delimit;
clear all;
set more off;
version 13;

/* Note: change Stata directory to the ../Stata/Code directory to run the code */
/*qui: cd "DIRECTORY IN HERE/Stata/Code"; */

* setting paths;
qui: do paths;

* loval vars;
local jp2008 = yq(2008,1);
local jpbase = yq(2012,4);

********************************************************************************
*
* Compiling Japan national accounts data
*
********************************************************************************;

* insheeting japan GDP data: additional variables contained in kgaku file;
cd "$DataPath/NA";
insheet using kgaku-jk1521.csv, names;

* fix date format;
gen date=yq(1993,4);
replace date=date+_n;
destring, replace;
drop v*;

* renaming variables;
local oldnames consumptionofhouseholdsidat_h directpurchasesabroadbyresidenth lessdirectpurchasesinthedomestic domesticfinalconsumptionexpendit durablegoods semidurablegoods services netexportsidat_h exportsidat_h goods servicesiincludingdirectpurchase importsidat_h;
local newnames conshouse dirabr dirhom domcons cdur csdur cserv exp netexp exports goods services imports;

* use only these variables from this additional sheet;
local varkeep cdur csdur cserv;

qui: local varcount: word count `oldnames';

forvalues kk=1(1)`varcount' {;

	qui: local currname: word `kk' of `oldnames';
	qui: local nextname: word `kk' of `newnames';
	rename `currname' `nextname';
	
	
};
keep date `varkeep';
destring, replace;

* saving japan NA data;
save "$StDataPath/jpna2", replace;
clear all;


********************************************************************************;


* insheeting japan deflator data;
cd "$DataPath/NA";
insheet using def-qk1521.csv, names;

* fix date format;
gen date=yq(1993,4);
replace date=date+_n;
destring, replace;
drop v*;


* renaming variables;
local oldnames gdpexpenditureapproach privateconsumption privateresidentialinvestment privatenonresiinvestment changeinprivateinventories governmentconsumption publicinvestment changeinpublicinventories exports imports;
local newnames deflgdp deflcons deflinvres deflinvnonres defldinvent deflcgovt deflinvgovt defldinventgov deflexp deflimp;
local varkeep `newnames';


qui: local varcount: word count `oldnames';

forvalues kk=1(1)`varcount' {;

	qui: local currname: word `kk' of `oldnames';
	qui: local nextname: word `kk' of `newnames';
	rename `currname' `nextname';
	
	
};
keep date `varkeep';
destring, replace;

* saving japan NA deflator data;
save "$StDataPath/jpnadefl", replace;
clear all;

********************************************************************************;

* nominal GDP data;
insheet using gaku-mk1521.csv, names;

* fix date format;
gen date=yq(1993,4);
replace date=date+_n;
destring, replace;
*tsset date, quarterly;
*drop v*;

* renaming variables;
local oldnames gdpexpenditureapproach privateconsumption privateresidentialinvestment privatenonresiinvestment changeinprivateinventories governmentconsumption publicinvestment changeinpublicinventories exports imports;
local newnames nomgdp nomcons nominvres nominvnonres nomdinvent nomcgovt nominvgovt nomdinventgov nomexp nomimp;
local varkeep `newnames' nomgovt;
qui: local varcount: word count `oldnames';

forvalues kk=1(1)`varcount' {;

	qui: local currname: word `kk' of `oldnames';
	qui: local nextname: word `kk' of `newnames';
	rename `currname' `nextname';
	
	
};


* aggregating to conform to US accounts;
gen nomgovt = nomcgovt + nominvgovt + nomdinventgov;

keep date `varkeep';

* saving japan NA data;
save "$StDataPath/jpnanom", replace;
clear all;


********************************************************************************;

* second set of GDP data;
*insheet using gaku-jk1421.csv, names;
insheet using gaku-jk1521.csv, names;

* fix date format;
gen date=yq(1993,4);
format date %tq;
replace date=date+_n;
destring, replace;


* renaming variables;
local oldnames gdpexpenditureapproach privateconsumption privateresidentialinvestment privatenonresiinvestment changeinprivateinventories governmentconsumption publicinvestment changeinpublicinventories exports imports;
local newnames gdp cons invres invnonres dinvent cgovt invgovt dinventgov exp imp;
qui: local varcount: word count `oldnames';

forvalues kk=1(1)`varcount' {;
	qui: local currname: word `kk' of `oldnames';
	qui: local nextname: word `kk' of `newnames';
	disp "`currname'";
	rename `currname' `nextname';
	
	
};


* aggregating to conform to US accounts;
gen govt = cgovt + invgovt + dinventgov;

* saving japan NA data;
drop v1;

save "$StDataPath/jpna", replace;

