#delimit;
clear all;
set more off;
version 13;

/* Note: change Stata directory to the ../Stata/Code directory to run the code */
/*qui: cd "DIRECTORY IN HERE/Stata/Code"; */

* setting paths;
qui: do paths;


********************************************************************************
*
* Organizing short and long-term forecasts
*
********************************************************************************;

* long-term forecasts;
qui: do japan_annual_forecast;
clear all;
use "$StDataPath/jpceacpi";
gen datem = ym(date,6);
drop date;
rename datem date;
format date %tm;
gen horizon = round((date-survey)/12);
gen cpiy = 1 if horizon==0;
sort survey  date ;
*drop if cpiy==1 & cpiy[_n+1]==1;
xtset survey horizon;
forvalues jj=1(1)10 {;
	replace cpiy = L.cpiy * (1+cpi/100) if L.cpiy<.;
};
replace cpiy = (cpiy^(1/horizon)-1)*100;
keep if horizon == 10;
drop date cpi;
save "$StDataPath/jpceacpi_ts", replace;
clear all;

* short-term forecasts;
qui: do japan_quarterly_forecast;
clear all;
use "$StDataPath/jpceqcpi";
gen dateq = qofd(dofm(date));
gen surveyq = qofd(dofm(survey));
gen horizon = dateq-surveyq;
gen cpiq = cpi;
sort survey  date ;
keep if horizon == 4;
drop date cpi surveyq dateq;
save "$StDataPath/jpceqcpi_ts", replace;
clear all;


********************************************************************************
*
* Importing short-run forecasts from BoJ opinion survey
*
********************************************************************************;

qui: cd "$DataPath/BoJ Opinion";
import excel using "boj opinion update.xlsx", firstrow case(lower);
keep mean median survey_date;
gen year = substr(survey_date,1,4);
gen month = substr(survey_date,6,2);
destring, replace;
gen survey = ym(year, month);
drop year month survey_date;
save "$StDataPath/jpbojcpi_ts", replace;
clear all;

********************************************************************************
*
* Importing short-run forecasts from BoJ Tankan survey
*
********************************************************************************;

qui: cd "$DataPath/Tankan";
import excel using "tankan_inflation.xlsx", firstrow case(lower);
keep mean_1yr_all survey_date;
gen year = substr(survey_date,1,4);
gen month = substr(survey_date,6,2);
destring, replace;
gen survey = ym(year, month);
drop if survey==.;
drop year month survey_date;
rename mean_1yr_all tankan_1yr_mean;
save "$StDataPath/tankan_1pi", replace;



********************************************************************************
*
* Merging and plotting
*
********************************************************************************;
merge 1:1 survey using "$StDataPath/jpbojcpi_ts", gen(_merge1);
merge m:1 survey using "$StDataPath/jpceqcpi_ts", gen(_merge2);
merge m:1 survey using "$StDataPath/jpceacpi_ts", gen(_merge3);
drop _merge*;

tsset survey, monthly;

cd "$StGrphPath";


tsline cpiq cpiy mean tankan_1yr_mean if tin(2006m1,), name(survey_infe) ///
legend(label(1 "Consensus Economics: 1 year-ahead CPI forecast") label(2 "Consensus Economics: 10 year-ahead CPI forecast") label(3 "BoJ Opinion Survey: 1 year-ahead CPI forecast") ///
 label(4 "Tankan Survey: 1 year-ahead CPI forecast") cols(1) ring(0) position(1)) ///
	ytitle("Expected inflation (%)") xtitle("Survey date") tline(2012m11) plotregion(style(none)) ylabel(0(2)10) ///
    lwidth(medthick medthick medthick medthick) clpattern(solid dash dash_dot shortdash dot) lcolor(blue red black black) ///
     graphregion(color(white)) tlabel(2007m1 2009m1 2011m1 2013m1 2015m1, format(%tm)) ;
    graph export survey_infe.pdf, replace;	

*restore;
