#delimit;
clear all;
set more off;
version 13;

/* Note: change Stata directory to the ../Stata/Code directory to run the code */
/*qui: cd "DIRECTORY IN HERE/Stata/Code"; */

* setting paths;
qui: do paths;

* local vars;
local rececb = "2008q1";
local trendb = "2001q1";
local abestt = "2012q4";
local abeend = "2015q2";
local varnames gdp cons invres invnonres dinvent cgovt invgovt dinventgov govt exp imp cdur csdur cserv deflgdp; // invtransp invmachequ invcomp gcf;
local varnames gdp cons invres invnonres dinvent cgovt invgovt dinventgov govt exp imp cdur csdur cserv deflgdp; // invtransp invmachequ invcomp gcf;
local pltnames GDP Consumption "Residential Investment" "Non-residential Investment" "Change in Inventories" ///
"Govt Consumption" "Govt Investment" "Change in Govt Inventories" Government Exports Imports ///
"Consumer Durables" "Consumer Semi-Durables" "Consumer Services"  "GDP deflator"; 
//"NR-Investment: Transportation Equ." "NR-Investment: Other Machines" "NR-Investment: Computer Software" "Gross Capital Formation";
local cefevars gdp cons invnonres ip cpi;

********************************************************************************
*
* Working age population
*
********************************************************************************;


freduse LFWA64TTJPQ647S;


rename LFWA64TTJPQ647S working_pop;
drop date;
gen date = qofd(daten);


tsset date, quarterly;
sort date;

keep date working_pop;
save  "$StDataPath/jpworkpop", replace;



clear all;


********************************************************************************
*
* Japan since 2008: national accounts  
*
********************************************************************************;

* insheeting japan GDP data;
cd "$CodePath";

do jp_na_setup_update.do;
clear all;
use "$StDataPath/jpna";
merge m:1 date using "$StDataPath/jpna2", gen(_mergena);
merge m:1 date using "$StDataPath/jpnanom", gen(_mergenanom);
merge m:1 date using "$StDataPath/jpnadefl", gen(_mergedefl);
merge m:1 date using "$StDataPath/jpworkpop", gen(_mergepop);


* creating new variables;
gen inv = invres+invnonres+dinvent;
local varnames `varnames' inv;
local pltnames `pltnames' Investment;

gen nx = exp-imp;
local varnames `varnames' nx;
local pltnames `pltnames' "Net Exports";

* tsseting;
sort date;
tsset date, quarterly;

* impute 2015:Q1 and 2015:Q2 working population;
replace working_pop = L.working_pop*(L.working_pop/L5.working_pop)^(1/4) if date==yq(2015,1);
replace working_pop = L.working_pop*(L2.working_pop/L6.working_pop)^(1/4) if date==yq(2015,2);

* distance to base;
local mindat = date[1];
local recnum = tq(`rececb');
local abenum = tq(`abestt');
local recobs = tq(`rececb')-`mindat'+1;
display "`recobs'";
local trenum = tq(`abeend');
local treobs = tq(`trendb')-`mindat'+1;
display "`treobs'";




cd "$StGrphPath";
* generating graphs;
local zz = 1;
foreach var of varlist `varnames' {;

	qui: local plotvar: word `zz' of `pltnames';
	display "`plotvar'";

	qui: gen `var'base = `var'/`var'[`recobs']*100;
	qui: gen `var'wpbase = `var'/`var'[`recobs']/(working_pop/working_pop[`recobs'])*100;
	qui: gen `var'trend = `var'base[`recobs']*(100/`var'base[`treobs'])^((date-tq(`rececb'))/(`recobs'-`treobs')) if tin(`rececb',);
	
	qui: gen `var'growth = ((`var'/L.`var')^4-1)*100;
	qui: gen `var'trgrowth = ((`var'trend/L.`var'trend)^4-1)*100;
	qui: replace `var'trgrowth = F.`var'trgrowth if date==yq(2008,1);
	
	local zz = `zz'+1;
};



********************************************************************************
*
* Contributions to growth: annual  
*
********************************************************************************;



* we need nominal variables to calculate contributions as in the national accounts;
gen nominv = nominvres+nominvnonres+nomdinvent;
gen nomnx  = nomexp-nomimp;

* variables to be plotted;
local varlplot gdp cons inv govt exp imp nx invres invnonres dinvent;
keep date working_pop `varlplot' nom*;

* Q4 variables;
foreach var of varlist `varlplot' nom* working_pop {;
	qui gen Q4`var' = `var';
};

* aggregate to annual;
gen datey = yofd(dofq(date));
gen counter = 1/4;
egen countery = sum(counter), by(datey);

/* taking mean and using last Q for Q4 variables */
collapse (mean) working_pop `varlplot' nom* countery (last) Q4*, by(datey);

* annual tsseting;
rename datey date;
tsset date, yearly;

foreach set in `""' `"Q4"' {;
	gen `set'dlwork = S.`set'working_pop/L.`set'working_pop;
	replace `set'imp = -`set'imp;
	replace `set'nomimp = -`set'nomimp;
};

* time periods to be plotted;
qui gen tvar = 1 if tin(1992,2007);
qui replace tvar = 2 if tin(2008,2012);
qui replace tvar = 3 if tin(2013,);
qui drop if tvar==.;

foreach set in `""' `"Q4"' {;
	* contributions calculated as in official data. then averaged across time;
	foreach var in `varlplot' {;
		qui gen `set'`var'wp = `set'`var'/`set'working_pop;
		qui gen `set'nom`var'wp = `set'nom`var'/`set'working_pop;
	
		qui gen growth`set'`var' 	= (S.`set'`var'/L.`set'`var')*(L.`set'nom`var'/L.`set'nomgdp)*100;
	};
	* calculation for GDP/working age pop;
	foreach var in gdp {;
	
		qui gen growth`set'`var'wp 	= (S.`set'`var'wp/L.`set'`var'wp)*(L.`set'nom`var'wp/L.`set'nomgdpwp)*100;
	};
};

/* collapsing data */
collapse (sum) growth* countery, by(tvar);

/* re-weighting data */
foreach var of varlist growth* {;
	qui replace `var' = `var'/countery;
};


* reducing data to plotted data;
keep tvar growth*;
duplicates drop;
drop if tvar==.;

reshape long growth, i(tvar) j(quant) string;

reshape wide growth, i(quant) j(tvar);



foreach set in `""' `"Q4"' {;
	preserve;
	* order in graph;
	gen order=1 if quant=="`set'gdp";
	replace order=2 if quant=="`set'cons";
	replace order=3 if quant=="`set'inv";
	replace order=4 if quant=="`set'govt";
	replace order=5 if quant=="`set'exp";
	replace order=6 if quant=="`set'imp";
	replace order=7 if quant=="`set'nx";
	replace order=1 if quant=="`set'gdpwp";
	gen wp = "Contribution to GDP growth";
	replace wp = "Per working age" if quant=="`set'gdpwp";;
	
	* names in graph;
	replace quant ="GDP" if quant=="`set'gdp";
	replace quant ="Consumption" if quant=="`set'cons";
	replace quant ="Investment" if quant=="`set'inv";
	replace quant ="Gov. purchases" if quant=="`set'govt";
	replace quant ="Exports" if quant=="`set'exp";
	replace quant ="Imports(-)" if quant=="`set'imp";
	replace quant ="Net exports" if quant=="`set'nx";
	replace quant ="GDP" if quant=="`set'gdpwp";
	
	* fraction of GDP growth explained;
	gen fraction = growth3 / growth3[4];
	list quant growth* fraction;
	
	* drop exports and imports.;
	drop if order==7;
	drop if order==.;
	
	
	/* labels and titles */
	if `"`set'"' == `""' {;
		local ytitle "Avg. year-on-year growth rate (p.p.)";
		local ytitlewp "Avg. year-on-year growth rate per working pop (p.p.)";
		local labelset `"label(1 "1995-2007") label(2 "2008-2012") label(3 "Abenomics (2013-2015)")"';
	};
	else {;
		local ytitle "Avg. annualized growth rate (p.p.)";
		local ytitlewp "Avg. annualized growth rate per working pop (p.p.)";
		local labelset `"label(1 "1995Q4-2007Q4") label(2 "2008Q4-2012Q4") label(3 "Abenomics (2013Q4-2015Q2)")"';
	};
	
	* plotting data;
	graph bar growth1 growth2 growth3, name(allgrowthy`set')  bar(1, color(eltblue) bstyle(p3bar) ) bar(2, color(edkblue) bstyle(p4bar)) bar(3, color(ebblue) bstyle(p5bar)) ///
		over(quant, sort(order) label( alternate labstyle(p1)  ) ) over(wp, gap(300)) nofill ///
		ytitle(`ytitle`adj'')  ///
		legend( `labelset'  cols(1) ring(0) position(12)) ///
		 graphregion(color(white)) yline(0, lcolor(black) )
		 ;
		 graph export allgrowth`adj'2`set'_annual_new.pdf, replace;
		 
		 restore;
		 
};		

