cd "C:\Users\chausman\Desktop\Data package to post"

//CALCULATING PRICE EQUILIBRIA, WELFARE EFFECTS
//Requires running first: data.do, which cleans and compiles the raw data

capture program drop COUNTERFACTUAL
program define COUNTERFACTUAL

//1. SUPPLY AND DEMAND EQUATIONS. Constant elasticity: Q=Ap^e
//calculating scale parameters and overall elasticity:

replace deliv_indu=deliv_indu+deliv_vehi //lump vehicles in with industrial (i.e., elastic)
gen supply=production_marketed*(1-0.14) //14% goes to pipeline use, plant fuel use, and liquids
		//alternatives:
		//gen supply=production_dry-deliv_pipe-deliv_lease
		//gen supply = production_dry*(1-0.09) 

	foreach y in 2007 2013{
		foreach v in resi comm indu elec{
			display "`v', `y'"
			quietly sum deliv_`v' if year==`y' & state_a=="US"
			local q_`v'_`y'=r(mean)/1000 //bcf each month
			display "QUANTITY, bcf each month = dollars per mcf"
			display `q_`v'_`y''
			
			quietly sum henryhub_dmcf_real if year==`y' & state_a=="US"
			local p_`v'_`y'=r(mean)+${mu_`v'}
			display "RETAIL PRICE (Henry Hub + assumed markup), million dollars per bcf = dollars per mcf"
			display `p_`v'_`y''
			//alternatively, could use obs. retail price, but that's not internally consistent with what follows
			
			local A_`v'_`y'=`q_`v'_`y'' / (`p_`v'_`y'' ^ ${e_`v'})
			display "SCALE"
			display `A_`v'_`y''
		}
		local e_overall_`y'=(`A_resi_`y''*$e_resi*(`p_resi_`y''^($e_resi)) ///
			+ `A_comm_`y''*$e_comm*(`p_comm_`y''^($e_comm)) ///
			+ `A_indu_`y''*$e_indu*(`p_indu_`y''^($e_indu)) ///
			+ `A_elec_`y''*$e_elec*(`p_elec_`y''^($e_elec)) ///
			) / (`q_resi_`y''+`q_comm_`y''+`q_indu_`y''+`q_elec_`y'')  
			//this does not get used anywhere - it's just for us to know
		display "overall elasticity at `y' quantity"
		display `e_overall_`y''
	}
	
	display "---------------------"	
	foreach v in resi comm indu elec{
		display "`v'"
		display "elasticity: ${e_`v'}"
		display "scale in 2007: `A_`v'_2007'"
		display "scale in 2013: `A_`v'_2013'"
		display "log change " ln(`A_`v'_2013')-ln(`A_`v'_2007')
	}
	display "---------------------"
	display "overall LR demand elasticity, 2007"
	display `e_overall_2007'
	display "overall LR demand elasticity, 2013"
	display `e_overall_2013'
	display "---------------------"	
	foreach y in 2007 2013{
		display "SUPPLY, `y'"
		quietly sum supply if year==`y' & state_a=="US"
		local q_`y'=r(mean)/1000 //bcf each month, 
		
		display "QUANTITY, bcf each month"
		display `q_`y''
		quietly sum henryhub_dmcf_real if year==`y' & state_a=="US"
		local p_`y'=r(mean) //million dollars per bcf
		display "REAL HENRY HUB PRICE, million dollars per bcf = dollars per mcf"
		display `p_`y''
		local B_`y'=`q_`y''/(`p_`y'' ^ $e_supply)
		display "SCALE"
		display `B_`y''
	}
	display "log change " ln(`B_2013')-ln(`B_2007')
	display "---------------------"	
	foreach y in 2007 2013{
		quietly sum imports if year==`y' & state_a=="US"
		local m_`y'=r(mean)/1000 //bcf each month
		display "imports `y' " `m_`y''
		quietly sum exports if year==`y' & state_a=="US"
		local x_`y'=r(mean)/1000 //bcf each month
		display "exports `y' " `x_`y''
		display "net imports `y' " `m_`y''-`x_`y'' //net imports each month
	}

//method 1 for imports and exports: calculate slope off the two observed points 
//(linear functions, not constant elas)
//m = a_m + slope_m * p, x = a_x + slope_x * p, x-m = a_x-a_m + (slope_x-slope_m) * p
	local slope_imports_2007=(`m_2013'-`m_2007')/(`p_2013'-`p_2007')
		local A_imports_2007=`m_2007'-`slope_imports_2007'*`p_2007'
	local slope_exports_2007=(`x_2013'-`x_2007')/(`p_2013'-`p_2007')
		local A_exports_2007=`x_2007'-`slope_exports_2007'*`p_2007'
	local slope_imports_2013=`slope_imports_2007' //by construction, equal
		local A_imports_2013=`m_2013'-`slope_imports_2013'*`p_2013'
	local slope_exports_2013=`slope_exports_2007'
		local A_exports_2013=`x_2013'-`slope_exports_2013'*`p_2013'
	local A_netex_2007=`A_exports_2007'-`A_imports_2007'
	local A_netex_2013=`A_exports_2013'-`A_imports_2013'
	local slope_netex_2007=`slope_exports_2007'-`slope_imports_2007'
	local slope_netex_2013=`slope_exports_2013'-`slope_imports_2013'
	
	disp "scale net exports 2007 = "`A_netex_2007'
	disp "scale net exports 2013 = "`A_netex_2013'
	disp "slope net exports 2007 = "`slope_netex_2007'
	disp "slope net exports 2013 = "`slope_netex_2013'	
	disp "----check: should be equal" 
/*
//method 2 for imports and exports: assume elasticities are same as domestic
//then calculate slopes and use linear functions
//for counterfactual, use 2013 equation or 2007 equation (below)
	local e_imports=$e_supply
	local e_exports=`e_overall_2007'
	foreach y in 2007 2013{
		local slope_imports_`y'=`e_imports'*`m_`y''/`p_`y''
		local A_imports_`y'=`m_`y''-`slope_imports_`y''*`p_`y''
		local slope_exports_`y'=`e_exports'*`x_`y''/`p_`y''
		local A_exports_`y'=`x_`y''-`slope_exports_`y''*`p_`y''
		local A_netex_`y'=`A_exports_`y''-`A_imports_`y''
		local slope_netex_`y'=`slope_exports_`y''-`slope_imports_`y''
		
		disp "scale net exports `y' = "`A_netex_`y''
		disp "slope net exports `y' = "`slope_netex_`y''	
	}	
*/
//calculating equilibrium in each year, with imports and exports, lease + pipeline, dry vs marketed
//observed:
	// GRID SEARCH:
	foreach y in 2007 2013{
		forval p = 0(0.001)10{
			local equi=`A_resi_`y''*(`p'+$mu_resi)^$e_resi+`A_comm_`y''*(`p'+$mu_comm)^$e_comm ///
			+`A_indu_`y''*(`p'+$mu_indu)^$e_indu+`A_elec_`y''*(`p'+$mu_elec)^$e_elec ///
			-`B_`y''*`p'^$e_supply  ///
			+(`A_netex_`y''+`slope_netex_`y''*`p') 
			if abs(`equi')<0.75 {
				local p_equi_`y'=`p'
				display "EQUILIBRIUM HENRY HUB PRICE, `y', million $ per bcf = $ per mcf"
				display `p_equi_`y''
			}
		}
	}
//counterfactual, including assumptions on imports and exports 
//(whatever year we use for demand):
	local countery = 2013 //demand, imports, exports
	local counterz = 2007 //supply
	forval p = 0(0.001)10{
		local equi=`A_resi_`countery''*(`p'+$mu_resi)^$e_resi ///
		+`A_comm_`countery''*(`p'+$mu_comm)^$e_comm ///
		+`A_indu_`countery''*(`p'+$mu_indu)^$e_indu ///
		+`A_elec_`countery''*(`p'+$mu_elec)^$e_elec ///
		-`B_`counterz''*`p'^$e_supply ///
		+(`A_netex_`countery''+`slope_netex_`countery''*`p') 
		if abs(`equi')<0.75 {
			local p_counter_`countery'_`counterz'=`p'
			display "COUNTERFACTUAL HENRY HUB PRICE,"
			display "demand from `countery', supply from `counterz', million $ per bcf = $ per mcf"
			display `p_counter_`countery'_`counterz''
		}
	}
	display "---------------------"	

	
//counterfactual, including approved lng exports, including assumptions on other imports and exports
//use 2013 supply and demand
	forval p = 0(0.001)10{
		local equi=`A_resi_`countery''*(`p'+$mu_resi)^$e_resi ///
		+`A_comm_`countery''*(`p'+$mu_comm)^$e_comm ///
		+`A_indu_`countery''*(`p'+$mu_indu)^$e_indu ///
		+`A_elec_`countery''*(`p'+$mu_elec)^$e_elec ///
		-`B_`countery''*`p'^$e_supply ///
		+(`A_netex_`countery''+`slope_netex_`countery''*`p') ///
		+ $qLNGa*365/12
		if abs(`equi')<0.75 {
			local p_LNGa=`p'
			display "COUNTERFACTUAL HENRY HUB PRICE WITH APPROVED LNG,"
			display "demand from `countery', supply from `countery', million $ per bcf = $ per mcf"
			display `p_LNGa'
		}
	}
	display "---------------------"	


//counterfactual, including approved + proposed lng exports, including assumptions on other imports and exports
//use 2013 supply and demand
	forval p = 0(0.001)10{
		local equi=`A_resi_`countery''*(`p'+$mu_resi)^$e_resi ///
		+`A_comm_`countery''*(`p'+$mu_comm)^$e_comm ///
		+`A_indu_`countery''*(`p'+$mu_indu)^$e_indu ///
		+`A_elec_`countery''*(`p'+$mu_elec)^$e_elec ///
		-`B_`countery''*`p'^$e_supply ///
		+(`A_netex_`countery''+`slope_netex_`countery''*`p') ///
		+ $qLNGap*365/12
		if abs(`equi')<0.75 {
			local p_LNGap=`p'
			display "COUNTERFACTUAL HENRY HUB PRICE WITH APPROVED + PROPOSED LNG,"
			display "demand from `countery', supply from `countery', million $ per bcf = $ per mcf"
			display `p_LNGap'
		}
	}
	display "---------------------"		
	
//welfare calculations	
local p0=`p_counter_`countery'_`counterz''
display "p0"
display `p0'
local p1=`p_equi_`countery''
display "p1"
display `p1'
display "---------------------"	

//quantities in counterfactual
display "q demanded in counterfactual = " `A_resi_`countery''*(`p0'+$mu_resi)^$e_resi ///
		+`A_comm_`countery''*(`p0'+$mu_comm)^$e_comm ///
		+`A_indu_`countery''*(`p0'+$mu_indu)^$e_indu ///
		+`A_elec_`countery''*(`p0'+$mu_elec)^$e_elec
display "annual change in 2013 = " ///
		12* (`A_resi_`countery''*(`p1'+$mu_resi)^$e_resi ///
		+`A_comm_`countery''*(`p1'+$mu_comm)^$e_comm ///
		+`A_indu_`countery''*(`p1'+$mu_indu)^$e_indu ///
		+`A_elec_`countery''*(`p1'+$mu_elec)^$e_elec ) ///
		- 12*(`A_resi_`countery''*(`p0'+$mu_resi)^$e_resi ///
		+`A_comm_`countery''*(`p0'+$mu_comm)^$e_comm ///
		+`A_indu_`countery''*(`p0'+$mu_indu)^$e_indu ///
		+`A_elec_`countery''*(`p0'+$mu_elec)^$e_elec )
	
display "q demanded in counterfactual = non-elec " `A_resi_`countery''*(`p0'+$mu_resi)^$e_resi ///
		+`A_comm_`countery''*(`p0'+$mu_comm)^$e_comm ///
		+`A_indu_`countery''*(`p0'+$mu_indu)^$e_indu 
display "annual change in 2013 = " ///
		12*(`A_resi_`countery''*(`p1'+$mu_resi)^$e_resi ///
		+`A_comm_`countery''*(`p1'+$mu_comm)^$e_comm ///
		+`A_indu_`countery''*(`p1'+$mu_indu)^$e_indu ) ///
		-	12*(`A_resi_`countery''*(`p0'+$mu_resi)^$e_resi ///
		+`A_comm_`countery''*(`p0'+$mu_comm)^$e_comm ///
		+`A_indu_`countery''*(`p0'+$mu_indu)^$e_indu ) 	

display "q demanded in counterfactual, elec = " ///
		+`A_elec_`countery''*(`p0'+$mu_elec)^$e_elec	
display "annual change in 2013 = " ///
		+12*`A_elec_`countery''*(`p1'+$mu_elec)^$e_elec	///
		-12*`A_elec_`countery''*(`p0'+$mu_elec)^$e_elec	

display "q supplied in counterfactual = " `B_`counterz'' *`p0'^$e_supply
display "annual change in 2013 = " 12*(`B_2013' *`p1'^$e_supply)-12*(`B_`counterz'' *`p0'^$e_supply)

display "q net imports in counterfactual = " -(`A_netex_`countery''+`slope_netex_`countery''*`p0') 
display "---------------------"

//quantities in LNG counterfactual
foreach v in resi comm indu elec{
	local q_LNGa_`v' = `A_`v'_`countery''*(`p_LNGa'+${mu_`v'})^${e_`v'}
	local q_LNGap_`v' = `A_`v'_`countery''*(`p_LNGap'+${mu_`v'})^${e_`v'}
}
display "q demanded with approved LNG = " `q_LNGa_resi' + `q_LNGa_comm' + `q_LNGa_indu' + `q_LNGa_elec'
display "q demanded with approved + proposed LNG = " `q_LNGap_resi' + `q_LNGap_comm' + `q_LNGap_indu' + `q_LNGap_elec'
local q_LNGa = `B_`countery'' *`p_LNGa'^$e_supply
local q_LNGap = `B_`countery'' *`p_LNGap'^$e_supply
display "q supplied with approved LNG = " `q_LNGa'
display "q supplied with approved + proposed LNG = " `q_LNGap'
display "q non-LNG net imports with approved LNG = " -(`A_netex_`countery''+`slope_netex_`countery''*`p_LNGa') 
display "q non-LNG net imports with approved + proposed LNG = " -(`A_netex_`countery''+`slope_netex_`countery''*`p_LNGap') 
display "q LNG exports with approved LNG = " $qLNGa*365/12
display "q LNG exports with approved + proposed LNG = " $qLNGap*365/12

//CS compare to approximation: q * delta_p
//note: smallest should be using qcounter; and largest should be using q2013
//ranking of actual CS versus using q2007 is indeterminate
display "change in CS, approximation, using q * delta p (monthly, million $)"
foreach v in resi comm indu elec{
display "`v'"
foreach y in 2007 2013{
display "change in CS, approximation, using q from `y'"
	local approx_`v'_`y' = `q_`v'_`y'' * (`p0'-`p1') //mark-ups cancel
	display "`v'  = "`approx_`v'_`y''
}
	local approx_`v'_counter = (`A_`v'_`countery''*(`p0'+${mu_`v'})^${e_`v'}) * (`p0'-`p1') 
		//mark-ups in last term cancel
	display "counterfactual q -- should match total above"
	display "`v' = "(`A_`v'_`countery''*(`p0'+${mu_`v'})^${e_`v'})
	display "change in CS, approximation, using q from counterfactual"
	display "`v' = "`approx_`v'_counter'
}
foreach y in 2007 2013 counter{
	display "total CS approximation, using q from `y' = " `approx_resi_`y''+`approx_comm_`y'' ///
	+`approx_indu_`y''+`approx_elec_`y''
}

display "---------------------"	
	
//CS version 1: demand function Q=A1*p^e1 + A2*p^e2 etc;
display "change in CS, using demand function (monthly, million $)" 
foreach v in resi comm indu elec{
	local cs`v' = `A_`v'_2013'/(${e_`v'}+1) * (`p0'+${mu_`v'})^(${e_`v'}+1) ///
				- `A_`v'_2013'/(${e_`v'}+1) * (`p1'+${mu_`v'})^(${e_`v'}+1)
	display "change in `v' CS = " `cs`v''
}
display `csresi'+`cscomm'+`csindu'+`cselec'
display "---------------------"	


//CS version 1 for LNG (LNGa counterfactual minus 2013 eqbm)
display "change in CS for approved LNG, using demand function (monthly, million $)" 
foreach v in resi comm indu elec{
	local csLNGa`v' = `A_`v'_2013'/(${e_`v'}+1) * (`p1'+${mu_`v'})^(${e_`v'}+1) ///
				- `A_`v'_2013'/(${e_`v'}+1) * (`p_LNGa'+${mu_`v'})^(${e_`v'}+1)
	display "change in `v' CS = " `csLNGa`v''
}
display `csLNGaresi'+`csLNGacomm'+`csLNGaindu'+`csLNGaelec'
display "change in CS for approved + proposed LNG, using demand function (monthly, million $)" 
foreach v in resi comm indu elec{
	local csLNGap`v' = `A_`v'_2013'/(${e_`v'}+1) * (`p1'+${mu_`v'})^(${e_`v'}+1) ///
				- `A_`v'_2013'/(${e_`v'}+1) * (`p_LNGap'+${mu_`v'})^(${e_`v'}+1)
	display "change in `v' CS = " `csLNGap`v''
}
display `csLNGapresi'+`csLNGapcomm'+`csLNGapindu'+`csLNGapelec'
display "---------------------"	


//CS version 2: inverse demand function by sector 
display "change in CS, using inverse demand function by sector (monthly, million $)"
foreach v in resi comm indu elec{
	local qalt0`v'=(`A_`v'_2013'*(`p0'+${mu_`v'})^${e_`v'}) 
	display `qalt0`v''
	local qalt1`v'=(`A_`v'_2013'*(`p1'+${mu_`v'})^${e_`v'}) 
	display `qalt1`v''
	local eta_`v'=${e_`v'}/(${e_`v'}+1)
	local csalt`v'=0 ///
		+ (1/`A_`v'_2013')^(1/${e_`v'})*`eta_`v''*`qalt1`v''^(1/`eta_`v'') ///
		- (1/`A_`v'_2013')^(1/${e_`v'})*`eta_`v''*`qalt0`v''^(1/`eta_`v'') ///
		+ (`p0'+${mu_`v'}) * `qalt0`v'' ///
		- (`qalt1`v'')*(`p1'+${mu_`v'})
	display "change in `v' CS, alt calc = " `csalt`v''
}

//PS. NOTE SHOULD BE sensitive to assumptions about possible change in elasticity.
//q_supply under counterfactual price:
display "---------------------"	
display "change in PS, not allowing for decay in production"
local q_0=`B_2007'*`p0'^$e_supply
display "quantity, counterfactual (bcf each month) (should match above) = " `q_0'
local ps_0 = `B_2007' / ($e_supply+1) * ///
			`p0'^($e_supply+1)
display "PS, counterfactual (monthly, million $) = " `ps_0'
display "check = " `p0'*`q_0' - (1/`B_2007')^(1/$e_supply) * $e_supply/($e_supply+1) * ///
			`q_0'^(($e_supply+1)/$e_supply)

local q_1=`B_2013'*`p1'^$e_supply //should match observed
display "quantity, 2013 (bcf each month) = " `q_1'
local ps_1 = `B_2013'/ ($e_supply+1) * ///
			`p1'^($e_supply+1)
display "PS, 2013 (monthly, million $) = " `ps_1'
display "check = " `p1'*`q_1' - (1/`B_2013')^(1/$e_supply) * $e_supply/($e_supply+1) * ///
			`q_1'^(($e_supply+1)/$e_supply)
			
display "change in quantity, from counterfactual = " `q_1'-`q_0'
display "change in PS, from counterfactual = " `ps_1'-`ps_0'
display "---------------------"	


//CHANGE IN PS FROM LNG
display "---------------------"	
local ps_lnga = `B_2013'/($e_supply+1) * (`p_LNGa')^($e_supply+1) ///
				- `B_2013'/($e_supply+1) * (`p1')^($e_supply+1)
local ps_lngap = `B_2013'/($e_supply+1) * (`p_LNGap')^($e_supply+1) ///
				- `B_2013'/($e_supply+1) * (`p1')^($e_supply+1)
display "change in PS for approved LNG = " `ps_lnga'	
display "change in PS for approved + proposed LNG = " `ps_lngap'	
* Check lnga
local ps_lnga0 = `p1'*`q_1' - (1/`B_2013')^(1/$e_supply) * $e_supply/($e_supply+1) * ///
			`q_1'^(($e_supply+1)/$e_supply)
local ps_lnga1 = `p_LNGa'*`q_LNGa' - (1/`B_2013')^(1/$e_supply) * $e_supply/($e_supply+1) * ///
			`q_LNGa'^(($e_supply+1)/$e_supply)
display "approved LNG check = " `ps_lnga1' - `ps_lnga0'

display "change in CS + PS for approved LNG = " `csLNGaresi'+`csLNGacomm'+`csLNGaindu'+`csLNGaelec' + `ps_lnga'
display "change in CS + PS for approved + proposed LNG = " `csLNGapresi'+`csLNGapcomm'+`csLNGapindu'+`csLNGapelec' + `ps_lngap'


//PS. ASSUMING 2007 PRODUCTION DECAYS AND HAS MC = 0
display "PS calculations, allowing for production to decay"
local q_equi_2007 = `B_2007'*`p_equi_2007'^$e_supply // quantity off eq price in 2007
local q_inf = `q_equi_2007' * (1-$lambda)^(2013-2007)	
* inframarginal quantity in 2013; i.e., production from wells drilled by 2007
display "quantity, 2007 (bcf each month) = " `q_equi_2007'
display "inframarginal quantity, 2013 (bcf each month) = " `q_inf'
* Calc PS in 2013 under counterfactual
local ps_inf_1c = `p0'*`q_inf'	// surplus on inframarginal q in 2013 under counterfactual
local ps_inf_1 = `p1'*`q_inf'	// surplus on inframarginal q in 2013
* Next get surplus from drilled wells between 2007 and 2013, in counterfactual and actual
local ps_m_1c = `p0'*(`q_0'-`q_inf') - (1/`B_2007')^(1/$e_supply) * $e_supply/($e_supply+1) * ///
	(`q_0'^(($e_supply+1)/$e_supply)-`q_inf'^(($e_supply+1)/$e_supply))
local ps_m_1 = `p1'*(`q_1'-`q_inf') - (1/`B_2013')^(1/$e_supply) * $e_supply/($e_supply+1) * ///
	(`q_1'^(($e_supply+1)/$e_supply)-`q_inf'^(($e_supply+1)/$e_supply))
local ps_1c = `ps_inf_1c'+`ps_m_1c'		// total counterfactual 2013 PS
local ps_1 = `ps_inf_1'+`ps_m_1'		// total actual 2013 PS
display "Inframarginal PS, counterfactual (monthly, million $) = " `ps_inf_1c'
display "Marginal PS, counterfactual (monthly, million $) = " `ps_m_1c'
display "Total PS, counterfactual (monthly, million $) = " `ps_1c'
display "Inframarginal PS, 2013 (monthly, million $) = " `ps_inf_1'
display "Marginal PS, 2013 (monthly, million $) = " `ps_m_1'
display "Total PS, 2013 (monthly, million $) = " `ps_1'

display "change in inframarginal PS, from counterfactual = " `ps_inf_1'-`ps_inf_1c'
display "change in marginal PS, from counterfactual = " `ps_m_1'-`ps_m_1c'
display "change in total PS, from counterfactual = " `ps_1'-`ps_1c'

display "change in total surplus, from counterfactual = " ///
	`ps_1'-`ps_1c' + `csresi' + `cscomm' + `csindu' + `cselec'
display "---------------------"	

display "---------------------"	
display "PRICE AT KINK IN 2013 SUPPLY CURVE: MINIMUM MC FOR NEW WELLS WITH FRACKING"
display (`q_inf'/`B_2013' )^(1/$e_supply)
display "PRICE AT KINK IN COUNTERFACTUAL SUPPLY CURVE: MINIMUM MC FOR NEW WELLS WITHOUT FRACKING"
display (`q_inf'/`B_2007' )^(1/$e_supply)

display "---------------------"	
display "ANNUAL SUMMARY, BILLION DOLLARS"
display `p1'-`p0'
display 12*`csresi'/1000
display 12*`cscomm'/1000
display 12*`csindu'/1000
display 12*`cselec'/1000
display 12*(`csresi'+`cscomm'+`csindu'+`cselec')/1000
display 12*(`ps_1'-`ps_1c')/1000
display 12*(`ps_1'-`ps_1c'+`csresi'+`cscomm'+`csindu'+`cselec')/1000
display "---------------------"		
display 12*(`ps_inf_1'-`ps_inf_1c')/1000
display 12*(`ps_m_1'-`ps_m_1c')/1000
display "---------------------"	
	
//graphing supply and demand
clear 
quietly set obs 50
quietly gen n=[_n]
quietly gen p=2+0.25*n //relevant range: 2 to 15
foreach v in resi comm indu elec{
foreach y in 2007 2013{
	quietly gen q_`v'_`y'=`A_`v'_`y'' * (p+${mu_`v'}) ^ ${e_`v'} 
	//scale is currently off of actual observed retail prices, but this is off of henry hub + markup
}
}
foreach y in 2007 2013{
	quietly gen q_total_`y'=`A_resi_`y''*(p+$mu_resi)^$e_resi + `A_comm_`y''*(p+$mu_comm)^$e_comm + ///
		`A_indu_`y''*(p+$mu_indu)^$e_indu + `A_elec_`y''*(p+$mu_elec)^$e_elec
		//this is for a mark-up over henryhub
	quietly gen q_supply_`y'=`B_`y'' * p ^ $e_supply
}
foreach v in resi comm indu elec{
	local nameresi "Residential"
	local namecomm "Commercial"
	local nameindu "Industrial"
	local nameelec "Electric power"
	twoway (scatter p q_`v'_2007 if q_`v'_2007<=600, msymbol(none) connect(l) ///
	lcolor(black) lwidth(thick)) ///
	(scatter p q_`v'_2013 if q_`v'_2013<=600, msymbol(none) connect(l) ///
	lcolor(black) lwidth(medthick)	///
	yscale(range(0(15)15)) ylabel(0(5)15) ///
	xscale(range(200(100)600)) xlabel(200(100)600) legend(off) title(`name`v'') ///
	graphregion(color(white)) ytitle("Dollars per mcf (Henry Hub)") xtitle("Bcf per month") )
	if "$graphs"=="yes"{
		graph save demand_`v', replace
	}
}
if "$graphs"=="yes"{
	graph combine demand_resi.gph demand_comm.gph ///
		demand_indu.gph demand_elec.gph, graphregion(color(white)) 
		graph export "demandshift_by_sector.png", as(png) width(2400) replace	
}		

foreach v in resi comm indu elec total supply{
foreach y in 2007 2013{
	quietly replace q_`v'_`y'=. if q_`v'_`y'>2300 | q_`v'_`y'<1300
}
}
display "prices for graph:"
display `p_equi_2007' 
display `p_equi_2013' 
display `p_counter_`countery'_`counterz''
twoway (scatter p q_total_2007, msymbol(none) connect(l) lcolor(black) lwidth(vthick)) ///
	(scatter p q_total_2013, msymbol(none) connect(l) lcolor(black) lwidth(medthick)) ///
	(scatter p q_supply_2007, msymbol(none) connect(l) lcolor(orange) lwidth(vthick)) ///
	(scatter p q_supply_2013, msymbol(none) connect(l) lcolor(orange) lwidth(medthick) ///
	yline(`p_equi_2007' `p_equi_2013' `p_counter_`countery'_`counterz'', ///
	lcolor(gs10) lpattern(dash)) ///
	yscale(range(0(15)15)) ylabel(0(2)15, nogrid) ///
	xscale(range(1200(200)2600)) xlabel(1200(200)2400) legend(off) ///
	text(15 1200 "Demand, 2013", place(e) size(small) color(black)) ///
	text(15 1450 "Demand, 2007", place(e) size(small) color(black)) ///
	text(6.4 1200 "Supply, 2007", place(e) size(small) color(black)) ///
	text(2.1 1200 "Supply, 2013", place(e) size(small) color(black)) ///
	text(4.45 2300 "Equilibrium price" "in 2013", place(e) size(small) j(left)) ///
	text(6.93 2300 "Counterfactual price", place(e) size(small) j(left)) ///
	text(8.6 2300 "Equilibrium price" "in 2007", place(e) size(small) j(left)) ///
	ytitle("Dollars per mcf (Henry Hub)") xtitle("Bcf per month") ///
	graphregion(color(white)) )	
	if "$graphs"=="yes"{
		graph export "supply_demand_withprices.png", as(png) width(2400) replace	
	}
	
// LNG GRAPH
clear 
quietly set obs 24
quietly gen n=[_n]
quietly gen p=2+0.25*n //relevant range: 2 to 8
foreach v in resi comm indu elec{
foreach y in 2007 2013{
	quietly gen q_`v'_`y'=`A_`v'_`y'' * (p+${mu_`v'}) ^ ${e_`v'} 
	//scale is currently off of actual observed retail prices, but this is off of henry hub + markup
}
}
foreach y in 2007 2013{
	quietly gen q_total_`y'=`A_resi_`y''*(p+$mu_resi)^$e_resi + `A_comm_`y''*(p+$mu_comm)^$e_comm + ///
		`A_indu_`y''*(p+$mu_indu)^$e_indu + `A_elec_`y''*(p+$mu_elec)^$e_elec
		//this is for a mark-up over henryhub
	quietly gen q_supply_`y'=`B_`y'' * p ^ $e_supply
}	
foreach v in resi comm indu elec total supply{
foreach y in 2007 2013{
	quietly replace q_`v'_`y'=. if q_`v'_`y'>2600 | q_`v'_`y'<1600
}
}
display "prices for LNG graph:" 
display `p_equi_2013' 
display `p_LNGa'
display `p_LNGap'
twoway (scatter p q_total_2013, msymbol(none) connect(l) lcolor(black) lwidth(medthick)) ///
	(scatter p q_supply_2013, msymbol(none) connect(l) lcolor(orange) lwidth(medthick) ///
	yline(`p_equi_2013' `p_LNGa' `p_LNGap', ///
	lcolor(gs10) lpattern(dash)) ///
	yscale(range(2(1)8)) ylabel(2(1)8, nogrid) ///
	xscale(range(1500(200)2600)) xlabel(1600(200)2600) legend(off) ///
	text(7.5 1630 "Demand, 2013", place(e) size(small) color(black)) ///
	text(5.9 2400 "Supply, 2013", place(e) size(small) color(black)) ///
	text(3.75 2200 "Equilibrium price in 2013", place(e) size(small) j(left)) ///
	text(4.55 2200 "Eqbm price with approved LNG", place(e) size(small) j(left)) ///
	text(5.25 1900 "Eqbm price with approved" "+ proposed LNG", place(e) size(small) j(left)) ///
	ytitle("Dollars per mcf (Henry Hub)") xtitle("Bcf per month") ///
	graphregion(color(white)) )	
	if "$graphs"=="yes"{
		graph export "supply_demand_withLNG.png", as(png) width(2400) replace	
	}
	
	
// GRAPH SHOWING INFRAMARGINAL SUPPLY	
clear 
quietly set obs 152
quietly gen n1=[_n]
quietly gen n=n1-2
quietly replace n = 0 if n<0
quietly gen p=0.1*n //relevant range: 0 to 15. Need tight spacing so kink point looks clean
* Demand
foreach y in 2007 2013{
	quietly gen q_total_`y'=`A_resi_`y''*(p+$mu_resi)^$e_resi + `A_comm_`y''*(p+$mu_comm)^$e_comm + ///
		`A_indu_`y''*(p+$mu_indu)^$e_indu + `A_elec_`y''*(p+$mu_elec)^$e_elec
		//this is for a mark-up over henryhub
}
* 2007 and 2013 supply
foreach y in 2007 2013{
	quietly gen q_supply_`y'=`B_`y'' * p ^ $e_supply
	quietly replace q_supply_`y' = `q_inf' if q_supply_`y'<`q_inf'
	quietly replace q_supply_`y' = 0 if n1==1
}
foreach v in total supply{
foreach y in 2007 2013{
	quietly replace q_`v'_`y'=. if q_`v'_`y'>2300 | p>14.51
}
}
display "prices for graph:"
display `p_equi_2007' 
display `p_equi_2013' 
display `p_counter_`countery'_`counterz''
twoway (scatter p q_total_2013, msymbol(none) connect(l) lcolor(black) lwidth(medthick)) ///
	(scatter p q_supply_2007, msymbol(none) connect(l) lcolor(orange) lwidth(vthick)) ///
	(scatter p q_supply_2013, msymbol(none) connect(l) lcolor(orange) lwidth(medthick) ///
	yline(`p_equi_2013' `p_counter_`countery'_`counterz'', lcolor(gs10) lpattern(dash)) ///
	yscale(range(0(15)15)) ylabel(0(2)15, nogrid) ///
	xscale(range(0(500)3000)) xlabel(0(500)2500) legend(off) ///
	text(15 1200 "2013 demand", place(e) size(small) color(black)) ///
	text(5 1100 "Counterfactual" "2013 supply", place(e) size(small) color(black) j(left)) ///
	text(1.75 1100 "2013 supply", place(e) size(small) color(black)) ///
	text(4.45 2370 "Equilibrium price" "in 2013", place(e) size(small) j(left)) ///
	text(8 2370 "Counterfactual price", place(e) size(small) j(left)) ///
	ytitle("Dollars per mcf (Henry Hub)") xtitle("Bcf per month") ///
	graphregion(color(white)) )	
	if "$graphs"=="yes"{
		graph export "inframarginalsupply_demand.png", as(png) width(2400) replace	
	}
local p_equi_2013 3.877
local p_counter 7.329
twoway ///
	(area q_total_2007 q_supply_2007 p if p<`p_counter' & p>`p_equi_2013', horizontal color(gs8 gs11))  ///
	(area q_supply_2013 q_supply_2007 p if p<`p_equi_2013'+0.1, horizontal color(gs14 white))  ///
	(scatter p q_total_2007, msymbol(none) connect(l) lcolor(black) lwidth(vthick)) ///
	(scatter p q_supply_2007, msymbol(none) connect(l) lcolor(orange) lwidth(vthick)) ///
	(scatter p q_supply_2013, msymbol(none) connect(l) lcolor(orange) lwidth(medthick) ///
	yline(`p_equi_2013' `p_counter', ///
	lcolor(gs10) lpattern(dash)) ///
	yscale(range(0(15)15)) ylabel(0(2)15, nogrid) ///
	xscale(range(1200(200)2600)) legend(off) ///
	ytitle("Dollars per mcf (Henry Hub)") xtitle("Bcf per month") ///
	text(5.5 400 "A", size(large) color(black)) ///
	text(5.5 1500 "B", size(large) color(black)) ///
	text(3 1000 "C", size(large) color(black)) ///
	graphregion(color(white)) )	
	if "$graphs"=="yes"{
		graph export "supply_demand_areas.png", as(png) width(2400) replace	
	}	
	
end
//------------------------------------------------------------------------//


//mark-ups:
use Data\statedata, clear
replace price_elec_real=price_city_real
foreach v in resi comm indu elec{
gen markup`v'=price_`v'_real-henryhub_dmcf_real
sum markup`v' if state_a=="US" & year>=2007 & year<=2013
}
// 8.58 5.06 0.91 1.48

use Data\statedata, clear
replace price_elec_real=price_city_real
global e_resi=-0.20
global e_comm=-0.23
global e_indu=-0.57
global e_elec=-0.47
global e_supply=0.81
global mu_resi=8.58 
global mu_comm=5.06
global mu_indu=0.91
global mu_elec=1.48
global lambda=0.111
global qLNGa = 9.22	// bcf/d. 9.22 approved
global qLNGap = 24.605 // bcf/d. 15.385 proposed, 24.605 approved + proposed
global graphs="yes"
COUNTERFACTUAL


//bounds: double and halve the elasticities

foreach multsupply in 0.5 2{ //0.5 or 2
foreach multdemand in 0.5 2{ //0.5 or 2
display "multsupply = `multsupply'"
display "multdemand = `multdemand'"
use Data\statedata, clear
replace price_elec_real=price_city_real
global e_resi=-0.20*`multdemand'
global e_comm=-0.23*`multdemand'
global e_indu=-0.57*`multdemand'
global e_elec=-0.47*`multdemand'
global e_supply=0.81*`multsupply'
global mu_resi=8.58 
global mu_comm=5.06
global mu_indu=0.91
global mu_elec=1.48
global lambda=0.111
global qLNGa = 9.22	// bcf/d. 9.22 approved
global qLNGap = 24.605 // bcf/d. 15.385 proposed, 24.605 approved + proposed
global graphs="no"
COUNTERFACTUAL
}
}

//sensitivity: double and halve the decline rate
foreach multlambda in 0.5 2{
display "multlambda = `multlambda'" //0.5 or 2
use Data\statedata, clear
replace price_elec_real=price_city_real
global e_resi=-0.20
global e_comm=-0.23
global e_indu=-0.57
global e_elec=-0.47
global e_supply=0.81
global mu_resi=8.58 
global mu_comm=5.06
global mu_indu=0.91
global mu_elec=1.48
global lambda=0.111*`multlambda'
global qLNGa = 9.22	// bcf/d. 9.22 approved
global qLNGap = 24.605 // bcf/d. 15.385 proposed, 24.605 approved + proposed
global graphs="no"
COUNTERFACTUAL
}


//most basic approximation, to guide intuition:
//doesn't account for demand shift, nor change in MC
use Data\statedata, clear
keep if state_a=="US"
gen supply=production_market*0.86
sum deliv_cons if year==2007
	local temp1=r(mean)/1000
sum deliv_cons if year==2013
	local temp2=r(mean)/1000
sum henryhub_dmcf_real if year==2007
	local temp3=r(mean)
sum henryhub_dmcf_real if year==2013
	local temp4=r(mean)
sum supply if year==2007
	local temp5=r(mean)/1000
sum supply if year==2013
	local temp6=r(mean)/1000
display "approx cs = " 12*`temp1'*(`temp3'-`temp4')/1000
display "approx cs = " 12*`temp2'*(`temp3'-`temp4')/1000
display "approx revenue = " 12*(`temp4'*`temp6'-`temp3'*`temp5')/1000


//------------------------------------- CS BY STATE
set matsize 800

global p_equi_2007=8.032 //$/mcf
global p_equi_2013=3.877
global p_counter_2013_2007=7.329

use Data\statedata, clear
replace price_elec_real=price_city_real
global e_resi=-0.20
global e_comm=-0.23
global e_indu=-0.57
global e_elec=-0.47
global e_supply=0.81
global mu_resi=8.58 
global mu_comm=5.06
global mu_indu=0.91
global mu_elec=1.48
global lambda=0.111

//For each region (state), calculate scale parameter.
//then calculate counterfactual q (2013 demand, 2007 supply) given estimated price from national step.
//then calculate change in CS and change in PS for that state.

forval d=1/9{
foreach v in resi comm indu elec{
foreach y in 2007 2013{
	sum deliv_`v' if year==`y' & division==`d'
	local q_`v'_`y'_`d'=r(mean)*r(N)/12/1000 //bcf each month 
		//because different numbers of state in each division. 
	local A_`v'_`y'_`d'=`q_`v'_`y'_`d''/((${p_equi_`y'}+${mu_`v'})^${e_`v'})
}
}
}

forval d=1/9{
foreach v in resi comm indu elec{
	local q_counter_`v'_`d'=`A_`v'_2013_`d''*($p_counter_2013_2007+${mu_`v'})^${e_`v'}
	local cs`v'_`d' = ///
		  `A_`v'_2013_`d''/(${e_`v'}+1) * ($p_counter_2013_2007+${mu_`v'})^(${e_`v'}+1) ///
		- `A_`v'_2013_`d''/(${e_`v'}+1) * ($p_equi_2013+${mu_`v'})^(${e_`v'}+1)
		//million dollars
	local cs`v'_`d'=round(`cs`v'_`d'',1)
}
}
forval d=1/9{
	local cstotal_`d'=`csresi_`d''+`cscomm_`d''+`csindu_`d''+`cselec_`d''
}
foreach v in resi comm indu elec{
	local cs`v'_all=`cs`v'_1'+`cs`v'_2'+`cs`v'_3'+`cs`v'_4'+`cs`v'_5'+`cs`v'_6'+`cs`v'_7'+`cs`v'_8'+`cs`v'_9'
}
foreach d in all{
	local cstotal_`d'=`csresi_`d''+`cscomm_`d''+`csindu_`d''+`cselec_`d''
}


disp "A 2007"
foreach v in resi comm indu elec{
disp "`v'"
forval d=1/9{
	disp `A_`v'_2007_`d''
}
}

disp "q 2007, bcf each month"
foreach v in resi comm indu elec{
disp "`v'"
forval d=1/9{
	disp `q_`v'_2007_`d''
}
}
disp "q 2013, bcf each month"
foreach v in resi comm indu elec{
disp "`v'"
forval d=1/9{
	disp `q_`v'_2013_`d''
}
}
disp "q counter., bcf each month"
foreach v in resi comm indu elec{
disp "`v'"
forval d=1/9{
	disp `q_counter_`v'_`d''
}
}

disp "dq, bcf each month"
foreach v in resi comm indu elec{
disp "`v'"
forval d=1/9{
	disp `q_`v'_2013_`d''-`q_counter_`v'_`d''
}
}

disp "dcs, million dollars per month"
foreach v in resi comm indu elec{
disp "`v'"
forval d=1/9{
	disp `cs`v'_`d''
}
}


disp "consumer surplus table"
disp "region & residential & commercial & industrial & electric & total"
disp        "New England & `csresi_1' & `cscomm_1' & `csindu_1' & `cselec_1' & `cstotal_1'"
disp    "Middle Atlantic & `csresi_2' & `cscomm_2' & `csindu_2' & `cselec_2' & `cstotal_2'"
disp "East North Central & `csresi_3' & `cscomm_3' & `csindu_3' & `cselec_3' & `cstotal_3'"
disp "West North Central & `csresi_4' & `cscomm_4' & `csindu_4' & `cselec_4' & `cstotal_4'"
disp     "South Atlantic & `csresi_5' & `cscomm_5' & `csindu_5' & `cselec_5' & `cstotal_5'"
disp "East South Central & `csresi_6' & `cscomm_6' & `csindu_6' & `cselec_6' & `cstotal_6'"
disp "West South Central & `csresi_7' & `cscomm_7' & `csindu_7' & `cselec_7' & `cstotal_7'"
disp           "Mountain & `csresi_8' & `cscomm_8' & `csindu_8' & `cselec_8' & `cstotal_8'"
disp            "Pacific & `csresi_9' & `cscomm_9' & `csindu_9' & `cselec_9' & `cstotal_9'"
disp              "Total & `csresi_all' & `cscomm_all' & `csindu_all' & `cselec_all' & `cstotal_all'"

merge m:1 state_name using Data\Census\population_20102014, keep(master match) nogen
forval d=1/9{
	sum population_2013 if division==`d' & year==2013 & month==1
	local pop`d'=r(mean)*r(N)
	foreach v in resi comm indu elec total{
		local cspc`v'_`d'=round(`cs`v'_`d''*10^6*12/`pop`d'',1) //dollars per capita per year
	}
}
disp "consumer surplus table, per capita"
disp "region & residential & commercial & industrial & electric & total"
disp        "New England & `cspcresi_1' & `cspccomm_1' & `cspcindu_1' & `cspcelec_1' & `cspctotal_1'"
disp    "Middle Atlantic & `cspcresi_2' & `cspccomm_2' & `cspcindu_2' & `cspcelec_2' & `cspctotal_2'"
disp "East North Central & `cspcresi_3' & `cspccomm_3' & `cspcindu_3' & `cspcelec_3' & `cspctotal_3'"
disp "West North Central & `cspcresi_4' & `cspccomm_4' & `cspcindu_4' & `cspcelec_4' & `cspctotal_4'"
disp     "South Atlantic & `cspcresi_5' & `cspccomm_5' & `cspcindu_5' & `cspcelec_5' & `cspctotal_5'"
disp "East South Central & `cspcresi_6' & `cspccomm_6' & `cspcindu_6' & `cspcelec_6' & `cspctotal_6'"
disp "West South Central & `cspcresi_7' & `cspccomm_7' & `cspcindu_7' & `cspcelec_7' & `cspctotal_7'"
disp           "Mountain & `cspcresi_8' & `cspccomm_8' & `cspcindu_8' & `cspcelec_8' & `cspctotal_8'"
disp            "Pacific & `cspcresi_9' & `cspccomm_9' & `cspcindu_9' & `cspcelec_9' & `cspctotal_9'"
disp              "Total & `cspcresi_all' & `cspccomm_all' & `cspcindu_all' & `cspcelec_all' & `cspctotal_all'"

forval d=1/9{
	tab state_a if division==`d'
}




//ALLOWING ELASTICITIES TO DIFFER
use Data\statedata, clear
xtset fips ym, monthly 
corr price_elec_real price_city_real
replace lnprice_elec_real=lnprice_city_real 
 
forval d=1/9{
display "--------------`d'----------------"
foreach v in resi comm indu elec{
	if "`v'"=="resi"{ 
		local iv=1
	}
	if "`v'"=="comm"{
		local iv=2
	}
	if "`v'"=="indu"{ 
		local iv=3
	}
	if "`v'"=="elec"{ 
		local iv=4
	}
	display "-----------`v'----------"
	quietly ivreg2 lndeliv_`v' l.lndeliv_`v' (lnprice_`v'_real = cumul_hdd_o12) ///
	hdd cdd l.hdd l.cdd SM* Time1 if year>=2002 & state_a!="US" & division==`d', ///
	first cluster(ym)
	quietly nlcom _b[lnprice_`v'] / (1-_b[l.lndeliv_`v'])
	matrix bmat = r(b)
	local tempe_`v'_`d' = round(bmat[1,1], 0.01)
	global e_`v'_`d'=min(`tempe_`v'_`d'',-0.05)
}
}

global p_equi_2007=8.03 //$/mcf
global p_equi_2013=3.88
global p_counter_2013_2007=7.33

global e_supply=0.81
global mu_resi=8.58 
global mu_comm=5.06
global mu_indu=0.91
global mu_elec=1.48
global lambda=0.111

forval d=1/9{
foreach v in resi comm indu elec{
foreach y in 2007 2013{
	sum deliv_`v' if year==`y' & division==`d'
	local q_`v'_`y'_`d'=r(mean)*r(N)/12/1000 //bcf each month 
		//because different numbers of state in each division. 
	local A_`v'_`y'_`d'=`q_`v'_`y'_`d''/((${p_equi_`y'}+${mu_`v'})^${e_`v'_`d'})
}
}
}

forval d=1/9{
foreach v in resi comm indu elec{
	local q_counter_`v'_`d'=`A_`v'_2013_`d''*($p_counter_2013_2007+${mu_`v'})^${e_`v'_`d'}
	local cs`v'_`d' = ///
		  `A_`v'_2013_`d''/(${e_`v'_`d'}+1) * ($p_counter_2013_2007+${mu_`v'})^(${e_`v'_`d'}+1) ///
		- `A_`v'_2013_`d''/(${e_`v'_`d'}+1) * ($p_equi_2013+${mu_`v'})^(${e_`v'_`d'}+1)
		//million dollars
	local cs`v'_`d'=round(`cs`v'_`d'',1)
}
}
forval d=1/9{
	local cstotal_`d'=`csresi_`d''+`cscomm_`d''+`csindu_`d''+`cselec_`d''
}
foreach v in resi comm indu elec{
	local cs`v'_all=`cs`v'_1'+`cs`v'_2'+`cs`v'_3'+`cs`v'_4'+`cs`v'_5'+`cs`v'_6'+`cs`v'_7'+`cs`v'_8'+`cs`v'_9'
}
foreach d in all{
	local cstotal_`d'=`csresi_`d''+`cscomm_`d''+`csindu_`d''+`cselec_`d''
}
disp "dcs, million dollars per month"
foreach v in resi comm indu elec{
disp "`v'"
forval d=1/9{
	disp `cs`v'_`d''
}
}
disp "consumer surplus table"
disp "region & residential & commercial & industrial & electric & total"
disp        "New England & `csresi_1' & `cscomm_1' & `csindu_1' & `cselec_1' & `cstotal_1'"
disp    "Middle Atlantic & `csresi_2' & `cscomm_2' & `csindu_2' & `cselec_2' & `cstotal_2'"
disp "East North Central & `csresi_3' & `cscomm_3' & `csindu_3' & `cselec_3' & `cstotal_3'"
disp "West North Central & `csresi_4' & `cscomm_4' & `csindu_4' & `cselec_4' & `cstotal_4'"
disp     "South Atlantic & `csresi_5' & `cscomm_5' & `csindu_5' & `cselec_5' & `cstotal_5'"
disp "East South Central & `csresi_6' & `cscomm_6' & `csindu_6' & `cselec_6' & `cstotal_6'"
disp "West South Central & `csresi_7' & `cscomm_7' & `csindu_7' & `cselec_7' & `cstotal_7'"
disp           "Mountain & `csresi_8' & `cscomm_8' & `csindu_8' & `cselec_8' & `cstotal_8'"
disp            "Pacific & `csresi_9' & `cscomm_9' & `csindu_9' & `cselec_9' & `cstotal_9'"
disp              "Total & `csresi_all' & `cscomm_all' & `csindu_all' & `cselec_all' & `cstotal_all'"

merge m:1 state_name using Data\Census\population_20102014, keep(master match) nogen
forval d=1/9{
	sum population_2013 if division==`d' & year==2013 & month==1
	local pop`d'=r(mean)*r(N)
	foreach v in resi comm indu elec total{
		local cspc`v'_`d'=round(`cs`v'_`d''*10^6*12/`pop`d'',1) //dollars per capita per year
	}
}
disp "consumer surplus table, per capita"
disp "region & residential & commercial & industrial & electric & total"
disp        "New England & `cspcresi_1' & `cspccomm_1' & `cspcindu_1' & `cspcelec_1' & `cspctotal_1'"
disp    "Middle Atlantic & `cspcresi_2' & `cspccomm_2' & `cspcindu_2' & `cspcelec_2' & `cspctotal_2'"
disp "East North Central & `cspcresi_3' & `cspccomm_3' & `cspcindu_3' & `cspcelec_3' & `cspctotal_3'"
disp "West North Central & `cspcresi_4' & `cspccomm_4' & `cspcindu_4' & `cspcelec_4' & `cspctotal_4'"
disp     "South Atlantic & `cspcresi_5' & `cspccomm_5' & `cspcindu_5' & `cspcelec_5' & `cspctotal_5'"
disp "East South Central & `cspcresi_6' & `cspccomm_6' & `cspcindu_6' & `cspcelec_6' & `cspctotal_6'"
disp "West South Central & `cspcresi_7' & `cspccomm_7' & `cspcindu_7' & `cspcelec_7' & `cspctotal_7'"
disp           "Mountain & `cspcresi_8' & `cspccomm_8' & `cspcindu_8' & `cspcelec_8' & `cspctotal_8'"
disp            "Pacific & `cspcresi_9' & `cspccomm_9' & `cspcindu_9' & `cspcelec_9' & `cspctotal_9'"
disp              "Total & `cspcresi_all' & `cspccomm_all' & `cspcindu_all' & `cspcelec_all' & `cspctotal_all'"




//----------------------------- PS BY STATE
global p_equi_2007=8.032 //$/mcf
global p_equi_2013=3.877
global p_counter_2013_2007=7.329

use Data\statedata, clear
replace price_elec_real=price_city_real
global e_supply=0.81
global lambda=0.111

* Identify top producing states, 2007 - 2013
keep state* year month ym production_marketed henryhub_dmcf_real
gen supply=production_marketed*(1-0.14) //14% goes to pipeline use, plant fuel use, and liquids
drop production_marketed
keep if year>=2007 & year<=2013
* Observation count by state
tab state_a		// all states either have all 84 obs or are all missing
* mean production
bysort state_a: egen mean_s = mean(supply)
sort mean_s
// TX, WY, LA, fedoffshore, OK, CO, NM, PA, AR, UT, WV are top 11
drop mean_s

replace state_name="Offshore" if state_abbr=="fedoffshore"
replace state_name="United States" if state_abbr=="US"
replace state_a = "OF" if state_a=="fedoffshore"

* Get "other states" production
gen temp1=supply if state_abbr=="US"
	bysort ym: egen temp2=max(supply)
gen producing_state = 1 if inlist(state_a,"TX", "WY", "LA", "OK", "CO") | inlist(state_a, "NM", "PA", "AR", "UT", "WV", "OF")
gen temp4=supply if producing_state==1
bysort ym: egen temp5=total(temp4)
gen supply_other_states=temp2-temp5
replace producing_state=1 if state_abbr=="US"
drop temp*

gen sample=1 if year>=2007 & producing_state==1
table state_name if sample==1, ///
	contents(mean supply mean supply_other_states count supply count supply_other_states)
	//to check aggregation
drop sample	
replace supply=supply_other_states if state_abbr=="MI"
	//MI now has other states supply. Relabel as OT
replace state_a = "OT" if state_a=="MI"
replace producing_state=1 if state_abbr=="OT"
replace state_name = "Other States" if state_a=="OT"


// For each top 10 state and other, get 2007 and 2013 production and scale parameters
// then get 2013 inframarginal production using decline rate
// then get change in PS

* First step: observed prices
foreach y in 2007 2013 {
	qui sum henryhub_dmcf_real if year==`y' & state_a=="US"
	local p_`y'=r(mean) //million dollars per bcf
	display "REAL HENRY HUB PRICE, million dollars per bcf = dollars per mcf"
	display `p_`y''
}

* Shorthand
local p0=$p_counter_2013_2007
local p1=$p_equi_2013
local p_equi_2007=$p_equi_2007

foreach s in TX WY LA OK CO NM PA AR UT WV OF OT US {
	foreach y in 2007 2013 {
		qui sum supply if year==`y' & state_a=="`s'"
		local q_`y'_`s'=r(mean)/1000 	//bcf each month. Actual quantity
		local B_`y'_`s'=`q_`y'_`s''/(`p_`y''^$e_supply)
	}
	local q_equi_2007_`s' = `B_2007_`s''*`p_equi_2007'^$e_supply // quantity off eq price in 2007
	local q_inf_`s' = `q_equi_2007_`s'' * (1-$lambda)^(2013-2007)	 // inframarginal quantity
	local q0_`s' = `B_2007_`s'' * `p0'^$e_supply // Counterfactual quantity
	local q1_`s' = `B_2013_`s'' * `p1'^$e_supply // 2013 equilibrium quantity
	* Inframarginal surplus
	local ps_inf_1c_`s' = `p0' * `q_inf_`s''
	local ps_inf_1_`s' = `p1' * `q_inf_`s''
	* Surplus from drilled wells between 2007 and 2013
	local ps_m_1c_`s' = `p0'*(`q0_`s''-`q_inf_`s'') - (1/`B_2007_`s'')^(1/$e_supply) * /// 
	$e_supply/($e_supply+1) * (`q0_`s''^(($e_supply+1)/$e_supply)-`q_inf_`s''^(($e_supply+1)/$e_supply))
	local ps_m_1_`s' = `p1'*(`q1_`s''-`q_inf_`s'') - (1/`B_2013_`s'')^(1/$e_supply) * /// 
	$e_supply/($e_supply+1) * (`q1_`s''^(($e_supply+1)/$e_supply)-`q_inf_`s''^(($e_supply+1)/$e_supply))
	local ps_1c_`s' = `ps_inf_1c_`s''+`ps_m_1c_`s''	
	local ps_1_`s' = `ps_inf_1_`s''+`ps_m_1_`s''		
	local Dps_1_`s' = round(12/1000*(`ps_1_`s'' - `ps_1c_`s''),0.1) //display only. billion per year
	local dp_ps_`s'=round(100*(`ps_1_`s'' - `ps_1c_`s'')/`ps_1c_`s'',1) //display only
	local q_2007_`s'=round(12*`q_2007_`s'',1) //display only
	local q_2013_`s'=round(12*`q_2013_`s'',1) //display only
}
	

disp "producer surplus table"
disp "state & 2007 supply & 2013 supply & change in PS"
disp         "Arkansas & `q_2007_AR' & `q_2013_AR' & `Dps_1_AR' & `dp_ps_AR'" 
disp         "Colorado & `q_2007_CO' & `q_2013_CO' & `Dps_1_CO' & `dp_ps_CO'"
disp        "Louisiana & `q_2007_LA' & `q_2013_LA' & `Dps_1_LA' & `dp_ps_LA'"
disp       "New Mexico & `q_2007_NM' & `q_2013_NM' & `Dps_1_NM' & `dp_ps_NM'"
disp         "Oklahoma & `q_2007_OK' & `q_2013_OK' & `Dps_1_OK' & `dp_ps_OK'"
disp     "Pennsylvania & `q_2007_PA' & `q_2013_PA' & `Dps_1_PA' & `dp_ps_PA'"
disp            "Texas & `q_2007_TX' & `q_2013_TX' & `Dps_1_TX' & `dp_ps_TX'"
disp             "Utah & `q_2007_UT' & `q_2013_UT' & `Dps_1_UT' & `dp_ps_UT'"
disp    "West Virginia & `q_2007_WV' & `q_2013_WV' & `Dps_1_WV' & `dp_ps_WV'"
disp          "Wyoming & `q_2007_WY' & `q_2013_WY' & `Dps_1_WY' & `dp_ps_WY'"	
disp     "Other states & `q_2007_OT' & `q_2013_OT' & `Dps_1_OT' & `dp_ps_OT'"	
disp "Federal Offshore & `q_2007_OF' & `q_2013_OF' & `Dps_1_OF' & `dp_ps_OF'"
disp 	     "Total US & `q_2007_US' & `q_2013_US' & `Dps_1_US' & `dp_ps_US'"

gen Q2007 = 0
gen Q2013 = 0
gen DPS = 0
gen DPPS = 0
gen PSIc = 0
gen PSI1 = 0
gen PSMc = 0
gen PSM1 = 0
gen QE2007 = 0
gen QE2013 = 0
gen QC2013 = 0
gen QI2013 = 0

foreach s in TX WY LA OK CO NM PA AR UT WV OF OT US {
	replace Q2007 = `q_2007_`s'' if state_a=="`s'"
	replace Q2013 = `q_2013_`s'' if state_a=="`s'"	
	replace DPS = `Dps_1_`s'' if state_a=="`s'"
	replace DPPS = `dp_ps_`s'' if state_a=="`s'"
	replace PSIc = `ps_inf_1c_`s'' if state_a=="`s'"
	replace PSI1 = `ps_inf_1_`s'' if state_a=="`s'"
	replace PSMc = `ps_m_1c_`s'' if state_a=="`s'"
	replace PSM1 = `ps_m_1_`s'' if state_a=="`s'"
	replace QE2007 = `q_equi_2007_`s'' if state_a=="`s'"
	replace QE2013 = `q1_`s'' if state_a=="`s'"
	replace QC2013 = `q0_`s'' if state_a=="`s'"
	replace QI2013 = `q_inf_`s'' if state_a=="`s'"
}

table state_name if producing_state==1, ///
	contents(mean Q2007 mean Q2013 mean DPS mean DPPS)

table state_name if producing_state==1, ///
	contents(mean PSIc mean PSI1 mean PSMc mean PSM1)

table state_name if producing_state==1, ///
	contents(mean QE2007 mean QE2013 mean QC2013 mean QI2013)

