cd "C:\Users\chausman\Desktop\Data package to post"
set matsize 800

**DEMAND AND SUPPLY ELASTICITIES, AND PRICE PASS-THROUGH EQUATIONS
//Requires running first: data.do, which cleans and compiles the raw data

///////////////
//ESTIMATION OF ELASTICITIES, MAIN SPECIFICATIONS (CONSTANT ELASTICITY)
//////////////
use Data\statedata, clear
xtset fips ym, monthly 
corr price_elec_real price_city_real
replace lnprice_elec_real=lnprice_city_real //elec price has missing values but city does not 
	
//same time period for all variables:
foreach v in resi comm indu elec{
	display "`v'"
	sum ym if lndeliv_`v'!=.
	sum ym if l.lndeliv_`v'!=.
	sum ym if lnprice_`v'!=.
}
sum ym if cumul_hdd_o12!=.
//latest start period: 504, for elec price
//earliest end period: 647 for all
tab year month if ym==504 //jan 2002
tab year month if ym==647 //dec 2013

//missing values and zeroes of deliv_elec:
count if year>=2001 & deliv_elec==. & state_a!="US" & hdd!=. 
	*br if year>=2001 & deliv_elec==. & state_a!="US" & hdd!=.  //mt, ND, ETC, as expected
	//because DC and offshore don't have deliv_elec, but neither do they have the other variables we use
count if year>=2001 & deliv_elec==0 & state_a!="US" & hdd!=. 
	//because DC and offshore don't have deliv_elec, but neither do they have the other variables we use
	//br if year>=2001 & deliv_elec==0 & state_a!="US" & hdd!=.  //vt, nh, nd as expected
gen temp1=1 if year>=2001 & deliv_elec==. & state_a!="US" & hdd!=. 
	bysort state_a: egen temp2=max(temp1)
	tab state_a if temp2==1 & state_a!="US" & hdd!=.
	tab state_a if temp2==. & state_a!="US" & hdd!=.
	sum deliv_elec if temp2==1 & state_a!="US" & hdd!=. 
	sum deliv_elec if temp2==. & state_a!="US" & hdd!=. 
	table state_a if temp2==1 & state_a!="US" & hdd!=., contents(mean deliv_elec)
	table state_a if temp2==. & state_a!="US" & hdd!=., contents(mean deliv_elec)
	disp 352/13049 //states with small % of total
	drop temp1 temp2
xtset fips ym, monthly 
	
//WHY WE DON'T USE ONLY CONTEMPORANEOUS WEATHER IN OTHER STATES: WEAK FIRST STAGE
foreach v in resi comm indu elec{
	display "-----------`v'----------"
	xtivreg2 lndeliv_`v' l.lndeliv_`v' (lnprice_`v'_real = hdd_other_wtd cdd_other_wtd) ///
	hdd cdd l.hdd l.cdd SM* Time1 if year>=2002 & state_a!="US", ///
	first fe cluster(state_a ym) partial(SM* Time1)
}

foreach v in resi comm indu elec{
	display "-----------`v'----------"
	xtivreg2 lndeliv_`v' l.lndeliv_`v' (lnprice_`v'_real = cumul_hdd_o12) ///
	hdd cdd l.hdd l.cdd SM* Time1 if year>=2002 & state_a!="US", ///
	first fe cluster(state_a ym) partial(SM* Time1)
}

foreach v in resi comm indu elec{
	if "`v'"=="resi"{ 
		local iv=1
	}
	if "`v'"=="comm"{
		local iv=2
	}
	if "`v'"=="indu"{ 
		local iv=3
	}
	if "`v'"=="elec"{ 
		local iv=4
	}
	display "-----------`v'----------"
	quietly xtivreg2 lndeliv_`v' l.lndeliv_`v' (lnprice_`v'_real = cumul_hdd_o12) ///
	hdd cdd l.hdd l.cdd SM* Time1 if year>=2002 & state_a!="US", ///
	first fe cluster(state_a ym) partial(SM* Time1)
	local n`iv'=e(N)
	local f`iv'=round(e(widstat),0.01)
	quietly lincom lnprice
	local pb`iv'=round(r(estimate),0.01)
	local pse`iv'=round(r(se),0.01)
	quietly lincom l.lndeliv_
	local ab`iv'=round(r(estimate),0.01)
	local ase`iv'=round(r(se),0.01)
	quietly lincom hdd*100
	local hb`iv'=round(r(estimate),0.01)
	local hse`iv'=round(r(se),0.01)
	quietly lincom cdd*100
	local cb`iv'=round(r(estimate),0.01)
	local cse`iv'=round(r(se),0.01)
	quietly nlcom _b[lnprice_`v'] / (1-_b[l.lndeliv_`v'])
	matrix bmat = r(b)
	local plrb`iv' = round(bmat[1,1], 0.01)
	matrix smat = r(V)
	local plrse`iv' = round(smat[1,1]^0.5, 0.01)
	quietly xtivreg2 lnprice_`v'_real l.lndeliv_`v' cumul_hdd_o12 ///
	hdd cdd l.hdd l.cdd SM* Time1 if year>=2002 & state_a!="US", ///
	first fe cluster(state_a ym) partial(SM* Time1)
	quietly lincom l.lndeliv_`v'
	local fab`iv'=round(r(estimate),0.01)
	local fase`iv'=round(r(se),0.01)
	quietly lincom cumul_hdd_o`y'*100
	local fivb`iv'=round(r(estimate),0.01)
	local fivse`iv'=round(r(se),0.01)
	quietly lincom hdd*100
	local fhddb`iv'=round(r(estimate),0.01)
	local fhddse`iv'=round(r(se),0.01)
	quietly lincom cdd*100
	local fcddb`iv'=round(r(estimate),0.01)
	local fcddse`iv'=round(r(se),0.01)
}
display " & `pb1' & `pb2' & `pb3' & `pb4'" //beta on price
display " & (0`pse1') & (0`pse2') & (0`pse3') & (0`pse4') " //se
display " & 0`ab1' & 0`ab2' & 0`ab3' & 0`ab4' " //beta on ar(1)
display " & (0`ase1') & (0`ase2') & (0`ase3') & (0`ase4') " //se
display " & `plrb1' & `plrb2' & `plrb3' & `plrb4'" //beta for l.r. price
display " & (0`plrse1') & (0`plrse2') & (0`plrse3') & (0`plrse4') " //se
display " & `hb1' & `hb2' & `hb3' & `hb4' " //beta on HDD, hundreds
display " & (0`hse1') & (0`hse2') & (0`hse3') & (0`hse4') " //se
display " & `cb1' & `cb2' & `cb3' & `cb4' " //beta on CDD, hundreds
display " & (0`cse1') & (0`cse2') & (0`cse3') & (0`cse4') " //se
display " & `f1' & `f2' & `f3' & `f4' " //first-stage f
display " & `n1' & `n2' & `n3' & `n4' " //n

display " & `fab1' & `fab2' & `fab3' & `fab4'" //firststage beta on ar1
display " & (0`fase1') & (0`fase2') & (0`fase3') & (0`fase4') " //se
display " & `fivb1' & `fivb2' & `fivb3' & `fivb4'" //firststage beta on instrument
display " & (0`fivse1') & (0`fivse2') & (0`fivse3') & (0`fivse4') " //se
display " & `fhddb1' & `fhddb2' & `fhddb3' & `fhddb4'" //firststage beta on own hdd
display " & (0`fhddse1') & (0`fhddse2') & (0`fhddse3') & (0`fhddse4') " //se
display " & `fcddb1' & `fcddb2' & `fcddb3' & `fcddb4'" //firststage beta on own cdd
display " & (0`fcddse1') & (0`fcddse2') & (0`fcddse3') & (0`fcddse4') " //se

//ESTIMATING SUPPLY
ivreg2 lnwells_all_gas l.lnwells_all_gas (lnhenryhub_dmcf_real = l.hdd_national_wtd l.cdd_national_wtd) ///
	hdd_national_wtd cdd_national_wtd MM* Time1 if year>=2002 & state_a=="US", ///
	first robust bw(18) 
	lincom hdd_n*100
	lincom cdd_n*100
	nlcom _b[lnhenryhub_dmcf_real] / (1-_b[l.lnwells_all_gas])

//ALTERNATIVE SPECIFICATIONS: INSTRUMENTS 
	foreach v in wells_all_gas deliv_cons wells_all_oil_drilled{
		gen temp1=`v' if state_a=="US"
		bysort ym: egen temp2=max(temp1)
		gen ln`v'_national=ln(temp2)
		drop temp1 temp2
	}
	xtset fips ym, monthly
	//cumulative weather in OWN STATE
	foreach var in hdd{
		gen cumul_`var'_2=l2.`var'
			forval v = 3/14{
			local y=`v'-1
				gen cumul_`var'_`v'=cumul_`var'_`y'+l`v'.`var'
			}
			gen check=l2.`var'+l3.`var'+l4.`var'+l5.`var' ///
				-cumul_`var'_5
			sum check
			drop check
	}
	//weather in East/West, except own division
	gen east=1 if division<8
		replace east=0 if division==8|division==9
	gen hdd_half=.
	gen hdd_half_wtd=.
	forval division=1/9{
		sum east if division==`division'
			local east=r(mean)
		gen temp1=hdd if east==`east' & division!=`division'  //same east/west half, not own division
		bysort ym: egen temp2=mean(temp1)
		bysort ym: egen temp3=wtmean(temp1), weight(population)
		replace hdd_half=temp2 if division==`division'
		replace hdd_half_wtd=temp3 if division==`division'
		drop temp*	
	}
	xtset fips ym, monthly
	foreach var in hdd_half_wtd{
		gen cumul_`var'_2=l2.`var'
			forval v = 3/14{
			local y=`v'-1
				gen cumul_`var'_`v'=cumul_`var'_`y'+l`v'.`var'
			}
			gen check=l2.`var'+l3.`var'+l4.`var'+l5.`var' ///
				-cumul_`var'_5
			sum check
			drop check
	}

xtset fips ym, monthly
foreach v in resi comm indu elec{
	local list1="cumul_hdd_o11" 
	local list2="cumul_hdd_o13"
	local list3="l(2/12).hdd_other"
	local list4="cumul_cdd_o12"
	local list5="cumul_hdd_o12 cumul_cdd_o12"
	local list6="cumul_hdd_12"
	local list7="cumul_hdd_half_wtd_12"
	forval iv = 1/7{
	display "-----------`v', `iv'----------"
	quietly xtivreg2 lndeliv_`v' l.lndeliv_`v' (lnprice_`v'_real = `list`iv'') ///
		hdd cdd l.hdd l.cdd SM* Time1 if year>=2002 & state_a!="US", ///
		first fe cluster(state_a ym) partial(SM* Time1)
		local n`iv'=e(N)
		local f`iv'=round(e(widstat),0.01)
		quietly lincom lnprice
		local pb`iv'=round(r(estimate),0.01)
		local pse`iv'=round(r(se),0.01)
		quietly lincom l.lndeliv_
		local ab`iv'=round(r(estimate),0.01)
		local ase`iv'=round(r(se),0.01)		
		quietly nlcom _b[lnprice_`v'] / (1-_b[l.lndeliv_`v'])
		matrix bmat = r(b)
		local plrb`iv' = round(bmat[1,1], 0.01)
		matrix smat = r(V)
		local plrse`iv' = round(smat[1,1]^0.5, 0.01)
	}
display " & `pb1' & `pb2' & `pb3' & `pb4' & `pb5' & `pb6' & `pb7' & `pb8'" //beta on price
display " & (0`pse1') & (0`pse2') & (0`pse3') & (0`pse4') & (0`pse5') & (0`pse6') & (0`pse7') & (0`pse8')" //se
display " & 0`ab1' & 0`ab2' & 0`ab3' & 0`ab4' & 0`ab5' & 0`ab6' & 0`ab7' & 0`ab8'"  //beta on ar(1)
display " & (0`ase1') & (0`ase2') & (0`ase3') & (0`ase4') & (0`ase5') & (0`ase6') & (0`ase7') & (0`ase8')" //se
display " & `plrb1' & `plrb2' & `plrb3' & `plrb4' & `plrb5' & `plrb6' & `plrb7' & `plrb8'" //beta for l.r. price
display " & (0`plrse1') & (0`plrse2') & (0`plrse3') & (0`plrse4') & (0`plrse5') & (0`plrse6') & (0`plrse7') & (0`plrse8') " //se
display " & `f1' & `f2' & `f3' & `f4' & `f5' & `f6' & `f7' & `f8'" //first-stage f
display " & `n1' & `n2' & `n3' & `n4' & `n5' & `n6' & `n7' & `n8'" //n
}
local list1="l.hdd_national_wtd cumul_hdd_n12 l.cdd_national_wtd cumul_cdd_n12"
local list2="l.hdd_national_wtd l.cdd_national_wtd l6.lnhenryhub_dmcf_real"
local list3="l.hdd_national_wtd l.cdd_national_wtd l6.lndeliv_cons_national"
local list4="l.hdd_national_wtd l.cdd_national_wtd l6.lnwells_all_oil_drilled"
local list5="l.hdd_national_wtd l.cdd_national_wtd l6.lnhenryhub_dmcf_real l6.lndeliv_cons_national l6.lnwells_all_oil_drilled"
forval iv = 1/5{
display "-----------`iv'----------"
quietly ivreg2 lnwells_all_gas l.lnwells_all_gas (lnhenryhub_dmcf_real = `list`iv'') ///
	hdd_national_wtd cdd_national_wtd MM* Time1 if year>=2002 & state_a=="US", ///
	first robust bw(18) 
	local n`iv'=e(N)
	local f`iv'=round(e(widstat),0.01)
	quietly lincom lnhenryhub_dmcf_real
	local pb`iv'=round(r(estimate),0.01)
	local pse`iv'=round(r(se),0.01)
	quietly lincom l.lnwells_all_gas
	local ab`iv'=round(r(estimate),0.01)
	local ase`iv'=round(r(se),0.01)
	quietly nlcom _b[lnhenryhub_dmcf_real`v'] / (1-_b[l.lnwells_all_gas`v'])
	matrix bmat = r(b)
	local plrb`iv' = round(bmat[1,1], 0.01)
	matrix smat = r(V)
	local plrse`iv' = round(smat[1,1]^0.5, 0.01)
}
display " & 0`pb1' & 0`pb2' & 0`pb3' & 0`pb4' & 0`pb5' & 0`pb6'" //beta on price
display " & (0`pse1') & (0`pse2') & (0`pse3') & (0`pse4') & (0`pse5') & (0`pse6')" //se
display " & 0`ab1' & 0`ab2' & 0`ab3' & 0`ab4' & 0`ab5' & 0`ab6'" //beta on ar(1)
display " & (0`ase1') & (0`ase2') & (0`ase3') & (0`ase4') & (0`ase5') & (0`ase6')" //se
display " & `plrb1' & `plrb2' & `plrb3' & `plrb4' & `plrb5' & `plrb6' & `plrb7' & `plrb8'" //beta for l.r. price
display " & (0`plrse1') & (0`plrse2') & (0`plrse3') & (0`plrse4') & (0`plrse5') & (0`plrse6') & (0`plrse7') & (0`plrse8') " //se
display " & `f1' & `f2' & `f3' & `f4' & `f5' & `f6'" //first-stage f
display " & `n1' & `n2' & `n3' & `n4' & `n5' & `n6'" //n

// ALTERNATIVE SPECIFICATIONS: CONTROLS (main uses l.hdd l.cdd SM* time1)
forval d=1/9{
	gen D`d'Time1=Time1 if division==`d'
	replace D`d'Time1=0 if division!=`d'
}
foreach v in resi comm indu elec{
	local list1="SM* Time1" //dropping lagged weather - less than in main
	local list2="l.hdd l.cdd SM*" //dropping linear trend - less than in main
	local list3="l.hdd l.cdd DM* YY*" //year effects, with division by month so fewer parameters to estimate
	local list4="l.hdd l.cdd SM* YY*" //year effects (recall now very sensitive to iv lag length)
	local list5="l.hdd l.cdd SM* D*Time1" //time trends by division
	local list6="l.hdd l.cdd SM* Time1 cumul_hdd_12" //local cumulative weather
	forval iv = 1/6{
	display "-----------`v', `iv'----------"
	quietly xtivreg2 lndeliv_`v' l.lndeliv_`v' (lnprice_`v'_real = cumul_hdd_o12) ///
		hdd cdd `list`iv'' if year>=2002 & state_a!="US", ///
		first fe cluster(state_a ym) partial(`list`iv'')
		local n`iv'=e(N)
		local f`iv'=round(e(widstat),0.01)
		quietly lincom lnprice
		local pb`iv'=round(r(estimate),0.01)
		local pse`iv'=round(r(se),0.01)
		quietly lincom l.lndeliv_
		local ab`iv'=round(r(estimate),0.01)
		local ase`iv'=round(r(se),0.01)
		quietly nlcom _b[lnprice_`v'_real] / (1-_b[l.lndeliv_`v'])
		matrix bmat = r(b)
		local plrb`iv' = round(bmat[1,1], 0.01)
		matrix smat = r(V)
		local plrse`iv' = round(smat[1,1]^0.5, 0.01)
	}
	local iv=7
	display "-----------`v', `iv'---------" //ar(2)
	quietly xtivreg2 lndeliv_`v' l.lndeliv_`v' l2.lndeliv_`v' (lnprice_`v'_real = cumul_hdd_o12) ///
		hdd cdd l.hdd l.cdd l2.hdd l2.cdd SM* Time1 if year>=2002 & state_a!="US", ///
		first fe cluster(state_a ym) partial(SM* Time1)
		local n`iv'=e(N)
		local f`iv'=round(e(widstat),0.01)
		quietly lincom lnprice
		local pb`iv'=round(r(estimate),0.01)
		local pse`iv'=round(r(se),0.01)
		quietly lincom l.lndeliv_
		local ab`iv'=round(r(estimate),0.01)
		local ase`iv'=round(r(se),0.01)	
		quietly lincom l2.lndeliv_
		local a2b`iv'=round(r(estimate),0.01)
		local a2se`iv'=round(r(se),0.01)	
		quietly nlcom _b[lnprice_`v'_real] / (1-_b[l.lndeliv_`v']-_b[l2.lndeliv_`v'])
		matrix bmat = r(b)
		local plrb`iv' = round(bmat[1,1], 0.01)
		matrix smat = r(V)
		local plrse`iv' = round(smat[1,1]^0.5, 0.01)
	display " & `pb1' & `pb2' & `pb3' & `pb4' & `pb5' & `pb6' & `pb7'" //beta on price
	display " & (0`pse1') & (0`pse2') & (0`pse3') & (0`pse4') & (0`pse5') & (0`pse6')& (0`pse7')" //se
	display " & 0`ab1' & 0`ab2' & 0`ab3' & 0`ab4' & 0`ab5' & 0`ab6' & 0`ab7'" //beta on ar(1)
	display " & (0`ase1') & (0`ase2') & (0`ase3') & (0`ase4') & (0`ase5') & (0`ase6') & (0`ase7')" //se
	display " & 0`a2b1' & 0`a2b2' & 0`a2b3' & 0`a2b4' & 0`a2b5' & 0`a2b6' &  0`a2b7'" //beta on ar(2)
	display " & (0`a2se1') & (0`a2se2') & (0`a2se3') & (0`a2se4') & (0`a2se5') & (0`a2se6') & (0`a2se7')" //se
	display " & `plrb1' & `plrb2' & `plrb3' & `plrb4' & `plrb5' & `plrb6' & `plrb7'" //beta for l.r. price
	display " & (0`plrse1') & (0`plrse2') & (0`plrse3') & (0`plrse4') & (0`plrse5') & (0`plrse6') & (0`plrse7')" //se	
	display " & `f1' & `f2' & `f3' & `f4' & `f5' & `f6' & `f7'" //first-stage f
	display " & `n1' & `n2' & `n3' & `n4' & `n5' & `n6' & `n7'" //n
}

foreach m of numlist 1/12{
	gen ym_m`m'=Time1 if month==`m'
	replace ym_m`m'=0 if month!=`m'
}
local list1="MM* Time1" //dropping contemporaneous weather
local list2="hdd_national_wtd cdd_national_wtd MM*" //dropping linear trend
local list3="hdd_national_wtd cdd_national_wtd MM* YY*" //year effects 
local list4="hdd_national_wtd cdd_national_wtd MM* ym_m*" //time trends by month
forval iv = 1/4{
display "-----------`iv'----------"
quietly ivreg2 lnwells_all_gas l.lnwells_all_gas (lnhenryhub_dmcf_real = l.hdd_national_wtd l.cdd_national_wtd) ///
	`list`iv'' if year>=2002 & state_a=="US", ///
	first robust bw(18) 
	local n`iv'=e(N)
	local f`iv'=round(e(widstat),0.01)
	quietly lincom lnhenryhub_dmcf_real
	local pb`iv'=round(r(estimate),0.01)
	local pse`iv'=round(r(se),0.01)
	quietly lincom l.lnwells_all_gas
	local ab`iv'=round(r(estimate),0.01)
	local ase`iv'=round(r(se),0.01)
	quietly nlcom _b[lnhenryhub_dmcf_real`v'] / (1-_b[l.lnwells_all_gas`v'])
	matrix bmat = r(b)
	local plrb`iv' = round(bmat[1,1], 0.01)
	matrix smat = r(V)
	local plrse`iv' = round(smat[1,1]^0.5, 0.01)
}
local iv=5
display "-----------`iv'----------"
quietly ivreg2 lnwells_all_gas l.lnwells_all_gas l2.lnwells_all_gas (lnhenryhub_dmcf_real = l.hdd_national_wtd l.cdd_national_wtd) ///
	hdd_national_wtd cdd_national_wtd MM* Time1 if year>=2002 & state_a=="US", ///
	first robust bw(18) 
	local n`iv'=e(N)
	local f`iv'=round(e(widstat),0.01)
	quietly lincom lnhenryhub_dmcf_real
	local pb`iv'=round(r(estimate),0.01)
	local pse`iv'=round(r(se),0.01)
	quietly lincom l.lnwells_all_gas
	local ab`iv'=round(r(estimate),0.01)
	local ase`iv'=round(r(se),0.01)
	quietly lincom l2.lnwells_all_gas
	local a2b`iv'=round(r(estimate),0.01)
	local a2se`iv'=round(r(se),0.01)
	quietly nlcom _b[lnhenryhub_dmcf_real`v'] / (1-_b[l.lnwells_all_gas`v']-_b[l2.lnwells_all_gas`v'])
	matrix bmat = r(b)
	local plrb`iv' = round(bmat[1,1], 0.01)
	matrix smat = r(V)
	local plrse`iv' = round(smat[1,1]^0.5, 0.01)
display " & 0`pb1' & 0`pb2' & 0`pb3' & 0`pb4' & 0`pb5' & 0`pb6'" //beta on price
display " & (0`pse1') & (0`pse2') & (0`pse3') & (0`pse4') & (0`pse5') & (0`pse6')" //se
display " & 0`ab1' & 0`ab2' & 0`ab3' & 0`ab4' & 0`ab5' & 0`ab6'" //beta on ar(1)
display " & (0`ase1') & (0`ase2') & (0`ase3') & (0`ase4') & (0`ase5') & (0`ase6')" //se
display " & 0`a2b1' & 0`a2b2' & 0`a2b3' & 0`a2b4' & 0`a2b5' & 0`a2b6' " //beta on ar(2)
display " & (0`a2se1') & (0`a2se2') & (0`a2se3') & (0`a2se4') & (0`a2se5') & (0`a2se6') " //se
display " & `plrb1' & `plrb2' & `plrb3' & `plrb4' & `plrb5' & `plrb6' " //beta for l.r. price
display " & (0`plrse1') & (0`plrse2') & (0`plrse3') & (0`plrse4') & (0`plrse5') & (0`plrse6') " //se
display " & `f1' & `f2' & `f3' & `f4' & `f5' & `f6'" //first-stage f
display " & `n1' & `n2' & `n3' & `n4' & `n5' & `n6'" //n


///////////////
//PASS-THROUGH
///////////////
use Data\statedata, clear
xtset fips ym, monthly 

//AVERAGE MARK-UP
sum henryhub_dmcf_real if year>=2001 & state_a=="US"
	local temp2=r(mean)
quietly sum cpi_leg if year==2013
	local temp=r(mean)
foreach v in residential commercial industrial electricpower citygate{
	gen price_`v'_dmcf_real=price_`v'_dmcf/cpi_leg*`temp'
	sum price_`v'_dmcf_real if year>=2001 & state_a=="US"
	local temp1=r(mean)
	display `temp1'-`temp2'
}

//recall year effects important wherever not instrumenting with weather
//and not DC because it's not in any other results (lack of HDDs)
foreach v in resi comm indu elec city{
	areg price_`v'_real l.price_`v'_real l(0/11).henryhub_dmcf_real ///
	YY* if year>=2002 & state_a!="US" & state_a!="DC", ///
	vce(cluster ym) absorb(state_by_month)
	nlcom (_b[l0.henryhub]+_b[l1.henryhub]+_b[l2.henryhub]+_b[l3.henryhub] ///
	+_b[l4.henryhub]+_b[l5.henryhub]+_b[l6.henryhub]+_b[l7.henryhub] ///
	+_b[l8.henryhub]+_b[l9.henryhub]+_b[l10.henryhub] ///
	+_b[l11.henryhub] ) ///
	/ (1-_b[l.price])
}
foreach v in resi comm indu elec city{
	xtivreg2 price_`v'_real l.price_`v'_real (l(0).henryhub_dmcf_real = l.hdd_national_wtd l.cdd_national_wtd) ///
	hdd cdd l.hdd l.cdd SM* Time1 if year>=2002 & state_a!="US", ///
	first fe cluster(state_a ym) partial(SM* Time1)
	nlcom (_b[henryhub] ) ///
	/ (1-_b[l.price])
}
