cd "C:\Users\chausman\Desktop\Data package to post"

//UNDERSTANDING WHETHER DEMAND MIGHT BE SHIFTING IN OR OUT, AND WHY
//Requires running first: data.do, which cleans and compiles the raw data

/*
GDP (all end uses)
HDDs, population weighted (residential)
median income, as opposed to average (residential)
	esp. in cold regions, (residential)
population, by region
	cold regions (residential)
	warm regions (electricity)
CDDs, population weighted (electricity)	
fossil-fuel fired generation (electricity)
industrial production (industrial)
*/

//////////GDP (REAL, BILLIONS OF 2009 DOLLARS)
import excel using Data/Fed/GDPDEF.xls, cellrange(A17) first clear 
quietly sum VALUE if DATE==mdy(1,1,2009) //because real series below is in 2009 dollars
local def1=r(mean)
quietly sum VALUE if DATE==mdy(1,1,2013)
local def2=r(mean)

use Data/Fed/GDP_real, clear
replace gdp=gdp/1000 //trillions of 2009 dollars
sum gdp if year==2007
	local temp1=r(mean)
sum gdp if year==2013
	local temp2=r(mean)
display ln(`temp2')-ln(`temp1')
display (`temp2'-`temp1')/`temp1'

gen gdp_2013dollars=gdp/`def1'*`def2'
sum gdp_2013dollars if year==2007
	local temp1=r(mean)
sum gdp_2013dollars if year==2013
	local temp2=r(mean)
display ln(`temp2')-ln(`temp1')
display (`temp2'-`temp1')/`temp1'

//////////HDDS, POPULATION-WEIGHTED (RESIDENTIAL SHIFTER)
//////////CDDS, POPULATION-WEIGHTED (ELECTRICITY SHIFTER)
use Data\NOAA\daily_degree_days, clear //daily count per state (population weighted within state)
rename state state_abbr
merge m:1 state_abb using Data\Census\state_fips, keep(master match) nogen
merge m:1 state_name using Data\Census\population, keep(master match) nogen
gen year=year(date)
collapse (mean) hdd	cdd [aweight=population], by(year) //mean daily count
sum hdd if year==2007
	local temp1=r(mean)
sum hdd if year==2013
	local temp2=r(mean)
display ln(`temp2')-ln(`temp1')
display (`temp2'-`temp1')/`temp1'

sum cdd if year==2007
	local temp1=r(mean)
sum cdd if year==2013
	local temp2=r(mean)
display ln(`temp2')-ln(`temp1')
display (`temp2'-`temp1')/`temp1'

///////////MEDIAN INCOME AND POPULATION, BY REGION, REAL AND NOMINAL
insheet using Data\Census\ST-EST00INT-01.csv, comma clear
keep v1 v10
rename v1 state_name
rename v10 population_2007
drop in 1/4
drop in 57/66
destring, replace ignore(",")
replace state=subinstr(state,".","",.)
compress
saveold Data\Census\population_2007, replace

insheet using Data\Census\NST-EST2014-01.csv, comma clear
keep v1 v7
rename v1 state_name
rename v7 population_2013
drop in 1/4
drop in 57/63
destring, replace ignore(",")
replace state=subinstr(state,".","",.)
compress
saveold Data\Census\population_2013, replace

//2013 dollars:
import excel using Data\Census\h08.xls, first cellrange(A59:BI113) clear
rename DOLLARS state_name
keep state B N
rename B median_2013
rename N median_2007
drop in 1/2
destring, replace

merge 1:1 state_name using Data\Census\population_2007, keep(master match) nogen
merge 1:1 state_name using Data\Census\population_2013, keep(master match) nogen

sum median_2007 if state=="United States"
	local temp1=r(mean)
sum median_2013 if state=="United States"
	local temp2=r(mean)
display ln(`temp2')-ln(`temp1')
display (`temp2'-`temp1')/`temp1'

replace population_2007=population_2007/10^6
replace population_2013=population_2013/10^6
sum population_2007 if state=="United States"
	local temp1=r(mean)
sum population_2013 if state=="United States"
	local temp2=r(mean)
display ln(`temp2')-ln(`temp1')
display (`temp2'-`temp1')/`temp1'

drop if state=="United States"
replace state_name="District Of Columbia" if state_name=="D.C."
merge 1:1 state_name using Data\Census\state_fips, keep(master match) nogen
rename state_abbr state
merge 1:m state using Data\NOAA\monthly_degree_days, keep(master match) nogen
drop if state=="AK"|state=="DC"|state=="HI"
collapse (mean) hdd cdd, by(state_name median_2013 median_2007 population_2013 population_2007)
isid state_name
sum hdd, detail

gen climate="hot" if hdd<14.8
replace climate="cold" if hdd>=14.8
tab state if climate=="hot"
tab state if climate=="cold"

sum median_2007 if climate=="hot"
	local temp1=r(mean) //average of each state's median income
sum median_2013 if climate=="hot"
	local temp2=r(mean)
display (`temp2'-`temp1')/`temp1'	

sum median_2007 if climate=="cold"
	local temp1=r(mean) //average of each state's median income
sum median_2013 if climate=="cold"
	local temp2=r(mean)
display (`temp2'-`temp1')/`temp1'	

sum population_2007 if climate=="hot"
	local temp1=r(mean)*r(N) //total population across hot states
	display `temp1'
sum population_2013 if climate=="hot"
	local temp2=r(mean)*r(N)
	display `temp2'
display (`temp2'-`temp1')/`temp1'	

sum population_2007 if climate=="cold"
	local temp1=r(mean)*r(N) //total population across cold states
	display `temp1'
sum population_2013 if climate=="cold"
	local temp2=r(mean)*r(N)
	display `temp2'
display (`temp2'-`temp1')/`temp1'		


////////////FOSSIL FUEL GENERATION
insheet using Data\EIA\Other\Net_generation_for_all_sectors.csv, comma clear
//thousand mwh
forval v=4/16{
	local y=`v'-3+2000
	rename v`v' elec`y'
	replace elec`y'=elec`y'/10^6 //billion mwh
}
drop v2 v3
drop in 1/7
compress
replace v1=subinstr(v1,"United States : ","",.)
gen fuel="all" if v1=="all fuels"
	order v1 fuel
	replace fuel="fossil" if v1=="coal"|v1=="petroleum liquids"|v1=="petroleum coke"|v1=="natural gas"
	replace fuel="hydro" if strmatch(v1,"*hydro*")
	replace fuel="renewables" if v1=="other renewables"
	replace fuel="nuclear" if v1=="nuclear"
	replace fuel="other" if v1=="other"|v1=="other gases"
	tab fuel, missing
	rename v1 fuel_detailed
isid fuel_detailed
gen percentchange=(elec2013-elec2007)/elec2007
gen change=elec2013-elec2007
table fuel_d, contents(mean elec2007 mean elec2013 mean percentchange)	
table fuel_d, contents(mean elec2007 mean elec2013 mean change)

collapse (sum) elec*, by(fuel)
gen percentchange=(elec2013-elec2007)/elec2007
gen change=elec2013-elec2007
table fuel, contents(mean elec2007 mean elec2013 mean percentchange)
table fuel, contents(mean elec2007 mean elec2013 mean change)
// fossil fuel gen dropped 9%, a combination of a fall in total electricity demand (recession + efficiency, presumably) and a rise in renewables output


//graphically, not used, to see changes in year 2008-2012
insheet using Data\EIA\Other\Net_generation_for_all_sectors.csv, comma clear
//thousand mwh
forval v=4/16{
	local y=`v'-3+2000
	rename v`v' elec`y'
	replace elec`y'=elec`y'/10^6 //billion mwh
}
drop v2 v3
drop in 1/7
compress
replace v1=subinstr(v1,"United States : ","",.)
reshape long elec, i(v1) j(year)
replace v1=subinstr(v1," ","_",.)
replace v1=subinstr(v1,"-","",.)
replace v1="pumped_storage" if strmatch(v1,"*pumped_storage*")
rename elec elec_
reshape wide elec_, i(year) j(v1) string
scatter elec_all year, connect(l) xline(2007 2013)
scatter elec_coal elec_natural year, connect(l l) xline(2007 2013)
gen elec_fossil=elec_coal+elec_natural
scatter elec_fossil year, connect(l) xline(2007 2013)
gen elec_all_other=elec_other+elec_other_gases+elec_petroleum_coke+elec_petroleum_liquids+elec_pumped
scatter elec_fossil elec_conv elec_nuclear elec_other_renewables elec_all_other year, ///
	connect(l l l l l) xline(2007 2013)
scatter elec_conv elec_nuclear elec_other_renewables elec_all_other year, ///
	connect(l l l l l) xline(2007 2013)	


////////MANUFACTURING, NON-GAS INTENSIVE SECTORS. 
//Requires running first: manufintensity.do, which compiles the data
use Data\Manufacturing\ManufOutputAndGasIntensity.dta, clear
sum gasreq [aweight=BEAindout], detail
local median=r(p50)

sum emp2007 if gasreq<`median'
local temp1=r(mean)*r(N)
sum emp2012 if gasreq<`median'
local temp2=r(mean)*r(N)
display `temp1'/10^6
display `temp2'/10^6
display (`temp2'-`temp1')/`temp1'

sum estab2007 if gasreq<`median'
local temp1=r(mean)*r(N)
sum estab2012 if gasreq<`median'
local temp2=r(mean)*r(N)
display `temp1'/10^3
display `temp2'/10^3
display (`temp2'-`temp1')/`temp1'
