cd "C:\Users\chausman\Desktop\Data package to post"

//NUMBERS CITED IN TEXT
//Requires running first: data.do, which cleans and compiles the raw data

//////////////
//STYLIZED FACTS
//////////////

//NUMBERS IN TEXT
use Data\statedata, clear

//growth in marketed production 1997 to 2007, 
summarize production_market if year==1997 & state_a=="US"
local temp1=r(mean) //mmcf per month
summarize production_market if year==2007 & state_a=="US"
local temp2=r(mean)
disp ln(`temp2')-ln(`temp1')
disp (`temp2'-`temp1')/`temp1'
//2 percent total over 10 years

//growth in marketed producion 2007 to 2013
summarize production_market if year==2007 & state_a=="US"
local temp1=r(mean) //mmcf per month
summarize production_market if year==2013 & state_a=="US"
local temp2=r(mean) //mmcf per month
disp ln(`temp2')-ln(`temp1')
disp (`temp2'-`temp1')/`temp1'
//27 percent total over 5 years
disp (`temp2'-`temp1')*12/10^6 //mmcf per month to tcf per year

//shale production in late 2013 (gross withdrawals)
summarize withdrawals_shale if year==2013 & state_a=="US" & month>6 //mmcf
disp r(mean)/10^6 //trillion cf per month - since this is "late 2013," we don't want annual

//non-shale production (gross withdrawals)
gen temp1=withdrawals_gross-withdrawals_shale
gen temp2=withdrawals_gaswells+withdrawals_oilwells+withdrawals_coalbed
compare temp1 temp2
//scatter temp2 ym if state_a=="US" 
summarize temp1 if year==2007 & state_a=="US"
local temp1=r(mean)
summarize temp1 if year==2013 & state_a=="US"
local temp2=r(mean)
disp ln(`temp2')-ln(`temp1')
disp (`temp2'-`temp1')/`temp1' //20 percent fall

//Henry Hub average 2000 to 2010
sum henryhub_dmcf_real if year>=2000 & year<=2010 & state_a=="US" // real 2013 dollars per mcf

//Henry Hub average since 2010, real 2013 dollars per mcf
sum henryhub_dmcf_real if year>2010  & state_a=="US"

//Henry Hub average 2007
sum henryhub_dmcf_real if year==2007 & state_a=="US" // real 2013 dollars per mcf

//Henry Hub average 2013
sum henryhub_dmcf_real if year==2013  & state_a=="US" // real 2013 dollars per mcf

//shale per day, 2007, NOTE THESE ARE gross withdrawals
sum withdrawals_shale_mmcf if year==2007 & state_a=="US"
display r(mean)*12/365/1000 //mmcf per month to bcf per day

//shale per day, 2013, NOTE THESE ARE gross withdrawals
sum withdrawals_shale_mmcf if year==2013 & state_a=="US"
display r(mean)*12/365/1000 //mmcf per month to bcf per day

//shale annual vs gross annual in 2007
sum withdrawals_gross_mmcf if year==2007 & state_a=="US"
local temp1=r(mean)*12
display `temp1'/10^6 //tcf
sum withdrawals_shale_mmcf if year==2007 & state_a=="US"
local temp2=r(mean)*12
display `temp2'/10^6 //tcf
display `temp2'/`temp1'

//crude oil production change http://www.eia.gov/dnav/pet/hist/LeafHandler.ashx?n=PET&s=MCRFPUS1&f=A
disp ln(2718571)-ln(1853166)
disp (2718571-1853166)/1853166

//crude oil prices (CHANGE TO REAL)
use Data\EIA\Prices\wti, clear
sum wti if year==2014 & month<=6
sum wti if year==2014 & month>9
table month if year==2014, contents(mean wti count wti)
//we say "50 $ by start of 2014, which is off of daily data at 
// http://www.eia.gov/dnav/pet/hist/LeafHandler.ashx?n=PET&s=RWTC&f=D

//marketed production up to 2007, by state
use Data\statedata, clear
gen temp=month+1
gen daysinmonth=mdy(temp,1,year)-mdy(month,1,year)
replace daysinmonth=31 if month==12	
tab month daysinmonth 
drop temp
gen production_market_perday=production_market/daysinmonth
sum year
summarize production_market_perday if year>=1997 & year<=2007 & state_a=="US"
display r(mean)/1000 //mmcf to bcf per day
table state_a if year>=1990 & year<=2007 & production_market_perday!=., ///
	contents(mean production_market_perday count production_market_perday)
foreach state in LA NM OK TX WY fedoffshore US{
	summarize production_market_perday if year>=1997 & year<=2007 & state_a=="`state'"
	local temp`state'=r(mean)
}
disp (`tempLA'+`tempTX'+`tempOK')/(`tempUS'-`tempfedoffshore')

//marketed production vs gross withdrawals
use Data\statedata, clear
sum production_market if state_a=="US" & withdrawals_gross!=.
local temp1=r(mean)
sum withdrawals_gross if state_a=="US" & production_market!=.
local temp2=r(mean)
disp `temp1'/`temp2'
gen temp=production_market/withdrawals_gross
sum temp if state_a=="US"

//drop in residential bills
use Data\statedata, clear
gen bill_resi=deliv_resi*1000*price_resi_real //mmcf per month to mcf, times real dollars per mcf
sum bill_resi if state_a=="US" & year==2007
local temp1=r(mean)*12/10^9 //billion dollars per year
sum bill_resi if state_a=="US" & year==2013
local temp2=r(mean)*12/10^9 //billion dollars per year
disp `temp1'
disp `temp2'
disp `temp2'-`temp1' //billion dollars per year

//change in residential bills, from fracking (use 2013 scale parameter in both.)
// (eq. price + markup in millions per bcf) * (quantity in bcf at that price, given 2013 demand)
// (eq. price + markup in millions per bcf) * (2013 scale parameter * (price + markup)^elasticity)
local temp1=(7.329+8.58)*10^6*(677.6038*(7.329+8.58)^-0.2) //bills in counterfactual
local temp2=(3.877+8.58)*10^6*(677.6038*(3.877+8.58)^-0.2) //bills in 2013
disp `temp1'*12
disp `temp2'*12
disp (`temp2'-`temp1')*12/10^9 //causal drop in bill totals, billions per year

disp (`temp2'-`temp1')*12/(3.165*10^8) //per person, all US: 3.165e+08 (below)
disp (`temp2'-`temp1')*12/115610216 //per household, all US 2009-2013: 115,610,216 (http://quickfacts.census.gov/qfd/states/00000.html)
	//makes sense -- about 2.5 people per household
disp (`temp2'-`temp1')*12/66723049 //per household, gas using (# of natural gas residential consumers, 2013: 66,723,049 (http://www.eia.gov/dnav/ng/ng_cons_num_a_EPG0_VN3_Count_a.htm)
	//verifying this: In 20091, about 61% of all U.S. households (residential sector) used natural gas. (http://www.eia.gov/tools/faqs/faq.cfm?id=49&t=8)
	
//use Data\Census\population_2013, clear
//sum population_2013 if state_name=="United States"


//size of the sector in 2013
use Data\statedata, clear
keep if state_a=="US"
quietly sum henryhub_dmcf_real if year==2013
local temp1=r(mean)
quietly sum production_market if year==2013
local temp2=r(mean)
display 12*`temp1'*`temp2' //thousand dollars per year
display 12*`temp1'*`temp2'/10^6 //98 billion dollars

replace price_elec_real=price_city_real
foreach v in resi comm indu elec{
	sum price_`v'*_real if year==2013
	local temp1`v'=r(mean)
	sum deliv_`v' if year==2013
	local temp2`v'=r(mean)
}
display 12*(`temp1resi'*`temp2resi'+`temp1comm'*`temp2comm'+`temp1indu'*`temp2indu'+`temp1elec'*`temp2elec') //thousand dollars
display 12*(`temp1resi'*`temp2resi'+`temp1comm'*`temp2comm'+`temp1indu'*`temp2indu'+`temp1elec'*`temp2elec')/10^6 //billion dollars
//163 billion dollars

//surplus change compared to gdp
import excel using Data/Fed/GDPDEF.xls, cellrange(A17) first clear 
	quietly sum VALUE if DATE==mdy(1,1,2009) //because real series below is in 2009 dollars
	local def1=r(mean)
	quietly sum VALUE if DATE==mdy(1,1,2013)
	local def2=r(mean)
use Data/Fed/GDP_real, clear //billions of 2009 dollars
	gen gdp_2013dollars=gdp/`def1'*`def2'
	sum gdp_2013dollars if year==2013
	local temp2=r(mean)
disp 47.802537/`temp2'

//surplus change per person
use Data\Census\population_2013, clear
sum population_2013 if state_name=="United States"
display 47.802537*10^9/r(mean) //surplus increase of 48 billion in 2013

use Data\Census\population_20102014, clear
sum population_2013 
display 47.802537*10^9/(r(mean)*r(N)) //surplus increase of 48 billion in 2013

//PRODUCTION AND PRICES ON SAME GRAPH. STARTING WITH RAW DATA, TO INCLUDE 2014	
use Data\EIA\Prices\henryhub_monthly, clear
gen henryhub_dmcf=henryhub_monthly*1.025
merge 1:1 year month using Data\Fed\CPI_LEG_NS, keep(master match) nogen
quietly sum cpi_leg if year==2013
	local temp=r(mean)
foreach v in henryhub_dmcf{
	gen `v'_real=`v'/cpi_leg*`temp'
}
gen ym=ym(year, month)
	format %tm ym
label variable henryhub_dmcf_real "Henry Hub natural gas"
merge 1:1 year month using Data\EIA\Supply\production_summary, keep(match) nogen
	//only plot months with observations on both p and q
foreach v in withdrawals_gross withdrawals_shale production_m{
	replace `v'=`v'/1000 //bcf
}
gen temp=month+1
gen daysinmonth=mdy(temp,1,year)-mdy(month,1,year)	
replace daysinmonth=31 if month==12
tab month daysinmonth 
drop temp
gen withdrawals_gross_perday=withdrawals_gross/daysinmonth //bcf per day
gen withdrawals_shale_perday=withdrawals_shale/daysinmonth
label variable withdrawals_gross_perday "Natural gas withdrawals"
label variable withdrawals_shale_perday "Natural gas withdrawals from shale"
label variable henryhub_dmcf_real "Henry Hub price"
twoway (scatter henryhub_dmcf_real ym, ///
	xtitle("") ytitle("Real dollars per mcf", axis(1)) ///
	msymbol(O) connect(l) lcolor(orange) lpattern() mcolor(orange) lwidth() tlabel(1997m1(36)2014m9) yaxis(1))	///
	scatter withdrawals_gross_perday withdrawals_shale_perday    ym, ///
	xtitle("") ytitle("Bcf per day", axis(2)) legend(col(1)) graphregion(color(white)) ///
	msymbol(none none) connect(l l) lcolor(black gs8)  ///
	lwidth(medthick medthick) lpattern(solid dash) yaxis(2)
graph export "paper\imagefiles\supply_pandq_timeseries.png", as(png) width(2400) replace		
	
//wells 
use Data\statedata, clear	
scatter wells_all_gas ym, ///
	xtitle("") ytitle("Natural gas wells drilled per month") graphregion(color(white)) ///
	msymbol(none) connect(l) lcolor(black) lwidth(medthick)
	graph export "paper\imagefiles\wells_timeseries.png", as(png) width(2400) replace

//consumption and net exports
use Data\statedata, clear	
keep if state_abb=="US"
xtset fips ym ,monthly
gen net_exports=exports-imports
gen dinventories=d.inventories
gen temp=month+1
gen daysinmonth=mdy(temp,1,year)-mdy(month,1,year)	
replace daysinmonth=31 if month==12
foreach v in deliv_comm deliv_res deliv_elec deliv_indu net_exports{
	replace `v'=`v'/1000/daysinmonth //mmcf per month to bcf per day
}
label variable deliv_comm "Commercial"
label variable deliv_resi "Residential"
label variable deliv_elec "Electric power"
label variable deliv_indu "Industrial"
label variable net_exports "Net exports"
label variable invent "Change in Inventories"
scatter deliv_comm deliv_res deliv_elec deliv_indu net_exports ym if year>=2010, ///
	xtitle("") ytitle("Bcf per day") graphregion(color(white)) ///
	msymbol(none none none none none) connect(l l l l l) ///
	lcolor(gs8 gs8 orange black green)  ///
	lwidth(medium thick thick thick medium) lpattern(shortdash solid longdash dash dash) 
	graph export "paper\imagefiles\demand_timeseries.png", as(png) width(2400) replace
	
//domestic price of n.g. using raw data to include 2014.
//REQUIRES BLOOMBERG DATA -- NOT POSTED ONLINE
use Data\EIA\Prices\henryhub_monthly, clear
gen henryhub_dmcf=henryhub_monthly*1.025
merge 1:1 year month using Data\Fed\CPI_LEG_NS, keep(master match) nogen
quietly sum cpi_leg if year==2013
	local temp=r(mean)
foreach v in henryhub_dmcf{
	gen `v'_real=`v'/cpi_leg*`temp'
}
gen ym=ym(year, month)
	format %tm ym
label variable henryhub_dmcf_real "Henry Hub natural gas"
//domestic and international prices of n.g. and oil. using raw data to include 2014.
merge 1:1 year month using Data\Bloomberg\uknbp_monthly, keep(master match) nogen //NOT MERGED: early years
merge 1:1 year month using Data\Fed\usd_per_gbp_monthly, keep(master match) nogen //NOT MERGED: early years
	gen uknbp_dmcf=uknbp_gbptherm*usd_per_gbp/0.1/100*1.025 //0.1 mmbtu per therm, and 100 pence per pound, and 1.025 mmbtu per mcf
merge 1:1 year month using Data\EIA\Prices\brent, keep(master match) nogen //NOT MERGED: early
merge 1:1 year month using Data\EIA\Prices\wti, keep(master match) nogen //NOT MERGED: early
merge 1:1 year month using Data\pinksheet, keep(master match) nogen
	gen ngprice_jp_dmcf=ngprice_jp_dmmbtu*1.025
quietly sum cpi_leg if year==2013
	local temp=r(mean)
foreach v in uknbp_dmcf wti brent ngprice_jp_dmcf{
	gen `v'_real=`v'/cpi_leg*`temp'
}
label variable uknbp_dmcf_real "UK NBP natural gas"
label variable wti_real "WTI crude oil"
label variable brent_real "Brent crude oil"
label variable ngprice_jp_dmcf_real "Japan LNG"
twoway (scatter ngprice_jp_dmcf_real uknbp_dmcf_real henryhub_dmcf_real   ym, ///
	xtitle("") ytitle("Real dollars per mcf") graphregion(color(white)) ///
	msymbol(none none o) connect(l l l) lcolor(green black orange) mcolor(green black orange) ///
	lwidth(thick med medthick) tlabel(1998m1(48)2015m2) legend(col(1))) 
	graph save paper\imagefiles\temp1, replace	
	graph export "paper\imagefiles\intlgas_timeseries.png", as(png) width(2400) replace	
twoway (scatter brent_real wti_real  ym, ///
	xtitle("") ytitle("Real dollars per barrel") graphregion(color(white)) ///
	msymbol(none o o) connect(l l l) lcolor(black orange gs8) mcolor(black orange gs8) ///
	lwidth(med medthick) tlabel(1998m1(48)2015m2) legend(col(1))) 
	graph save paper\imagefiles\temp2, replace	
	gr combine paper\imagefiles\temp1.gph paper\imagefiles\temp2.gph, graphregion(color(white))
	graph export "paper\imagefiles\gasoil_timeseries.png", as(png) width(2400) replace	


//INVENTORIES AND WEATHER
use Data\statedata, clear
keep if state_a=="US"
newey inventories hdd_national_wtd cdd_national_wtd MM*, lag(18)
newey d.inventories d.hdd_national_wtd d.l.hdd_national_wtd d.l2.hdd_national_wtd d.l3.hdd_national_wtd ///
	d.l4.hdd_national_wtd d.l5.hdd_national_wtd d.l6.hdd_national_wtd d.l7.hdd_national_wtd ///
	d.l8.hdd_national_wtd d.l9.hdd_national_wtd d.l10.hdd_national_wtd d.l11.hdd_national_wtd d.l12.hdd_national_wtd MM* ///
	, lag(18)
newey inventories hdd_national_wtd l.hdd_national_wtd l2.hdd_national_wtd l3.hdd_national_wtd ///
	l4.hdd_national_wtd l5.hdd_national_wtd ///
	l6.hdd_national_wtd l7.hdd_national_wtd l8.hdd_national_wtd l9.hdd_national_wtd ///
	l10.hdd_national_wtd l11.hdd_national_wtd l12.hdd_national_wtd MM* ///
	, lag(18)
forval v=2/12{
	newey inventories hdd_national_wtd l.hdd_national_wtd cumul_hdd_n`v' MM*, lag(18)
}

//"RESULTS SIMILAR IF WE USE ELECTRIC POWER PRICE " WHICH HAS MANY MISSING VALUES
use Data\statedata, clear
set matsize 800
xtset fips ym, monthly 
local v elec
xtivreg2 lndeliv_`v' l.lndeliv_`v' (lnprice_`v'_real = cumul_hdd_o12) ///
	hdd cdd l.hdd l.cdd SM* Time1 if year>=2002 & state_a!="US" & deliv_elec!=0 & l.deliv_elec!=0, ///
	first fe cluster(state_a ym) partial(SM* Time1)
	nlcom _b[lnprice_`v'] / (1-_b[l.lndeliv_`v'])
	
//"RESULTS SIMILAR IF WE DROP STATES THAT HAD WITHHELD DELIV_ELEC"
set matsize 800
use Data\statedata, clear
replace lnprice_elec_real=lnprice_city_real
gen temp1=1 if lndeliv_elec==. & year>=2001
	bysort fips: egen temp2=max(temp1)
	bysort fips year: egen temp3=max(temp1)
xtset fips ym, monthly 
local v elec
xtivreg2 lndeliv_`v' l.lndeliv_`v' (lnprice_`v'_real = cumul_hdd_o12) ///
	hdd cdd l.hdd l.cdd SM* Time1 if year>=2002 & state_a!="US" & temp2!=1, ///
	first fe cluster(state_a ym) partial(SM* Time1)
	nlcom _b[lnprice_`v'] / (1-_b[l.lndeliv_`v'])
xtivreg2 lndeliv_`v' l.lndeliv_`v' (lnprice_`v'_real = cumul_hdd_o12) ///
	hdd cdd l.hdd l.cdd SM* Time1 if year>=2002 & state_a!="US" & temp3!=1, ///
	first fe cluster(state_a ym) partial(SM* Time1)
	nlcom _b[lnprice_`v'] / (1-_b[l.lndeliv_`v'])	

//"RESULTS SIMILAR IF WE DROP OBSERVATIONS RECORDED AS ZERO DELIV_ELEC"
use Data\statedata, clear
xtset fips ym, monthly 
replace lnprice_elec_real=lnprice_city_real
local v elec
xtivreg2 lndeliv_`v' l.lndeliv_`v' (lnprice_`v'_real = cumul_hdd_o12) ///
	hdd cdd l.hdd l.cdd SM* Time1 if year>=2002 & state_a!="US" & deliv_elec!=0 & l.deliv_elec!=0, ///
	first fe cluster(state_a ym) partial(SM* Time1)
	nlcom _b[lnprice_`v'] / (1-_b[l.lndeliv_`v'])

//"RESULTS SIMILAR IF WE USE WELLHEAD PRICE RATHER THAN HH FOR SUPPLY ESTIMATION"
use Data\statedata, clear
xtset fips ym, monthly 
quietly sum cpi_leg if year==2013
	local temp=r(mean)
foreach v in price_wellhead_dmcf{
	gen `v'_real=`v'/cpi_leg*`temp'
	gen ln`v'_real=ln(`v'_real)
}
ivreg2 lnwells_all_gas l.lnwells_all_gas (lnprice_wellhead_dmcf_real = l.hdd_national_wtd l.cdd_national_wtd) ///
	hdd_national_wtd cdd_national_wtd MM* Time1 if year>=2002 & state_a=="US", ///
	first robust bw(18) 
	lincom hdd_n*100
	lincom cdd_n*100
	nlcom _b[lnprice_wellhead_dmcf_real] / (1-_b[l.lnwells_all_gas])
