cd "C:\Users\chausman\Desktop\Data package to post"

**BPEA MANUFACTURING ACTIVITY
**COMPARE INDUSTRIES WITH DIFFERENT GAS INTENSITIES

/*
STEPS TO FOLLOW:
1. Merge concordance table with 2007 BEA vector of natural gas intensity.
Consolidate two sets of BEA codes that are many-to-one relative to the economic census.
2. Clean data for each of the 2002, 2007, and 2012 economic censes. Drop unneeded variables.
Deal with text entries for revised / missing data
3. Merge the EC data with the concordance table and nat gas intensity.
4. Plot out manuf activity in gas intense vs. non-intense NAICS codes.
*/

/////////////////
// STEP 1
/////////////////
insheet using Data\Manufacturing\BEA_EconCensus_Concordance.csv, clear
	keep bea_iocode finalcode
	sort bea_iocode
	drop if bea_iocode==""	/* one blank for final code 339100 */
	duplicates drop
	isid bea
	saveold Data\Manufacturing\bea_x_finalcode.dta, replace
insheet using Data\Manufacturing\GasTotalReq_Manuf.csv, clear
	rename code bea_iocode
	drop if bea_iocode==""	/* lots of empty rows got into the csv file */
	merge 1:1 bea_iocode using Data\Manufacturing\bea_x_finalcode.dta, nogen /* must be all 3 */
	isid bea
	saveold Data\temp.dta, replace
* Bring in direct gas requirements
insheet using Data\Manufacturing\GasDirectReq_Manuf.csv, clear
	rename code bea_iocode
	merge 1:1 bea_iocode using Data\temp.dta, nogen /* must be all 3 */
	isid bea
	corr gasdir gastot
	sum gasdir gastot
* Consolidate many-to-one matches; take weighted averages of gas intensity
rename gastotalrequirement gasreq
	rename gasdirectrequirement gasdirreq
	rename totalindustryoutput BEAindout
	rename industrydescription ind_desc
	replace ind_desc = "Nonferrous metal (except aluminum) smelting and refining" if finalcode=="331410"
	replace ind_desc = "Other industrial machinery manufacturing" if finalcode=="33329A"
	replace ind_desc = "Other commercial and service industry machinery manufacturing" if finalcode=="333318"
	replace ind_desc = "Medical equipment and supplies manufacturing" if finalcode=="339100"
	duplicates report finalcode
	duplicates report finalcode ind_desc

	gen outtimesreq = gasreq * BEAindout
	gen outtimesdirreq = gasdirreq * BEAindout
	sort finalcode ind_desc
	isid bea //all the following sums make sense, since these variables were at the bea level, and we are summing across unique bea codes
	collapse (sum) outtimesreq outtimesdirreq BEAindout, by(finalcode ind_desc) 
		//can't do as weighted mean collapse because want sum of BEAindout
	gen gasreq = outtimesreq / BEAindout
	gen gasdirreq = outtimesdirreq / BEAindout
	drop outtimesreq outtimesdirreq

isid finalcode
compress
saveold Data\Manufacturing\GasIntens_ByFinalCode.dta, replace


/////////////////
// STEP 2
/////////////////
* 2002 EC
clear
insheet using Data\Manufacturing\EcCensus2002_ToStata.csv
* Keep only most important vars
keep naicsid naicsdisplaylabel yearid company estab emp payabent rcptot valadd cextot 
label variable company "Number of companies"
label variable estab "Number of establishments"
label variable emp "Number of employees"
label variable payabent "Total compensation ($1,000)"
label variable rcptot "Total value of shipments ($1,000)"
label variable valadd "Value added ($1,000)"
label variable cextot "Total capital expenditures (new and used) ($1,000)"
* Deal with revised numbers that have an (r) next to them. This happens for NAICS 313312 and all cextot data
destring company estab emp payabent rcptot valadd cextot, replace ignore("(r)")
rename naicsid EconCensusCode2002
drop naicsdisplaylabel
foreach var of varlist(company-cextot) {
	rename `var' `var'2002
}
drop yearid
sort EconCensusCode2002
isid Econ
saveold Data\EC2002temp.dta, replace

* 2007 EC
clear
insheet using Data\Manufacturing\EcCensus2007_ToStata.csv
* Keep only most important vars
keep naicsid naicsdisplaylabel yearid company estab emp payann benefit rcptot valadd cextot 
label variable company "Number of companies"
label variable estab "Number of establishments"
label variable emp "Number of employees"
label variable payann "Annual payroll ($1,000)"
label variable benefit "Total fringe benefits ($1,000)"
label variable rcptot "Total value of shipments ($1,000)"
label variable valadd "Value added ($1,000)"
label variable cextot "Total capital expenditures (new and used) ($1,000)"
* Destringing
* cextot and valadd each have two sectors with "D" recorded; indicating that data are not divulged.
* Force replace for now, and carry missing values forward
destring company estab emp payann benefit rcptot valadd cextot, replace ignore("(r)") force
gen MissFlag = 0
	replace MissFlag = 1 if valadd==. | cextot==.
* Deal with revised numbers that have an (r) next to them. Scattered throughout company, estab, and emp
rename naicsid EconCensusCode2007
* Get total compensation
gen payabent = payann + benefit		/* same as 2002 census */
label variable payabent "Total compensation ($1,000)"
drop payann benefit
drop naicsdisplaylabel
order EconCensusCode2007 yearid company estab emp payabent
foreach var of varlist(company-cextot) {
	rename `var' `var'2007
}
rename MissFlag MissFlag2007
drop yearid
sort EconCensusCode2007
isid Econ
saveold Data\EC2007temp.dta, replace

* 2012 EC
clear
insheet using Data\Manufacturing\EcCensus2012_ToStata.csv
* Keep only most important vars
keep naicsid naicsdisplaylabel yearid company estab emp payann benefit rcptot valadd cextot 
label variable company "Number of companies"
label variable estab "Number of establishments"
label variable emp "Number of employees"
label variable payann "Annual payroll ($1,000)"
label variable benefit "Total fringe benefits ($1,000)"
label variable rcptot "Total value of shipments ($1,000)"
label variable valadd "Value added ($1,000)"
label variable cextot "Total capital expenditures (new and used) ($1,000)"
* Destringing
* emp through rcptot have "D" recorded for NAICS 335224; indicating that data are not divulged.
* Force replace for now, and carry missing values forward
destring company estab emp payann benefit rcptot valadd cextot, replace ignore("(r)") force
gen MissFlag = 0
	replace MissFlag = 1 if valadd==.
rename naicsid EconCensusCode2012
* Get total compensation
gen payabent = payann + benefit		/* same as 2002 census */
label variable payabent "Total compensation ($1,000)"
drop payann benefit
drop naicsdisplaylabel
order EconCensusCode2012 yearid company estab emp payabent
foreach var of varlist(company-cextot) {
	rename `var' `var'2012
}
rename MissFlag MissFlag2012
drop yearid
sort EconCensusCode2012
isid Econ
saveold Data\EC2012temp.dta, replace



/////////////////
// STEP 3
/////////////////
insheet using Data\Manufacturing\BEA_EconCensus_Concordance.csv, clear 
	keep econcensuscode2002 finalcode
	duplicates drop
	rename econcensuscode2002 EconCensusCode2002
	sort EconCensusCode2002
	merge EconCensusCode2002 using Data\EC2002temp.dta
	tab _merge
	drop _merge
	sort finalcode
	collapse (sum) company2002-cextot2002, by(finalcode)
	sort finalcode
	saveold Data\temp2002.dta, replace
insheet using Data\Manufacturing\BEA_EconCensus_Concordance.csv, clear
	keep econcensuscode2007 finalcode
	duplicates drop
	rename econcensuscode2007 EconCensusCode2007
	sort EconCensusCode2007
	merge EconCensusCode2007 using Data\EC2007temp.dta
	tab _merge	/* only 1 is 339100 */
	drop _merge
	sort finalcode
	collapse (sum) company2007-MissFlag2007, by(finalcode)
	sort finalcode
	saveold Data\temp2007.dta, replace
insheet using Data\Manufacturing\BEA_EconCensus_Concordance.csv, clear
	keep econcensuscode2012 finalcode
	duplicates drop
	rename econcensuscode2012 EconCensusCode2012
	sort EconCensusCode2012
	merge m:1 EconCensusCode2012 using Data\EC2012temp.dta
	tab _merge	/* only 1 is 339100 */
	drop _merge
	sort finalcode
	collapse (sum) company2012-MissFlag2012, by(finalcode)
	sort finalcode
	saveold Data\temp2012.dta, replace
	
use Data\Manufacturing\GasIntens_ByFinalCode.dta, clear
isid final
merge 1:1 finalcode using Data\temp2002.dta
drop _merge
merge 1:1 finalcode using Data\temp2007.dta
drop _merge
merge 1:1 finalcode using Data\temp2012.dta
drop _merge
* Drop sectors with missing data
tab finalcode if MissFlag2007>0		/* 316000 (leather & allied prod), 331410 (non-iron, non-aluminum smelting) */
tab finalcode if MissFlag2012>0		/* 335224 (household laundry equip manuf) */
drop if finalcode=="339100"		/* medical equipment; 2002 sector 339111 doesn't match up to anything; no "other" category */
drop MissFlag*
* saveold dataset
sort finalcode
saveold Data\Manufacturing\ManufOutputAndGasIntensity.dta, replace




/////////////////
// STEP 4
/////////////////
use Data\Manufacturing\ManufOutputAndGasIntensity.dta, clear
sort finalcode
* Get percentiles of gas intensity (unweighted and weighted by 2007 BEA IO total industry output)
xtile gaspct = gasreq, nq(100)
xtile gaspctw = gasreq [aweight = BEAindout], nq(100)
xtile gasdpct = gasdirreq, nq(100)
xtile gasdpctw = gasdirreq [aweight = BEAindout], nq(100)
order finalcode ind_desc BEAindout gasreq gasdirreq gaspct gaspctw gasdpct gasdpctw
sort gaspctw gasreq
order finalcode ind_desc gasreq gaspctw BEAindout
//browse finalcode-gasdpctw emp* estab* cextot*

* Get weighted average intensity
sum gasreq 
sum gasreq [aweight=BEAindout]

//br finalcode ind_desc gasreq gaspctw BEAindout rcptot2007 if gaspctw>=90
disp (0.033766- .0183667  )/ .0183667   //90th percentile over avg
disp (.14336- .0183667  )/  .0183667   //top over avg
disp (.14336-.093674)/ .093674 //top to second

//regressions
foreach v in estab emp payabent cextot{
foreach y in 2002 2007 2012{
	gen ln`v'`y'=ln(`v'`y')
}
}
gen naics4=substr(final,1,4)
gen naics3=substr(final,1,3)
gen naics2=substr(final,1,2)
//main specification:
	areg lnemp2012 gasreq lnemp2002 lnemp2007 [aweight=BEAindout], absorb(naics3)
		lincom gasreq
		local coef=r(estimate)	
		local se=r(se)
	gen temp2=gasreq*`coef'*emp2007 //suppose hypothetical zero intensity sector experienced zero changes from gas
		sum temp2
		display r(mean)*r(N) 
		//list ind_desc temp2 if gaspctw>=90 
		drop temp2
	gen temp2=gasreq*(`coef'+1.96*`se')*emp2007 //suppose hypothetical zero intensity sector experienced zero changes from gas
		sum temp2
		display r(mean)*r(N) 
		drop temp2
	gen temp2=gasreq*(`coef'-1.96*`se')*emp2007 //suppose hypothetical zero intensity sector experienced zero changes from gas
		sum temp2
		display r(mean)*r(N) 
		drop temp2
	sum gasreq if gaspctw<90
		local temp=r(max)
		gen temp1=gasreq-`temp' //suppose 90th percentile sector experienced zero changes from gas
		gen temp2=temp1*`coef'*emp2007 if gaspctw>=90
		sum temp2
		display r(mean)*r(N)
		drop temp1 temp2
		
	//comparison to total manuf employment
	sum emp2012
	display "millions of employees in 2012, all manufacturing: " r(mean)*r(N)/10^6 

//alternative: absorbing 2-digit naics
	areg lnemp2012 gasreq lnemp2002 lnemp2007 [aweight=BEAindout], absorb(naics2)
		lincom gasreq
		local coef=r(estimate)	 
	gen temp2=gasreq*`coef'*emp2007 //suppose hypothetical zero intensity sector experienced zero changes from gas
		sum temp2
		display r(mean)*r(N) 
		//list ind_desc temp2 if gaspctw>=90 
		drop temp2
	sum gasreq if gaspctw<90
		local temp=r(max)
		gen temp1=gasreq-`temp' //suppose 90th percentile sector experienced zero changes from gas
		gen temp2=temp1*`coef'*emp2007 if gaspctw>=90
		sum temp2
		display r(mean)*r(N)
		drop temp1 temp2		
//alternative: no naics fixed effects
	reg lnemp2012 gasreq lnemp2002 lnemp2007 [aweight=BEAindout]
		lincom gasreq
		local coef=r(estimate)
	gen temp2=gasreq*`coef'*emp2007 //suppose hypothetical zero intensity sector experienced zero changes from gas
		sum temp2
		display r(mean)*r(N) 
		drop temp2
	sum gasreq if gaspctw<90
		local temp=r(max)
		gen temp1=gasreq-`temp' //suppose 90th percentile sector experienced zero changes from gas
		gen temp2=temp1*`coef'*emp2007 if gaspctw>=90
		sum temp2
		display r(mean)*r(N)
		drop temp1 temp2
//alternative: weight by employment not output:
	areg lnemp2012 gasreq lnemp2002 lnemp2007 [aweight=emp2007], absorb(naics3)
		lincom gasreq
		local coef=r(estimate)
	gen temp2=gasreq*`coef'*emp2007 //suppose hypothetical zero intensity sector experienced zero changes from gas
		sum temp2
		display r(mean)*r(N) 
		drop temp2
	sum gasreq if gaspctw<90
		local temp=r(max)
		gen temp1=gasreq-`temp' //suppose 90th percentile sector experienced zero changes from gas
		gen temp2=temp1*`coef'*emp2007 if gaspctw>=90
		sum temp2
		display r(mean)*r(N)
		drop temp1 temp2
	
//alternative: direct gas req:
	areg lnemp2012 gasdirreq lnemp2002 lnemp2007 [aweight=BEAindout], absorb(naics3)
		lincom gasdirreq
		local coef=r(estimate)	
		local se=r(se)
	gen temp2=gasdirreq*`coef'*emp2007 //suppose hypothetical zero intensity sector experienced zero changes from gas
		sum temp2
		display r(mean)*r(N) 
		//list ind_desc temp2 if gaspctw>=90 
		drop temp2

//Summary table
//also look at: for >=90 and >=95, robustness to dropping 325310
foreach v in estab emp payabent cextot{
	foreach y in 2002 2007 2012{
		quietly sum `v'`y' if gaspctw<90
		local temp`v'`y'low=r(mean)*r(N)
		quietly sum `v'`y' if gaspctw>=90
		local temp`v'`y'90=r(mean)*r(N)
		quietly sum `v'`y' if gaspctw>=95
		local temp`v'`y'95=r(mean)*r(N)
		quietly sum `v'`y' if finalcode=="325310"
		local temp`v'`y'fert=r(mean)*r(N)
	}
	foreach type in low 90 95 fert{
		local d1`v'`type'=(100*(`temp`v'2007`type''-`temp`v'2002`type'')/`temp`v'2002`type'')
		local d2`v'`type'=(100*(`temp`v'2012`type''-`temp`v'2007`type'')/`temp`v'2007`type'')
	}
	foreach type in low 90 95 fert{
		local rd1`v'`type'=round(100*(`temp`v'2007`type''-`temp`v'2002`type'')/`temp`v'2002`type'',0.1)
		local rd2`v'`type'=round(100*(`temp`v'2012`type''-`temp`v'2007`type'')/`temp`v'2007`type'',0.1)
	}
}
foreach type in low 90 95 fert{
	display "`rd1estab`type'' `rd1emp`type'' `rd1payabent`type'' `rd1cextot`type''"
	display "`rd2estab`type'' `rd2emp`type'' `rd2payabent`type'' `rd2cextot`type''"
}

display "DD"
foreach v in estab emp payabent cextot{
	display (`d2`v'90'-`d2`v'low')
}
display "DDD"
foreach v in estab emp payabent cextot{
	display (`d2`v'90'-`d2`v'low')- (`d1`v'90'-`d1`v'low')
}

foreach v in cextot{
	display (`d2`v'95'-`d2`v'low')- (`d1`v'95'-`d1`v'low')
	display (`d2`v'fert'-`d2`v'low')- (`d1`v'fert'-`d1`v'low')
}
disp `d1emplow'-`d1emp90'

//DD and DDD estimates from table, for text
sum emp2007 if gaspctw>=90
local temp=r(mean)*r(N)
display `temp' //employees in 90th percentile and above in 2007
display (`d2emp90'-`d2emplow') //DD employee % change
display `temp'*(`d2emp90'-`d2emplow')/100 //DD employee level change
display ((`d2emp90'-`d2emplow')-(`d1emp90'-`d1emplow')) //DDD employee % change
display `temp'*((`d2emp90'-`d2emplow')-	(`d1emp90'-`d1emplow'))/100 //DDD employee level change

//excluding fertilizer:
foreach v in estab emp payabent cextot{
	foreach y in 2002 2007 2012{
		quietly sum `v'`y' if gaspctw<90
		local temp`v'`y'low=r(mean)*r(N)
		quietly sum `v'`y' if gaspctw>=90 & finalcode!="325310"
		local temp`v'`y'90=r(mean)*r(N)
		quietly sum `v'`y' if gaspctw>=95 & finalcode!="325310"
		local temp`v'`y'95=r(mean)*r(N)
	}
	foreach type in low 90 95 {
		local d1`v'`type'=(100*(`temp`v'2007`type''-`temp`v'2002`type'')/`temp`v'2002`type'')
		local d2`v'`type'=(100*(`temp`v'2012`type''-`temp`v'2007`type'')/`temp`v'2007`type'')
	}
	foreach type in low 90 95 {
		local rd1`v'`type'=round(100*(`temp`v'2007`type''-`temp`v'2002`type'')/`temp`v'2002`type'',0.1)
		local rd2`v'`type'=round(100*(`temp`v'2012`type''-`temp`v'2007`type'')/`temp`v'2007`type'',0.1)
	}
}
foreach type in low 90 95 {
	display "`rd1estab`type'' `rd1emp`type'' `rd1payabent`type'' `rd1cextot`type''"
	display "`rd2estab`type'' `rd2emp`type'' `rd2payabent`type'' `rd2cextot`type''"
}
display "DD"
foreach v in estab emp payabent cextot{
	display (`d2`v'90'-`d2`v'low')
}
display "DDD"
foreach v in estab emp payabent cextot{
	display (`d2`v'90'-`d2`v'low')- (`d1`v'90'-`d1`v'low')
}

//using dirrect req instead
foreach v in estab emp payabent cextot{
	foreach y in 2002 2007 2012{
		quietly sum `v'`y' if gasdpctw<90
		local temp`v'`y'low=r(mean)*r(N)
		quietly sum `v'`y' if gasdpctw>=90
		local temp`v'`y'90=r(mean)*r(N)
		quietly sum `v'`y' if gasdpctw>=95
		local temp`v'`y'95=r(mean)*r(N)
		quietly sum `v'`y' if finalcode=="325310"
		local temp`v'`y'fert=r(mean)*r(N)
	}
	foreach type in low 90 95 fert{
		local d1`v'`type'=(100*(`temp`v'2007`type''-`temp`v'2002`type'')/`temp`v'2002`type'')
		local d2`v'`type'=(100*(`temp`v'2012`type''-`temp`v'2007`type'')/`temp`v'2007`type'')
	}
	foreach type in low 90 95 fert{
		local rd1`v'`type'=round(100*(`temp`v'2007`type''-`temp`v'2002`type'')/`temp`v'2002`type'',0.1)
		local rd2`v'`type'=round(100*(`temp`v'2012`type''-`temp`v'2007`type'')/`temp`v'2007`type'',0.1)
	}
}
foreach type in low 90 95 fert{
	display "`rd1estab`type'' `rd1emp`type'' `rd1payabent`type'' `rd1cextot`type''"
	display "`rd2estab`type'' `rd2emp`type'' `rd2payabent`type'' `rd2cextot`type''"
}

display "DD"
foreach v in estab emp payabent cextot{
	display (`d2`v'90'-`d2`v'low')
}
display "DDD"
foreach v in estab emp payabent cextot{
	display (`d2`v'90'-`d2`v'low')- (`d1`v'90'-`d1`v'low')
}
sum emp2007 if gaspctw>=90
local temp=r(mean)*r(N)
display `temp' //employees in 90th percentile and above in 2007
display (`d2emp90'-`d2emplow') //DD employee % change
display `temp'*(`d2emp90'-`d2emplow')/100 //DD employee level change
display ((`d2emp90'-`d2emplow')-(`d1emp90'-`d1emplow')) //DDD employee % change
display `temp'*((`d2emp90'-`d2emplow')-	(`d1emp90'-`d1emplow'))/100 //DDD employee level change


* Or, reshape for summary table
clear
use Data\Manufacturing\ManufOutputAndGasIntensity.dta
sort finalcode
* Get percentiles of gas intensity (unweighted and weighted by 2007 BEA IO total industry output)
xtile gaspct = gasreq, nq(100)
xtile gaspctw = gasreq [fweight = BEAindout], nq(100)
xtile gasdpct = gasdirreq, nq(100)
xtile gasdpctw = gasdirreq [fweight = BEAindout], nq(100)
order finalcode ind_desc BEAindout gasreq gasdirreq gaspct gaspctw gasdpct gasdpctw
sort gaspctw gasreq
order finalcode ind_desc gasreq gaspctw BEAindout
//browse finalcode-gasdpctw emp* estab* cextot*

* Get weighted average intensity
gen gasreqout = gasreq * BEAindout
sum gasreqout
local gr = r(mean)
sum BEAindout
local out = r(mean)
local wavg = `gr' / `out'
display `wavg'
drop gasreqout

sort finalcode
reshape long company estab emp payabent rcptot valadd cextot, i(finalcode) j(year)

* Set cutoffs
gen intense = 0
*replace intense = 1 if gaspctw>=95
*replace intense = 1 if gaspctw>=90 & finalcode~="325310"
 replace intense = 1 if finalcode=="325310"
sort intense year
collapse (sum) company-cextot, by(intense year)
* Take logs
foreach var of varlist(company-cextot) {
	replace `var' = log(`var')
}
* Get differences
sort intense year
by intense: gen yearind = _n
xtset intense yearind
foreach var of varlist(company-cextot) {
	gen D`var' = d.`var'*100
}
foreach var of varlist(company-cextot) {
	gen e_D`var'=100*exp(D`var'/100)-100
}
drop yearind

br


//--------------------------
**PRICES FOR AMMONIA, ETHANE, AND ETHYLENE
// Requires Bloomberg data.

// GREEN MARKETS FERTILIZER AMMONIA PRICES
import excel "Data\Bloomberg\chemical_data\greenmarket_ammonia_prices.xlsx", sheet("formatted") firstrow clear
drop if date==. 
  
/* Generate year and month vars */
  gen year = year(date)
  gen month = month(date)
  tab year,m
  tab month, m
  
 * Save and merge with HH gas
 sort year month
 save Data\temp.dta, replace
 clear
 use Data\Bloomberg\henryhub.dta
 drop datestring
 gen year = year(date)
 gen month = month(date)
 drop date
 sort year month
 collapse (mean) henryhub, by(year month)
 sort year month
 merge 1:1 year month using Data\temp.dta
 keep if _merge==3
 drop _merge
 tab year,m

 *convert HH from $/mmbtu to $/mcf 
 replace henryhub=henryhub*1.025
 
 * Merge with CPI, all urban less energy
 sort year month
 merge 1:1 year month using Data\Fed\CPI_LEG_NS, keep(master match) nogen
 tab year, m
 quietly sum cpi_leg if year==2013
	local temp=r(mean)
foreach v in henryhub black_sea middle_east us_cornbelt us_gulf{
	gen `v'_real=`v'/cpi_leg*`temp'
}
  
/* Graph the series */  
  sort date
  format date %dM_CY
  local x = 2005  
  twoway (line us_gulf_real date if year>`x', clcolor(black) clwidth(mthick)) /*
	*/ (line black_sea_real date if year>`x', lpattern(shortdash) clcolor(green)) /*
	*/ (line middle_east_real date if year>`x', lpattern(dash) clcolor(gs8)) /*
	*/ (line henryhub_real date if year>`x', lwidth(medthick) clcolor(orange) yaxis(2)), /*
	*/ ytitle("Price in real U.S. dollars per metric ton") xtitle("") ylabel(0(200)1000, grid) /*
	*/ ytitle("U.S. Henry Hub gas price, real $/mcf", axis(2)) ylabel(0(3)15, axis(2)) /*
	*/ legend(label(1 "U.S. Gulf Coast") label(2 "Black Sea") label(3 "Middle East") /*
	*/ label(4 "Henry Hub gas")) graphregion(color(white))
graph export Paper\imagefiles\AmmoniaPrices.png, as(png) width(2400) replace	
   
  
// NEXANT ETHANE AND HDPE, USA VS WESTERN EUROPE

* Start with ethane
import excel "Data\Bloomberg\chemical_data\nexant_ethane_prices.xlsx", sheet("formatted_quarterly") firstrow clear  

* Generate year and month vars */
gen year = year(date)
gen month = month(date)
tab year,m
tab month, m
rename usa Ethane_usa
rename western_europe Ethane_weurope

* Save and merge with HDPE
sort year month
save Data\temp.dta, replace
import excel "Data\Bloomberg\chemical_data\nexant_HDPE_prices.xlsx", sheet("formatted_quarterly") firstrow clear  
gen year = year(date)
gen month = month(date)
tab year,m
tab month, m
rename usa HDPE_usa
rename western_europe HDPE_weurope
drop southeast_asia_IM	

sort year month
merge 1:1 year month using Data\temp.dta
keep if _merge==3
drop _merge  
  
* Merge with CPI, all urban less energy
sort year month
merge 1:1 year month using Data\Fed\CPI_LEG_NS, keep(master match) nogen
tab year, m
quietly sum cpi_leg if year==2013
local temp=r(mean)
foreach v in HDPE_usa HDPE_weurope Ethane_usa Ethane_weurope{
	gen `v'_real=`v'/cpi_leg*`temp'
}  

 /* Graph the series */  
sort date
format date %dM_CY
local x = 2005  
twoway (line HDPE_usa_real date if year>`x', lpattern(dash) clcolor(orange) clwidth(thick)) /*
	*/ (line HDPE_weurope_real date if year>`x', clcolor(black) clwidth(med)) /*
	*/ (line Ethane_usa_real date if year>`x',  clcolor(orange) clwidth(medthick) mcolor(orange) yaxis(2)) /*
	*/ (line Ethane_weurope_real date if year>`x', lpattern(shortdash) clcolor(black) clwidth(med) yaxis(2)), /*
	*/ ytitle("HDPE price in real U.S. dollars per metric ton") xtitle("") ylabel(0(500)2750, grid) /*
	*/ ytitle("Ethane price in real U.S. dollars per metric ton", axis(2)) ylabel(0(200)1100, axis(2)) /*
	*/ legend(label(1 "HDPE, U.S.A.") label(2 "HDPE, Western Europe") label(3 "Ethane, U.S.A.") /*
	*/ label(4 "Ethane, Western Europe")) graphregion(color(white))
graph export Paper\imagefiles\EthaneAndHDPEPrices.png, as(png) width(2400) replace	 
  
 
