cd "M:\BPEA\BPEA Spring 2015\Comments\Cicala_to_HausmanKellogg\all_files\BPEA"

* North Dakota
import excel using "ND_Gas1990ToPresent.xls", clear firstrow
replace Date = "1-" + Date
gen temp = date(Date,"DMY")
gen modate = mofd(temp)
format modate %tm
drop Date
gen year = year(temp)
gen days = temp - temp[_n-1]
replace days = 31 if days == .
drop temp

foreach v of varlist MCF*	{
	replace `v' = `v' / (1000 * days)
}

label var oil "Oil Production (Thous. barrels per day)"
label var MCFProduced "Gas Production (Mmcf per day)"
label var MCFSold "Gas Sold (Mmcf per day)"
label var modate "Year-Month"

rename MCFProduced gas_produced
rename MCFSold gas_sold

keep gas_produced gas_sold oil modate
rename modate period
order period oil gas_produced gas_sold
save "figure_1.dta", replace


*Texas
insheet using "tx_monthly_output.txt", names tab clear
replace date = "1 " + date

gen temp = date(date,"DMY")
gen modate = mofd(temp)
format modate %tm
gen year = year(temp)
gen days = temp - temp[_n-1]
replace days = 31 if days == .
drop temp
foreach v of varlist oil casing gwgas condensate	{
	replace `v' = `v' / (1000 * days)
}
label var oil "Oil Production (Thous barrels per day)"
label var casing "Casinghead Gas Production (Mmcf per day)"
label var gwgas "Gas Well Gas Production (Mmcf per day)"
label var condensate "Condensate Production"

keep modate oil casing gwgas
rename modate period
order period oil gwgas casing
save "figure_2.dta", replace


*Pennsylvania
import excel using "PADD1_NGL.xls", sheet("Data 1") clear first
gen modate = mofd(date)
format modate %tm
gen year = year(date)
gen gas = .

//EIA Annual:
replace gas = 168501 if year == 2005
replace gas = 175950 if year == 2006
replace gas = 182277 if year == 2007
replace gas = 198295 if year == 2008
replace gas = 273869 if year == 2009
replace gas = 572902 if year == 2010
replace gas = 1310592 if year == 2011
replace gas = 2256696 if year == 2012
replace gas = 3259042 if year == 2013
replace gas = gas / 365

label var condensate "Condensate Production (Thous. barrels per day)"
label var gas "Gas Production (Mmcf per day)"

keep modate condensate gas
rename modate period
order period condensate gas
save "figure_3.dta", replace
