global dir = "/Users/scicala/Dropbox/Presentations/Discussions/BPEA"

/*
import excel using "$dir/ND_Gas1990ToPresent.xls", clear firstrow
replace Date = "1-" + Date
gen temp = date(Date,"DMY")
gen modate = mofd(temp)
format modate %tm
drop Date
gen year = year(temp)
gen days = temp - temp[_n-1]
replace days = 31 if days == .
drop temp

foreach v of varlist MCF*	{
	replace `v' = `v' / (1000 * days)
}

label var oil "Oil Production"
label var MCFProduced "Gas Production"
label var MCFSold "Gas Sold"
label var modate "Year-Month"

twoway (line oil modate if year >= 2005), ytitle("Thousand Barrels / Day") ///
legend(label(1 "Oil Production")) graphregion(fcolor(white))
graph export "$dir/ND_oil.eps", replace

twoway (line oil modate if year >= 2005, ytitle("Thousand Barrels / Day")) ///
(line MCFProduced modate if year >= 2005, yaxis(2) ytitle("Mmcf / Day", axis(2)) ///
lwidth(thick) graphregion(fcolor(white)))
graph export "$dir/ND_oil_and_gas.eps", replace

twoway (line oil modate if year >= 2005, ytitle("Thousand Barrels / Day")) ///
(line MCFProduced modate if year >= 2005, yaxis(2) ytitle("Mmcf / Day", axis(2)) ///
lwidth(thick)) ///
(line MCFSold modate if year >= 2005, yaxis(2) lpattern(dash) ///
graphregion(fcolor(white)))
graph export "$dir/ND_oil_and_gas_sold.eps", replace
*/

*TEXAS:
insheet using "$dir/tx_monthly_output.txt", names tab clear
replace date = "1 " + date

gen temp = date(date,"DMY")
gen modate = mofd(temp)
format modate %tm
gen year = year(temp)
gen days = temp - temp[_n-1]
replace days = 31 if days == .
drop temp
foreach v of varlist oil casing gwgas condensate	{
	replace `v' = `v' / (1000 * days)
}
label var oil "Oil Production"
label var casing "Casinghead Gas Production"
label var gwgas "Gas Well Gas Production"
label var condensate "Condensate Production"
stop

twoway (line oil modate if year >= 2005), ytitle("Thousand Barrels / Day") ///
graphregion(fcolor(white))
graph export "$dir/TX_oil.eps", replace

twoway (line oil modate if year >= 2005, ytitle("Thousand Barrels / Day")) ///
(line gwgas modate if year >= 2005, yaxis(2) ytitle("Mmcf / Day", axis(2)) ///
lwidth(thick) graphregion(fcolor(white))), name("TX_gwgas", replace)
graph export "$dir/TX_oil_and_gas.eps", replace

twoway (line oil modate if year >= 2005, ytitle("Thousand Barrels / Day")) ///
(line casinghead modate if year >= 2005, yaxis(2) ytitle("Mmcf / Day", axis(2)) ///
lwidth(thick) graphregion(fcolor(white))), name("TX_casingheadgas", replace)
graph export "$dir/TX_oil_and_casinggas.eps", replace
*/

*PA:

import excel using "$dir/PADD1_NGL.xls", sheet("Data 1") clear first
gen modate = mofd(date)
format modate %tm
gen year = year(date)
gen gas = .

*EIA Annual:
replace gas = 168501 if year == 2005
replace gas = 175950 if year == 2006
replace gas = 182277 if year == 2007
replace gas = 198295 if year == 2008
replace gas = 273869 if year == 2009
replace gas = 572902 if year == 2010
replace gas = 1310592 if year == 2011
replace gas = 2256696 if year == 2012
replace gas = 3259042 if year == 2013
replace gas = gas / 365

label var condensate "Condensate Production"
label var gas "Gas Production"
twoway (line condensate modate if year >= 2005, ytitle("Thousand Barrels / Day") ///
 graphregion(fcolor(white))), name("PA_condensate", replace)
graph export "$dir/PA_condensate.eps", replace

twoway (line condensate modate if year >= 2005, ytitle("Thousand Barrels / Day")) ///
(line gas modate if year >= 2005, yaxis(2) ytitle("Mmcf / Day", axis(2)) ///
lwidth(thick) graphregion(fcolor(white))), name("PA_gas", replace)
graph export "$dir/PA_oil_and_gas.eps", replace
 
 
stop
foreach y of numlist 2005(1)2014	{
	insheet using "$dir/PA/ProdExport`y'-0.csv", names comma clear
	save "$dir/PA/`y'.dta", replace
}
foreach y of numlist 2011(1)2014	{
	insheet using "$dir/PA/ProdExport`y'-1.csv", names comma clear
	append using "$dir/PA/`y'.dta"
	save "$dir/PA/`y'.dta", replace
}
foreach y of numlist 2010(1)2014	{
	insheet using "$dir/PA/ProdExport`y'-2.csv", names comma clear
	append using "$dir/PA/`y'.dta"
	save "$dir/PA/`y'.dta", replace
}

use "$dir/PA/2005.dta", clear
foreach y of numlist 2006(1)2014	{
	append using "$dir/PA/`y'.dta"
}
save "$dir/PA/raw_2005_2014.dta", replace
*/

use "$dir/PA/raw_2005_2014.dta", clear
gen year = substr(periodid,1,4)
destring year, replace
rename gasquantitymcf gas
rename oilquantitybbl oil
rename condensatequantity condensate
foreach v of varlist gas oil condensate	{
	replace `v' = 0 if `v' == .
	replace `v' = `v' / (1000 * 365)
}
gen casinghead = gas if (oil > 0 | condensate > 0)
gen gwgas = gas if casinghead == .

collapse (sum) gwgas casinghead gas oil condensate, by(year)

stop
stop


twoway (line nameplate_mc q if datetime == tc($d $h:00:00), ///
lcolor(navy) ) ///
(line netgen_mc q if datetime == tc($d $h:00:00) & ///
q <= $netgen , lpattern(dash) lwidth(thick) lcolor(black)) , ///
graphregion(fcolor(white)) name("nameplate_only$h", replace) ///
xtitle("MWh")  ytitle("$/MWh") title("$pca_abbrev99 $d  $h:00") ///
xline($load) xline($netgen, lpattern(dot) lcolor(black)) ///
subtitle("Netgen: $netgen Load: $load") ///
legend( label(1 "Ideal Supply") label(2 "Observed Supply")) 
graph export "$tex/$name.eps", replace
