* this file generates the VAR forecasts in table 3.;

#delimit;
clear all;
set more off;


*change this directory first;
qui: cd "/Users/johanneswieland/Dropbox/uni/Work/Research/PhD/Brookings/Hausman_Wieland_Data_Programs/Stata/Code";
*qui: cd "~/Dropbox/Brookings/Hausman_Wieland_Data_Programs/Stata/Code";

* setting paths;
qui: do paths;

********************************************************************************
*
* Collect data
*
********************************************************************************;

* getting financial data (requires Bloomberg data);
do japan_fin_final;
clear all;

*current real GDP and GDP deflator data (3/14/14 release);
import excel "$DataPath/NA/quarterly_real_gdp.xlsx", first;

gen date = yq(year, quarter);
format date %tq;

keep date gdp_lvl deflgdp_lvl;
tsset date;

save "$StDataPath/quarterly_rgdp", replace;

* getting december GDP data as known in December 2012;
clear all;
import excel "$DataPath/NA/quarterly_real_gdp_1212.xlsx", first;

gen date = yq(year, quarter);
format date %tq;

keep year date gdp_fclvl deflgdp_fclvl;
tsset date;

*add forecast for Q4 2012;
*quarterly growth forecast for GDP from Consensus Economics was -0.1 percent;
replace gdp_fclvl = l.gdp_fclvl*(1-.1/100) if gdp_fclvl==.;

*The deflator is more problematic, since there is no Consensus Economics forecast;
*Instead, we use the first value reported, i.e. the value in the Feb. 2013 release;
*In Feb. 2013 it was reported that the deflator fell 0.4 percent in Q4 2012;
replace deflgdp_fclvl = l.deflgdp_fclvl*(1-.437/100) if deflgdp_fclvl==.;

* merging data;
merge 1:1 date using "$StDataPath/quarterly_rgdp", gen(_mergegdp);
save "$StDataPath/quarterly_rgdp_w1212", replace; 

*get 10 year nominal bond rate;
*The dataset jp_fin_monthly is put together in jp_fin_monthly;
use "$StDataPath/jp_fin_monthly", clear;

sort date;
gen dateq = qofd(dofm(date));

collapse (mean) bond10, by(dateq);
rename dateq date;
format date %tq;
tsset date, quarterly;

merge 1:1 date using "$StDataPath/quarterly_rgdp_w1212", gen(_mergebond10);
drop if gdp_lvl==.;


********************************************************************************
*
* running var
*
********************************************************************************;

* location;
local pickdate = "2013q4";
local locdate = tq(`pickdate')-date[1]+1;

* percent change of real variables;
foreach var of varlist gdp_lvl deflgdp_lvl gdp_fclvl deflgdp_fclvl {;
	gen p`var' = `var' / l.`var' -1;
};

*difference in 10year rate;
gen dbond10 = d.bond10;

* matrix with lags;
local maxlag = 4;
matrix gdp_fc_mat = J(`maxlag',5,.);

matrix aic_mat = J(`maxlag',5,.);
matrix bic_mat = J(`maxlag',5,.);

* autoregressive models;
local zz = 1;
foreach jj in 1 2 3 4 {;

	local kk =2;
	
	foreach type in lvl fclvl {;

		var pgdp_`type' if tin(1996q1,2012q4), lags(1/`jj') ;
		fcast compute for`type'`jj'_, step(4) dynamic(yq(2013,1)) replace;
		
		gen gdpar_`type'`jj' = gdp_`type' if date<=yq(2012,4);
		replace gdpar_`type'`jj' = L.gdpar_`type'`jj'*(1+for`type'`jj'_pgdp_`type') if gdpar_`type'`jj'==.;
		disp "test";
		
		by year, sort: egen gdpar_`type'`jj'_annual = mean(gdpar_`type'`jj');
		sort date;
		gen gdpar_`type'`jj'_growth = (gdpar_`type'`jj'_annual/L4.gdpar_`type'`jj'_annual-1)*100;
		
		
		matrix aic_mat[`zz',`kk']=e(aic);
		matrix bic_mat[`zz',`kk']=e(sbic);
		
		local kk =`kk'+1;
		
	};
	
	local final_data_growth = gdpar_lvl`jj'_growth[`locdate'];
	local fc_data_growth = gdpar_fclvl`jj'_growth[`locdate'];
	
	matrix gdp_fc_mat[`zz',1]=`jj';
	matrix gdp_fc_mat[`zz',2]=`final_data_growth';
	matrix gdp_fc_mat[`zz',3]=`fc_data_growth';
	
	display "lags `jj'";
	display "2013 Growth (y-o-y) with final data = `final_data_growth'";
	display "2013 Growth (y-o-y) with forecasted data = `fc_data_growth'";
	
	local zz = `zz'+1;
};

* VAR model;
forvalues jj=1(1)4 {;

	local kk =4;

	foreach type in lvl fclvl {;
	
		var pgdp_`type' pdeflgdp_`type' dbond10 if tin(1996q1,2012q4), lags(1/`jj') ;
		fcast compute for`type'`jj'_, step(4) dynamic(yq(2013,1)) replace;
		gen gdpvar_`type'`jj' = gdp_`type' if date<=yq(2012,4);
		replace gdpvar_`type'`jj' = L.gdpvar_`type'`jj'*(1+for`type'`jj'_pgdp_`type') if gdpvar_`type'`jj'==.;
		
		by year, sort: egen gdpvar_`type'`jj'_annual = mean(gdpvar_`type'`jj');
		sort date;
		gen gdpvar_`type'`jj'_growth = (gdpvar_`type'`jj'_annual/L4.gdpvar_`type'`jj'_annual-1)*100;
		
		matrix aic_mat[`jj',`kk']=e(aic);
		matrix bic_mat[`jj',`kk']=e(sbic);
		
		local kk =`kk'+1;
		
	};
	
	local final_data_growth = gdpvar_lvl`jj'_growth[`locdate'];
	local fc_data_growth = gdpvar_fclvl`jj'_growth[`locdate'];
	
	matrix gdp_fc_mat[`jj',4]=`final_data_growth';
	matrix gdp_fc_mat[`jj',5]=`fc_data_growth';
	
	display "lags `jj'";
	display "2013 Growth (y-o-y) with final data = `final_data_growth'";
	display "2013 Growth (y-o-y) with forecasted data = `fc_data_growth'";
};

matrix list aic_mat;
matrix list bic_mat;

matrix list gdp_fc_mat;

* producing table with forecast results;
outtable using "$StTabPath/varforecasts", mat(gdp_fc_mat) format(%9.0f %9.2f %9.2f %9.2f %9.2f) ///
 norowlab center nobox replace caption("2013 Growth Forecasts from Autoregressive Models") clabel(tab:varforecasts);


