*This graphs quarterly changes in seasonally adjusted Japanese GDP, at an annual rate.;
* Figures plotted are 5(a) and 5(b).; 

#delimit;
clear all;
set more off;

*change this directory first;
qui: cd "/Users/johanneswieland/Dropbox/uni/Work/Research/PhD/Brookings/Hausman_Wieland_Data_Programs/Stata/Code";
*qui: cd "~/Dropbox/Brookings/Hausman_Wieland_Data_Programs/Stata/Code";

* setting paths;
qui: do paths;

********************************************************************************
*
* Japan since 2007: national accounts  
*
********************************************************************************;


* importing GDP data: need nominal data for contributions;
qui: do jp_na_setup_final.do;
clear all;
use "$StDataPath/jpna";
merge m:1 date using "$StDataPath/jpnanom", gen(_mergenanom);

********************************************************************************
*
* Calculations  
*
********************************************************************************;

tsset date, quarterly;

gen quarter=quarter(dofq(date));
gen year=year(dofq(date));
gen lab_var = "Quarter";

* total investment;
gen invest = invres+invnonres+dinvent;
gen nominvest = nominvres+nominvnonres+nomdinvent;

* imports are negative contribution;
replace imp = -imp;
replace nomimp = -nomimp;

* annual mean and growth rate;
sort year;
foreach var of varlist gdp cons invest govt exp imp nom* {;
	by year: egen `var'y=mean(`var');
};
foreach var of varlist gdp cons invest govt exp imp {;
	gen defl`var'y=nom`var'y/`var'y;
};
sort date;

* contributions calculated as in Japan national accounts;
foreach var of varlist gdp cons invest govt exp imp {;
	gen dl`var' = S.`var'/L.`var'*400;
	gen dl`var'_contrib = (S.`var'/L.`var')*(L4.defl`var'y*L.`var'/(L4.deflgdpy*L.gdp))*400;*S.`var'/L.gdp*400;
};


* GDP under Abe;
gen dlgdp_abe = dlgdp if year>2012;

correlate dlcons_contrib dlinvest_contrib dlgovt_contrib if year==2013;


	 
********************************************************************************
*
* Graphs
*
********************************************************************************;

cd "$StGrphPath";

* Graph 5(a): quarterly evolution;
graph twoway (bar dlgdp date if year>2006, lcolor(black)) (bar dlgdp_abe date if year>2006, color(red) lcolor(black)), ///
   xtitle("Date") ytitle("Real GDP growth (%, annualized)")  ///
	 saving(quart_gdp, replace)  graphregion(color(white)) name(quart_gdp) legend(off);
graph export quart_gdp.eps, replace;


* Graph 5(b): contributions by quarter in 2013;
graph bar dlcons_contrib dlinvest_contrib dlgovt_contrib dlexp_contrib dlimp_contrib if year==2013, over(quarter) over(lab_var) ///
ytitle("Contributions to quarterly GDP growth (p.p., annualized)") ylabel(-2(1)3) ///
	  saving(quart_gdp_comp, replace)  graphregion(color(white))  ///
	  legend(label(1 "Consumption") label(2 "Investment") label(3 "Gov. spending") label(4 "Exports") label(5 "Imports(-)") ///
	  cols(2) ring(0) position(1) ) name(components_2013);
	  
	  graph export components_2013.eps, replace;
	 
