*This compares movements in the money supply around the time that quantitative easing 
*was announced with movements around the time that Abenomics was announced.;


#delimit;
clear all;
set more off;

*change this directory first;
qui: cd "/Users/johanneswieland/Dropbox/uni/Work/Research/PhD/Brookings/Hausman_Wieland_Data_Programs/Stata/Code";
*qui: cd "~/Dropbox/Brookings/Hausman_Wieland_Data_Programs/Stata/Code";

* setting paths;
qui: do paths;


********************************************************************************
*
* Get data
*
********************************************************************************;

clear;
cd "$DataPath/Money_supply";
import excel using "money_data.xls", sheet("for_stata") firstrow case(lower);
gen date = ym(year, month);
tsset date, monthly;



********************************************************************************
*
* Local vars
********************************************************************************;

* local vars;
local mthly_vars mbase_nsa m3_nsa; 
local mthly_vars_d  d12mbase_nsa d12m3_nsa;
local abestt = "2012m11";
local qestt = "2001m3";
local abenum = tm(`abestt');
local qenum = tm(`qestt');
local qe_abe_diff = `abenum' - `qenum'; 
local mindat = date[1];
local qestt_diff = `qenum' - `mindat';
local qe_obs = `qestt_diff' +1;
local plotst = "1999m3";
local plotend = "2003m8";



********************************************************************************
*
* 12 month changes;
********************************************************************************;

tsset date;

foreach var of varlist `mthly_vars' {;
	gen d12`var' = 100*(`var'/L12.`var'-1);
	
};

********************************************************************************
*
* Plots;
********************************************************************************;


*Make new variable to align QE / Abenomics start;

foreach var of varlist `mthly_vars_d' {;
	gen `var'_qe = `var';
	gen `var'_abe = F`qe_abe_diff'.`var';
	drop `var';	
	};
	
	
* labeling variables;
label variable d12mbase_nsa_abe "Monetary base 12-month growth (NSA), Abenomics (11/2012)";
label variable d12mbase_nsa_qe "Monetary base 12-month growth (NSA), QE (3/2001)";
label variable d12m3_nsa_abe "Broad money (M3) 12-month growth (NSA), Abenomics (11/2012)";
label variable d12m3_nsa_qe "Broad money (M3) 12-month growth (NSA), QE (3/2001)";

saveold "$StDataPath/monthly_actual_qe", replace;

*graphs;
cd "$StGrphPath";

*variable for xaxis;
gen months = date - `qenum';


*local variables for xaxis label;
local xlabelstt = tm(`plotst') - `qenum';
local xlabelend = tm(`plotend') - `qenum';

* graphing output;
foreach var in  `mthly_vars_d' {;

	line `var'_abe `var'_qe months if tin(`plotst',`plotend') , name(`var'_qe) ///
 	plotregion(style(none)) clcolor(blue) legend(cols(1) ring(0) position(6) ) ///
	ytitle("12-month growth rate (%)") xtitle("Months before / after policy change") xlabel(`xlabelstt'(6)`xlabelend') ///
	lwidth(medthick medthick) clcolor(blue red) clpattern(solid dash) graphregion(color(white));
	graph export `var'_qe.eps, replace;

};


