/*
This file constructs measures of Japan's output gap: figure 1(b)
*/
*;

#delimit;
clear all;
set more off;

*change this directory first;
qui: cd "/Users/johanneswieland/Dropbox/uni/Work/Research/PhD/Brookings/Hausman_Wieland_Data_Programs/Stata/Code";
*qui: cd "~/Dropbox/Brookings/Hausman_Wieland_Data_Programs/Stata/Code";

* setting paths;
qui: do paths;

********************************************************************************
*
* Importing data: national accounts;
*
********************************************************************************;

* annual GDP data from national accounts;
insheet using "$DataPath/NA/gaku-jcy1342.csv", names;

* fix date format;
drop year;
gen year=1993;
replace year = year +_n;
destring, replace;

* renaming variables;
local oldnames gdpexpenditureapproach privateconsumption privateresidentialinvestment privatenonresiinvestment changeinprivateinventories governmentconsumption publicinvestment changeinpublicinventories exports imports;
local newnames gdp cons invres invnonres dinvent cgovt invgovt dinventgov exp imp;
qui: local varcount: word count `oldnames';

forvalues kk=1(1)`varcount' {;

	qui: local currname: word `kk' of `oldnames';
	qui: local nextname: word `kk' of `newnames';
	rename `currname' `nextname';
	
	*gen l`nextname' = ln(`nextname');
	
};


* aggregating to conform to US accounts;
gen govt = cgovt + invgovt + dinventgov;

* saving japan NA data;
saveold "$StDataPath/jpna_annual", replace;
clear all;

********************************************************************************
*
* Importing IMF GDP data ;
*
********************************************************************************;


/*Get GDP data */
cd "$DataPath/NA";
import excel using annual_real_gdp, first sheet(table);

tsset year;

saveold "$StDataPath/jp_output_gap", replace;

clear;

********************************************************************************
*
* Importing FRED data ;
*
********************************************************************************;


*get working age population;
freduse LFWA64TTJPA647N LRHUTTTTJPA156S;

rename LFWA64TTJPA647N working_pop;
rename LRHUTTTTJPA156S unemployment;
drop date;
gen year = yofd(daten);

tsset year;
sort year;

keep year working_pop unemployment;

merge 1:1 year using "$StDataPath/jp_output_gap";
merge 1:1 year using "$StDataPath/jpna_annual",gen(_merge2);
sort year;

********************************************************************************
*
* Calculations ;
*
********************************************************************************;

* use new values for gdp;
replace spliced = gdp if gdp<.;


*local variables for analysis;
local mindat = year[1];
local base = 1998;
local base_obs = `base' - `mindat' +1;

local end = 2006;
local end_obs = `end' - `mindat' +1;

local splice = 2007;
local splice_obs = `splice' - `mindat' +1;

local trend_length = `end' - `base';

local gdp_vars gdp_working_age trend_gdp consensus_working_age;

gen gdp_working_age = spliced / working_pop;


*average annual growth 1998 to 2006;
local trend_growth = (gdp_working_age[`end_obs']/gdp_working_age[`base_obs'])^(1/`trend_length') -1;

disp `trend_growth';

disp `base_obs';
disp `end_obs';

*trend_gdp;
gen trend_gdp = gdp_working_age if year==`end';
replace trend_gdp = l.trend_gdp*(1+`trend_growth') if trend_gdp==.;


*consensus forecast;
gen consensus_gdp = spliced if year==2006;
replace consensus_gdp = l.consensus_gdp*(1+consensus_2007_growth /100) if consensus_gdp==.;
gen consensus_working_age = consensus_gdp / working_pop;




*index to be 100 in 2007 and convert back from being per working age person;
foreach var in `gdp_vars' {;
	gen temp`var' = `var'*working_pop;
	gen `var'base = 100*(temp`var'/temp`var'[`splice_obs']);
};

* Krugman measure:;
*gen pot_krug = (6*(unemployment-2.5)/100+1)* gdp_working_agebase;
gen krug_gap = -(6*(unemployment - 2.5))/100;
gen pot_krug = gdp_working_agebase/(1+krug_gap);

********************************************************************************
*
* Plots ;
*
********************************************************************************;

	
label var gdp_working_agebase "Actual real GDP";
label var trend_gdpbase "Potential: `base'-`end' GDP/working pop. trend";
label var consensus_working_agebase "Potential: 10/2007 forecast";  
label var pot_krug "Potential: Okun's Law (Krugman,1998)";
	
tsline gdp_working_agebase trend_gdpbase consensus_working_agebase pot_krug if tin(2007,2013) , name(output_gap)  xlabel(2007[2]2013) ///
yscale(range(92 121)) plotregion(style(none)) clcolor(blue) ylabel(95(5)115) ///
legend(cols(1) ring(0) position(10) ) ytitle("Actual and potential real GDP, 2007=100") xtitle("") ///	
ms(Oh Th Dh Sh) mcolor(blue red black green) recast(connected) ///
lwidth(medthick medthick medthick medthick) clpattern(solid dash dash_dot longdash) lcolor(blue red black green)
 graphregion(color(white)); ///
graph export  "$StGrphPath/output_gap`base'-`end'.eps", replace;

*clcolor(black blue red green) clpattern(solid dash dash_dot longdash) lwidth(medthick medthick medthick medthick);

*disp output gaps;
gen trendgap = gdp_working_agebase / trend_gdpbase - 1;
gen forecastgap = gdp_working_agebase / consensus_working_agebase -1;
gen kruggap = gdp_working_agebase / pot_krug -1;

list year *gap if year>2006;

	
	
*	lwidth(medthick medthick medthick medthick) clcolor(black red blue) clpattern(solid dash) ///







