* This file generates figure 5(c);

#delimit;
clear all;
set more off;

*change this directory first;
qui: cd "/Users/johanneswieland/Dropbox/uni/Work/Research/PhD/Brookings/Hausman_Wieland_Data_Programs/Stata/Code";
*qui: cd "~/Dropbox/Brookings/Hausman_Wieland_Data_Programs/Stata/Code";

* setting paths;
qui: do paths;

* local vars;
local rececb = "2008q1";
local trendb = "2001q1";
local abestt = "2012q4";
local abeend = "2013q4";
local varnames gdp cons invres invnonres dinvent cgovt invgovt dinventgov govt exp imp cdur csdur cserv deflgdp; // invtransp invmachequ invcomp gcf;
local pltnames GDP Consumption "Residential Investment" "Non-residential Investment" "Change in Inventories" ///
"Govt Consumption" "Govt Investment" "Change in Govt Inventories" Government Exports Imports ///
"Consumer Durables" "Consumer Semi-Durables" "Consumer Services"  "GDP deflator"; 



********************************************************************************
*
* Working age population
*
********************************************************************************;


freduse LFWA64TTJPQ647S;


rename LFWA64TTJPQ647S working_pop;
drop date;
gen date = qofd(daten);


tsset date, quarterly;
sort date;

keep date working_pop;
save  "$StDataPath/jpworkpop", replace;


clear all;


********************************************************************************
*
* Japan since 2008: national accounts  
*
********************************************************************************;

* insheeting japan GDP data created by jp_na_setup_final.do;
cd "$CodePath";
do jp_na_setup_final.do;
clear all;
use "$StDataPath/jpna";
merge m:1 date using "$StDataPath/jpna2", gen(_mergena);
merge m:1 date using "$StDataPath/jpnanom", gen(_mergenanom);
merge m:1 date using "$StDataPath/jpnadefl", gen(_mergedefl);
merge m:1 date using "$StDataPath/jpworkpop", gen(_mergepop);

* creating new variables;
gen inv = invres+invnonres+dinvent;
local varnames `varnames' inv;
local pltnames `pltnames' Investment;

gen nx = exp-imp;
local varnames `varnames' nx;
local pltnames `pltnames' "Net Exports";

* tsseting;
tsset date, quarterly;

* distance to base;
local mindat = date[1];
local recnum = tq(`rececb');
local abenum = tq(`abestt');
local recobs = tq(`rececb')-`mindat'+1;
display "`recobs'";
local trenum = tq(`abeend');
local treobs = tq(`trendb')-`mindat'+1;
display "`treobs'";




cd "$StGrphPath";
* generating graphs;
local zz = 1;
foreach var of varlist `varnames' {;

	qui: local plotvar: word `zz' of `pltnames';
	display "`plotvar'";

	qui: gen `var'base = `var'/`var'[`recobs']*100;
	qui: gen `var'wpbase = `var'/`var'[`recobs']/(working_pop/working_pop[`recobs'])*100;
	qui: gen `var'trend = `var'base[`recobs']*(100/`var'base[`treobs'])^((date-tq(`rececb'))/(`recobs'-`treobs')) if tin(`rececb',);
	
	qui: gen `var'growth = ((`var'/L.`var')^4-1)*100;
	qui: gen `var'trgrowth = ((`var'trend/L.`var'trend)^4-1)*100;
	qui: replace `var'trgrowth = F.`var'trgrowth if date==yq(2008,1);
	
	local zz = `zz'+1;
};



********************************************************************************
*
* Contributions to growth: annual  
*
********************************************************************************;

preserve;

* three time periods;
local delta1 = yq(2007,4)-yq(1992,1)+1; 
local delta2 = yq(2012,4)-yq(2008,1)+1;
local delta3 = yq(2013,4)-yq(2013,1)+1;

* we need nominal variables to calculate contributions as in the national accounts;
gen nominv = nominvres+nominvnonres+nomdinvent;
gen nomnx  = nomexp-nomimp;

* variables to be plotted;
local varlplot gdp cons inv govt exp imp nx invres invnonres dinvent;
keep date working_pop `varlplot' nom*;

* aggregate to annual;
gen datey = yofd(dofq(date));

collapse (mean) working_pop `varlplot' nom*, by(datey);

* annual tsseting;
rename datey date;
tsset date, yearly;

gen dlwork = S.working_pop/L.working_pop;
replace imp = -imp;
replace nomimp = -nomimp;

* contributions calculated as in official data. then averaged across time;
foreach var in `varlplot' {;
	gen `var'wp = `var'/working_pop;
	gen nom`var'wp = nom`var'/working_pop;

	gen `var'growthgdp 	= (S.`var'/L.`var')*(L.nom`var'/L.nomgdp)*100;
	gen growth`var' 	= .;
	
	su `var'growthgdp if tin(1992,2007);
	replace growth`var' = `r(mean)' if tin(1992,2007);
	
	su `var'growthgdp if tin(2008,2012);
	replace growth`var' = `r(mean)' if tin(2008,2012);
	
	su `var'growthgdp if tin(2013,);
	replace growth`var' = `r(mean)' if tin(2013,);
};

* calculation for GDP/working age pop;
foreach var in gdp {;

	gen `var'growthgdpwp 	= (S.`var'wp/L.`var'wp)*(L.nom`var'wp/L.nomgdpwp)*100;
	gen growth`var'wp 	= .;
	
	su `var'growthgdpwp if tin(1992,2007);
	replace growth`var'wp = `r(mean)' if tin(1992,2007);
	
	su `var'growthgdpwp if tin(2008,2012);
	replace growth`var'wp = `r(mean)' if tin(2008,2012);
	
	su `var'growthgdpwp if tin(2013,);
	replace growth`var'wp = `r(mean)' if tin(2013,);
};

* time periods to be plotted;
gen tvar = 1 if tin(1992,2007);
replace tvar = 2 if tin(2008,2012);
replace tvar = 3 if tin(2013,);

* reducing data to plotted data;
keep tvar growth*;
duplicates drop;
drop if tvar==.;

reshape long growth, i(tvar) j(quant) string;

reshape wide growth, i(quant) j(tvar);

* order in graph;
gen order=1 if quant=="gdp";
replace order=2 if quant=="cons";
replace order=3 if quant=="inv";
replace order=4 if quant=="govt";
replace order=5 if quant=="exp";
replace order=6 if quant=="imp";
replace order=7 if quant=="nx";
replace order=1 if quant=="gdpwp";
gen wp = "Contribution to GDP growth";
replace wp = "Per working age" if quant=="gdpwp";;

* names in graph;
replace quant ="GDP" if quant=="gdp";
replace quant ="Consumption" if quant=="cons";
replace quant ="Investment" if quant=="inv";
replace quant ="Gov. spending" if quant=="govt";
replace quant ="Exports" if quant=="exp";
replace quant ="Imports(-)" if quant=="imp";
replace quant ="Net exports" if quant=="nx";
replace quant ="GDP" if quant=="gdpwp";

* fraction of GDP growth explained;
gen fraction = growth3 / growth3[4];
list quant growth* fraction;

* drop exports and imports.;
drop if order==7;
drop if order==.;


* titles;
local ytitle "Avg. year-on-year growth rate (p.p.)";
local ytitlewp "Avg. year-on-year growth rate per working pop (p.p.)";

* plotting data;
graph bar growth1 growth2 growth3, name(allgrowthy)  bar(1, color(eltblue) bstyle(p3bar) ) bar(2, color(edkblue) bstyle(p4bar)) bar(3, color(ebblue) bstyle(p5bar)) ///
	over(quant, sort(order) label( alternate labstyle(p1)  ) ) over(wp, gap(300)) nofill ///
	ytitle(`ytitle`adj'')  ///
	legend( label(1 "1995-2007") label(2 "2008-2012") label(3 "Abenomics (2013)")   cols(1) ring(0) position(12)) ///
	 graphregion(color(white)) yline(0, lcolor(black) )
	 ;
	 graph export allgrowth`adj'2_annual.eps, replace;
	 
