* This file generates figure 1(a);

#delimit;
clear all;
set more off;

*change this directory first;
qui: cd "/Users/johanneswieland/Dropbox/uni/Work/Research/PhD/Brookings/Hausman_Wieland_Data_Programs/Stata/Code";
*qui: cd "~/Dropbox/Brookings/Hausman_Wieland_Data_Programs/Stata/Code";

* setting paths;
qui: do paths;

* saving temporary file;
qui: cd "$StDataPath";
tempvar tt;
gen test=1;
save imflt, replace;
save imflt_temp, replace;

* downloading data from the IMG website;
forvalues kk=2008(1)2013 {;
	
	local miniss 1;
	if `kk'==2007 {;
		local miniss 2;
	};

	forvalues jj=`miniss'(1)2 {;
		clear all;
		local enddate = `kk'+5;
		qui: cd "$DataPath/IMF";
		copy "http://www.imf.org/external/pubs/ft/weo/`kk'/0`jj'/weodata/weoreptc.aspx?pr.x=79&pr.y=9&sy=1980&ey=`enddate'&ssd=1&sort=country&ds=.&br=1&c=158&s=NGDP_R%2CNGDP_RPCH%2CNGAP_NPGDP%2CPCPI%2CPCPIPCH&grp=0&a=" weoreptc.txt, replace;
		insheet using weoreptc.txt;
		qui: cd "$StDataPath";
		drop if _n==_N;
		drop scale;
		foreach v of var v* {;
			replace `v' = subinstr(`v',",","",1);
			replace `v' = "" if `v'=="n/a";
			local curryear: var label `v' ;
			disp "`curryear'";
			rename `v' year`curryear';
		};
		gen year = `kk';
		gen issue= 4+(`jj'-1)*6;
		destring, replace;
		save imflt_temp, replace;
		append using imflt;
		save imflt, replace;
		tab issue;
	};
};
drop test;
sort subjectdescriptor year issue;

* preparing for cross-merge;
gen date = ym(year,issue);
format date %tm;
gen type = "gdp" if subjectdescriptor=="Gross domestic product, constant prices" & (units=="Annual percent change" | units=="Percent change");
replace type = "gdplvl" if subjectdescriptor=="Gross domestic product, constant prices" & units=="National currency";
replace type = "gdppot" if subjectdescriptor=="Output gap in percent of potential GDP";
replace type = "cpi" if subjectdescriptor=="Inflation, average consumer prices" & (units=="Annual percent change" | units=="Percent change");
replace type = "cpilvl" if subjectdescriptor=="Inflation, average consumer prices" & (units=="Index" | units=="Index, 2000=100");
drop subjectdescriptor country units estimates* year issue;

* reshaping;
reshape long year, i(date type);
gen cpiimf = year if type=="cpi";
gen gdpimf = year if type=="gdp";
gen cpilvlimf = year if type=="cpilvl";
gen gdplvlimf = year if type=="gdplvl";
gen gdppotimf = year if type=="gdppot";
drop year;
rename _j year;
drop type;
collapse (min) cpiimf gdpimf cpilvlimf gdplvlimf gdppotimf, by(date year);
reshape wide cpiimf gdpimf cpilvlimf gdplvlimf gdppotimf, i(year) j(date);
rename year date;
gen consimf =.;
gen invnonresimf =.;
gen ipimf =.;
save imflt, replace;


* plotting GDP forecasts: basis is 2007=100. Note: price basis switches from 2005 to 2010 at some point;
tsset date, yearly;
local dateselec 579 645; // forecasts we use;
local pos2007 28;		// position of base year. here 2007;


foreach time in `dateselec' {;
	gen gdplvlimfbase`time' = gdplvlimf`time' / gdplvlimf`time'[`pos2007'] *100;
	gen gdppotimfbase`time' = gdplvlimfbase`time'/(1+gdppotimf`time'/100);
};

save "$StDataPath/japan_imf", replace;
clear;

* get actual Japanese real GDP data from our output gap file;
cd "$CodePath";
qui: do japan_output_gap.do;
clear all;

use "$StDataPath/jpna_annual";


* merge with the imf data we downloaded;
rename year date;
merge 1:1 date using "$StDataPath/japan_imf";
sort date;

* gdp index;
gen indexed = gdp/gdp[`pos2007']*100;

format indexed %9.0g;

* with GDP forecast;
tsline gdplvlimfbase645 gdppotimfbase645 gdplvlimfbase579 gdppotimfbase579 if tin(2007,2013), name(imfpotential) xlabel(2007[2]2013) ///
		ytitle("Actual and potential real GDP, 2007=100") ylabel(95(5)115) ///
		legend(label(3 "WEO 4/2008: Output forecast") label(4 "WEO 4/2008: Potential output forecast") label(1 "WEO 10/2013: Output forecast") label(2 "WEO 10/2013: Potential output forecast")  cols(1) ring(0) position(11) ) ///
		 xtitle("") ///
		ms(Oh Th Dh Sh) mcolor(blue red black green) recast(connected) ///
lwidth(medthick medthick medthick medthick) clpattern(solid dash dash_dot longdash) lcolor(blue red black green) ///
		graphregion(color(white));
		graph export "$StGrphPath/imfpotential.eps", replace;
		

* with actual real GDP (figure 1a);		
tsline indexed gdppotimfbase645 gdplvlimfbase579 gdppotimfbase579 if tin(2007,2013), name(imfpotential_data) xlabel(2007[2]2013) ///
		ytitle("Actual and potential real GDP, 2007=100") ylabel(95(5)115) ///
		legend(label(3 "WEO 4/2008: Output forecast") label(4 "WEO 4/2008: Potential output forecast") label(1 "Actual real GDP") label(2 "WEO 10/2013: Potential output forecast")  cols(1) ring(0) position(11) ) ///
		 xtitle("") ///
		ms(Oh Th Dh Sh) mcolor(blue red black green) recast(connected) ///
lwidth(medthick medthick medthick medthick) clpattern(solid dash dash_dot longdash) lcolor(blue red black green) ///		
		graphregion(color(white));
		graph export "$StGrphPath/imfpotential_data.eps", replace;
