* this file generates figure 3(a) using price level data;

#delimit;
clear all;
set more off;

*change this directory first;
qui: cd "/Users/johanneswieland/Dropbox/uni/Work/Research/PhD/Brookings/Hausman_Wieland_Data_Programs/Stata/Code";
*qui: cd "~/Dropbox/Brookings/Hausman_Wieland_Data_Programs/Stata/Code";

* setting paths;
qui: do paths;

* local vars;
local plotst = "2007m1";
local rececb = "2007m1";
local trendb = "2001m1";
local abestt = "2012m11";
local abeend = "2013m10";

* variables to be plotted;
local cpinames cpisa cpicoresa ;
local pltnames CPI "Core CPI";
local deflnames deflgdp deflcons;
local allnames cpisa cpicoresa gdp_deflator cons_deflator;



********************************************************************************
*
* Japan: CPI
*
********************************************************************************;

* insheeting japan CPI data;
cd "$DataPath/CPI";
insheet using zmi2010e_mar2014.csv, names;

* fix date format;
gen date=ym(1970,1);
replace date=date+_n-1;
destring, replace;
drop v*;

tsset date;

* renaming variables;
local oldnames allitemsseasonallyadjusted allitemslessfreshfoodseasonallya allitemslessimputedrentseasonall allitemslessimputedrentfreshfood allitemslessfoodlessalcoholicbev;
local newnames cpisa cpilffsa cpilirsa cpilffirsa cpicoresa;
local varkeep `cpinames';

qui: local varcount: word count `oldnames';

forvalues kk=1(1)`varcount' {;

	qui: local currname: word `kk' of `oldnames';
	qui: local nextname: word `kk' of `newnames';
	rename `currname' `nextname';
		
};
keep date `varkeep';


qui: local varcount: word count `cpinames';
forvalues kk=1(1)`varcount' {;

	qui: local currname: word `kk' of `cpinames';
	qui: local labname:  word `kk' of `pltnames';
	label var `currname' "`labname'";
		
};

destring, replace;

saveold "$StDataPath/jpcpi", replace;
clear;

********************************************************************************
*
* Japan: GDP deflators
*
********************************************************************************;



* insheeting japan deflator data;
cd "$DataPath/NA";
insheet using def-qk1342.csv, names;

* fix date format;
gen date=yq(1993,4);
replace date=date+_n;
destring, replace;
drop v*;


* renaming variables;
local oldnames gdpexpenditureapproach privateconsumption privateresidentialinvestment privatenonresiinvestment changeinprivateinventories governmentconsumption publicinvestment changeinpublicinventories exports imports;
local newnames deflgdp deflcons deflinvres deflinvnonres defldinvent deflcgovt deflinvgovt defldinventgov deflexp deflimp;
local varkeep `newnames';


qui: local varcount: word count `oldnames';

forvalues kk=1(1)`varcount' {;

	qui: local currname: word `kk' of `oldnames';
	qui: local nextname: word `kk' of `newnames';
	rename `currname' `nextname';
		
};

keep date `varkeep';
destring, replace;

* saving japan NA deflator data;
save "$StDataPath/jpnadefl", replace;

* date;
gen datem=mofd(dofq(date))+1;
drop date;
rename datem date;
format date %tm;
tsset date;

* merging and saving data;
merge 1:1 date using "$StDataPath/jpcpi";
sort date;
saveold "$StDataPath/jpcpi", replace;

clear;





********************************************************************************
*
* Plotting Data
*
********************************************************************************;

use "$StDataPath/jpcpi";

* tsseting;
tsset date, monthly;

* distance to base;
local mindat = date[1];
local recnum = tm(`plotst');
local abenum = tm(`abestt');

*add 2 for ease of working with quarterly data;
local recobs = tm(`rececb')-`mindat'+2;
local abesttobs = `abenum' - `mindat' +2; 
display "`recobs'";
local trenum = tm(`abeend');
local treobs = tm(`trendb')-`mindat'+1;
display "`treobs'";

* generating base variables;
foreach var of varlist `cpinames' `deflnames' {;
	
	qui: gen `var'base = `var'/`var'[`recobs']*100;
	
};



cd "$StGrphPath";


* generating graphs;
label variable cpisabase "CPI (SA), 2/2007 = 100";
label variable cpicoresabase "CPI ex. fresh food and energy (SA)";
label variable deflgdpbase "GDP deflator (SA), 2007:Q1 = 100";
label variable deflconsbase "Consumption deflator (SA)";


tsline cpisabase cpicoresabase deflgdpbase if tin(`plotst',) , name(cpi_defl_allbase) xlabel(`recnum'(12)`trenum' , format(%tm)) ///
tline(`abestt') plotregion(style(none)) legend(cols(1) ring(0) position(7) ) ytitle("Price indices") xtitle("") ///
	lwidth(medthick medthick medthick) clpattern(solid dash dash_dot) lcolor(blue red black) graphregion(color(white));
graph export cpi_defl_allbase.eps, replace;


