* this file produces table 5: quarterly forecast accuracy in the online appendix.

#delimit;
clear all;
set more off;

*change this directory first;
qui: cd "/Users/johanneswieland/Dropbox/uni/Work/Research/PhD/Brookings/Hausman_Wieland_Data_Programs/Stata/Code";
*qui: cd "~/Dropbox/Brookings/Hausman_Wieland_Data_Programs/Stata/Code";

* setting paths;
qui: do paths;

* loval vars;
local rececb = "2008m11";
local trendb = "2001m2";
local abestt = "2012m11";
local abeend = "2013m11";
local cebase = "2012m12";
local celast = "2013m9";
local plotst = "2011m7";

* variables to be used;
local cefevars cpi gdp cons ip;
local pltnames CPI GDP Consumption "Industrial Production";

* location of variables in excel file;
local sheetlist "Consumer Prices" "GDP Q-o-Q" "Consumption Q-o-Q" "Industrial Production";
local celllist "A5:DG100";


* local nums;
local cebasenum = tm(`cebase');
local celastnum = tm(`celast');

local abelen = tm(`abestt')-tm(`abeend');
local plotnum= tm(`plotst');

********************************************************************************
*
* Consensus forecasts for Japan: quarterly forecasts
*
********************************************************************************;

local zz = 1;

foreach var in `cefevars' {;

	local sheetname: word `zz' of "`sheetlist'";
	display "`sheetname'";

	*qui: cd "/Users/johanneswieland/Dropbox/uni/Work/Research/PhD/Ideas/ZLB and Asset Prices/Data/Forecast Data/Consensus";
	qui: cd "$DataPath/Consensus";
	import excel using "JAPAN Extended.xls", sheet("`sheetname'") cellrange("`celllist'") firstrow case(lower);
	drop if _n==1;
	
	destring, replace;
	
	foreach varq of varlist q* {;
		local varstr "`varq'";
		local yearst = substr("`varstr'",3,4);
		local qurtst = substr("`varstr'",1,2);
		rename `varq' `var'`yearst'`qurtst';
	};
	
	reshape long `var', i(surveydate) j(date) string;
	
	
	* new date variable;
	gen year = substr(date,1,4);
	gen quarter = substr(date,6,1);
	destring year quarter, replace;
	drop date;
	gen date = ym(year,2+(quarter-1)*3);
	drop year quarter;
	format date %tm;
	
	* new survey variable;
	gen survey = mofd(surveydate);
	format survey %tm;
	drop surveydate;
	
	* reshape again for merging;
	*reshape wide `var', i(survey) j(date);
	save "$StDataPath/jpceq`var'", replace;
	clear all;
	
	local zz = `zz' + 1;
};

qui: cd "$CodePath";

* merging files;
use "$StDataPath/jpceqgdp";
merge m:1 survey date using "$StDataPath/jpceqcons", gen(_mergececons);
merge m:1 survey date using "$StDataPath/jpceqcpi", gen(_mergececpi);
merge m:1 survey date using "$StDataPath/jpceqip", gen(_mergeceip);
save "$StDataPath/jpcequart", replace;
drop _merge*;
order survey date, before(gdp);

* add data: (we'll have to get those forecasts);
set obs `=_N+1';
replace survey = ym(2013,12) if _n==_N;
replace date = ym(2013,8) if _n==_N;
replace gdp = 0.3 if _n==_N;

* forecast horizon (quarters);
gen horizon = round((date - survey )/3) if cpi<. | ip<. | gdp<.;
gen thorizon= -horizon;

* time setting;
drop if thorizon==.;
sort date survey;
tsset date thorizon;

* date time setting;
gen dateq = qofd(dofm(date));


********************************************************************************
*
* Accuracy analysis
*
********************************************************************************;


* forecast changes:;
eststo clear;
foreach var in `cefevars' {;
	gen d`var' = S.`var';
	forvalues jj=0(1)4 {;
		local lag = 5+`jj';
		gen d`lag'`var' = S`lag'.`var';
		
		qui: regress F4.d`lag'`var' L`jj'.d`var' if horizon==0, robust;
		local r2_temp_`jj' = e(r2);
	};
	
	forvalues jj=0(1)4 {;
		local lag = 5+`jj';
		gen f4d`lag'`var' = F4.d`lag'`var';
		gen lag`jj'd`var' = L`jj'.d`var';
		
		sort thorizon dateq;
		tsset thorizon dateq, quarterly;
		newey f4d`lag'`var' lag`jj'd`var' if horizon==0, lag(4) force;
		eststo, addscalars(r2 `r2_temp_`jj'');
		sort date thorizon;
		tsset date thorizon;
		
	};
	

    esttab using "$StTabPath/forecastqd`var'panel_newey.tex", b(2) se(2) r2 label title(Forecasting Bias\label{tab:cebias`var'}) ///
    legend nonotes starlevels( \sym{+} 0.10 \sym{*} 0.05 \sym{**} 0.010) ///
    coeflabels("") ///
    rename(lag1d`var' lag0d`var' lag2d`var' lag0d`var' lag3d`var' lag0d`var' lag4d`var' lag0d`var') ///                                   
    noconstant fragment nolines nonum nomtitles ///
    substitute(\_ _ < \textless [1em] "" Observations N lag0d`var' "\multirow{2}{*}{$\beta_{1}$}") wrap compress replace;

	eststo clear;
	
};


