* this code file will plot figure 6: monthly consensus forecasts;
* This file imports the monthly consensus forecasts from the excel spreadsheet japan extended.xls;
* You will need to input the data in the excel sheet for this code to work.;

#delimit;
clear all;
set more off;

*change this directory first;
qui: cd "/Users/johanneswieland/Dropbox/uni/Work/Research/PhD/Brookings/Hausman_Wieland_Data_Programs/Stata/Code";
*qui: cd "~/Dropbox/Brookings/Hausman_Wieland_Data_Programs/Stata/Code";

* setting paths;
qui: do paths;

* list of variables to be plotted;
local cefevars cpi y c ;
local pltnames Inflation "GDP Growth" "Consumption  Growth" ;

* location of variables;
local sheetname "Annual"; // worksheet with data;
local celllist "A1:L291"; // cellrange of data;

* start of abenomics;
local abestt = "2012m11";

********************************************************************************
*
* Consensus forecasts for Japan: monthly forecasts
*
********************************************************************************;

local zz = 1;


*This loop imports the monthly consensus forecasts from the excel spreadsheet japan extended.xls;
* You will need to input the data in the excel sheet for this code to work.;

qui: cd "$DataPath/Consensus";
import excel using "japan extended.xls", sheet("`sheetname'") cellrange("`celllist'") firstrow case(lower);

* survey month is date;
gen survey = ym(year,month);
drop year month consensusday;

drop if survey[_n]==500 & survey[_n+1]==500; // two surveys due to 9/11.;

reshape long `cefevars', i(survey) j(fc);

replace fc=-1 if fc==9; // y9 is last years output, y0 current output, y1 next years output and so on.;

format survey %tm;
gen yearfc = yofd(dofm(survey))+fc; // yearfc is date forecasted;

xtset yearfc survey, monthly;

local zz = 1;

foreach var of varlist `cefevars' {;
	
	local newname: word `zz' of `pltnames';
	label variable `var' "`newname'";
	
	local zz = `zz'+1;
};


* saving data;
saveold "$StDataPath/jpcem", replace;

qui: cd "$CodePath";


********************************************************************************
*
* Plotting Data
*
********************************************************************************;

cd "$StGrphPath";

local zz=1;
matrix locmat = [11,1,11]; // location for legend in graph (clock);

foreach var of varlist `cefevars' {;

	local varname: var label `var';
	
	local location = locmat[1,`zz'];
	
	* figure 6 (a) and (b);
	graph twoway (tsline `var' if yearfc==2013, lwidth(medthick) clcolor(blue) clpattern(solid) ms(Oh) mcolor(blue) recast(connected)) (tsline `var' if yearfc==2014, lwidth(medthick) clcolor(red) clpattern(dash) ms(Dh) mcolor(red) recast(connected)) (tsline `var' if yearfc==2012 & tin(2012m1,), lwidth(medthick) clcolor(black) clpattern(dash_dot) ms(Th) mcolor(black) recast(connected)), name(`var'monce2)  ///
	tline(`abestt') legend(order(1 "2013 Forecast" 2 "2014 Forecast" 3 "2012 Forecast") cols(1) ring(0) position(`location') ) ytitle("`varname'") xtitle("Survey Date") ///
	 graphregion(color(white)) ///
	tlabel(2012m1 2012m7 2013m1 2013m7 2014m1, format(%tm)) ;
	graph export `var'cem2.eps, replace;
	
	local zz = `zz'+1;
	
	
	
};

