* this code file will plot figure 7 (a) and (b): long-run consensus forecasts;
* This file imports the long-run consensus forecasts from the excel spreadsheet japan extended.xls;
* You will need to input the data in the excel sheet for this code to work.;

#delimit;
clear all;
set more off;

*change this directory first;
qui: cd "/Users/johanneswieland/Dropbox/uni/Work/Research/PhD/Brookings/Hausman_Wieland_Data_Programs/Stata/Code";
*qui: cd "~/Dropbox/Brookings/Hausman_Wieland_Data_Programs/Stata/Code";

* setting paths;
qui: do paths;

* loval vars;
local rececb = "2007"; // base year;
local abestt = "2012"; // Abe start year;
local laststt = "2013"; // last year;
local abestty = "2011.9"; // Abe start year (more precise);
local cebase = "2012m10"; // pre-Abe forecast date;
local celast = "2013m10"; // post-Abe forecast date;
local ce2007 = "2007m10"; // 2007 forecast date;
local plotst = "2005";  // start of plot;

* list of variables to be plotted;
local celtvars cpi gdp cons ;
local pltnames CPI GDP Consumption ; // new names ;
local sheetlistlt "Consumer Prices LT" "GDP LT" "Consumption LT" ;  // sheets from which they are imported;
local celllistlt "A5:V19";  // sheets from which they are imported;

* local nums;
local cebasenum = tm(`cebase');
local celastnum = tm(`celast');
local ce2007num = tm(`ce2007');
local plotnum= `plotst';

********************************************************************************
*
* Consensus forecasts for Japan: long-term forecasts
*
********************************************************************************;

local zz = 1;


foreach var in `celtvars' {;

	local sheetname: word `zz' of "`sheetlistlt'";
	display "`sheetname'";

	qui: cd "$DataPath/Consensus";
	import excel using "JAPAN Extended.xls", sheet("`sheetname'") cellrange("`celllistlt'") firstrow case(lower);
	drop if _n==1;
	
	destring, replace;
	
	foreach varq of varlist y* {;
		local varstr "`varq'";
		local yearst = substr("`varstr'",2,4);
		rename `varq' `var'`yearst';
	};
	
	reshape long `var', i(surveydate) j(date) string;
	
	* new date variable;
	destring, replace;
	format date %ty;
	
	* new survey variable;
	gen survey = mofd(surveydate);
	format survey %tm;
	drop surveydate;
	
	* reshape again for merging;
	reshape wide `var', i(date) j(survey);
	save "$StDataPath/jpcelt`var'", replace;
	clear all;
	
	local zz = `zz' + 1;
};

qui: cd "$CodePath";


********************************************************************************
*
* Merging with NA and Prices & IMF forecasts;
*
********************************************************************************;

* getting other data files;
clear all;
qui: cd "$CodePath";
qui: do japan_cpi_final;
clear all;
qui: cd "$CodePath";
qui: do jp_na_setup_final;
clear all;

* prices at annual basis;
use "$StDataPath/jpcpi";
gen datey = yofd(dofm(date));
rename cpisa cpi;
local cpiset cpi cpicoresa;
foreach var of varlist `cpiset' {;
	by datey, sort: egen `var'y = mean(`var');
	drop `var';
	rename `var'y `var';
};
drop date;
rename datey date;
keep date `cpiset';
duplicates drop;
drop if date==2014;
save "$StDataPath/jpcpiy", replace;
clear all;

* national accounts at annual basis: aggregate from quarterly;
use "$StDataPath/jpna";
local naset gdp invnonres cons;
keep date `naset';
gen datey = yofd(dofq(date));
foreach var of varlist `naset' {;
	by datey, sort: egen `var'y = mean(`var');
	drop `var';
	rename `var'y `var';
};
drop date;
rename datey date;
duplicates drop;
save "$StDataPath/jpnay", replace;
clear all;

* merging data;
use "$StDataPath/jpnay";
merge m:1 date using "$StDataPath/jpcpiy", gen(_mergecpi);
foreach var in `celtvars' {;
	merge m:1 date using "$StDataPath/jpcelt`var'", gen(_mergece`var');
};

* keeping only variables to be plotted;
local keeplist;
foreach var of varlist `celtvars' {;
	local keeplist `keeplist' `var' `var'`ce2007num' `var'`cebasenum' `var'`celastnum';
	local celtbase `celtbase' `var'basecelt;
};

keep date `keeplist';


********************************************************************************
*
* Plotting data;
*
********************************************************************************;

cd "$StGrphPath";
tsset date, yearly;

* base year;
local mindat = date[1];
local recobs = `rececb'-`mindat'+1;

local zz = 1;

foreach var in `celtvars' {;
	
	qui: local plotvar: word `zz' of `pltnames';
	display "`plotvar'";
	
	
	foreach set in "" {;
	
		* base year = 100;
		gen `var'`set'base = `var' / `var'[`recobs']*100;
		
		gen `var'`set'`ce2007num'base = `var'`set'base if date == 2007;
		gen `var'`set'`cebasenum'base = `var'`set'base if date == `abestt';
		gen `var'`set'`celastnum'base = `var'`set'base if date == `laststt';
		
		* relative to base year;
		forvalues jj=1(1)12 {;
			replace `var'`set'`cebasenum'base = (1+`var'`set'`cebasenum'/100) * L`lag'.`var'`set'`cebasenum'base if date==`abestt'+`jj';
			replace `var'`set'`celastnum'base = (1+`var'`set'`celastnum'/100) * L`lag'.`var'`set'`celastnum'base if date==`laststt'+`jj';
			
			replace `var'`set'`ce2007num'base = (1+`var'`set'`ce2007num'/100) * L`lag'.`var'`set'`ce2007num'base if date==2007 +`jj';
		};
	};
	
	tsline `var'base `var'`cebasenum'base `var'`celastnum'base  `var'`ce2007num'base if tin(`plotst',) , name(`var'basecelt)  ///
	tline(`abestty') legend(order(1 "Data (2007=100)" 2 "Forecast `cebase'" 3 "Forecast `celast'" 4 "Forecast `ce2007'") cols(1) ring(0) position(4) ) ytitle("`plotvar'") xtitle("") ///
	lwidth(medthick medthick medthick medthick medthick medthick) clcolor(blue black green orange) clpattern(solid dash dash_dot dash_dot dash dash_dot) graphregion(color(white)) ///
	 saving(`var'celt, replace);
	graph export `var'celt.eps, replace;
	

	local zz = `zz'+1;
};


* growth relative to previous forecasts;
gen improve = gdp`celastnum'base/gdp`cebasenum'base;

gen gap1 = gdp`cebasenum'base/gdp`ce2007num'base;
gen gap2 = gdp`celastnum'base/gdp`ce2007num'base;
